/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.outline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.ui.filters.FilterDescriptor;
import org.eclipse.dltk.internal.ui.filters.FilterMessages;
import org.eclipse.dltk.internal.ui.util.SWTUtil;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.SelectionDialog;

public class CustomFiltersDialog
extends SelectionDialog {
    private static final String SEPARATOR = ",";
    private String fViewId;
    private boolean fEnablePatterns;
    private String[] fPatterns;
    private String[] fEnabledFilterIds;
    private FilterDescriptor[] fBuiltInFilters;
    private CheckboxTableViewer fCheckBoxList;
    private Button fEnableUserDefinedPatterns;
    private Text fUserDefinedPatterns;
    private Stack<FilterDescriptor> fFilterDescriptorChangeHistory;

    public CustomFiltersDialog(Shell shell, String viewId, boolean enablePatterns, String[] patterns, String[] enabledFilterIds) {
        super(shell);
        Assert.isNotNull((Object)viewId);
        Assert.isNotNull((Object)patterns);
        Assert.isNotNull((Object)enabledFilterIds);
        this.fViewId = viewId;
        this.fPatterns = patterns;
        this.fEnablePatterns = enablePatterns;
        this.fEnabledFilterIds = enabledFilterIds;
        this.fBuiltInFilters = CustomFiltersDialog.getFilterDescriptors(this.fViewId);
        this.fFilterDescriptorChangeHistory = new Stack();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public static FilterDescriptor[] getFilterDescriptors(String targetId) {
        FilterDescriptor[] filterDescs = FilterDescriptor.getFilterDescriptors();
        ArrayList<FilterDescriptor> result = new ArrayList<FilterDescriptor>(filterDescs.length);
        int i = 0;
        while (i < filterDescs.length) {
            String tid = filterDescs[i].getTargetId();
            if (!WorkbenchActivityHelper.filterItem((Object)filterDescs[i]) && targetId.equals(tid)) {
                result.add(filterDescs[i]);
            }
            ++i;
        }
        return result.toArray(new FilterDescriptor[result.size()]);
    }

    protected void configureShell(Shell shell) {
        this.setTitle(FilterMessages.CustomFiltersDialog_title);
        this.setMessage(FilterMessages.CustomFiltersDialog_filterList_label);
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Composite group = composite;
        this.fEnableUserDefinedPatterns = new Button(group, 32);
        this.fEnableUserDefinedPatterns.setFocus();
        this.fEnableUserDefinedPatterns.setText(FilterMessages.CustomFiltersDialog_enableUserDefinedPattern);
        this.fUserDefinedPatterns = new Text(group, 2052);
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(59);
        this.fUserDefinedPatterns.setLayoutData((Object)data);
        String patterns = CustomFiltersDialog.convertToString(this.fPatterns, SEPARATOR);
        this.fUserDefinedPatterns.setText(patterns);
        final Label info = new Label(group, 16384);
        info.setText(FilterMessages.CustomFiltersDialog_patternInfo);
        this.fEnableUserDefinedPatterns.setSelection(this.fEnablePatterns);
        this.fUserDefinedPatterns.setEnabled(this.fEnablePatterns);
        info.setEnabled(this.fEnablePatterns);
        this.fEnableUserDefinedPatterns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = CustomFiltersDialog.this.fEnableUserDefinedPatterns.getSelection();
                CustomFiltersDialog.this.fUserDefinedPatterns.setEnabled(state);
                info.setEnabled(CustomFiltersDialog.this.fEnableUserDefinedPatterns.getSelection());
                if (state) {
                    CustomFiltersDialog.this.fUserDefinedPatterns.setFocus();
                }
            }
        });
        if (this.fBuiltInFilters.length > 0) {
            this.createCheckBoxList(group);
        }
        CustomFiltersDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void createCheckBoxList(Composite parent) {
        new Label(parent, 0);
        Label info = new Label(parent, 16384);
        info.setText(FilterMessages.CustomFiltersDialog_filterList_label);
        this.fCheckBoxList = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = this.fCheckBoxList.getTable().getItemHeight() * 10;
        this.fCheckBoxList.getTable().setLayoutData((Object)data);
        this.fCheckBoxList.setLabelProvider((IBaseLabelProvider)this.createLabelPrivder());
        this.fCheckBoxList.setContentProvider((IContentProvider)new ArrayContentProvider());
        Arrays.sort(this.fBuiltInFilters);
        this.fCheckBoxList.setInput((Object)this.fBuiltInFilters);
        this.setInitialSelections(this.getEnabledFilterDescriptors());
        List initialSelection = this.getInitialElementSelections();
        if (initialSelection != null && !initialSelection.isEmpty()) {
            this.checkInitialSelections();
        }
        info = new Label(parent, 16384);
        info.setText(FilterMessages.CustomFiltersDialog_description_label);
        final Text description = new Text(parent, 19018);
        data = new GridData(768);
        data.heightHint = this.convertHeightInCharsToPixels(3);
        description.setLayoutData((Object)data);
        this.fCheckBoxList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedElement;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof FilterDescriptor) {
                    description.setText(((FilterDescriptor)selectedElement).getDescription());
                }
            }
        });
        this.fCheckBoxList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof FilterDescriptor) {
                    FilterDescriptor fd = (FilterDescriptor)element;
                    if (CustomFiltersDialog.this.fFilterDescriptorChangeHistory.contains(fd)) {
                        CustomFiltersDialog.this.fFilterDescriptorChangeHistory.remove(fd);
                    }
                    CustomFiltersDialog.this.fFilterDescriptorChangeHistory.push(fd);
                }
            }
        });
        this.addSelectionButtons(parent);
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        String label = FilterMessages.CustomFiltersDialog_SelectAllButton_label;
        Button selectButton = this.createButton(buttonComposite, 18, label, false);
        SWTUtil.setButtonDimensionHint((Button)selectButton);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomFiltersDialog.this.fCheckBoxList.setAllChecked(true);
                CustomFiltersDialog.this.fFilterDescriptorChangeHistory.clear();
                int i = 0;
                while (i < CustomFiltersDialog.this.fBuiltInFilters.length) {
                    CustomFiltersDialog.this.fFilterDescriptorChangeHistory.push(CustomFiltersDialog.this.fBuiltInFilters[i]);
                    ++i;
                }
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        label = FilterMessages.CustomFiltersDialog_DeselectAllButton_label;
        Button deselectButton = this.createButton(buttonComposite, 19, label, false);
        SWTUtil.setButtonDimensionHint((Button)deselectButton);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomFiltersDialog.this.fCheckBoxList.setAllChecked(false);
                CustomFiltersDialog.this.fFilterDescriptorChangeHistory.clear();
                int i = 0;
                while (i < CustomFiltersDialog.this.fBuiltInFilters.length) {
                    CustomFiltersDialog.this.fFilterDescriptorChangeHistory.push(CustomFiltersDialog.this.fBuiltInFilters[i]);
                    ++i;
                }
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialElementSelections().iterator();
        while (itemsToCheck.hasNext()) {
            this.fCheckBoxList.setChecked(itemsToCheck.next(), true);
        }
    }

    protected void okPressed() {
        if (this.fBuiltInFilters != null) {
            ArrayList<FilterDescriptor> result = new ArrayList<FilterDescriptor>();
            int i = 0;
            while (i < this.fBuiltInFilters.length) {
                if (this.fCheckBoxList.getChecked((Object)this.fBuiltInFilters[i])) {
                    result.add(this.fBuiltInFilters[i]);
                }
                ++i;
            }
            this.setResult(result);
        }
        super.okPressed();
    }

    private ILabelProvider createLabelPrivder() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof FilterDescriptor) {
                    return ((FilterDescriptor)element).getName();
                }
                return null;
            }
        };
    }

    protected void setResult(List newResult) {
        super.setResult(newResult);
        if (this.fUserDefinedPatterns.getText().length() > 0) {
            this.fEnablePatterns = this.fEnableUserDefinedPatterns.getSelection();
            this.fPatterns = CustomFiltersDialog.convertFromString(this.fUserDefinedPatterns.getText(), SEPARATOR);
        } else {
            this.fEnablePatterns = false;
            this.fPatterns = new String[0];
        }
    }

    public String[] getUserDefinedPatterns() {
        return this.fPatterns;
    }

    public String[] getEnabledFilterIds() {
        Object[] result = this.getResult();
        HashSet<String> enabledIds = new HashSet<String>(result.length);
        int i = 0;
        while (i < result.length) {
            enabledIds.add(((FilterDescriptor)result[i]).getId());
            ++i;
        }
        return enabledIds.toArray(new String[enabledIds.size()]);
    }

    public boolean areUserDefinedPatternsEnabled() {
        return this.fEnablePatterns;
    }

    public Stack<FilterDescriptor> getFilterDescriptorChangeHistory() {
        return this.fFilterDescriptorChangeHistory;
    }

    private FilterDescriptor[] getEnabledFilterDescriptors() {
        FilterDescriptor[] filterDescs = this.fBuiltInFilters;
        ArrayList<FilterDescriptor> result = new ArrayList<FilterDescriptor>(filterDescs.length);
        List<String> enabledFilterIds = Arrays.asList(this.fEnabledFilterIds);
        int i = 0;
        while (i < filterDescs.length) {
            String id = filterDescs[i].getId();
            if (enabledFilterIds.contains(id)) {
                result.add(filterDescs[i]);
            }
            ++i;
        }
        return result.toArray(new FilterDescriptor[result.size()]);
    }

    public static String[] convertFromString(String patterns, String separator) {
        StringTokenizer tokenizer = new StringTokenizer(patterns, separator, true);
        int tokenCount = tokenizer.countTokens();
        ArrayList<String> result = new ArrayList<String>(tokenCount);
        boolean escape = false;
        boolean append = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (separator.equals(token)) {
                if (!escape) {
                    escape = true;
                    continue;
                }
                CustomFiltersDialog.addPattern(result, separator);
                append = true;
                continue;
            }
            if (!append) {
                result.add(token);
            } else {
                CustomFiltersDialog.addPattern(result, token);
            }
            append = false;
            escape = false;
        }
        return result.toArray(new String[result.size()]);
    }

    private static void addPattern(List<String> list, String pattern) {
        if (list.isEmpty()) {
            list.add(pattern);
        } else {
            int index = list.size() - 1;
            list.set(index, list.get(index) + pattern);
        }
    }

    public static String convertToString(String[] patterns, String separator) {
        int length = patterns.length;
        StringBuilder strBuf = new StringBuilder();
        if (length <= 0) {
            return "";
        }
        strBuf.append(CustomFiltersDialog.escapeSeparator(patterns[0], separator));
        int i = 1;
        while (i < length) {
            strBuf.append(separator);
            strBuf.append(" ");
            strBuf.append(CustomFiltersDialog.escapeSeparator(patterns[i++], separator));
        }
        return strBuf.toString();
    }

    private static String escapeSeparator(String pattern, String separator) {
        int length = pattern.length();
        StringBuilder buf = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char ch = pattern.charAt(i);
            if (separator.equals(String.valueOf(ch))) {
                buf.append(ch);
            }
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }
}

