"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.lazy = lazy;
class LazyValue {
    #hasValue = false;
    #value;
    #getValue;
    constructor(getValue) {
        this.#getValue = getValue;
    }
    get value() {
        if (!this.#hasValue) {
            this.#hasValue = true;
            this.#value = this.#getValue();
        }
        return this.#value;
    }
    get hasValue() {
        return this.#hasValue;
    }
    map(f) {
        return new LazyValue(() => f(this.value));
    }
}
function lazy(getValue) {
    return new LazyValue(getValue);
}
//# sourceMappingURL=lazy.js.map