/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers;

import java.net.URL;
import org.eclipse.ui.IMemento;

public interface IHoverHelp {
    public static void visitMemento(IMemento node, IMementoVisitor visitor) {
        visitor.visit(node);
        IMemento[] iMementoArray = node.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            IHoverHelp.visitMemento(child, visitor);
            ++n2;
        }
    }

    public static String getNodeContent(IMemento node) {
        String candidate = node.toString();
        int startPos = candidate.indexOf("<" + node.getType());
        if (startPos != -1) {
            startPos = candidate.indexOf(62, startPos);
        }
        int endPos = candidate.lastIndexOf("<");
        if (startPos != -1 && endPos != -1 && startPos < endPos) {
            return candidate.substring(startPos + 1, endPos);
        }
        return node.getTextData() != null ? node.getTextData() : "";
    }

    public static void updateRelativeLinks(IMemento contentNode, URL baseUrl) {
        IHoverHelp.visitMemento(contentNode, node -> {
            if (node.getType().equals("a") && node.getString("href") != null) {
                node.putString("href", IHoverHelp.resolveUrl(baseUrl, node.getString("href")));
            }
            if (node.getType().equals("img") && node.getString("src") != null) {
                node.putString("src", IHoverHelp.resolveUrl(baseUrl, node.getString("src")));
            }
        });
    }

    public static String resolveUrl(URL baseUrl, String relativeLocation) {
        if (relativeLocation.contains("://")) {
            return relativeLocation;
        }
        String baseLocation = baseUrl.toString();
        if (relativeLocation.startsWith("#")) {
            return String.valueOf(baseLocation) + relativeLocation;
        }
        if (relativeLocation.startsWith("/")) {
            int hostPosition = baseLocation.indexOf(baseUrl.getHost());
            return String.valueOf(baseLocation.substring(0, hostPosition + baseUrl.getHost().length())) + relativeLocation;
        }
        int lastPathDelimiter = baseLocation.lastIndexOf(47);
        if (lastPathDelimiter > 0) {
            return String.valueOf(baseLocation.substring(0, lastPathDelimiter + 1)) + relativeLocation;
        }
        return "";
    }

    public static String getImageAndLabel(String imageSrcPath, String label) {
        StringBuffer buf = new StringBuffer();
        int imageWidth = 16;
        int imageHeight = 16;
        int labelLeft = 20;
        int labelTop = 2;
        buf.append("<div style='word-wrap: break-word; position: relative; ");
        if (imageSrcPath != null) {
            buf.append("margin-left: ").append(20).append("px; ");
            buf.append("padding-top: ").append(2).append("px; ");
        }
        buf.append("'>");
        if (imageSrcPath != null) {
            StringBuffer imageStyle = new StringBuffer("border:none; position: absolute; ");
            imageStyle.append("width: ").append(16).append("px; ");
            imageStyle.append("height: ").append(16).append("px; ");
            imageStyle.append("left: ").append(-21).append("px; ");
            buf.append("<!--[if lte IE 6]><![if gte IE 5.5]>\n");
            String tooltip = "";
            buf.append("<span ").append("").append("style=\"").append(imageStyle).append("filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(imageSrcPath).append("')\"></span>\n");
            buf.append("<![endif]><![endif]-->\n");
            buf.append("<!--[if !IE]>-->\n");
            buf.append("<img ").append("").append("style='").append(imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<!--<![endif]-->\n");
            buf.append("<!--[if gte IE 7]>\n");
            buf.append("<img ").append("").append("style='").append(imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<![endif]-->\n");
        }
        buf.append(label);
        buf.append("</div>");
        return buf.toString();
    }

    public String getName();

    public String getDescription();

    public String getHoverContent();

    public static interface IMementoVisitor {
        public void visit(IMemento var1);
    }
}

