/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.build.Messages;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.launchbar.core.target.ILaunchTarget;

public class StandardBuildConfiguration
extends CBuildConfiguration {
    public static final String BUILD_CONTAINER = "stdbuild.build.container";
    public static final String BUILD_COMMAND = "stdbuild.build.command";
    public static final String CLEAN_COMMAND = "stdbuild.clean.command";
    private static final String DEFAULT_BUILD_COMMAND = "make";
    private static final String DEFAULT_CLEAN_COMMAND = "make clean";
    private String buildCommand = "make";
    private String cleanCommand = "make clean";
    private IContainer buildContainer;
    private IEnvironmentVariable[] envVars;
    private Stack<String> directoryStack = new Stack();
    private final List<DirectoryPatternParser> enteringDirectoryPatterns = List.of(new DirectoryPatternParser(this, this, "make\\[(.*)\\]: Entering directory [`'](.*)'"){
        final /* synthetic */ StandardBuildConfiguration this$0;
        {
            this.this$0 = standardBuildConfiguration2;
            super($anonymous0);
        }

        @Override
        protected void recordDirectoryChange(Matcher matcher) {
            int level;
            try {
                level = Integer.valueOf(matcher.group(1));
            }
            catch (NumberFormatException e) {
                level = 0;
            }
            String dir = matcher.group(2);
            int parseLevel = this.this$0.directoryStack.size();
            while (level < parseLevel) {
                if (!this.this$0.directoryStack.empty()) {
                    this.this$0.directoryStack.pop();
                }
                ++level;
            }
            this.this$0.directoryStack.push(dir);
        }
    }, new DirectoryPatternParser(this, this, "make: Entering directory [`'](.*)'"){
        final /* synthetic */ StandardBuildConfiguration this$0;
        {
            this.this$0 = standardBuildConfiguration2;
            super($anonymous0);
        }

        @Override
        protected void recordDirectoryChange(Matcher matcher) {
            String dir = matcher.group(1);
            this.this$0.directoryStack.push(dir);
        }
    }, new DirectoryPatternParser(this, this, "make(\\[.*\\])?: Leaving directory"){
        final /* synthetic */ StandardBuildConfiguration this$0;
        {
            this.this$0 = standardBuildConfiguration2;
            super($anonymous0);
        }

        @Override
        protected void recordDirectoryChange(Matcher matcher) {
            if (!this.this$0.directoryStack.empty()) {
                this.this$0.directoryStack.pop();
            }
        }
    });

    public StandardBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
        this.applyProperties();
        this.setupEnvVars();
    }

    public StandardBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, String launchMode, ILaunchTarget launchTarget) throws CoreException {
        super(config, name, toolChain, launchMode, launchTarget);
        this.applyProperties();
        this.setupEnvVars();
    }

    private IContainer getContainer(String containerPath) {
        if (containerPath != null && !containerPath.trim().isEmpty()) {
            Path containerLoc = new Path(containerPath);
            if (containerLoc.segmentCount() == 1) {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(containerLoc.segment(0));
            }
            return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)containerLoc);
        }
        return null;
    }

    private void applyProperties() {
        this.setBuildContainer(this.getProperty(BUILD_CONTAINER));
        String buildCommand = this.getProperty(BUILD_COMMAND);
        this.buildCommand = buildCommand != null && !buildCommand.isBlank() ? buildCommand : DEFAULT_BUILD_COMMAND;
        String cleanCommand = this.getProperty(CLEAN_COMMAND);
        this.cleanCommand = cleanCommand != null && !cleanCommand.isBlank() ? cleanCommand : DEFAULT_CLEAN_COMMAND;
    }

    private void setupEnvVars() throws CoreException {
        String mode;
        String[] cxx;
        IToolChain toolchain = this.getToolChain();
        ArrayList<EnvironmentVariable> vars = new ArrayList<EnvironmentVariable>();
        String[] cc = toolchain.getCompileCommands(GCCLanguage.getDefault());
        if (cc != null && cc.length > 0) {
            vars.add(new EnvironmentVariable("CC", cc[0]));
        }
        if ((cxx = toolchain.getCompileCommands(GPPLanguage.getDefault())) != null && cxx.length > 0) {
            vars.add(new EnvironmentVariable("CXX", cxx[0]));
        }
        if ((mode = this.getLaunchMode()) != null && !mode.isEmpty()) {
            vars.add(new EnvironmentVariable("BUILD_MODE", mode));
        }
        this.envVars = vars.toArray(new IEnvironmentVariable[0]);
    }

    @Override
    public IEnvironmentVariable[] getVariables() {
        return this.envVars;
    }

    private void setBuildContainer(String containerPath) {
        IContainer container = null;
        if (containerPath != null && !containerPath.trim().isEmpty()) {
            container = this.getContainer(containerPath);
        }
        this.setBuildContainer(container);
    }

    public void setBuildContainer(IContainer buildContainer) {
        this.buildContainer = buildContainer;
        if (buildContainer == null) {
            this.setProperty(BUILD_CONTAINER, "");
        } else {
            this.setProperty(BUILD_CONTAINER, buildContainer.getFullPath().toString());
        }
    }

    public void setBuildCommand(String buildCommand) {
        if (buildCommand != null && !buildCommand.isBlank()) {
            this.buildCommand = buildCommand;
            this.setProperty(BUILD_COMMAND, buildCommand);
        } else {
            this.buildCommand = DEFAULT_BUILD_COMMAND;
            this.removeProperty(BUILD_COMMAND);
        }
    }

    public void setCleanCommand(String cleanCommand) {
        if (cleanCommand != null && !cleanCommand.isBlank()) {
            this.cleanCommand = cleanCommand;
            this.setProperty(CLEAN_COMMAND, cleanCommand);
        } else {
            this.cleanCommand = DEFAULT_CLEAN_COMMAND;
            this.removeProperty(CLEAN_COMMAND);
        }
    }

    @Override
    public IContainer getBuildContainer() throws CoreException {
        if (this.buildContainer == null) {
            this.setBuildContainer(this.getDefaultBuildContainer());
        }
        return this.buildContainer;
    }

    public IContainer getDefaultBuildContainer() throws CoreException {
        return super.getBuildContainer();
    }

    @Override
    public String getProperty(String name) {
        String prop = super.getProperty(name);
        if (prop != null) {
            return prop;
        }
        switch (name) {
            case "stdbuild.build.container": {
                try {
                    return this.getBuildContainer().getFullPath().toString();
                }
                catch (CoreException e) {
                    CCorePlugin.log(e.getStatus());
                    return null;
                }
            }
            case "stdbuild.build.command": {
                return this.buildCommand;
            }
            case "stdbuild.clean.command": {
                return this.cleanCommand;
            }
        }
        return null;
    }

    @Override
    public boolean setProperties(Map<String, String> properties) {
        if (!super.setProperties(properties)) {
            return false;
        }
        this.applyProperties();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream infoStream = console.getInfoStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            infoStream.write(String.format(Messages.StandardBuildConfiguration_0, buildDir.toString()));
            String[] parsedBuildCommand = CommandLineUtil.argumentsToArray(this.buildCommand);
            ArrayList<String> command = new ArrayList<String>();
            command.add(parsedBuildCommand[0]);
            if (!this.getBuildContainer().equals((Object)this.getProject())) {
                java.nio.file.Path makefile = Paths.get(this.getProject().getFile("Makefile").getLocationURI());
                java.nio.file.Path relative = this.getBuildDirectory().relativize(makefile);
                command.add("-f");
                command.add(relative.toString());
            }
            int i = 1;
            while (true) {
                if (i >= parsedBuildCommand.length) {
                    Throwable throwable = null;
                    Object var11_15 = null;
                    try (ErrorParserManager epm = new ErrorParserManager(project, this.getProject().getLocationURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                        epm.setOutputStream(console.getOutputStream());
                        console.getOutputStream().write(String.format("%s\n", CommandLineUtil.argumentsToString(command, false)));
                        Path workingDir = new Path(this.getBuildDirectory().toString());
                        Process p = this.startBuildProcess(command, this.envVars, (IPath)workingDir, console, monitor);
                        if (p == null) {
                            console.getErrorStream().write(String.format(Messages.StandardBuildConfiguration_Failure, ""));
                            return null;
                        }
                        IConsoleParser[] consoleParsers = new IConsoleParser[]{epm, this};
                        this.watchProcess(consoleParsers, monitor);
                        project.refreshLocal(2, monitor);
                        infoStream.write(String.format(Messages.StandardBuildConfiguration_1, epm.getErrorCount(), epm.getWarningCount(), buildDir.toString()));
                        return new IProject[]{project};
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                command.add(parsedBuildCommand[i]);
                ++i;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", "Building " + project.getName(), (Throwable)e));
        }
    }

    @Override
    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream infoStream = console.getInfoStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            infoStream.write(String.format(Messages.StandardBuildConfiguration_0, buildDir.toString()));
            ArrayList<String> command = new ArrayList<String>();
            List<String> buildCommand = this.cleanCommand != null ? Arrays.asList(CommandLineUtil.argumentsToArray(this.cleanCommand)) : Arrays.asList(CommandLineUtil.argumentsToArray(DEFAULT_CLEAN_COMMAND));
            command.add(buildCommand.get(0));
            if (!this.getBuildContainer().equals((Object)this.getProject())) {
                java.nio.file.Path makefile = Paths.get(this.getProject().getFile("Makefile").getLocationURI());
                java.nio.file.Path relative = this.getBuildDirectory().relativize(makefile);
                command.add("-f");
                command.add(relative.toString());
            }
            int i = 1;
            while (i < buildCommand.size()) {
                command.add(buildCommand.get(i));
                ++i;
            }
            infoStream.write(String.format("%s\n", CommandLineUtil.argumentsToString(command, false)));
            Path workingDir = new Path(this.getBuildDirectory().toString());
            Process p = this.startBuildProcess(command, this.envVars, (IPath)workingDir, console, monitor);
            if (p == null) {
                console.getErrorStream().write(String.format(Messages.StandardBuildConfiguration_Failure, ""));
                return;
            }
            this.watchProcess(console, monitor);
            infoStream.write(Messages.CBuildConfiguration_BuildComplete);
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", "Building " + project.getName(), (Throwable)e));
        }
    }

    @Override
    public boolean processLine(String line) {
        this.enteringDirectoryPatterns.forEach(p -> p.processLine(line));
        return super.processLine(line);
    }

    @Override
    public URI getBuildDirectoryURI() throws CoreException {
        if (!this.directoryStack.isEmpty()) {
            return java.nio.file.Path.of(this.directoryStack.peek(), new String[0]).toUri();
        }
        return super.getBuildDirectoryURI();
    }

    private abstract class DirectoryPatternParser {
        private final Pattern pattern;

        public DirectoryPatternParser(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public void processLine(String line) {
            Matcher matcher = this.pattern.matcher(line);
            if (matcher.find()) {
                this.recordDirectoryChange(matcher);
            }
        }

        protected abstract void recordDirectoryChange(Matcher var1);
    }
}

