/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tracetype.preferences;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypePreferences;
import org.eclipse.tracecompass.tmf.ui.tracetype.preferences.TraceTypePreferencePageViewer;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TraceTypePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TraceTypePreferencePageViewer fViewer;

    public void init(IWorkbench workbench) {
        this.fViewer = new TraceTypePreferencePageViewer(Iterables.filter((Iterable)TmfTraceType.getTraceTypeHelpers(), helper -> !helper.isExperimentType()));
        this.fViewer.setComparator(new ViewerComparator());
    }

    protected Control createContents(Composite parent) {
        return this.fViewer.create(parent);
    }

    public boolean performOk() {
        List<TraceTypeHelper> unchecked = this.fViewer.getUncheckedElements();
        TraceTypePreferences.setPreferenceValue((List)Lists.newArrayList((Iterable)Iterables.transform(unchecked, helper -> helper.getTraceTypeId())));
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fViewer.performDefaults();
    }
}

