/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleShortMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleShortMap;
import org.eclipse.collections.api.map.primitive.DoubleShortMap;

/**
 * ImmutableDoubleShortMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableDoubleShortMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableDoubleShortMapFactoryImpl implements ImmutableDoubleShortMapFactory
{
    public ImmutableDoubleShortMap empty()
    {
        return ImmutableDoubleShortEmptyMap.INSTANCE;
    }

    public ImmutableDoubleShortMap of()
    {
        return this.empty();
    }

    public ImmutableDoubleShortMap with()
    {
        return this.empty();
    }

    public ImmutableDoubleShortMap of(double key, short value)
    {
        return this.with(key, value);
    }

    public ImmutableDoubleShortMap with(double key, short value)
    {
        return new ImmutableDoubleShortSingletonMap(key, value);
    }

    public ImmutableDoubleShortMap ofAll(DoubleShortMap map)
    {
        return this.withAll(map);
    }

    public ImmutableDoubleShortMap withAll(DoubleShortMap map)
    {
        if (map instanceof ImmutableDoubleShortMap)
        {
            return (ImmutableDoubleShortMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            double key = map.keysView().doubleIterator().next();
            return new ImmutableDoubleShortSingletonMap(key, map.get(key));
        }
        return new ImmutableDoubleShortHashMap(map);
    }
}
