/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.ios.templates;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.xtend2.lib.StringConcatenation;

public class EntityClassTemplate
implements IFileTemplate<Entity> {
    public String getFileName(Entity context) {
        String _name = context.getName();
        return String.valueOf(_name) + ".swift";
    }

    public String getPath(Entity context) {
        return "";
    }

    public String getContent(Entity context, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"//Generated by Vorto");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import Foundation");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"class ");
        String _name = context.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _properties = context.getProperties();
        for (Property property : _properties) {
            _builder.append((Object)"\t");
            _builder.append((Object)"var ");
            String _name_1 = property.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append((Object)" : ");
            boolean _isMultiplicity = property.isMultiplicity();
            if (_isMultiplicity) {
                _builder.append((Object)"[");
                PropertyType _type = property.getType();
                String _type_1 = this.getType(_type);
                _builder.append((Object)_type_1, "\t");
                _builder.append((Object)"]");
            } else {
                PropertyType _type_2 = property.getType();
                String _type_3 = this.getType(_type_2);
                _builder.append((Object)_type_3, "\t");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"init() {}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    public String getType(PropertyType propType) {
        if (propType instanceof PrimitivePropertyType) {
            PrimitivePropertyType primitiveProp = (PrimitivePropertyType)propType;
            PrimitiveType _type = primitiveProp.getType();
            if (_type != null) {
                switch (_type) {
                    case STRING: {
                        return "String";
                    }
                    case INT: {
                        return "Int";
                    }
                    case DATETIME: {
                        return "NSDate";
                    }
                    case DOUBLE: {
                        return "Double";
                    }
                    case FLOAT: {
                        return "Float";
                    }
                }
                return "String";
            }
            return "String";
        }
        Type _type_1 = ((ObjectPropertyType)propType).getType();
        return _type_1.getName();
    }
}

