/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.filewrite;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.vorto.codegen.ui.filewrite.AbstractFileWriteStrategy;
import org.eclipse.vorto.codegen.ui.filewrite.FileWriteContext;

public class WriteGenOverWriteStrategy
extends AbstractFileWriteStrategy {
    private static final String FILENAME_SUFFIX = "_gen";

    @Override
    public void writeFile(FileWriteContext generated, IFile existingFile) throws CoreException, IOException {
        String fileName = existingFile.getName();
        IProject project = existingFile.getProject();
        if (!existingFile.exists()) {
            this.write(generated.getContent(), existingFile);
            existingFile.clearHistory(null);
        } else if (this.isModified(existingFile)) {
            IFile replacefile = this.getFile(String.valueOf(fileName) + FILENAME_SUFFIX, existingFile.getLocation(), project);
            if (replacefile.exists()) {
                replacefile.delete(true, null);
            }
            this.write(generated.getContent(), replacefile);
        } else {
            existingFile.delete(true, null);
            this.write(generated.getContent(), existingFile);
        }
    }

    private boolean isModified(IFile existingFile) {
        IFileState[] history = null;
        try {
            history = existingFile.getHistory(null);
        }
        catch (CoreException coreException) {
            return true;
        }
        return history.length != 0;
    }

    private IFile getFile(String fileName, IPath folderPath, IProject project) {
        return project.getFolder(folderPath).getFile(fileName);
    }

    private void write(String contentStr, IFile existingFile) throws CoreException, IOException {
        InputStream content = IOUtils.toInputStream((String)contentStr);
        existingFile.create(content, false, null);
        content.close();
    }
}

