/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.tasks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.ui.tasks.ClasspathConfiguration;
import org.eclipse.vorto.codegen.ui.tasks.IEclipseProjectConfiguration;
import org.eclipse.vorto.codegen.ui.tasks.natures.CustomNature;
import org.eclipse.vorto.codegen.ui.tasks.natures.JavaNature;
import org.eclipse.vorto.codegen.ui.tasks.natures.MavenNature;
import org.eclipse.vorto.codegen.ui.tasks.natures.PluginNature;

public class NatureConfiguration
implements IEclipseProjectConfiguration {
    private ClasspathConfiguration classpathConfiguration = new ClasspathConfiguration();
    private List<CustomNature> natures = new ArrayList<CustomNature>();
    private boolean configureClasspath = false;

    private String[] allNatures() {
        ArrayList<String> natures = new ArrayList<String>(this.natures.size());
        for (CustomNature nature : this.natures) {
            natures.add(nature.asString());
        }
        return natures.toArray(new String[natures.size()]);
    }

    @Override
    public NatureConfiguration configure(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            description.setNatureIds(this.allNatures());
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.configureClasspath) {
            this.classpathConfiguration.configure(project);
        }
        return this;
    }

    public NatureConfiguration addNature(String nature) {
        this.natures.add(new CustomNature(nature));
        return this;
    }

    public NatureConfiguration addJavaNature(String[] srcFolders) {
        this.natures.add(new JavaNature(srcFolders, this.classpathConfiguration));
        this.configureClasspath = true;
        return this;
    }

    public <Context> NatureConfiguration addPluginNature(ITemplate<Context> buildFile, ITemplate<Context> manifestFile, String[] srcFolders) {
        this.natures.add(new PluginNature<Context>(buildFile, manifestFile, this.classpathConfiguration));
        this.addJavaNature(srcFolders);
        return this;
    }

    public <Context> NatureConfiguration addPluginNature(String outputLocation, ITemplate<Context> buildFile, ITemplate<Context> manifestFile, String[] srcFolders) {
        this.natures.add(new PluginNature<Context>(buildFile, manifestFile, this.classpathConfiguration));
        this.classpathConfiguration.setOutputLocation(outputLocation);
        this.addJavaNature(srcFolders);
        return this;
    }

    public <Context> NatureConfiguration addMavenNature(ITemplate<Context> pomFile, String[] srcFolders) {
        this.natures.add(new MavenNature<Context>(pomFile));
        this.addJavaNature(srcFolders);
        return this;
    }

    @Override
    public <Context> List<ICodeGeneratorTask<Context>> getGeneratorTasks() {
        ArrayList<ICodeGeneratorTask<Context>> modules = new ArrayList<ICodeGeneratorTask<Context>>();
        for (CustomNature nature : this.natures) {
            modules.addAll(nature.getGeneratorTasks());
        }
        return modules;
    }
}

