/* wptTextInputDlg.cpp - Dialog for getting text
 *	Copyright (C) 2001-2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "../resource.h"
#include "wptTypes.h"
#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptContext.h"
#include "wptDlgs.h"
#include "wptW32API.h"
#include "wptNLS.h"
#include "wptErrors.h"

#define MAX_FILESIZE 15000000


void
load_file_contents (HWND dlg, const char * file)
{
    size_t size = 0;
    char *buf = NULL;
    FILE *fp;
    
    size = get_file_size (file);
    if (!size)
        return;
    if (size > MAX_FILESIZE) 
    {
	msg_box (dlg, _("Data is too large for copying."), _("Info"), MB_ERR);
	return;
    }
    buf = new char[size+1];
    if (!buf)
        BUG (0);
    fp = fopen (file, "rb");
    if (fp) 
    {
        fread (buf, 1, size, fp);
        fclose (fp);
        SetDlgItemText (dlg, IDC_TEXT_INPUT, buf);
    }
    free_if_alloc (buf);
} /* load_file_contents */


BOOL CALLBACK
text_input_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    static text_input_s *ctx;
    char *p;
    size_t n;
    
    switch( msg ) {
    case WM_INITDIALOG:
        ctx = (text_input_s *)lparam;
        if( ctx == NULL )
            dlg_fatal_error(dlg, "Could not get dialog param.");
	#ifndef LANG_DE
        SetWindowText( dlg, _("Text Input") );
	#endif
        switch ( ctx->type )  {
        case 0: 
	    SetDlgItemText( dlg, IDC_TEXT_INFO, _("Enter the text that was signed") );
	    break;
        }
	SetDlgItemText (dlg, IDC_TEXT_FILE, _("&Load"));
        SetForegroundWindow( dlg );
        return TRUE;
        
    case WM_COMMAND:
        switch( LOWORD(wparam) ) {
        case IDC_TEXT_FILE:
            const char *file;
            
            file = get_filename_dlg( dlg, 0, _("Text Input from File"), NULL, NULL );
            if( file )
                load_file_contents( dlg, file );
            break;
            
        case IDOK:
            p = new char[100*1024+1];
            if( !p )
		BUG( NULL );
            n = GetDlgItemText(dlg, IDC_TEXT_INPUT, p, 100*1024 );
            if( n ) {
                ctx->length = n;
                ctx->data = new char[n+1];
		if( !ctx->data )
		    BUG( NULL );
                strcpy( ctx->data, p );
            }
            else {
                ctx->length = 0;
                ctx->data = NULL;
            }
	    free_if_alloc( p );
            EndDialog( dlg, TRUE );
            return TRUE;
            
        case IDCANCEL:
            ctx->length = 0;
            ctx->data = NULL;
            EndDialog( dlg, FALSE );
            return FALSE;
        }
        break;
    }
    
    return FALSE;
} /* text_input_dlg_proc */
