/* wptW32API.h - Common API interface
 *	Copyright (C) 2001-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#ifndef WPT_W32_API_H
#define WPT_W32_API_H

enum {
    FILE_OPEN = 0,
    FILE_SAVE = 1
};

enum {
    WIPE_MODE_SIMPLE	= 0,
    WIPE_MODE_DOD	= 1,
    WIPE_MODE_GUTMANN	= 2,
    WIPE_MODE_FAST	= 3,
};

#ifdef __cplusplus
extern "C" {
#endif

extern "C" char * strsep (char * *,char const *);
const char *memistr (const char *buf, size_t buflen, const char *sub);
int gpg_md_hash_file (int mdalgo, const char *file, byte *digest, size_t *nlen);
int gpg_md_selftest (void);

#ifdef __cplusplus
}
#endif


#define stristr(buf, sub) memistr ((buf), strlen ((buf)), (sub))

struct reminder_ctx_s {
    int msecs;
};

struct curr_wnd_ctx {
    HWND main;
    HWND focus;
};

struct LOCK {
    char *file;
    int size;
    HANDLE fh;
};


/*-- mapi --*/
int mapi_init (void);
int mapi_send_pubkey (const char * keyid, char * keyfile);
int mapi_send_ascfile (char * ascfile);
void mapi_deinit (void);

char* make_filename( const char *path, const char *file, const char *ext );
int init_file_lock( LOCK *ctx, const char *file );
void release_file_lock( LOCK *ctx );
int file_exist_check( const char *fname );
int dir_exist_check( const char *dir );
size_t get_file_size( const char *fname );

int get_window_contents( HWND old_hwnd, curr_wnd_ctx *ctx, int *r_hotkey );
int set_window_contents( HWND old_hwnd, curr_wnd_ctx *ctx );

void center_window (HWND hwnd);
void center_window2 (HWND hwndChild, HWND style);
HANDLE window_reminder (struct reminder_ctx_s * ctx);
void set_active_window (HWND dlg);
void reset_active_window (void);

void set_menu_text( HMENU menu, int m_uid, const char *text );
void set_menu_state( HMENU menu, int m_uid, int state );
char* get_clip_text( HWND hwnd );
int set_clip_text (HWND hwnd, const char *text, int nbytes);
int set_clip_text2 (HWND hwnd, const char *text, int nbytes, int head_foot);
int dialog_box_param( HINSTANCE hinst, LPCTSTR name, HWND parent, DLGPROC fnc,
		     LPARAM param, LPCTSTR title, int title_id );
int msg_box( HWND hwnd, const char *text, const char *title, int mode );
int check_date( SYSTEMTIME *st );
const char * get_filename_dlg( HWND hwnd, int id, const char * title, 
			       const char * filter, const char * name );
const char * get_folder_dlg( HWND hwnd, const char * title, const char * name );
char * m_strdup( const char *str );
const char * strtimestamp (long timestamp);

int rename_unlink (const char *path);
int secure_unlink (const char *path, const int mode);
void secure_unlink_set_cb (void (*cb)(void *, const char *, int, unsigned, unsigned),
			   void *cb_value);
int wipe_freespace (const char * drive, HANDLE *r_fd,
		    void (*cb)(void *, unsigned __int64, unsigned __int64), 
		    void * cb_value);

#define listbox_add_string(lb, string) \
    SendMessage( (lb), LB_ADDSTRING, 0, (LPARAM)(LPCSTR)(string) )

#define listbox_get_cursel(lb) \
    SendMessage( (lb), LB_GETCURSEL, 0, 0 )

#define combox_add_string(cb, string) \
    SendMessage( (cb), CB_ADDSTRING, 0, (LPARAM)(LPCSTR)(string) )

#define item_get_text_length(dlg, itm) \
	SendDlgItemMessage ((dlg), (itm), WM_GETTEXTLENGTH, 0, 0)

#endif /* WPT_W32_API_H */