/* wptAboutDlgs.cpp - GPG and WinPT about dialogs
 *	Copyright (C) 2000-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <malloc.h>

#include "../resource.h"
#include "wptTypes.h"
#include "wptNLS.h"
#include "wptW32API.h"
#include "wptVersion.h"
#include "wptGPG.h"


static BOOL CALLBACK 
about_gpg_dlg_proc (HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam)
{	
    char * gpg_version = NULL;
    gpgme_error_t rc;
    
    switch( msg ) {
    case WM_INITDIALOG:
#ifndef LANG_DE
	SetWindowText( dlg, _("About the GNU Privacy Guard") );
#endif
	rc = gpgme_op_version( &gpg_version );
	if( rc || !gpg_version ) {
	    msg_box( dlg, gpgme_strerror( rc ), _("About GnuPG"), MB_ERR );
	    return FALSE;
	}
	SetDlgItemText( dlg, IDC_ABOUTGPG_INFO, gpg_version );
	free( gpg_version );
	center_window( dlg );
	SetForegroundWindow( dlg );	
	return TRUE;
        
    case WM_SYSCOMMAND:
	if( LOWORD( wparam ) == SC_CLOSE )
	    EndDialog( dlg, TRUE );
	return FALSE;
        
    case WM_COMMAND:
	switch( LOWORD( wparam ) ) {
	case IDOK:
	    EndDialog (dlg, TRUE);
	    return TRUE;
	}
	break;	
    }
    
    return FALSE;
} /* about_gpg_dlg_proc */


BOOL CALLBACK 
about_winpt_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    switch( msg ) {
    case WM_INITDIALOG:
#ifndef LANG_DE
	SetWindowText (dlg, _("About WinPT"));
	SetDlgItemText (dlg, IDC_ABOUT_INFO, 
                       _("A free open source privacy tray for Windows based on GnuPG."));
	SetDlgItemText (dlg, IDC_ABOUT_URL, 
                       _("For more information you can visit the homepage: http://www.winpt.org"));
	SetDlgItemText (dlg, IDC_ABOUT_BUGS, 
                       _("Please report any BUGS or suggestions for WinPT to <winpt@freakmail.de>"));
	SetDlgItemText (dlg, IDC_ABOUT_GPL1,
                       _("WinPT is free software; you can redistribute it and/or modify it under "
                         "the terms of the GNU General Public License as published by the Free "
                         "Software Foundation; either Version 2 of the License, or "
                         "(at your option) any later version."));
	SetDlgItemText(dlg, IDC_ABOUT_GPL2,
                       _("WinPT is distributed in the hope that it will be useful, but WITHOUT "
                         "ANY WARRANTY; without even the implied warranty of MERCHANTABLITY or "
                         "FITNESS FOR A PARTICULAR PURPOSE. See the General Public License for "
                         "more details. "));
	SetDlgItemText( dlg, IDC_WINPT_VERSION, PACKAGE_VERSION );
#endif
	center_window( dlg );
	SetForegroundWindow( dlg );
	return TRUE;
        
    case WM_SYSCOMMAND:
	if( LOWORD( wparam ) == SC_CLOSE )
	    EndDialog( dlg, TRUE );
        return FALSE;
        
    case WM_COMMAND:
	switch (LOWORD (wparam)) 
	{
	case IDC_ABOUT_GPG:
	    DialogBoxParam (glob_hinst, (LPCSTR)IDD_WINPT_ABOUTGPG, GetDesktopWindow(),
                              about_gpg_dlg_proc, NULL);
	    return TRUE;

	case IDC_ABOUT_HELP:
	    ShellExecute (dlg, "open", "winpt.chm", NULL, NULL, SW_SHOW);
	    break;

	case IDOK:
	    EndDialog( dlg, TRUE );
	    return TRUE;
	}
	break;
    }
    
    return FALSE;
} /* about_dlg_proc */

