/* wptCardManager.cpp
 *	Copyright (C) 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdio.h>
#include <windows.h>

#include "wptTypes.h"
#include "wptW32API.h"
#include "wptVersion.h"
#include "wptNLS.h"
#include "wptGPG.h"
#include "wptCard.h"
#include "../resource.h"


static BOOL CALLBACK
card_cb_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    static card_cb_s * ctx;

    switch( msg ) {
    case WM_INITDIALOG:
	ctx = (struct card_cb_s *)lparam;
	if( !ctx )
	    BUG( NULL );
	switch( ctx->code ) {
	case 1:
	    ShowWindow( GetDlgItem( dlg, IDC_CCTRL_VAL ), FALSE );
	    SetDlgItemText( dlg, IDC_CCTRL_MSG, 
		_("Please insert the OpenPGP smart card\n"
		  "Press OK to continue or Cancel") );
	    break;
	}
	center_window( dlg );
	SetForegroundWindow( dlg );
	break;

    case WM_COMMAND:
	switch( LOWORD( wparam ) ) {
	case IDOK:
	    strcpy( ctx->val, "\r\n" );
	    EndDialog( dlg, TRUE );
	    break;

	case IDCANCEL:
	    strcpy( ctx->val, "c" );
	    ctx->cancel = 1;
	    EndDialog( dlg, FALSE );
	    break;
	}
	break;
    }

    return FALSE;
} /* card_cb_dlg_proc */


const char *
card_callback( int code, void * opaque )
{
    struct card_cb_s * ctx = (struct card_cb_s *)opaque;

    if( !ctx )
	return NULL;

    if( !ctx->init ) {
	memset( ctx->val, 0, sizeof ctx->val );
	ctx->code = code;
	DialogBoxParam( glob_hinst, (LPCTSTR)IDD_WINPT_CARD_CTRL, glob_hwnd,
			card_cb_dlg_proc, (LPARAM)ctx );
	ctx->init = 0;
    }

    return ctx->val;
} /* card_callback */