/* wptGroupsDlg.cpp - Group management
 *	Copyright (C) 2001, 2002, 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <commctrl.h>
#include <stdio.h>

#include "../resource.h"
#include "wptTypes.h"
#include "wptW32API.h"
#include "wptErrors.h"
#include "wptNLS.h"
#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptContext.h"
#include "wptDlgs.h"
#include "wptKeyManager.h"


BOOL CALLBACK
group_manager_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{	
    static km_group_cb_s *ctx;
    char name[256];
    
    switch ( msg ) {
    case WM_INITDIALOG:
        ctx = (km_group_cb_s *)lparam;
        if (!ctx)
            dlg_fatal_error( dlg, "Can't get dialog param" );
#ifndef LANG_DE
        SetWindowText( dlg, _("New Group") );
#endif
        SetForegroundWindow( dlg );
        break;
        
    case WM_SYSCOMMAND:
        if( LOWORD(wparam) == SC_CLOSE ) {
            ctx->use_name = 0;
            EndDialog( dlg, TRUE );
        }
        return FALSE;
        
    case WM_COMMAND:
        switch( LOWORD( wparam ) ) {
        case IDOK:
            if( !GetDlgItemText(dlg, IDC_GROUP_EMAIL, name, sizeof name -1 ) ) {
                msg_box( dlg, _("Please enter the email address"), _("Group manager"), MB_ERR );
                return FALSE;
            }
	    add_group( ctx->gc->gh, name );
            strcpy( ctx->name, name );
            ctx->use_name = 1;
            EndDialog( dlg, TRUE );
            return TRUE;
            
        case IDCANCEL:
            ctx->use_name = 0;
            EndDialog( dlg, FALSE );
            return FALSE;
        }
        break;
    }
    
    return FALSE;
} /* group_manager_dlg_proc */
