/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-barchart-register.c
 *
 * Copyright (C) 2000 Helix Code, Inc.
 *
 * Developed by Jody Goldberg <jgoldberg@home.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/* $Id: init.c,v 1.1 2000/09/15 17:04:31 jody Exp $ */

#include <config.h>
#include <guppi-scripting.h>
#include <guppi-plot-plug-in.h>
#include "guppi-barchart-register.h"
#include "guppi-boxplot-register.h"
#include "guppi-linegraph-register.h"
#include "guppi-pie-register.h"
#include "guppi-scatter-register.h"

GuppiPlugIn* guppi_plug_in(void);

GuppiPlugIn*
guppi_plug_in(void)
{
  GuppiPlugIn* pi;
  GuppiPlotPlugIn* ppi;

  pi = guppi_plot_plug_in_new();
  ppi = GUPPI_PLOT_PLUG_IN(pi);

  pi->magic_number = GUPPI_PLUG_IN_MAGIC_NUMBER;
  ppi->element_constructor = NULL;

  guppi_barchart_register ();
  guppi_boxplot_register ();
  guppi_linegraph_register ();
  guppi_piechart_register ();
  guppi_scatter_register ();

  return pi;
}
