/*
 * Copyright 2000 Murray Cumming
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

 /**
  *@author Murray Cumming
  */

#ifndef BAKERY_DOCUMENT_H
#define BAKERY_DOCUMENT_H

#include "../View/View.h"
#include <gnome--.h>
#include <libgnome/gnome-i18n.h>

#include <iostream>
#include <string>

namespace Bakery
{

//The Document is like the 'Model' in the Model-View-Controller framework.
//Each App should have a Document.
//Each View gets and sets data in its document.
class Document
{
public: 
  Document();
  virtual ~Document();

  //Saves the data to disk.
  //Asks the View to update this document before saving to disk,
  //but you should probably ensure that the document is updated more regularly than this,
  //so that different parts of the GUI are synchronized.
  //Only saves if the document has been modified.
  //bool indicates success:
  virtual bool save();

  //Loads data from disk, then asks the View to update itself.
  //bool indicates success:
  virtual bool load();

  virtual bool get_modified() const;
  virtual void set_modified(bool bVal = true);

  virtual bool get_is_new() const; //Whether this just a default document.
  void set_is_new(bool bVal); //Called by App_WithDoc::init_create_document().

  virtual std::string get_contents() const;
  virtual void set_contents(const std::string& strVal);

  virtual std::string get_filepath() const;
  virtual void set_filepath(const std::string& strVal, bool bEnforceFileExtension = false);

  virtual std::string get_name() const; //Gets filename part of filepath, or 'untitled'.
  static std::string util_filepath_get_name(const std::string& filePath);

  virtual bool get_read_only() const;
  virtual void set_read_only(bool bVal);
  
  //If you don't want to use a View, then don't use set_view().
  virtual void set_view(ViewBase* pView);
  virtual ViewBase* get_view();

  virtual void set_file_extension(const std::string& strVal);
  virtual std::string get_file_extension() const;

  //Signals:
  SigC::Signal0<void> signal_modified; //Allow app to update icons/title bar.

protected:
  std::string m_strContents;
  std::string m_strFilePath;
  std::string m_strFileExtension;

  ViewBase* m_pView;

  bool m_bModified;
  bool m_bIsNew; //see get_is_new().
  bool m_bReadOnly;
};

} //namespace

#endif //GNOME_APPWITHDOCS_DOCUMENT_H
