/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * This file is part of capuchin-glib. 
 *
 * Copyright (C) Sebastian Pölsterl 2008 <marduk@k-d-w.org>
 * 
 * capuchin-glib is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option)
 * any later version.
 * 
 * capuchin-glib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with capuchin-glib.
 * If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CAPUCHIN_G_PLUGIN_INFO_H_
#define _CAPUCHIN_G_PLUGIN_INFO_H_

#include <glib-object.h>

G_BEGIN_DECLS

#define CAPUCHIN_TYPE_G_PLUGIN_INFO             (capuchin_g_plugin_info_get_type ())
#define CAPUCHIN_G_PLUGIN_INFO(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAPUCHIN_TYPE_G_PLUGIN_INFO, CapuchinGPluginInfo))
#define CAPUCHIN_G_PLUGIN_INFO_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), CAPUCHIN_TYPE_G_PLUGIN_INFO, CapuchinGPluginInfoClass))
#define CAPUCHIN_IS_G_PLUGIN_INFO(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAPUCHIN_TYPE_G_PLUGIN_INFO))
#define CAPUCHIN_IS_G_PLUGIN_INFO_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), CAPUCHIN_TYPE_G_PLUGIN_INFO))
#define CAPUCHIN_G_PLUGIN_INFO_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), CAPUCHIN_TYPE_G_PLUGIN_INFO, CapuchinGPluginInfoClass))

typedef struct _CapuchinGPluginInfoClass CapuchinGPluginInfoClass;
typedef struct _CapuchinGPluginInfo CapuchinGPluginInfo;
typedef struct _CapuchinGPluginInfoPrivate CapuchinGPluginInfoPrivate;

struct _CapuchinGPluginInfoClass
{
	GObjectClass parent_class;
};

struct _CapuchinGPluginInfo
{
	GObject parent_instance;
	CapuchinGPluginInfoPrivate *priv;
};

GType capuchin_g_plugin_info_get_type (void) G_GNUC_CONST;
CapuchinGPluginInfo* capuchin_g_plugin_info_new (const gchar *plugin_id, const gchar *version);

G_END_DECLS

#endif /* _CAPUCHIN_G_PLUGIN_INFO_H_ */
