// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_BEHAVIOUR_ELLIPSE_H
#define _CLUTTERMM_BEHAVIOUR_ELLIPSE_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/behaviour.h>
#include <cluttermm/alpha.h>
#include <cluttermm/types.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterBehaviourEllipse ClutterBehaviourEllipse;
typedef struct _ClutterBehaviourEllipseClass ClutterBehaviourEllipseClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class BehaviourEllipse_Class; } // namespace Clutter
namespace Clutter
{


class BehaviourEllipse : public Behaviour
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef BehaviourEllipse CppObjectType;
  typedef BehaviourEllipse_Class CppClassType;
  typedef ClutterBehaviourEllipse BaseObjectType;
  typedef ClutterBehaviourEllipseClass BaseClassType;

private:  friend class BehaviourEllipse_Class;
  static CppClassType behaviourellipse_class_;

private:
  // noncopyable
  BehaviourEllipse(const BehaviourEllipse&);
  BehaviourEllipse& operator=(const BehaviourEllipse&);

protected:
  explicit BehaviourEllipse(const Glib::ConstructParams& construct_params);
  explicit BehaviourEllipse(ClutterBehaviourEllipse* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~BehaviourEllipse();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterBehaviourEllipse*       gobj()       { return reinterpret_cast<ClutterBehaviourEllipse*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterBehaviourEllipse* gobj() const { return reinterpret_cast<ClutterBehaviourEllipse*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterBehaviourEllipse* gobj_copy();

private:


protected:
  explicit BehaviourEllipse(const Glib::RefPtr<Alpha>& alpha, int x, int y, int width, int height, RotateDirection direction, double begin, double end);
  explicit BehaviourEllipse(const Glib::RefPtr<Alpha>& alpha, int x, int y, int width, int height, RotateDirection direction, Fixed begin, Fixed end);

public:
  
  static Glib::RefPtr<BehaviourEllipse> create(const Glib::RefPtr<Alpha>& alpha, int x, int y, int width, int height, RotateDirection direction, double begin, double end);

  
  static Glib::RefPtr<BehaviourEllipse> create(const Glib::RefPtr<Alpha>& alpha, int x, int y, int width, int height, RotateDirection direction, Fixed begin, Fixed end);


  /** Sets the center of the elliptical path to the point represented by knot.
   * 
   * Since: 0.4
   * @param x X coordinace of centre.
   * @param y Y coordinace of centre.
   */
  void set_center(int x, int y);
  
  /** Gets the center of the elliptical path path.
   * 
   * Since: 0.4
   * @param x Location to store the x coordinace of the center, or <tt>0</tt>.
   * @param y Location to store the y coordinace of the center, or <tt>0</tt>.
   */
  void get_center(int& x, int& y) const;

  
  /** Sets the height of the elliptical path.
   * 
   * Since: 0.4
   * @param height Height of the ellipse.
   */
  void set_height(int height);
  
  /** Gets the height of the elliptical path.
   * @return The height of the path
   * 
   * Since: 0.4.
   */
  int get_height() const;
  
  /** Sets the width of the elliptical path.
   * 
   * Since: 0.4
   * @param width Width of the ellipse.
   */
  void set_width(int width);
  
  /** Gets the width of the elliptical path.
   * @return The width of the path
   * 
   * Since: 0.4.
   */
  int get_width() const;

  
  /** Sets the angle at which movement starts; angles &gt;= 360 degress get clamped
   * to the canonical interval &lt;0, 360).
   * 
   * Since: 0.6
   * @param angle_start Angle at which movement starts in degrees, between 0 and 360.
   */
  void set_angle_start(double angle_start);
  
  /** Gets the angle at which movements starts.
   * @return Angle in degrees
   * 
   * Since: 0.6.
   */
  double get_angle_start() const;
  
  /** Sets the angle at which movement ends; angles &gt;= 360 degress get clamped
   * to the canonical interval &lt;0, 360).
   * 
   * Since: 0.4
   * @param angle_end Angle at which movement ends in degrees, between 0 and 360.
   */
  void set_angle_end(double angle_end);
  
  /** Gets the at which movements ends.
   * @return Angle in degrees
   * 
   * Since: 0.4.
   */
  double get_angle_end() const;
  
  /** Sets the angle at which the ellipse should be tilted around it's center.
   * 
   * Since: 0.4
   * @param axis A Clutter::RotateAxis.
   * @param angle_tilt Tilt of the elipse around the center in the given axis in
   * degrees.
   */
  void set_angle_tilt(RotateAxis axis, double angle_tilt);
  
  /** Gets the tilt of the ellipse around the center in the given axis.
   * @param axis A Clutter::RotateAxis.
   * @return Angle in degrees.
   * 
   * Since: 0.4.
   */
  double get_angle_tilt(RotateAxis axis) const;

  
  /** Sets the angles at which the ellipse should be tilted around it's center.
   * 
   * Since: 0.4
   * @param angle_tilt_x Tilt of the elipse around the center in X axis in degrees.
   * @param angle_tilt_y Tilt of the elipse around the center in Y axis in degrees.
   * @param angle_tilt_z Tilt of the elipse around the center in Z axis in degrees.
   */
  void set_tilt(double angle_tilt_x, double angle_tilt_y, double angle_tilt_z);
  
  /** Gets the tilt of the ellipse around the center in Y axis.
   * 
   * Since: 0.4
   * @param angle_tilt_x Return location for tilt angle on the X axis, or <tt>0</tt>.
   * @param angle_tilt_y Return location for tilt angle on the Y axis, or <tt>0</tt>.
   * @param angle_tilt_z Return location for tilt angle on the Z axis, or <tt>0</tt>.
   */
  void get_tilt(double& angle_tilt_x, double& angle_tilt_y, double& angle_tilt_z) const;

  
  /** Sets the angle at which movement starts; angles &gt;= 360 degress get clamped
   * to the canonical interval &lt;0, 360).
   * 
   * Since: 0.6
   * @param angle_start An angle, as Clutter::Fixed, at which movement starts, in
   * degrees, between 0 and 360.
   */
  void set_angle_startx(Fixed angle_start);
  
  /** Gets the angle at which movements starts.
   * @return Angle, as Clutter::Fixed, in degrees.
   * 
   * Since: 0.6.
   */
  Fixed get_angle_startx() const;
  
  /** Sets the angle at which movement ends; angles &gt;= 360 degress get clamped
   * to the canonical interval &lt;0, 360).
   * 
   * Since: 0.4
   * @param angle_end Angle, as Clutter::Fixed, at which movement ends, in degrees,
   * between 0 and 360.
   */
  void set_angle_endx(Fixed angle_end);
  
  /** Gets the angle at which movements ends.
   * @return Angle, as Clutter::Fixed, in degrees
   * 
   * Since: 0.4.
   */
  Fixed get_angle_endx() const;
  
  /** Sets the angle at which the ellipse should be tilted around it's center.
   * 
   * Since: 0.4
   * @param axis A Clutter::RoateAxis.
   * @param angle_tilt Tilt, as Clutter::Fixed, of the elipse around the center in the given
   * axis in degrees.
   */
  void set_angle_tiltx(RotateAxis axis, Fixed angle_tilt);
  
  /** Gets the tilt of the ellipse around the center in the given axis.
   * @param axis A Clutter::RotateAxis.
   * @return Angle, as Clutter::Fixed, in degrees
   * 
   * Since: 0.4.
   */
  Fixed get_angle_tiltx(RotateAxis axis) const;

  
  /** Sets the angle at which the ellipse should be tilted around it's center.
   * 
   * Since: 0.4
   * @param angle_tilt_x Tilt of the elipse in degrees, as Clutter::Fixed, around the center in X axis.
   * @param angle_tilt_y Tilt of the elipse in degrees, as Clutter::Fixed, around the center in Y axis.
   * @param angle_tilt_z Tilt of the elipse in degrees, as Clutter::Fixed, around the center in Z axis.
   */
  void set_tiltx(Fixed angle_tilt_x, Fixed angle_tilt_y, Fixed angle_tilt_z);
  
  /** Gets the tilt of the ellipse around the center in Y axis.
   * 
   * Since: 0.4
   * @param angle_tilt_x Location for tilt of the elipse, as Clutter::Fixed, around the
   * center in X axis in degrees, or <tt>0</tt>.
   * @param angle_tilt_y Location for tilt of the elipse, as Clutter::Fixed, around the
   * center in Y axis in degress, or <tt>0</tt>.
   * @param angle_tilt_z Location for tilt of the elipse, as Clutter::Fixed, around the
   * center in Z axis in degrees, or <tt>0</tt>.
   */
  void get_tiltx(Fixed& angle_tilt_x, Fixed& angle_tilt_y, Fixed& angle_tilt_z) const;

  
  /** Sets the rotation direction used by the ellipse behaviour.
   * 
   * Since: 0.4
   * @param direction The rotation direction.
   */
  void set_direction(RotateDirection direction);
  
  /** Retrieves the Clutter::RotateDirection used by the ellipse behaviour.
   * @return The rotation direction
   * 
   * Since: 0.4.
   */
  RotateDirection get_direction() const;

  //gtkmmproc error: knot_reached :  signal defs lookup failed

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Final angle.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_angle_end() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Final angle.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_angle_end() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Initial angle.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_angle_start() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Initial angle.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_angle_start() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Tilt of the ellipse around x axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_angle_tilt_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Tilt of the ellipse around x axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_angle_tilt_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Tilt of the ellipse around y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_angle_tilt_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Tilt of the ellipse around y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_angle_tilt_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Center of ellipse.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Knot> property_center() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Center of ellipse.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Knot> property_center() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Direction of rotation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<RotateDirection> property_direction() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Direction of rotation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<RotateDirection> property_direction() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Height of ellipse.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_height() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Height of ellipse.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of ellipse.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of ellipse.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter
// vim:ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::BehaviourEllipse
   */
  Glib::RefPtr<Clutter::BehaviourEllipse> wrap(ClutterBehaviourEllipse* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_BEHAVIOUR_ELLIPSE_H */

