// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_CONTAINER_H
#define _CLUTTERMM_CONTAINER_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/actor.h>
#include <glibmm/interface.h>
#include <glibmm/ustring.h>
#include <clutter/clutter-container.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterContainer ClutterContainer;
typedef struct _ClutterContainerClass ClutterContainerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Container_Class; } // namespace Clutter
namespace Clutter
{


class Container : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Container CppObjectType;
  typedef Container_Class CppClassType;
  typedef ClutterContainer BaseObjectType;
  typedef ClutterContainerIface BaseClassType;

private:
  friend class Container_Class;
  static CppClassType container_class_;

  // noncopyable
  Container(const Container&);
  Container& operator=(const Container&);

protected:
  Container(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit Container(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Container(ClutterContainer* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Container();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterContainer*       gobj()       { return reinterpret_cast<ClutterContainer*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const ClutterContainer* gobj() const { return reinterpret_cast<ClutterContainer*>(gobject_); }

private:


public:
  
  /** Adds a Clutter::Actor to @a container. This function will emit the
   * "actor-added" signal. The actor should be parented to
   *  @a container. You cannot add a Clutter::Actor to more than one
   * Clutter::Container.
   * 
   * Since: 0.4
   * @param actor The first Clutter::Actor to add.
   */
  void add_actor(const Glib::RefPtr<Actor>& actor);
  
  /** Removes @a actor from @a container. The actor should be unparented, so
   * if you want to keep it around you must hold a reference to it
   * yourself, using Glib::object_ref(). When the actor has been removed,
   * the "actor-removed" signal is emitted by @a container.
   * 
   * Since: 0.4
   * @param actor A Clutter::Actor.
   */
  void remove_actor(const Glib::RefPtr<Actor>& actor);

 
  /** Retrieves all the children of @a container.
   * @return A list of Clutter::Actor&lt;!-- --&gt;s. Use Glib::list_free()
   * on the returned list when done.
   * 
   * Since: 0.4.
   */
  Glib::ListHandle<Glib::RefPtr<Actor> > get_children();
  
  /** Retrieves all the children of @a container.
   * @return A list of Clutter::Actor&lt;!-- --&gt;s. Use Glib::list_free()
   * on the returned list when done.
   * 
   * Since: 0.4.
   */
  Glib::ListHandle<Glib::RefPtr<const Actor> > get_children() const;

  
  /** Lowers @a actor to @a sibling level, in the depth ordering.
   * 
   * Since: 0.6
   * @param actor The actor to raise.
   * @param sibling The sibling to lower to, or <tt>0</tt> to lower to the bottom.
   */
  void lower_child(const Glib::RefPtr<Actor>& actor, const Glib::RefPtr<Actor>& sibling);
  void lower_child(const Glib::RefPtr<Actor>& actor);
  
  /** Raises @a actor to @a sibling level, in the depth ordering.
   * 
   * Since: 0.6
   * @param actor The actor to raise.
   * @param sibling The sibling to raise to, or <tt>0</tt> to raise to the top.
   */
  void raise_child(const Glib::RefPtr<Actor>& actor, const Glib::RefPtr<Actor>& sibling);
  void raise_child(const Glib::RefPtr<Actor>& actor);

  
  /** Finds a child actor of a container by its name. Search recurses
   * into any child container.
   * @param child_name The name of the requested child.
   * @return The child actor with the requested name, or <tt>0</tt> if no
   * actor with that name was found.
   * 
   * Since: 0.6.
   */
  Glib::RefPtr<Actor> find_child (const Glib::ustring& child_name);
  
  /** Finds a child actor of a container by its name. Search recurses
   * into any child container.
   * @param child_name The name of the requested child.
   * @return The child actor with the requested name, or <tt>0</tt> if no
   * actor with that name was found.
   * 
   * Since: 0.6.
   */
  Glib::RefPtr<const Actor> find_child (const Glib::ustring& child_name) const;

  /** For instance, 
   * void on_foreach(const Glib::RefPtr<Actor>& actor)
   */
  typedef sigc::slot<void, const Glib::RefPtr<Actor>&> SlotForEach;

  void foreach(const SlotForEach& slot);
  

  // not sure the valist stuff is good to wrap in C++
  

  // TODO: Do we want to wrap clutter_container_get/set_child_property, and/or
  // clutter_container_get_child_meta?

 
  /**
   * @par Prototype:
   * <tt>void on_my_%actor_added(const Glib::RefPtr<Actor>& actor)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > signal_actor_added();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%actor_removed(const Glib::RefPtr<Actor>& actor)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > signal_actor_removed();


  // TODO: child-notify signal? Perhaps doesn't make sense until we wrap
  // the ClutterChildMeta stuff, and clutter_container_get/set_child_property.

protected:

  // Only useful as a protected method for derived implementations.
  
  /** Sorts a container's children using their depth. This function should not
   * be normally used by applications.
   * 
   * Since: 0.6
   */
  void sort_depth_order();

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void add_vfunc(const Glib::RefPtr<Actor>& actor);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void remove_vfunc(const Glib::RefPtr<Actor>& actor);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void raise_vfunc(const Glib::RefPtr<Actor>& actor, const Glib::RefPtr<Actor>& sibling);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void lower_vfunc(const Glib::RefPtr<Actor>& actor, const Glib::RefPtr<Actor>& lower);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void sort_depth_order_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void foreach_vfunc(ClutterCallback callback, gpointer user_data);
#endif //GLIBMM_VFUNCS_ENABLED


  // TODO: Do we want to wrap create_child_meta, destory_child_meta,
  // get_child_meta?


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_actor_added(const Glib::RefPtr<Actor>& actor);
  virtual void on_actor_removed(const Glib::RefPtr<Actor>& actor);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter
//vim: ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Container
   */
  Glib::RefPtr<Clutter::Container> wrap(ClutterContainer* object, bool take_copy = false);

} // namespace Glib


#endif /* _CLUTTERMM_CONTAINER_H */

