// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_TIMEOUT_POOL_H
#define _CLUTTERMM_TIMEOUT_POOL_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <clutter/clutter-timeout-pool.h>


namespace Clutter
{

/** A timeout pool should be used when multiple timeout functions, running at
 * the same priority, are needed and the Glib::SignalTimeout API might lead to
 * starvation of the time slice of the main loop. A timeout pool allocates a
 * single time slice of the main loop and runs every timeout function
 * inside it. The timeout pool is always sorted, so that the extraction of
 * the next timeout function is a constant time operation.
 *
 * Inside Clutter, every Timeline share the same timeout pool, unless the
 * CLUTTER_TIMELINE=no-pool environment variable is set.
 */
class TimeoutPool
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TimeoutPool CppObjectType;
  typedef ClutterTimeoutPool BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:


public:
  explicit TimeoutPool(int priority);

  typedef sigc::slot<bool> TimeoutSlot;
  
  /** Sets a function to be called at regular intervals, and puts it inside
   * the @a pool. The function is repeatedly called until it returns <tt>false</tt>,
   * at which point the timeout is automatically destroyed and the function
   * won't be called again. If @a notify is not <tt>0</tt>, the @a notify function
   * will be called. The first call to @a func will be at the end of @a interval.
   * 
   * Since version 0.8 this will try to compensate for delays. For
   * example, if @a func takes half the interval time to execute then the
   * function will be called again half the interval time after it
   * finished. Before version 0.8 it would not fire until a full
   * interval after the function completes so the delay between calls
   * would be @a interval * 1.5. This function does not however try to
   * invoke the function multiple times to catch up missing frames if
   *  @a func takes more than @a interval ms to execute.
   * @param interval The time between calls to the function, in milliseconds.
   * @param func Function to call.
   * @param data Data to pass to the function, or <tt>0</tt>.
   * @param notify Function to call when the timeout is removed, or <tt>0</tt>.
   * @return The ID (greater than 0) of the timeout inside the pool.
   * Use clutter_timeout_pool_remove() to stop the timeout.
   * 
   * Since: 0.4.
   */

  guint add(guint interval, const TimeoutSlot& func, int priority = Glib::PRIORITY_DEFAULT);

  
  /** Removes a timeout function with @a id from the timeout pool. The id
   * is the same returned when adding a function to the timeout pool with
   * clutter_timeout_pool_add().
   * 
   * Since: 0.4
   * @param id The id of the timeout to remove.
   */
  void remove(guint id);

  ClutterTimeoutPool* gobj() { return gobject_; }
  const ClutterTimeoutPool* gobj() const { return gobject_; }

protected:
  ClutterTimeoutPool* gobject_;

private:
  // noncopyable:
  TimeoutPool(const TimeoutPool& other);
  TimeoutPool& operator=(const TimeoutPool& other);


};

}


#endif /* _CLUTTERMM_TIMEOUT_POOL_H */

