// Generated by gtkmmproc -- DO NOT MODIFY!


#include <cluttermm/timeline.h>
#include <cluttermm/private/timeline_p.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <clutter/clutter.h>

namespace Clutter
{

guint Timeline::get_delta() const
{
  return clutter_timeline_get_delta(const_cast<ClutterTimeline*>(gobj()), NULL);
}

Glib::StringArrayHandle Timeline::list_markers(gint frame_num) const
{
  gsize n_markers;
  gchar** markers = clutter_timeline_list_markers(const_cast<ClutterTimeline*>(gobj()), frame_num, &n_markers);
  return Glib::StringArrayHandle(markers, n_markers, Glib::OWNERSHIP_DEEP);
}

} //namespace Clutter


namespace
{


static const Glib::SignalProxyInfo Timeline_signal_completed_info =
{
  "completed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Timeline_signal_new_frame_callback(ClutterTimeline* self, gint p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,gint > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Timeline_signal_new_frame_info =
{
  "new-frame",
  (GCallback) &Timeline_signal_new_frame_callback,
  (GCallback) &Timeline_signal_new_frame_callback
};


static const Glib::SignalProxyInfo Timeline_signal_paused_info =
{
  "paused",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Timeline_signal_started_info =
{
  "started",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Timeline_signal_marker_reached_callback(ClutterTimeline* self, const gchar* p0,gint p1,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,const Glib::ustring&,int > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::convert_const_gchar_ptr_to_ustring(p0)
, p1
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Timeline_signal_marker_reached_info =
{
  "marker-reached",
  (GCallback) &Timeline_signal_marker_reached_callback,
  (GCallback) &Timeline_signal_marker_reached_callback
};


} // anonymous namespace

// static
GType Glib::Value<Clutter::TimelineDirection>::value_type()
{
  return clutter_timeline_direction_get_type();
}


namespace Glib
{

Glib::RefPtr<Clutter::Timeline> wrap(ClutterTimeline* object, bool take_copy)
{
  return Glib::RefPtr<Clutter::Timeline>( dynamic_cast<Clutter::Timeline*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Clutter
{


/* The *_Class implementation: */

const Glib::Class& Timeline_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Timeline_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(clutter_timeline_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Timeline_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->completed = &completed_callback;
  klass->new_frame = &new_frame_callback;
  klass->paused = &paused_callback;
  klass->started = &started_callback;
  klass->marker_reached = &marker_reached_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Timeline_Class::completed_callback(ClutterTimeline* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_completed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->completed)
    (*base->completed)(self);
}
void Timeline_Class::new_frame_callback(ClutterTimeline* self, gint p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_new_frame(p0);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->new_frame)
    (*base->new_frame)(self, p0);
}
void Timeline_Class::paused_callback(ClutterTimeline* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_paused();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->paused)
    (*base->paused)(self);
}
void Timeline_Class::started_callback(ClutterTimeline* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_started();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->started)
    (*base->started)(self);
}
void Timeline_Class::marker_reached_callback(ClutterTimeline* self, const gchar* p0, gint p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_marker_reached(Glib::convert_const_gchar_ptr_to_ustring(p0)
, p1
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->marker_reached)
    (*base->marker_reached)(self, p0, p1);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Timeline_Class::wrap_new(GObject* object)
{
  return new Timeline((ClutterTimeline*)object);
}


/* The implementation: */

ClutterTimeline* Timeline::gobj_copy()
{
  reference();
  return gobj();
}

Timeline::Timeline(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Timeline::Timeline(ClutterTimeline* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

Timeline::~Timeline()
{}


Timeline::CppClassType Timeline::timeline_class_; // initialize static member

GType Timeline::get_type()
{
  return timeline_class_.init().get_type();
}

GType Timeline::get_base_type()
{
  return clutter_timeline_get_type();
}


Timeline::Timeline(guint num_frames, guint fps)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(timeline_class_.init(), "num_frames", num_frames, "fps", fps, static_cast<char*>(0)))
{
  

}

Timeline::Timeline(guint duration)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(timeline_class_.init(), "duration", duration, static_cast<char*>(0)))
{
  

}

Glib::RefPtr<Timeline> Timeline::create(guint n_frames, guint fps)
{
  return Glib::RefPtr<Timeline>( new Timeline(n_frames, fps) );
}
Glib::RefPtr<Timeline> Timeline::create(guint msecs)
{
  return Glib::RefPtr<Timeline>( new Timeline(msecs) );
}
Glib::RefPtr<Timeline> Timeline::clone() const
{
  return Glib::wrap(clutter_timeline_clone(const_cast<ClutterTimeline*>(gobj())));
}

void Timeline::set_duration(guint msecs)
{
clutter_timeline_set_duration(gobj(), msecs); 
}

guint Timeline::get_duration() const
{
  return clutter_timeline_get_duration(const_cast<ClutterTimeline*>(gobj()));
}

void Timeline::set_speed(guint fps)
{
clutter_timeline_set_speed(gobj(), fps); 
}

guint Timeline::get_speed() const
{
  return clutter_timeline_get_speed(const_cast<ClutterTimeline*>(gobj()));
}

void Timeline::start()
{
clutter_timeline_start(gobj()); 
}

void Timeline::pause()
{
clutter_timeline_pause(gobj()); 
}

void Timeline::stop()
{
clutter_timeline_stop(gobj()); 
}

void Timeline::rewind()
{
clutter_timeline_rewind(gobj()); 
}

void Timeline::set_loop(bool loop)
{
clutter_timeline_set_loop(gobj(), static_cast<int>(loop)); 
}

bool Timeline::get_loop() const
{
  return clutter_timeline_get_loop(const_cast<ClutterTimeline*>(gobj()));
}

void Timeline::skip(guint n_frames)
{
clutter_timeline_skip(gobj(), n_frames); 
}

void Timeline::advance(guint frame_num)
{
clutter_timeline_advance(gobj(), frame_num); 
}

int Timeline::get_current_frame() const
{
  return clutter_timeline_get_current_frame(const_cast<ClutterTimeline*>(gobj()));
}

guint Timeline::get_delta(guint& msecs) const
{
  return clutter_timeline_get_delta(const_cast<ClutterTimeline*>(gobj()), &(msecs));
}

void Timeline::set_n_frames(guint n_frames)
{
clutter_timeline_set_n_frames(gobj(), n_frames); 
}

guint Timeline::get_n_frames() const
{
  return clutter_timeline_get_n_frames(const_cast<ClutterTimeline*>(gobj()));
}

bool Timeline::is_playing() const
{
  return clutter_timeline_is_playing(const_cast<ClutterTimeline*>(gobj()));
}

void Timeline::set_delay(guint msecs)
{
clutter_timeline_set_delay(gobj(), msecs); 
}

guint Timeline::get_delay() const
{
  return clutter_timeline_get_delay(const_cast<ClutterTimeline*>(gobj()));
}

double Timeline::get_progress() const
{
  return clutter_timeline_get_progress(const_cast<ClutterTimeline*>(gobj()));
}

Fixed Timeline::get_progressx() const
{
  return clutter_timeline_get_progressx(const_cast<ClutterTimeline*>(gobj()));
}

void Timeline::set_direction(TimelineDirection direction)
{
clutter_timeline_set_direction(gobj(), ((ClutterTimelineDirection)(direction))); 
}

TimelineDirection Timeline::get_direction() const
{
  return ((TimelineDirection)(clutter_timeline_get_direction(const_cast<ClutterTimeline*>(gobj()))));
}

void Timeline::add_marker_at_time(const Glib::ustring& marker_name, guint msecs)
{
clutter_timeline_add_marker_at_time(gobj(), marker_name.c_str(), msecs); 
}

void Timeline::add_marker_at_frame(const Glib::ustring& marker_name, guint frame_num)
{
clutter_timeline_add_marker_at_frame(gobj(), marker_name.c_str(), frame_num); 
}

bool Timeline::has_marker(const Glib::ustring& marker_name)
{
  return clutter_timeline_has_marker(gobj(), marker_name.c_str());
}

void Timeline::remove_marker(const Glib::ustring& marker_name)
{
clutter_timeline_remove_marker(gobj(), marker_name.c_str()); 
}

void Timeline::advance_to_marker(const Glib::ustring& marker_name)
{
clutter_timeline_advance_to_marker(gobj(), marker_name.c_str()); 
}


Glib::SignalProxy0< void > Timeline::signal_completed()
{
  return Glib::SignalProxy0< void >(this, &Timeline_signal_completed_info);
}


Glib::SignalProxy1< void,gint > Timeline::signal_new_frame()
{
  return Glib::SignalProxy1< void,gint >(this, &Timeline_signal_new_frame_info);
}


Glib::SignalProxy0< void > Timeline::signal_paused()
{
  return Glib::SignalProxy0< void >(this, &Timeline_signal_paused_info);
}


Glib::SignalProxy0< void > Timeline::signal_started()
{
  return Glib::SignalProxy0< void >(this, &Timeline_signal_started_info);
}


Glib::SignalProxy2< void,const Glib::ustring&,int > Timeline::signal_marker_reached()
{
  return Glib::SignalProxy2< void,const Glib::ustring&,int >(this, &Timeline_signal_marker_reached_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<guint> Timeline::property_delay() 
{
  return Glib::PropertyProxy<guint>(this, "delay");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<guint> Timeline::property_delay() const
{
  return Glib::PropertyProxy_ReadOnly<guint>(this, "delay");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<TimelineDirection> Timeline::property_direction() 
{
  return Glib::PropertyProxy<TimelineDirection>(this, "direction");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<TimelineDirection> Timeline::property_direction() const
{
  return Glib::PropertyProxy_ReadOnly<TimelineDirection>(this, "direction");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<guint> Timeline::property_duration() 
{
  return Glib::PropertyProxy<guint>(this, "duration");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<guint> Timeline::property_duration() const
{
  return Glib::PropertyProxy_ReadOnly<guint>(this, "duration");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<guint> Timeline::property_fps() 
{
  return Glib::PropertyProxy<guint>(this, "fps");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<guint> Timeline::property_fps() const
{
  return Glib::PropertyProxy_ReadOnly<guint>(this, "fps");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Timeline::property_loop() 
{
  return Glib::PropertyProxy<bool>(this, "loop");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Timeline::property_loop() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "loop");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<guint> Timeline::property_num_frames() 
{
  return Glib::PropertyProxy<guint>(this, "num-frames");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<guint> Timeline::property_num_frames() const
{
  return Glib::PropertyProxy_ReadOnly<guint>(this, "num-frames");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Clutter::Timeline::on_completed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->completed)
    (*base->completed)(gobj());
}
void Clutter::Timeline::on_new_frame(gint fram_num)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->new_frame)
    (*base->new_frame)(gobj(),fram_num);
}
void Clutter::Timeline::on_paused()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->paused)
    (*base->paused)(gobj());
}
void Clutter::Timeline::on_started()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->started)
    (*base->started)(gobj());
}
void Clutter::Timeline::on_marker_reached(const Glib::ustring& marker_name, int frame_num)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->marker_reached)
    (*base->marker_reached)(gobj(),marker_name.c_str(),frame_num);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Clutter


