using System;
using System.Collections;
using Gtk;
using GLib;
using Evolution;

namespace BookBindingsTest {
	public class BookBindingsTest {

                private void OnContactsAdded (object o,
                                              Evolution.ContactsAddedArgs args)
                {
			Console.WriteLine ("Contacts added:");
			foreach (Contact contact in args.Contacts) {
				Console.WriteLine ("\nId: {0}", contact.Id);
				Console.WriteLine ("Fullname: {0}", contact.FullName);
			}
                }

                private void OnContactsChanged (object o,
                                                Evolution.ContactsChangedArgs args)
                {

                }

                private void OnContactsRemoved (object o,
                                                Evolution.ContactsRemovedArgs args)
                {
			
		}

		public static void Main (string[] args)
		{
			Application.Init ();

			SourceList slist = new SourceList ("/apps/evolution/addressbook/sources");
			if (slist != null) {
				SList group_list = slist.Groups;
				Console.WriteLine ("Group count: {0}", group_list.Count);
				foreach (SourceGroup group in group_list) {
					Console.WriteLine ("UID: {0}, Name: {1}", group.Uid, group.Name);
					SList src_list = group.Sources;
					foreach (Evolution.Source src in src_list) {
						Book bk = Book.NewSystemAddressbook ();
						//Book bk = new Book (src);
					       	bk.Open (true);

						Console.WriteLine ("UID: {0}, Name: {1}", src.Uid, src.Name);
						Evolution.BookQuery q = Evolution.BookQuery.AnyFieldContains ("");
						
						ArrayList dummy = new ArrayList ();
						BookView bk_view = bk.GetBookView (q, dummy, -1);

						BookBindingsTest t = new BookBindingsTest ();
						bk_view.ContactsChanged += t.OnContactsChanged;
						bk_view.ContactsAdded += t.OnContactsAdded;
						bk_view.ContactsRemoved += t.OnContactsRemoved;
							
						bk_view.Start ();
						
						Contact[] contactlist = bk.GetContacts (q);
						Console.WriteLine ("Contact count (range) : {0}", contactlist.Length);
												 
						
						if (contactlist != null) {
							foreach (Contact comp in contactlist) {
								Console.WriteLine ("Id: {0}", comp.Id);
								Console.WriteLine ("Fullname: {0}", comp.FullName);
							}
						} else 
							Console.WriteLine ("No event strings found");

						Contact[] newcontacts;
						Contact[] updated;
						string[] removed;

						bk.GetChanges ("TestBook-testing", 
							       out newcontacts, 
							       out updated, 
							       out removed);
						if (newcontacts != null)
							Console.WriteLine ("Newly added: {0}", newcontacts.Length);

						if (updated != null)
							Console.WriteLine ("Updated : {0}", updated.Length);

						if (removed != null)
							Console.WriteLine ("removed added: {0}", removed.Length);
					}
					
				}
				
			}
			else
				Console.WriteLine ("slist is NULL");

			Application.Run ();
		}
	}
}
