/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* main.c
 *
 * Copyright (C) 1999-2008 Novell, Inc. (www.novell.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Author: Ettore Perazzoli
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>
#include <glib/gi18n.h>
#include <libgnome/gnome-init.h>
#include <glade/glade.h>

#include <bonobo/bonobo-main.h>
#include <bonobo/bonobo-shlib-factory.h>
#include <bonobo/bonobo-exception.h>

#include "dialogs/cal-prefs-dialog.h"
#include "calendar-commands.h"
#include "calendar-config.h"
#include "calendar-component.h"
#include "e-comp-editor-registry.h"
#include "comp-editor-factory.h"
#include "control-factory.h"
#include "itip-bonobo-control.h"
#include "tasks-control.h"
#include "tasks-component.h"
#include "memos-component.h"

#include <e-util/e-plugin.h>
#include <e-util/e-import.h>
#include "e-cal-config.h"
#include "e-cal-popup.h"
#include "e-cal-menu.h"
#include "e-cal-event.h"
#include "calendar/importers/evolution-calendar-importer.h"

#define FACTORY_ID "OAFIID:GNOME_Evolution_Calendar_Factory:" BASE_VERSION

#define CALENDAR_COMPONENT_ID  "OAFIID:GNOME_Evolution_Calendar_Component:" BASE_VERSION
#define TASKS_COMPONENT_ID     "OAFIID:GNOME_Evolution_Tasks_Component:" BASE_VERSION
#define MEMOS_COMPONENT_ID     "OAFIID:GNOME_Evolution_Memos_Component:" BASE_VERSION
#define ITIP_CONTROL_ID        "OAFIID:GNOME_Evolution_Calendar_iTip_Control:" BASE_VERSION
#define CONFIG_CONTROL_ID      "OAFIID:GNOME_Evolution_Calendar_ConfigControl:" BASE_VERSION
#define COMP_EDITOR_FACTORY_ID "OAFIID:GNOME_Evolution_Calendar_CompEditorFactory:" BASE_VERSION

ECompEditorRegistry *comp_editor_registry = NULL;

/* The component editor factory */
static CompEditorFactory *comp_editor_factory = NULL;


/* Factory function for the calendar component factory; just creates and
 * references a singleton service object.
 */
static BonoboObject *
comp_editor_factory_fn (void)
{
	if (!comp_editor_factory) {
		comp_editor_factory = comp_editor_factory_new ();
		if (!comp_editor_factory)
			return NULL;
	}

	bonobo_object_ref (BONOBO_OBJECT (comp_editor_factory));
	return BONOBO_OBJECT (comp_editor_factory);
}


/* Does a simple activation and unreffing of the alarm notification service so
 * that the daemon will be launched if it is not running yet.
 */
static gboolean
launch_alarm_daemon_cb (gpointer data)
{
	CORBA_Environment ev;
	CORBA_Object an;

	/* activate the alarm daemon */
	CORBA_exception_init (&ev);
	an = bonobo_activation_activate_from_id ("OAFIID:GNOME_Evolution_Calendar_AlarmNotify:" BASE_VERSION, 0, NULL, &ev);

	if (BONOBO_EX (&ev)) {
		g_message ("launch_alarm_daemon_cb(): %s", bonobo_exception_get_text (&ev));
		CORBA_exception_free (&ev);
		return FALSE;
	}
	CORBA_exception_free (&ev);

	/* Just get rid of it; what we are interested in is that it gets launched */

	CORBA_exception_init (&ev);
	bonobo_object_release_unref (an, &ev);
	if (BONOBO_EX (&ev))
		g_message ("add_alarms(): Could not unref the alarm notification service");

	CORBA_exception_free (&ev);

	return FALSE;
}

static void
launch_alarm_daemon (void)
{
	g_idle_add ((GSourceFunc) launch_alarm_daemon_cb, NULL);
}

static void
initialize (void)
{
	EImportClass *klass;

	comp_editor_registry = E_COMP_EDITOR_REGISTRY (e_comp_editor_registry_new ());

#if 0
	itip_control_factory_init ();
	component_editor_factory_init ();
#endif

	launch_alarm_daemon ();


	/* Initialize plugin system */
	e_plugin_hook_register_type (e_cal_popup_hook_get_type());
	e_plugin_hook_register_type (e_cal_menu_hook_get_type());
	e_plugin_hook_register_type (e_cal_config_hook_get_type ());
	e_plugin_hook_register_type (e_cal_event_hook_get_type ());

	klass = g_type_class_ref(e_import_get_type());
	e_import_class_add_importer(klass, gnome_calendar_importer_peek(), NULL, NULL);
	e_import_class_add_importer(klass, ical_importer_peek(), NULL, NULL);
	e_import_class_add_importer(klass, vcal_importer_peek(), NULL, NULL);
}

static BonoboObject *
factory (BonoboGenericFactory *factory,
	 const char *component_id,
	 void *closure)
{
	static gboolean initialized = FALSE;

	if (! initialized) {
		initialize ();
		initialized = TRUE;
	}

	if (strcmp (component_id, CALENDAR_COMPONENT_ID) == 0) {
		BonoboObject *object = BONOBO_OBJECT (calendar_component_peek ());
		bonobo_object_ref (object);
		return object;
	} else if (strcmp (component_id, TASKS_COMPONENT_ID) == 0) {
		BonoboObject *object = BONOBO_OBJECT (tasks_component_peek ());
		bonobo_object_ref (object);
		return object;
	} else if (strcmp (component_id, MEMOS_COMPONENT_ID) == 0){
		BonoboObject *object = BONOBO_OBJECT (memos_component_peek ());
		bonobo_object_ref (object);
		return object;
	} else if (strcmp (component_id, ITIP_CONTROL_ID) == 0)
		return BONOBO_OBJECT (itip_bonobo_control_new ());
	else if (strcmp (component_id, CONFIG_CONTROL_ID) == 0) {
		GtkWidget *prefs;
		EvolutionConfigControl *control;

		prefs = calendar_prefs_dialog_new ();
		gtk_widget_show (prefs);
		control = evolution_config_control_new (prefs);

		return BONOBO_OBJECT (control);
	} else if (strcmp (component_id, COMP_EDITOR_FACTORY_ID) == 0)
		return BONOBO_OBJECT (comp_editor_factory_fn ());

	g_warning (FACTORY_ID ": Don't know what to do with %s", component_id);
	return NULL;
}

BONOBO_ACTIVATION_SHLIB_FACTORY (FACTORY_ID, "Evolution Calendar component factory", factory, NULL)
