/* gcp-c-compile-args.c generated by valac 0.12.0, the Vala compiler
 * generated from gcp-c-compile-args.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define GCP_C_TYPE_COMPILE_ARGS (gcp_c_compile_args_get_type ())
#define GCP_C_COMPILE_ARGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_TYPE_COMPILE_ARGS, GcpCCompileArgs))
#define GCP_C_COMPILE_ARGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_TYPE_COMPILE_ARGS, GcpCCompileArgsClass))
#define GCP_C_IS_COMPILE_ARGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_TYPE_COMPILE_ARGS))
#define GCP_C_IS_COMPILE_ARGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_TYPE_COMPILE_ARGS))
#define GCP_C_COMPILE_ARGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_TYPE_COMPILE_ARGS, GcpCCompileArgsClass))

typedef struct _GcpCCompileArgs GcpCCompileArgs;
typedef struct _GcpCCompileArgsClass GcpCCompileArgsClass;
typedef struct _GcpCCompileArgsPrivate GcpCCompileArgsPrivate;

#define GCP_C_COMPILE_ARGS_TYPE_CACHE (gcp_c_compile_args_cache_get_type ())
#define GCP_C_COMPILE_ARGS_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_COMPILE_ARGS_TYPE_CACHE, GcpCCompileArgsCache))
#define GCP_C_COMPILE_ARGS_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_COMPILE_ARGS_TYPE_CACHE, GcpCCompileArgsCacheClass))
#define GCP_C_COMPILE_ARGS_IS_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_COMPILE_ARGS_TYPE_CACHE))
#define GCP_C_COMPILE_ARGS_IS_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_COMPILE_ARGS_TYPE_CACHE))
#define GCP_C_COMPILE_ARGS_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_COMPILE_ARGS_TYPE_CACHE, GcpCCompileArgsCacheClass))

typedef struct _GcpCCompileArgsCache GcpCCompileArgsCache;
typedef struct _GcpCCompileArgsCacheClass GcpCCompileArgsCacheClass;

#define GCP_C_COMPILE_ARGS_TYPE_MAKEFILE (gcp_c_compile_args_makefile_get_type ())
#define GCP_C_COMPILE_ARGS_MAKEFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_COMPILE_ARGS_TYPE_MAKEFILE, GcpCCompileArgsMakefile))
#define GCP_C_COMPILE_ARGS_MAKEFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_COMPILE_ARGS_TYPE_MAKEFILE, GcpCCompileArgsMakefileClass))
#define GCP_C_COMPILE_ARGS_IS_MAKEFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_COMPILE_ARGS_TYPE_MAKEFILE))
#define GCP_C_COMPILE_ARGS_IS_MAKEFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_COMPILE_ARGS_TYPE_MAKEFILE))
#define GCP_C_COMPILE_ARGS_MAKEFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_COMPILE_ARGS_TYPE_MAKEFILE, GcpCCompileArgsMakefileClass))

typedef struct _GcpCCompileArgsMakefile GcpCCompileArgsMakefile;
typedef struct _GcpCCompileArgsMakefileClass GcpCCompileArgsMakefileClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _gcp_c_compile_args_makefile_unref0(var) ((var == NULL) ? NULL : (var = (gcp_c_compile_args_makefile_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gcp_c_compile_args_cache_unref0(var) ((var == NULL) ? NULL : (var = (gcp_c_compile_args_cache_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _GcpCCompileArgsFindAsyncData GcpCCompileArgsFindAsyncData;
typedef struct _GcpCCompileArgsCachePrivate GcpCCompileArgsCachePrivate;
typedef struct _GcpCCompileArgsParamSpecCache GcpCCompileArgsParamSpecCache;
typedef struct _GcpCCompileArgsMakefilePrivate GcpCCompileArgsMakefilePrivate;
typedef struct _GcpCCompileArgsParamSpecMakefile GcpCCompileArgsParamSpecMakefile;

typedef enum  {
	GCP_C_COMPILE_ARGS_ERROR_MISSING_MAKEFILE,
	GCP_C_COMPILE_ARGS_ERROR_MISSING_TARGET,
	GCP_C_COMPILE_ARGS_ERROR_MISSING_MAKE_OUTPUT
} GcpCCompileArgsError;
#define GCP_C_COMPILE_ARGS_ERROR gcp_c_compile_args_error_quark ()
struct _GcpCCompileArgs {
	GObject parent_instance;
	GcpCCompileArgsPrivate * priv;
};

struct _GcpCCompileArgsClass {
	GObjectClass parent_class;
};

struct _GcpCCompileArgsPrivate {
	GeeHashMap* d_argsCache;
	GStaticRecMutex __lock_d_argsCache;
	GeeHashMap* d_makefileCache;
	GStaticRecMutex __lock_d_makefileCache;
};

struct _Block2Data {
	int _ref_count_;
	GcpCCompileArgs * self;
	GcpCCompileArgsMakefile* makefile;
};

struct _Block3Data {
	int _ref_count_;
	GcpCCompileArgs * self;
	GFile* file;
};

struct _Block4Data {
	int _ref_count_;
	GcpCCompileArgs * self;
	GFile* file;
	gpointer _async_data_;
};

struct _GcpCCompileArgsFindAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GcpCCompileArgs* self;
	GFile* file;
	Block4Data* _data4_;
	GThreadFunc func;
	void* func_target;
	GDestroyNotify func_target_destroy_notify;
	GError * _inner_error_;
};

struct _GcpCCompileArgsCache {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GcpCCompileArgsCachePrivate * priv;
};

struct _GcpCCompileArgsCacheClass {
	GTypeClass parent_class;
	void (*finalize) (GcpCCompileArgsCache *self);
};

struct _GcpCCompileArgsCachePrivate {
	GFile* d_source;
	GFile* d_makefile;
	gchar** d_args;
	gint d_args_length1;
	gint _d_args_size_;
};

struct _GcpCCompileArgsParamSpecCache {
	GParamSpec parent_instance;
};

struct _GcpCCompileArgsMakefile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GcpCCompileArgsMakefilePrivate * priv;
};

struct _GcpCCompileArgsMakefileClass {
	GTypeClass parent_class;
	void (*finalize) (GcpCCompileArgsMakefile *self);
};

struct _GcpCCompileArgsMakefilePrivate {
	GFile* d_file;
	GeeArrayList* d_sources;
	GFileMonitor* d_monitor;
	guint d_timeoutid;
};

struct _GcpCCompileArgsParamSpecMakefile {
	GParamSpec parent_instance;
};


static gpointer gcp_c_compile_args_parent_class = NULL;
static gpointer gcp_c_compile_args_cache_parent_class = NULL;
static GType gcp_c_compile_args_cache_type_id = 0;
static gpointer gcp_c_compile_args_makefile_parent_class = NULL;
static GType gcp_c_compile_args_makefile_type_id = 0;
static GType gcp_c_compile_args_type_id = 0;

GQuark gcp_c_compile_args_error_quark (void);
GType gcp_c_compile_args_get_type (void) G_GNUC_CONST;
GType gcp_c_compile_args_register_type (GTypeModule * module);
static gpointer gcp_c_compile_args_cache_ref (gpointer instance);
static void gcp_c_compile_args_cache_unref (gpointer instance);
static GParamSpec* gcp_c_compile_args_param_spec_cache (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void gcp_c_compile_args_value_set_cache (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void gcp_c_compile_args_value_take_cache (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer gcp_c_compile_args_value_get_cache (const GValue* value) G_GNUC_UNUSED;
GType gcp_c_compile_args_cache_get_type (void) G_GNUC_CONST;
GType gcp_c_compile_args_cache_register_type (GTypeModule * module);
static gpointer gcp_c_compile_args_makefile_ref (gpointer instance);
static void gcp_c_compile_args_makefile_unref (gpointer instance);
static GParamSpec* gcp_c_compile_args_param_spec_makefile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void gcp_c_compile_args_value_set_makefile (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void gcp_c_compile_args_value_take_makefile (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer gcp_c_compile_args_value_get_makefile (const GValue* value) G_GNUC_UNUSED;
GType gcp_c_compile_args_makefile_get_type (void) G_GNUC_CONST;
GType gcp_c_compile_args_makefile_register_type (GTypeModule * module);
#define GCP_C_COMPILE_ARGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_C_TYPE_COMPILE_ARGS, GcpCCompileArgsPrivate))
enum  {
	GCP_C_COMPILE_ARGS_DUMMY_PROPERTY
};
static GFile* gcp_c_compile_args_makefile_for (GcpCCompileArgs* self, GFile* file, GCancellable* cancellable, GError** error);
void gcp_log_debug (const gchar* format, ...);
static gchar* gcp_c_compile_args_target_from_make (GcpCCompileArgs* self, GFile* makefile, GFile* source, GError** error);
static gchar* gcp_c_compile_args_resolve_relative (GcpCCompileArgs* self, GFile* makefile, GFile* source, const gchar* path);
static gchar** gcp_c_compile_args_filter_flags (GcpCCompileArgs* self, GFile* makefile, GFile* source, gchar** args, int args_length1, int* result_length1);
static gchar** gcp_c_compile_args_flags_from_target (GcpCCompileArgs* self, GFile* makefile, GFile* source, const gchar* target, int* result_length1, GError** error);
static void gcp_c_compile_args_on_makefile_changed (GcpCCompileArgs* self, GcpCCompileArgsMakefile* makefile);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void* _lambda3_ (Block2Data* _data2_);
static GeeArrayList* gcp_c_compile_args_makefile_get_sources (GcpCCompileArgsMakefile* self);
static void gcp_c_compile_args_find_for_makefile (GcpCCompileArgs* self, GFile* makefile, GFile* file);
static GFile* gcp_c_compile_args_makefile_get_file (GcpCCompileArgsMakefile* self);
static gpointer __lambda3__gthread_func (gpointer self);
gchar* gcp_config_llvm_version (void);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void gcp_c_compile_args_cache_set_args (GcpCCompileArgsCache* self, gchar** value, int value_length1);
static GcpCCompileArgsCache* gcp_c_compile_args_cache_new (GFile* source, GFile* makefile, gchar** args, int args_length1);
static GcpCCompileArgsCache* gcp_c_compile_args_cache_construct (GType object_type, GFile* source, GFile* makefile, gchar** args, int args_length1);
static GcpCCompileArgsMakefile* gcp_c_compile_args_makefile_new (GFile* file);
static GcpCCompileArgsMakefile* gcp_c_compile_args_makefile_construct (GType object_type, GFile* file);
static void gcp_c_compile_args_makefile_add (GcpCCompileArgsMakefile* self, GFile* source);
static void _gcp_c_compile_args_on_makefile_changed_gcp_c_compile_args_makefile_changed (GcpCCompileArgsMakefile* _sender, gpointer self);
static void gcp_c_compile_args_changed_in_idle (GcpCCompileArgs* self, GFile* file);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean _lambda4_ (Block3Data* _data3_);
static gboolean __lambda4__gsource_func (gpointer self);
static void gcp_c_compile_args_find_async_data_free (gpointer _data);
static void gcp_c_compile_args_find_async (GcpCCompileArgs* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gcp_c_compile_args_find_finish (GcpCCompileArgs* self, GAsyncResult* _res_);
static gboolean gcp_c_compile_args_find_async_co (GcpCCompileArgsFindAsyncData* data);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void* _lambda5_ (Block4Data* _data4_);
static gpointer __lambda5__gthread_func (gpointer self);
gchar** gcp_c_compile_args_get (GcpCCompileArgs* self, GFile* file, int* result_length1);
static gchar** gcp_c_compile_args_cache_get_args (GcpCCompileArgsCache* self, int* result_length1);
static gchar** _vala_array_dup7 (gchar** self, int length);
void gcp_c_compile_args_monitor (GcpCCompileArgs* self, GFile* file);
static void _lambda6_ (GObject* source, GAsyncResult* res, GcpCCompileArgs* self);
static void __lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void gcp_c_compile_args_remove_monitor (GcpCCompileArgs* self, GFile* file);
static GFile* gcp_c_compile_args_cache_get_makefile (GcpCCompileArgsCache* self);
static gboolean gcp_c_compile_args_makefile_remove (GcpCCompileArgsMakefile* self, GFile* source);
GcpCCompileArgs* gcp_c_compile_args_new (void);
GcpCCompileArgs* gcp_c_compile_args_construct (GType object_type);
static GObject * gcp_c_compile_args_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static guint _g_file_hash_ghash_func (gconstpointer key);
#define GCP_C_COMPILE_ARGS_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_C_COMPILE_ARGS_TYPE_CACHE, GcpCCompileArgsCachePrivate))
enum  {
	GCP_C_COMPILE_ARGS_CACHE_DUMMY_PROPERTY
};
static gchar** _vala_array_dup8 (gchar** self, int length);
static GFile* gcp_c_compile_args_cache_get_source (GcpCCompileArgsCache* self);
static gchar** _vala_array_dup9 (gchar** self, int length);
static void gcp_c_compile_args_cache_finalize (GcpCCompileArgsCache* obj);
#define GCP_C_COMPILE_ARGS_MAKEFILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_C_COMPILE_ARGS_TYPE_MAKEFILE, GcpCCompileArgsMakefilePrivate))
enum  {
	GCP_C_COMPILE_ARGS_MAKEFILE_DUMMY_PROPERTY
};
static void gcp_c_compile_args_makefile_on_makefile_changed (GcpCCompileArgsMakefile* self, GFile* file, GFile* other, GFileMonitorEvent event_type);
static void _gcp_c_compile_args_makefile_on_makefile_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static gboolean gcp_c_compile_args_makefile_on_makefile_timeout (GcpCCompileArgsMakefile* self);
static gboolean _gcp_c_compile_args_makefile_on_makefile_timeout_gsource_func (gpointer self);
static gboolean gcp_c_compile_args_makefile_get_valid (GcpCCompileArgsMakefile* self);
static void gcp_c_compile_args_makefile_finalize (GcpCCompileArgsMakefile* obj);
static void gcp_c_compile_args_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark gcp_c_compile_args_error_quark (void) {
	return g_quark_from_static_string ("gcp_c_compile_args_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GFile* gcp_c_compile_args_makefile_for (GcpCCompileArgs* self, GFile* file, GCancellable* cancellable, GError** error) {
	GFile* result = NULL;
	GFile* ret;
	GFile* _tmp0_ = NULL;
	GFile* par;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	ret = NULL;
	_tmp0_ = g_file_get_parent (file);
	par = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		GFile* _tmp2_ = NULL;
		GFile* makefile;
		gboolean _tmp3_;
		GFile* _tmp5_ = NULL;
		if (par != NULL) {
			_tmp1_ = ret == NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = g_file_get_child (par, "Makefile");
		makefile = _tmp2_;
		_tmp3_ = g_file_query_exists (makefile, cancellable);
		if (_tmp3_) {
			GFile* _tmp4_;
			_tmp4_ = _g_object_ref0 (makefile);
			_g_object_unref0 (ret);
			ret = _tmp4_;
		}
		_tmp5_ = g_file_get_parent (par);
		_g_object_unref0 (par);
		par = _tmp5_;
		_g_object_unref0 (makefile);
	}
	if (ret != NULL) {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp6_ = g_file_get_path (file);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_get_path (ret);
		_tmp9_ = _tmp8_;
		gcp_log_debug ("Resolved makefile for `%s': `%s'", _tmp7_, _tmp9_, NULL);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
	}
	result = ret;
	_g_object_unref0 (par);
	return result;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) (-1), c);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gchar* gcp_c_compile_args_target_from_make (GcpCCompileArgs* self, GFile* makefile, GFile* source, GError** error) {
	gchar* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* wd;
	gchar* _tmp1_ = NULL;
	gchar* basen;
	gint _tmp2_;
	gint idx;
	gchar* noext = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gchar* outstr = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* prefreg;
	gchar* _tmp16_;
	gchar* preflessreg;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* reg;
	GRegex* _tmp21_ = NULL;
	GRegex* regex;
	GMatchInfo* info = NULL;
	GMatchInfo* _tmp22_ = NULL;
	gboolean _tmp23_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	GError* _tmp34_ = NULL;
	GError* _tmp35_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (makefile != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = g_file_get_parent (source);
	wd = _tmp0_;
	_tmp1_ = g_file_get_basename (source);
	basen = _tmp1_;
	_tmp2_ = string_last_index_of_char (basen, (gunichar) '.', 0);
	idx = _tmp2_;
	if (idx >= 0) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = string_substring (basen, (glong) 0, (glong) idx);
		_g_free0 (noext);
		noext = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (basen);
		_g_free0 (noext);
		noext = _tmp4_;
	}
	_tmp5_ = g_strdup ("make");
	_tmp6_ = g_strdup ("-p");
	_tmp7_ = g_strdup ("-n");
	_tmp8_ = g_new0 (gchar*, 4 + 1);
	_tmp8_[0] = _tmp5_;
	_tmp8_[1] = _tmp6_;
	_tmp8_[2] = _tmp7_;
	_tmp8_[3] = NULL;
	args = _tmp8_;
	args_length1 = 4;
	_args_size_ = 4;
	_tmp9_ = g_file_get_path (wd);
	_tmp10_ = _tmp9_;
	g_spawn_sync (_tmp10_, args, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &_tmp11_, NULL, NULL, &_inner_error_);
	_g_free0 (outstr);
	outstr = _tmp11_;
	_g_free0 (_tmp10_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == G_REGEX_ERROR)) || (_inner_error_->domain == GCP_C_COMPILE_ARGS_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (outstr);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (noext);
			_g_free0 (basen);
			_g_object_unref0 (wd);
			return NULL;
		} else {
			_g_free0 (outstr);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (noext);
			_g_free0 (basen);
			_g_object_unref0 (wd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp12_ = g_regex_escape_string (noext, -1);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf ("^([^:]*(%s\\.(o|lo)))$", _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	prefreg = _tmp15_;
	_tmp16_ = g_strdup ("^[a-z]+$");
	preflessreg = _tmp16_;
	_tmp17_ = g_regex_escape_string (basen, -1);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf ("^([^:\n]*):.*%s", _tmp18_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	reg = _tmp20_;
	_tmp21_ = g_regex_new (reg, G_REGEX_MULTILINE, 0, &_inner_error_);
	regex = _tmp21_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == G_REGEX_ERROR)) || (_inner_error_->domain == GCP_C_COMPILE_ARGS_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (reg);
			_g_free0 (preflessreg);
			_g_free0 (prefreg);
			_g_free0 (outstr);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (noext);
			_g_free0 (basen);
			_g_object_unref0 (wd);
			return NULL;
		} else {
			_g_free0 (reg);
			_g_free0 (preflessreg);
			_g_free0 (prefreg);
			_g_free0 (outstr);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (noext);
			_g_free0 (basen);
			_g_object_unref0 (wd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp23_ = g_regex_match (regex, outstr, 0, &_tmp22_);
	_g_match_info_free0 (info);
	info = _tmp22_;
	if (_tmp23_) {
		GRegex* _tmp24_ = NULL;
		GRegex* preg;
		GRegex* _tmp25_ = NULL;
		GRegex* lreg;
		gchar* lastmatch;
		_tmp24_ = g_regex_new (prefreg, 0, 0, &_inner_error_);
		preg = _tmp24_;
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == G_REGEX_ERROR)) || (_inner_error_->domain == GCP_C_COMPILE_ARGS_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_match_info_free0 (info);
				_g_regex_unref0 (regex);
				_g_free0 (reg);
				_g_free0 (preflessreg);
				_g_free0 (prefreg);
				_g_free0 (outstr);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (noext);
				_g_free0 (basen);
				_g_object_unref0 (wd);
				return NULL;
			} else {
				_g_match_info_free0 (info);
				_g_regex_unref0 (regex);
				_g_free0 (reg);
				_g_free0 (preflessreg);
				_g_free0 (prefreg);
				_g_free0 (outstr);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (noext);
				_g_free0 (basen);
				_g_object_unref0 (wd);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp25_ = g_regex_new (preflessreg, 0, 0, &_inner_error_);
		lreg = _tmp25_;
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == G_REGEX_ERROR)) || (_inner_error_->domain == GCP_C_COMPILE_ARGS_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_regex_unref0 (preg);
				_g_match_info_free0 (info);
				_g_regex_unref0 (regex);
				_g_free0 (reg);
				_g_free0 (preflessreg);
				_g_free0 (prefreg);
				_g_free0 (outstr);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (noext);
				_g_free0 (basen);
				_g_object_unref0 (wd);
				return NULL;
			} else {
				_g_regex_unref0 (preg);
				_g_match_info_free0 (info);
				_g_regex_unref0 (regex);
				_g_free0 (reg);
				_g_free0 (preflessreg);
				_g_free0 (prefreg);
				_g_free0 (outstr);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (noext);
				_g_free0 (basen);
				_g_object_unref0 (wd);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		lastmatch = NULL;
		while (TRUE) {
			gchar* _tmp26_ = NULL;
			gchar* target;
			gboolean _tmp27_;
			gboolean _tmp30_;
			gboolean _tmp31_;
			_tmp26_ = g_match_info_fetch (info, 1);
			target = _tmp26_;
			_tmp27_ = g_regex_match (preg, target, 0, NULL);
			if (_tmp27_) {
				result = target;
				_g_free0 (lastmatch);
				_g_regex_unref0 (lreg);
				_g_regex_unref0 (preg);
				_g_match_info_free0 (info);
				_g_regex_unref0 (regex);
				_g_free0 (reg);
				_g_free0 (preflessreg);
				_g_free0 (prefreg);
				_g_free0 (outstr);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (noext);
				_g_free0 (basen);
				_g_object_unref0 (wd);
				return result;
			} else {
				gboolean _tmp28_;
				_tmp28_ = g_regex_match (lreg, target, 0, NULL);
				if (_tmp28_) {
					gchar* _tmp29_;
					_tmp29_ = g_strdup (target);
					_g_free0 (lastmatch);
					lastmatch = _tmp29_;
				}
			}
			_tmp30_ = g_match_info_next (info, &_inner_error_);
			_tmp31_ = _tmp30_;
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == G_REGEX_ERROR)) || (_inner_error_->domain == GCP_C_COMPILE_ARGS_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (target);
					_g_free0 (lastmatch);
					_g_regex_unref0 (lreg);
					_g_regex_unref0 (preg);
					_g_match_info_free0 (info);
					_g_regex_unref0 (regex);
					_g_free0 (reg);
					_g_free0 (preflessreg);
					_g_free0 (prefreg);
					_g_free0 (outstr);
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (noext);
					_g_free0 (basen);
					_g_object_unref0 (wd);
					return NULL;
				} else {
					_g_free0 (target);
					_g_free0 (lastmatch);
					_g_regex_unref0 (lreg);
					_g_regex_unref0 (preg);
					_g_match_info_free0 (info);
					_g_regex_unref0 (regex);
					_g_free0 (reg);
					_g_free0 (preflessreg);
					_g_free0 (prefreg);
					_g_free0 (outstr);
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (noext);
					_g_free0 (basen);
					_g_object_unref0 (wd);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (!_tmp31_) {
				_g_free0 (target);
				break;
			}
			_g_free0 (target);
		}
		if (lastmatch != NULL) {
			result = lastmatch;
			_g_regex_unref0 (lreg);
			_g_regex_unref0 (preg);
			_g_match_info_free0 (info);
			_g_regex_unref0 (regex);
			_g_free0 (reg);
			_g_free0 (preflessreg);
			_g_free0 (prefreg);
			_g_free0 (outstr);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (noext);
			_g_free0 (basen);
			_g_object_unref0 (wd);
			return result;
		}
		_g_free0 (lastmatch);
		_g_regex_unref0 (lreg);
		_g_regex_unref0 (preg);
	}
	_tmp32_ = g_strdup_printf ("Could not find make target for %s", basen);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_error_new_literal (GCP_C_COMPILE_ARGS_ERROR, GCP_C_COMPILE_ARGS_ERROR_MISSING_TARGET, _tmp33_);
	_tmp35_ = _tmp34_;
	_g_free0 (_tmp33_);
	_inner_error_ = _tmp35_;
	if (((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == G_REGEX_ERROR)) || (_inner_error_->domain == GCP_C_COMPILE_ARGS_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_match_info_free0 (info);
		_g_regex_unref0 (regex);
		_g_free0 (reg);
		_g_free0 (preflessreg);
		_g_free0 (prefreg);
		_g_free0 (outstr);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (noext);
		_g_free0 (basen);
		_g_object_unref0 (wd);
		return NULL;
	} else {
		_g_match_info_free0 (info);
		_g_regex_unref0 (regex);
		_g_free0 (reg);
		_g_free0 (preflessreg);
		_g_free0 (prefreg);
		_g_free0 (outstr);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (noext);
		_g_free0 (basen);
		_g_object_unref0 (wd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_match_info_free0 (info);
	_g_regex_unref0 (regex);
	_g_free0 (reg);
	_g_free0 (preflessreg);
	_g_free0 (prefreg);
	_g_free0 (outstr);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (noext);
	_g_free0 (basen);
	_g_object_unref0 (wd);
}


static gchar* gcp_c_compile_args_resolve_relative (GcpCCompileArgs* self, GFile* makefile, GFile* source, const gchar* path) {
	gchar* result = NULL;
	gboolean _tmp0_;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_;
	GFile* ret;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (makefile != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_path_is_absolute (path);
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (path);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = g_file_get_parent (makefile);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_resolve_relative_path (_tmp3_, path);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	ret = _tmp5_;
	_tmp6_ = g_file_get_path (ret);
	result = _tmp6_;
	_g_object_unref0 (ret);
	return result;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) (-1), c);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gchar** gcp_c_compile_args_filter_flags (GcpCCompileArgs* self, GFile* makefile, GFile* source, gchar** args, int args_length1, int* result_length1) {
	gchar** result = NULL;
	gboolean inexpand;
	gint i;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* ret;
	gint _tmp14_;
	gpointer* _tmp15_ = NULL;
	gchar** _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (makefile != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	inexpand = FALSE;
	i = 0;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	ret = _tmp0_;
	while (TRUE) {
		gchar* _tmp1_;
		gchar* a;
		gint _tmp2_;
		gchar _tmp3_;
		gchar _tmp4_;
		if (!(i < args_length1)) {
			break;
		}
		_tmp1_ = g_strdup (args[i]);
		a = _tmp1_;
		i = i + 1;
		_tmp2_ = string_index_of_char (a, (gunichar) '`', 0);
		if (_tmp2_ != (-1)) {
			inexpand = !inexpand;
			_g_free0 (a);
			continue;
		}
		if (inexpand) {
			_g_free0 (a);
			continue;
		}
		_tmp3_ = string_get (a, (glong) 0);
		if (_tmp3_ != '-') {
			_g_free0 (a);
			continue;
		}
		_tmp4_ = string_get (a, (glong) 1);
		switch (_tmp4_) {
			case 'I':
			{
				gchar _tmp5_;
				_tmp5_ = string_get (a, (glong) 2);
				if (_tmp5_ != '\0') {
					gchar* _tmp6_ = NULL;
					gchar* _tmp7_;
					gchar* _tmp8_ = NULL;
					gchar* _tmp9_;
					gee_abstract_collection_add ((GeeAbstractCollection*) ret, "-I");
					_tmp6_ = string_substring (a, (glong) 2, (glong) (-1));
					_tmp7_ = _tmp6_;
					_tmp8_ = gcp_c_compile_args_resolve_relative (self, makefile, source, _tmp7_);
					_tmp9_ = _tmp8_;
					gee_abstract_collection_add ((GeeAbstractCollection*) ret, _tmp9_);
					_g_free0 (_tmp9_);
					_g_free0 (_tmp7_);
				} else {
					if (i < args_length1) {
						gchar* _tmp10_ = NULL;
						gchar* _tmp11_;
						gee_abstract_collection_add ((GeeAbstractCollection*) ret, "-I");
						_tmp10_ = gcp_c_compile_args_resolve_relative (self, makefile, source, args[i]);
						_tmp11_ = _tmp10_;
						gee_abstract_collection_add ((GeeAbstractCollection*) ret, _tmp11_);
						_g_free0 (_tmp11_);
						i = i + 1;
					}
				}
				break;
			}
			case 'D':
			case 'f':
			case 'W':
			{
				gboolean _tmp12_ = FALSE;
				gchar _tmp13_;
				gcp_log_debug ("gcc flag: `%s'", a, NULL);
				gee_abstract_collection_add ((GeeAbstractCollection*) ret, a);
				_tmp13_ = string_get (a, (glong) 2);
				if (_tmp13_ == '\0') {
					_tmp12_ = i < args_length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					gee_abstract_collection_add ((GeeAbstractCollection*) ret, args[i]);
					i = i + 1;
				}
				break;
			}
			default:
			break;
		}
		_g_free0 (a);
	}
	_tmp15_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) ret, &_tmp14_);
	_tmp16_ = _tmp15_;
	*result_length1 = _tmp14_;
	result = _tmp16_;
	_g_object_unref0 (ret);
	return result;
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar** gcp_c_compile_args_flags_from_target (GcpCCompileArgs* self, GFile* makefile, GFile* source, const gchar* target, int* result_length1, GError** error) {
	gchar** result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* relsource;
	gchar* _tmp4_;
	gchar* fakecc;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gchar* outstr = NULL;
	GFile* _tmp16_ = NULL;
	GFile* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	gint _tmp21_;
	gint idx;
	gchar** retargs = NULL;
	gint retargs_length1 = 0;
	gint _retargs_size_ = 0;
	gint _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_ = NULL;
	gchar** _tmp28_;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp29_ = NULL;
	gint _tmp30_;
	gint _tmp31_;
	gchar** _tmp32_ = NULL;
	gchar** _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (makefile != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	_tmp0_ = g_file_get_parent (makefile);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_relative_path (_tmp1_, source);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	relsource = _tmp3_;
	_tmp4_ = g_strdup ("__GCP_COMPILE_ARGS__");
	fakecc = _tmp4_;
	_tmp5_ = g_strdup ("make");
	_tmp6_ = g_strdup ("-s");
	_tmp7_ = g_strdup ("-i");
	_tmp8_ = g_strdup ("-n");
	_tmp9_ = g_strdup ("-W");
	_tmp10_ = g_strdup (relsource);
	_tmp11_ = g_strdup ("V=1");
	_tmp12_ = g_strconcat ("CC=", fakecc, NULL);
	_tmp13_ = g_strconcat ("CXX=", fakecc, NULL);
	_tmp14_ = g_strdup (target);
	_tmp15_ = g_new0 (gchar*, 11 + 1);
	_tmp15_[0] = _tmp5_;
	_tmp15_[1] = _tmp6_;
	_tmp15_[2] = _tmp7_;
	_tmp15_[3] = _tmp8_;
	_tmp15_[4] = _tmp9_;
	_tmp15_[5] = _tmp10_;
	_tmp15_[6] = _tmp11_;
	_tmp15_[7] = _tmp12_;
	_tmp15_[8] = _tmp13_;
	_tmp15_[9] = _tmp14_;
	_tmp15_[10] = NULL;
	args = _tmp15_;
	args_length1 = 11;
	_args_size_ = 11;
	_tmp16_ = g_file_get_parent (makefile);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_file_get_path (_tmp17_);
	_tmp19_ = _tmp18_;
	g_spawn_sync (_tmp19_, args, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &_tmp20_, NULL, NULL, &_inner_error_);
	_g_free0 (outstr);
	outstr = _tmp20_;
	_g_free0 (_tmp19_);
	_g_object_unref0 (_tmp17_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GCP_C_COMPILE_ARGS_ERROR)) || (_inner_error_->domain == G_SHELL_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (outstr);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (fakecc);
			_g_free0 (relsource);
			return NULL;
		} else {
			_g_free0 (outstr);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (fakecc);
			_g_free0 (relsource);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp21_ = string_last_index_of (outstr, fakecc, 0);
	idx = _tmp21_;
	if (idx < 0) {
		GError* _tmp22_ = NULL;
		_tmp22_ = g_error_new_literal (GCP_C_COMPILE_ARGS_ERROR, GCP_C_COMPILE_ARGS_ERROR_MISSING_MAKE_OUTPUT, "Make output did not contain flags");
		_inner_error_ = _tmp22_;
		if (((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GCP_C_COMPILE_ARGS_ERROR)) || (_inner_error_->domain == G_SHELL_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (outstr);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (fakecc);
			_g_free0 (relsource);
			return NULL;
		} else {
			_g_free0 (outstr);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (fakecc);
			_g_free0 (relsource);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp23_ = strlen (fakecc);
	_tmp24_ = string_substring (outstr, (glong) (idx + _tmp23_), (glong) (-1));
	_tmp25_ = _tmp24_;
	_tmp27_ = _tmp26_ = g_strsplit (_tmp25_, "\n", 0);
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp25_);
	parts = _tmp28_;
	parts_length1 = _vala_array_length (_tmp26_);
	_parts_size_ = _vala_array_length (_tmp26_);
	g_shell_parse_argv (parts[0], &_tmp30_, &_tmp29_, &_inner_error_);
	retargs = (_vala_array_free (retargs, retargs_length1, (GDestroyNotify) g_free), NULL);
	retargs = _tmp29_;
	retargs_length1 = _tmp30_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GCP_C_COMPILE_ARGS_ERROR)) || (_inner_error_->domain == G_SHELL_ERROR)) {
			g_propagate_error (error, _inner_error_);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			retargs = (_vala_array_free (retargs, retargs_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (outstr);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (fakecc);
			_g_free0 (relsource);
			return NULL;
		} else {
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			retargs = (_vala_array_free (retargs, retargs_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (outstr);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (fakecc);
			_g_free0 (relsource);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp32_ = gcp_c_compile_args_filter_flags (self, makefile, source, retargs, retargs_length1, &_tmp31_);
	_tmp33_ = _tmp32_;
	*result_length1 = _tmp31_;
	result = _tmp33_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	retargs = (_vala_array_free (retargs, retargs_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (outstr);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (fakecc);
	_g_free0 (relsource);
	return result;
}


static gpointer _gcp_c_compile_args_makefile_ref0 (gpointer self) {
	return self ? gcp_c_compile_args_makefile_ref (self) : NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_gcp_c_compile_args_makefile_unref0 (_data2_->makefile);
		g_slice_free (Block2Data, _data2_);
	}
}


static void* _lambda3_ (Block2Data* _data2_) {
	GcpCCompileArgs * self;
	void* result = NULL;
	self = _data2_->self;
	{
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_;
		GeeArrayList* _file_list;
		gint _tmp2_;
		gint _file_size;
		gint _file_index;
		_tmp0_ = gcp_c_compile_args_makefile_get_sources (_data2_->makefile);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_file_list = _tmp1_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _file_list);
		_file_size = _tmp2_;
		_file_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			GFile* file;
			GFile* _tmp4_ = NULL;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _file_list, _file_index);
			file = (GFile*) _tmp3_;
			_tmp4_ = gcp_c_compile_args_makefile_get_file (_data2_->makefile);
			gcp_c_compile_args_find_for_makefile (self, _tmp4_, file);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	result = NULL;
	return result;
}


static gpointer __lambda3__gthread_func (gpointer self) {
	gpointer result;
	result = _lambda3_ (self);
	return result;
}


static void gcp_c_compile_args_on_makefile_changed (GcpCCompileArgs* self, GcpCCompileArgsMakefile* makefile) {
	Block2Data* _data2_;
	GThreadFunc func;
	void* func_target = NULL;
	GDestroyNotify func_target_destroy_notify = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (makefile != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->makefile = _gcp_c_compile_args_makefile_ref0 (makefile);
	func = __lambda3__gthread_func;
	func_target = block2_data_ref (_data2_);
	func_target_destroy_notify = block2_data_unref;
	g_thread_create (func, func_target, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	goto __finally2;
	__catch2_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		(func_target_destroy_notify == NULL) ? NULL : (func_target_destroy_notify (func_target), NULL);
		func = NULL;
		func_target = NULL;
		func_target_destroy_notify = NULL;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	(func_target_destroy_notify == NULL) ? NULL : (func_target_destroy_notify (func_target), NULL);
	func = NULL;
	func_target = NULL;
	func_target_destroy_notify = NULL;
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _gcp_c_compile_args_on_makefile_changed_gcp_c_compile_args_makefile_changed (GcpCCompileArgsMakefile* _sender, gpointer self) {
	gcp_c_compile_args_on_makefile_changed (self, _sender);
}


static void gcp_c_compile_args_find_for_makefile (GcpCCompileArgs* self, GFile* makefile, GFile* file) {
	gchar* target = NULL;
	gchar** _tmp0_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gint _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint __tmp7__size_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gboolean _tmp10_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (makefile != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	args = _tmp0_;
	args_length1 = 0;
	_args_size_ = 0;
	_tmp1_ = gcp_c_compile_args_target_from_make (self, makefile, file, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	_g_free0 (target);
	target = _tmp2_;
	_tmp3_ = g_file_get_path (file);
	_tmp4_ = _tmp3_;
	gcp_log_debug ("Makefile make target for `%s': `%s'", _tmp4_, target, NULL);
	_g_free0 (_tmp4_);
	_tmp6_ = gcp_c_compile_args_flags_from_target (self, makefile, file, target, &_tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	__tmp7__size_ = _tmp5_;
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	args = _tmp7_;
	args_length1 = _tmp7__length1;
	_args_size_ = _tmp7__length1;
	_tmp8_ = gcp_config_llvm_version ();
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strcmp0 (_tmp9_, "2.8") == 0;
	_g_free0 (_tmp9_);
	if (_tmp10_) {
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = g_strdup ("-I");
		_vala_array_add1 (&args, &args_length1, &_args_size_, _tmp11_);
		_tmp12_ = g_strdup ("/usr/lib/clang/2.8/include");
		_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp12_);
	}
	_tmp13_ = g_file_get_path (file);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strjoinv (", ", args);
	_tmp16_ = _tmp15_;
	gcp_log_debug ("Compile flags for `%s': `%s'", _tmp14_, _tmp16_, NULL);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Makefile error: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (target);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_d_makefileCache);
		{
			gboolean _tmp17_;
			gboolean _tmp22_;
			g_static_rec_mutex_lock (&self->priv->__lock_d_argsCache);
			_tmp17_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->d_argsCache, file);
			if (_tmp17_) {
				gpointer _tmp18_ = NULL;
				GcpCCompileArgsCache* _tmp19_;
				gchar** _tmp20_;
				_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->d_argsCache, file);
				_tmp19_ = (GcpCCompileArgsCache*) _tmp18_;
				_tmp20_ = args;
				gcp_c_compile_args_cache_set_args (_tmp19_, _tmp20_, args_length1);
				_gcp_c_compile_args_cache_unref0 (_tmp19_);
			} else {
				GcpCCompileArgsCache* _tmp21_ = NULL;
				GcpCCompileArgsCache* c;
				_tmp21_ = gcp_c_compile_args_cache_new (file, makefile, args, args_length1);
				c = _tmp21_;
				gee_abstract_map_set ((GeeAbstractMap*) self->priv->d_argsCache, file, c);
				_gcp_c_compile_args_cache_unref0 (c);
			}
			_tmp22_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->d_makefileCache, makefile);
			if (!_tmp22_) {
				GcpCCompileArgsMakefile* _tmp23_ = NULL;
				GcpCCompileArgsMakefile* m;
				_tmp23_ = gcp_c_compile_args_makefile_new (makefile);
				m = _tmp23_;
				gcp_c_compile_args_makefile_add (m, file);
				g_signal_connect_object (m, "changed", (GCallback) _gcp_c_compile_args_on_makefile_changed_gcp_c_compile_args_makefile_changed, self, 0);
				gee_abstract_map_set ((GeeAbstractMap*) self->priv->d_makefileCache, makefile, m);
				_gcp_c_compile_args_makefile_unref0 (m);
			}
			__finally5:
			g_static_rec_mutex_unlock (&self->priv->__lock_d_argsCache);
			if (_inner_error_ != NULL) {
				g_static_rec_mutex_unlock (&self->priv->__lock_d_makefileCache);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (target);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		__finally4:
		g_static_rec_mutex_unlock (&self->priv->__lock_d_makefileCache);
		if (_inner_error_ != NULL) {
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (target);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	gcp_c_compile_args_changed_in_idle (self, file);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (target);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->file);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean _lambda4_ (Block3Data* _data3_) {
	GcpCCompileArgs * self;
	gboolean result = FALSE;
	self = _data3_->self;
	g_signal_emit_by_name (self, "arguments-changed", _data3_->file);
	result = FALSE;
	return result;
}


static gboolean __lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda4_ (self);
	return result;
}


static void gcp_c_compile_args_changed_in_idle (GcpCCompileArgs* self, GFile* file) {
	Block3Data* _data3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->file = _g_object_ref0 (file);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda4__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void gcp_c_compile_args_find_async_data_free (gpointer _data) {
	GcpCCompileArgsFindAsyncData* data;
	data = _data;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->self);
	g_slice_free (GcpCCompileArgsFindAsyncData, data);
}


static void gcp_c_compile_args_find_async (GcpCCompileArgs* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GcpCCompileArgsFindAsyncData* _data_;
	_data_ = g_slice_new0 (GcpCCompileArgsFindAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gcp_c_compile_args_find_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gcp_c_compile_args_find_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->file = _g_object_ref0 (file);
	gcp_c_compile_args_find_async_co (_data_);
}


static void gcp_c_compile_args_find_finish (GcpCCompileArgs* self, GAsyncResult* _res_) {
	GcpCCompileArgsFindAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->file);
		g_slice_free (Block4Data, _data4_);
	}
}


static void* _lambda5_ (Block4Data* _data4_) {
	GcpCCompileArgs * self;
	void* result = NULL;
	GFile* makefile;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
	self = _data4_->self;
	makefile = NULL;
	_tmp0_ = gcp_c_compile_args_makefile_for (self, _data4_->file, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch6_g_error;
	}
	_g_object_unref0 (makefile);
	makefile = _tmp1_;
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_object_unref0 (makefile);
		makefile = NULL;
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (makefile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (makefile == NULL) {
		gchar** _tmp2_ = NULL;
		gchar** _tmp3_;
		gint _tmp3__length1;
		GcpCCompileArgsCache* _tmp4_ = NULL;
		GcpCCompileArgsCache* _tmp5_;
		GcpCCompileArgsCache* c;
		_tmp2_ = g_new0 (gchar*, 0 + 1);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 0;
		_tmp4_ = gcp_c_compile_args_cache_new (_data4_->file, NULL, _tmp3_, 0);
		_tmp5_ = _tmp4_;
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
		c = _tmp5_;
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->d_argsCache, _data4_->file, c);
		gcp_c_compile_args_changed_in_idle (self, _data4_->file);
		result = NULL;
		_gcp_c_compile_args_cache_unref0 (c);
		_g_object_unref0 (makefile);
		return result;
	}
	gcp_c_compile_args_find_for_makefile (self, makefile, _data4_->file);
	{
		gboolean _tmp6_;
		g_static_rec_mutex_lock (&self->priv->__lock_d_makefileCache);
		_tmp6_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->d_makefileCache, _data4_->file);
		if (_tmp6_) {
			gpointer _tmp7_ = NULL;
			GcpCCompileArgsMakefile* _tmp8_;
			_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->d_makefileCache, makefile);
			_tmp8_ = (GcpCCompileArgsMakefile*) _tmp7_;
			gcp_c_compile_args_makefile_add (_tmp8_, _data4_->file);
			_gcp_c_compile_args_makefile_unref0 (_tmp8_);
		}
		__finally7:
		g_static_rec_mutex_unlock (&self->priv->__lock_d_makefileCache);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (makefile);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = NULL;
	_g_object_unref0 (makefile);
	return result;
}


static gpointer __lambda5__gthread_func (gpointer self) {
	gpointer result;
	result = _lambda5_ (self);
	return result;
}


static gboolean gcp_c_compile_args_find_async_co (GcpCCompileArgsFindAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data4_ = g_slice_new0 (Block4Data);
	data->_data4_->_ref_count_ = 1;
	data->_data4_->self = g_object_ref (data->self);
	data->_data4_->file = _g_object_ref0 (data->file);
	data->_data4_->_async_data_ = data;
	data->func_target = NULL;
	data->func_target_destroy_notify = NULL;
	data->func = __lambda5__gthread_func;
	data->func_target = block4_data_ref (data->_data4_);
	data->func_target_destroy_notify = block4_data_unref;
	g_thread_create (data->func, data->func_target, FALSE, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	goto __finally8;
	__catch8_g_error:
	{
		g_clear_error (&data->_inner_error_);
		data->_inner_error_ = NULL;
	}
	__finally8:
	if (data->_inner_error_ != NULL) {
		(data->func_target_destroy_notify == NULL) ? NULL : (data->func_target_destroy_notify (data->func_target), NULL);
		data->func = NULL;
		data->func_target = NULL;
		data->func_target_destroy_notify = NULL;
		block4_data_unref (data->_data4_);
		data->_data4_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	(data->func_target_destroy_notify == NULL) ? NULL : (data->func_target_destroy_notify (data->func_target), NULL);
	data->func = NULL;
	data->func_target = NULL;
	data->func_target_destroy_notify = NULL;
	block4_data_unref (data->_data4_);
	data->_data4_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


gchar** gcp_c_compile_args_get (GcpCCompileArgs* self, GFile* file, int* result_length1) {
	gchar** result = NULL;
	gchar** ret;
	gint ret_length1;
	gint _ret_size_;
	gchar** _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	ret = NULL;
	ret_length1 = 0;
	_ret_size_ = 0;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_d_argsCache);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->d_argsCache, file);
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			GcpCCompileArgsCache* _tmp2_;
			gchar** _tmp3_ = NULL;
			gint _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->d_argsCache, file);
			_tmp2_ = (GcpCCompileArgsCache*) _tmp1_;
			_tmp3_ = gcp_c_compile_args_cache_get_args (_tmp2_, &_tmp4_);
			_tmp5_ = (_tmp6_ = _tmp3_, (_tmp6_ == NULL) ? ((gpointer) _tmp6_) : _vala_array_dup7 (_tmp6_, _tmp4_));
			ret = (_vala_array_free (ret, ret_length1, (GDestroyNotify) g_free), NULL);
			ret = _tmp5_;
			ret_length1 = _tmp4_;
			_ret_size_ = _tmp4_;
			_gcp_c_compile_args_cache_unref0 (_tmp2_);
		} else {
			gcp_c_compile_args_monitor (self, file);
		}
		__finally9:
		g_static_rec_mutex_unlock (&self->priv->__lock_d_argsCache);
		if (_inner_error_ != NULL) {
			ret = (_vala_array_free (ret, ret_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp7_ = ret;
	*result_length1 = ret_length1;
	result = _tmp7_;
	return result;
}


static void _lambda6_ (GObject* source, GAsyncResult* res, GcpCCompileArgs* self) {
	g_return_if_fail (res != NULL);
	gcp_c_compile_args_find_finish (self, res);
}


static void __lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda6_ (source_object, res, self);
	g_object_unref (self);
}


void gcp_c_compile_args_monitor (GcpCCompileArgs* self, GFile* file) {
	gboolean hascache = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_d_argsCache);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->d_argsCache, file);
		hascache = _tmp0_;
		__finally10:
		g_static_rec_mutex_unlock (&self->priv->__lock_d_argsCache);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (hascache) {
		g_signal_emit_by_name (self, "arguments-changed", file);
	} else {
		gcp_c_compile_args_find_async (self, file, __lambda6__gasync_ready_callback, g_object_ref (self));
	}
}


void gcp_c_compile_args_remove_monitor (GcpCCompileArgs* self, GFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_d_argsCache);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->d_argsCache, file);
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			GcpCCompileArgsCache* c;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->d_argsCache, file);
			c = (GcpCCompileArgsCache*) _tmp1_;
			{
				GFile* _tmp2_ = NULL;
				gboolean _tmp3_;
				g_static_rec_mutex_lock (&self->priv->__lock_d_makefileCache);
				_tmp2_ = gcp_c_compile_args_cache_get_makefile (c);
				_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->d_makefileCache, _tmp2_);
				if (_tmp3_) {
					GFile* _tmp4_ = NULL;
					gpointer _tmp5_ = NULL;
					GcpCCompileArgsMakefile* m;
					gboolean _tmp6_;
					_tmp4_ = gcp_c_compile_args_cache_get_makefile (c);
					_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->d_makefileCache, _tmp4_);
					m = (GcpCCompileArgsMakefile*) _tmp5_;
					_tmp6_ = gcp_c_compile_args_makefile_remove (m, file);
					if (_tmp6_) {
						GFile* _tmp7_ = NULL;
						_tmp7_ = gcp_c_compile_args_cache_get_makefile (c);
						gee_abstract_map_unset ((GeeAbstractMap*) self->priv->d_makefileCache, _tmp7_, NULL);
					}
					_gcp_c_compile_args_makefile_unref0 (m);
				}
				__finally12:
				g_static_rec_mutex_unlock (&self->priv->__lock_d_makefileCache);
				if (_inner_error_ != NULL) {
					_gcp_c_compile_args_cache_unref0 (c);
					_gcp_c_compile_args_cache_unref0 (c);
					g_static_rec_mutex_unlock (&self->priv->__lock_d_argsCache);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			gee_abstract_map_unset ((GeeAbstractMap*) self->priv->d_argsCache, file, NULL);
			_gcp_c_compile_args_cache_unref0 (c);
		}
		__finally11:
		g_static_rec_mutex_unlock (&self->priv->__lock_d_argsCache);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


GcpCCompileArgs* gcp_c_compile_args_construct (GType object_type) {
	GcpCCompileArgs * self = NULL;
	self = (GcpCCompileArgs*) g_object_new (object_type, NULL);
	return self;
}


GcpCCompileArgs* gcp_c_compile_args_new (void) {
	return gcp_c_compile_args_construct (GCP_C_TYPE_COMPILE_ARGS);
}


static guint _g_file_hash_ghash_func (gconstpointer key) {
	guint result;
	result = g_file_hash (key);
	return result;
}


static GObject * gcp_c_compile_args_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GcpCCompileArgs * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (gcp_c_compile_args_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GCP_C_COMPILE_ARGS (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, GCP_C_COMPILE_ARGS_TYPE_CACHE, (GBoxedCopyFunc) gcp_c_compile_args_cache_ref, gcp_c_compile_args_cache_unref, _g_file_hash_ghash_func, (GEqualFunc) g_file_equal, NULL);
	_g_object_unref0 (self->priv->d_argsCache);
	self->priv->d_argsCache = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, GCP_C_COMPILE_ARGS_TYPE_MAKEFILE, (GBoxedCopyFunc) gcp_c_compile_args_makefile_ref, gcp_c_compile_args_makefile_unref, _g_file_hash_ghash_func, (GEqualFunc) g_file_equal, NULL);
	_g_object_unref0 (self->priv->d_makefileCache);
	self->priv->d_makefileCache = _tmp1_;
	return obj;
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static GcpCCompileArgsCache* gcp_c_compile_args_cache_construct (GType object_type, GFile* source, GFile* makefile, gchar** args, int args_length1) {
	GcpCCompileArgsCache* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	g_return_val_if_fail (source != NULL, NULL);
	self = (GcpCCompileArgsCache*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (self->priv->d_source);
	self->priv->d_source = _tmp0_;
	_tmp1_ = _g_object_ref0 (makefile);
	_g_object_unref0 (self->priv->d_makefile);
	self->priv->d_makefile = _tmp1_;
	_tmp2_ = (_tmp3_ = args, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup8 (_tmp3_, args_length1));
	self->priv->d_args = (_vala_array_free (self->priv->d_args, self->priv->d_args_length1, (GDestroyNotify) g_free), NULL);
	self->priv->d_args = _tmp2_;
	self->priv->d_args_length1 = args_length1;
	self->priv->_d_args_size_ = args_length1;
	return self;
}


static GcpCCompileArgsCache* gcp_c_compile_args_cache_new (GFile* source, GFile* makefile, gchar** args, int args_length1) {
	return gcp_c_compile_args_cache_construct (GCP_C_COMPILE_ARGS_TYPE_CACHE, source, makefile, args, args_length1);
}


static GFile* gcp_c_compile_args_cache_get_makefile (GcpCCompileArgsCache* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->d_makefile;
	return result;
}


static GFile* gcp_c_compile_args_cache_get_source (GcpCCompileArgsCache* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->d_source;
	return result;
}


static gchar** gcp_c_compile_args_cache_get_args (GcpCCompileArgsCache* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_args;
	*result_length1 = self->priv->d_args_length1;
	result = _tmp0_;
	return result;
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void gcp_c_compile_args_cache_set_args (GcpCCompileArgsCache* self, gchar** value, int value_length1) {
	gchar** _tmp0_;
	gchar** _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (_tmp1_ = value, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup9 (_tmp1_, value_length1));
	self->priv->d_args = (_vala_array_free (self->priv->d_args, self->priv->d_args_length1, (GDestroyNotify) g_free), NULL);
	self->priv->d_args = _tmp0_;
	self->priv->d_args_length1 = value_length1;
	self->priv->_d_args_size_ = value_length1;
}


static void gcp_c_compile_args_value_cache_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gcp_c_compile_args_value_cache_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gcp_c_compile_args_cache_unref (value->data[0].v_pointer);
	}
}


static void gcp_c_compile_args_value_cache_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gcp_c_compile_args_cache_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gcp_c_compile_args_value_cache_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gcp_c_compile_args_value_cache_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GcpCCompileArgsCache* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gcp_c_compile_args_cache_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gcp_c_compile_args_value_cache_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GcpCCompileArgsCache** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gcp_c_compile_args_cache_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* gcp_c_compile_args_param_spec_cache (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GcpCCompileArgsParamSpecCache* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GCP_C_COMPILE_ARGS_TYPE_CACHE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer gcp_c_compile_args_value_get_cache (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_C_COMPILE_ARGS_TYPE_CACHE), NULL);
	return value->data[0].v_pointer;
}


static void gcp_c_compile_args_value_set_cache (GValue* value, gpointer v_object) {
	GcpCCompileArgsCache* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_C_COMPILE_ARGS_TYPE_CACHE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_C_COMPILE_ARGS_TYPE_CACHE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gcp_c_compile_args_cache_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_c_compile_args_cache_unref (old);
	}
}


static void gcp_c_compile_args_value_take_cache (GValue* value, gpointer v_object) {
	GcpCCompileArgsCache* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_C_COMPILE_ARGS_TYPE_CACHE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_C_COMPILE_ARGS_TYPE_CACHE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_c_compile_args_cache_unref (old);
	}
}


static void gcp_c_compile_args_cache_class_init (GcpCCompileArgsCacheClass * klass) {
	gcp_c_compile_args_cache_parent_class = g_type_class_peek_parent (klass);
	GCP_C_COMPILE_ARGS_CACHE_CLASS (klass)->finalize = gcp_c_compile_args_cache_finalize;
	g_type_class_add_private (klass, sizeof (GcpCCompileArgsCachePrivate));
}


static void gcp_c_compile_args_cache_instance_init (GcpCCompileArgsCache * self) {
	self->priv = GCP_C_COMPILE_ARGS_CACHE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gcp_c_compile_args_cache_finalize (GcpCCompileArgsCache* obj) {
	GcpCCompileArgsCache * self;
	self = GCP_C_COMPILE_ARGS_CACHE (obj);
	_g_object_unref0 (self->priv->d_source);
	_g_object_unref0 (self->priv->d_makefile);
	self->priv->d_args = (_vala_array_free (self->priv->d_args, self->priv->d_args_length1, (GDestroyNotify) g_free), NULL);
}


GType gcp_c_compile_args_cache_get_type (void) {
	return gcp_c_compile_args_cache_type_id;
}


GType gcp_c_compile_args_cache_register_type (GTypeModule * module) {
	static const GTypeValueTable g_define_type_value_table = { gcp_c_compile_args_value_cache_init, gcp_c_compile_args_value_cache_free_value, gcp_c_compile_args_value_cache_copy_value, gcp_c_compile_args_value_cache_peek_pointer, "p", gcp_c_compile_args_value_cache_collect_value, "p", gcp_c_compile_args_value_cache_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GcpCCompileArgsCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_c_compile_args_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpCCompileArgsCache), 0, (GInstanceInitFunc) gcp_c_compile_args_cache_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	gcp_c_compile_args_cache_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GcpCCompileArgsCache", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gcp_c_compile_args_cache_type_id;
}


static gpointer gcp_c_compile_args_cache_ref (gpointer instance) {
	GcpCCompileArgsCache* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void gcp_c_compile_args_cache_unref (gpointer instance) {
	GcpCCompileArgsCache* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GCP_C_COMPILE_ARGS_CACHE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _gcp_c_compile_args_makefile_on_makefile_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	gcp_c_compile_args_makefile_on_makefile_changed (self, file, other_file, event_type);
}


static GcpCCompileArgsMakefile* gcp_c_compile_args_makefile_construct (GType object_type, GFile* file) {
	GcpCCompileArgsMakefile* self = NULL;
	GFile* _tmp0_;
	GFileMonitor* _tmp1_ = NULL;
	GFileMonitor* _tmp2_;
	GFileMonitor* _tmp3_;
	GeeArrayList* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GcpCCompileArgsMakefile*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->d_file);
	self->priv->d_file = _tmp0_;
	self->priv->d_timeoutid = (guint) 0;
	_g_object_unref0 (self->priv->d_monitor);
	self->priv->d_monitor = NULL;
	_tmp1_ = g_file_monitor (file, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch13_g_error;
	}
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->d_monitor);
	self->priv->d_monitor = _tmp3_;
	goto __finally13;
	__catch13_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
		return self;
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (self->priv->d_sources);
	self->priv->d_sources = _tmp4_;
	g_signal_connect (self->priv->d_monitor, "changed", (GCallback) _gcp_c_compile_args_makefile_on_makefile_changed_g_file_monitor_changed, self);
	return self;
}


static GcpCCompileArgsMakefile* gcp_c_compile_args_makefile_new (GFile* file) {
	return gcp_c_compile_args_makefile_construct (GCP_C_COMPILE_ARGS_TYPE_MAKEFILE, file);
}


static void gcp_c_compile_args_makefile_add (GcpCCompileArgsMakefile* self, GFile* source) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->d_sources, source);
}


static gboolean gcp_c_compile_args_makefile_remove (GcpCCompileArgsMakefile* self, GFile* source) {
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->d_sources, source);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->d_sources);
	result = _tmp0_ == 0;
	return result;
}


static gboolean _gcp_c_compile_args_makefile_on_makefile_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = gcp_c_compile_args_makefile_on_makefile_timeout (self);
	return result;
}


static void gcp_c_compile_args_makefile_on_makefile_changed (GcpCCompileArgsMakefile* self, GFile* file, GFile* other, GFileMonitorEvent event_type) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (event_type == G_FILE_MONITOR_EVENT_CHANGED) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event_type == G_FILE_MONITOR_EVENT_CREATED;
	}
	if (_tmp0_) {
		guint _tmp1_;
		if (self->priv->d_timeoutid != 0) {
			g_source_remove (self->priv->d_timeoutid);
		}
		_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _gcp_c_compile_args_makefile_on_makefile_timeout_gsource_func, gcp_c_compile_args_makefile_ref (self), gcp_c_compile_args_makefile_unref);
		self->priv->d_timeoutid = _tmp1_;
	}
}


static gboolean gcp_c_compile_args_makefile_on_makefile_timeout (GcpCCompileArgsMakefile* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->d_timeoutid = (guint) 0;
	g_signal_emit_by_name (self, "changed");
	result = FALSE;
	return result;
}


static gboolean gcp_c_compile_args_makefile_get_valid (GcpCCompileArgsMakefile* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->d_monitor != NULL;
	return result;
}


static GeeArrayList* gcp_c_compile_args_makefile_get_sources (GcpCCompileArgsMakefile* self) {
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->d_sources;
	return result;
}


static GFile* gcp_c_compile_args_makefile_get_file (GcpCCompileArgsMakefile* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->d_file;
	return result;
}


static void gcp_c_compile_args_value_makefile_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gcp_c_compile_args_value_makefile_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gcp_c_compile_args_makefile_unref (value->data[0].v_pointer);
	}
}


static void gcp_c_compile_args_value_makefile_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gcp_c_compile_args_makefile_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gcp_c_compile_args_value_makefile_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gcp_c_compile_args_value_makefile_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GcpCCompileArgsMakefile* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gcp_c_compile_args_makefile_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gcp_c_compile_args_value_makefile_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GcpCCompileArgsMakefile** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gcp_c_compile_args_makefile_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* gcp_c_compile_args_param_spec_makefile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GcpCCompileArgsParamSpecMakefile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GCP_C_COMPILE_ARGS_TYPE_MAKEFILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer gcp_c_compile_args_value_get_makefile (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_C_COMPILE_ARGS_TYPE_MAKEFILE), NULL);
	return value->data[0].v_pointer;
}


static void gcp_c_compile_args_value_set_makefile (GValue* value, gpointer v_object) {
	GcpCCompileArgsMakefile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_C_COMPILE_ARGS_TYPE_MAKEFILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_C_COMPILE_ARGS_TYPE_MAKEFILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gcp_c_compile_args_makefile_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_c_compile_args_makefile_unref (old);
	}
}


static void gcp_c_compile_args_value_take_makefile (GValue* value, gpointer v_object) {
	GcpCCompileArgsMakefile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_C_COMPILE_ARGS_TYPE_MAKEFILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_C_COMPILE_ARGS_TYPE_MAKEFILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_c_compile_args_makefile_unref (old);
	}
}


static void gcp_c_compile_args_makefile_class_init (GcpCCompileArgsMakefileClass * klass) {
	gcp_c_compile_args_makefile_parent_class = g_type_class_peek_parent (klass);
	GCP_C_COMPILE_ARGS_MAKEFILE_CLASS (klass)->finalize = gcp_c_compile_args_makefile_finalize;
	g_type_class_add_private (klass, sizeof (GcpCCompileArgsMakefilePrivate));
	g_signal_new ("changed", GCP_C_COMPILE_ARGS_TYPE_MAKEFILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void gcp_c_compile_args_makefile_instance_init (GcpCCompileArgsMakefile * self) {
	self->priv = GCP_C_COMPILE_ARGS_MAKEFILE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gcp_c_compile_args_makefile_finalize (GcpCCompileArgsMakefile* obj) {
	GcpCCompileArgsMakefile * self;
	self = GCP_C_COMPILE_ARGS_MAKEFILE (obj);
	_g_object_unref0 (self->priv->d_file);
	_g_object_unref0 (self->priv->d_sources);
	_g_object_unref0 (self->priv->d_monitor);
}


GType gcp_c_compile_args_makefile_get_type (void) {
	return gcp_c_compile_args_makefile_type_id;
}


GType gcp_c_compile_args_makefile_register_type (GTypeModule * module) {
	static const GTypeValueTable g_define_type_value_table = { gcp_c_compile_args_value_makefile_init, gcp_c_compile_args_value_makefile_free_value, gcp_c_compile_args_value_makefile_copy_value, gcp_c_compile_args_value_makefile_peek_pointer, "p", gcp_c_compile_args_value_makefile_collect_value, "p", gcp_c_compile_args_value_makefile_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GcpCCompileArgsMakefileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_c_compile_args_makefile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpCCompileArgsMakefile), 0, (GInstanceInitFunc) gcp_c_compile_args_makefile_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	gcp_c_compile_args_makefile_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GcpCCompileArgsMakefile", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gcp_c_compile_args_makefile_type_id;
}


static gpointer gcp_c_compile_args_makefile_ref (gpointer instance) {
	GcpCCompileArgsMakefile* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void gcp_c_compile_args_makefile_unref (gpointer instance) {
	GcpCCompileArgsMakefile* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GCP_C_COMPILE_ARGS_MAKEFILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void gcp_c_compile_args_class_init (GcpCCompileArgsClass * klass) {
	gcp_c_compile_args_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpCCompileArgsPrivate));
	G_OBJECT_CLASS (klass)->constructor = gcp_c_compile_args_constructor;
	G_OBJECT_CLASS (klass)->finalize = gcp_c_compile_args_finalize;
	g_signal_new ("arguments_changed", GCP_C_TYPE_COMPILE_ARGS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_FILE);
}


static void gcp_c_compile_args_instance_init (GcpCCompileArgs * self) {
	self->priv = GCP_C_COMPILE_ARGS_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_d_argsCache);
	g_static_rec_mutex_init (&self->priv->__lock_d_makefileCache);
}


static void gcp_c_compile_args_finalize (GObject* obj) {
	GcpCCompileArgs * self;
	self = GCP_C_COMPILE_ARGS (obj);
	g_static_rec_mutex_free (&self->priv->__lock_d_argsCache);
	_g_object_unref0 (self->priv->d_argsCache);
	g_static_rec_mutex_free (&self->priv->__lock_d_makefileCache);
	_g_object_unref0 (self->priv->d_makefileCache);
	G_OBJECT_CLASS (gcp_c_compile_args_parent_class)->finalize (obj);
}


GType gcp_c_compile_args_get_type (void) {
	return gcp_c_compile_args_type_id;
}


GType gcp_c_compile_args_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpCCompileArgsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_c_compile_args_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpCCompileArgs), 0, (GInstanceInitFunc) gcp_c_compile_args_instance_init, NULL };
	gcp_c_compile_args_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GcpCCompileArgs", &g_define_type_info, 0);
	return gcp_c_compile_args_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



