import pygtk
pygtk.require('2.0')
import gtk.glade
import os
import gconf
import gobject

import gettext
gettext.textdomain("gevice")
from gettext import gettext as _

import config

class GevicePrefer:
    def __init__ (self,gevice):
        self.flag_load_preferences = False
        
        self.viewip = False
        self.viewmodel = False
        self.viewserial = False
        self.viewcomments = False
        self.backcolor = "#EBE9AE"
        self.forecolor = "#000000"
        self.diagip = False
        self.diagmodel = False
        self.diaglink = False
        self.csvseparator = "|"
        self.host = _("Host")
        self.dbase = _("Database")
        self.user_dbase = _("User database")
        
    
    def load_interface (self,gevice):
        glade_file = gtk.glade.XML (os.path.join (config.GLADEDIR, "gevice.glade"),"window_prefer",None)
        self.window_prefer = glade_file.get_widget ("window_prefer")
        self.button_close_prefer = glade_file.get_widget ("button_close_prefer")
        self.checkbutton_ip = glade_file.get_widget ("checkbutton_ip")
        self.checkbutton_type = glade_file.get_widget ("checkbutton_type")
        self.checkbutton_status = glade_file.get_widget ("checkbutton_status")
        self.checkbutton_model = glade_file.get_widget ("checkbutton_model")
        self.checkbutton_serial = glade_file.get_widget ("checkbutton_serial")
        self.checkbutton_comments = glade_file.get_widget ("checkbutton_comments")
        self.entry_backcolor = glade_file.get_widget ("entry_backcolor")
        self.entry_forecolor = glade_file.get_widget ("entry_forecolor")
        self.entry_csvseparator = glade_file.get_widget ("entry_csvseparator")
        self.button_backcolor = glade_file.get_widget ("button_backcolor")
        self.button_forecolor = glade_file.get_widget ("button_forecolor")
        self.checkbutton_ip_diag = glade_file.get_widget ("checkbutton_ip_diag")
        self.checkbutton_model_diag = glade_file.get_widget ("checkbutton_model_diag")
        self.checkbutton_link_diag = glade_file.get_widget ("checkbutton_link_diag")
        self.entry_host = glade_file.get_widget ("entry_host")
        self.entry_dbase = glade_file.get_widget ("entry_dbase")
        self.entry_user_dbase = glade_file.get_widget ("entry_user_dbase")
        self.button_add_user = glade_file.get_widget ("button_add_user")
        self.button_rem_user = glade_file.get_widget ("button_rem_user")
        self.treeview_users = glade_file.get_widget ("treeview_users")
        
        self.button_close_prefer.connect ("clicked",self.on_button_close_prefer_clicked)
        self.checkbutton_ip.connect ("toggled",self.show_column,config.COLUMN_IP_DEV,gevice)
        self.checkbutton_model.connect ("toggled",self.show_column,config.COLUMN_NAME_MODEL_DEV,gevice)
        self.checkbutton_serial.connect ("toggled",self.show_column,config.COLUMN_SERIAL_DEV,gevice)
        self.checkbutton_comments.connect ("toggled",self.show_column,config.COLUMN_OBS_DEV,gevice)
        self.window_prefer.connect ("delete-event",self.on_window_prefer_delete_event)
        self.entry_backcolor.connect ("changed",self.on_entry_backcolor_changed,gevice)
        self.entry_forecolor.connect ("changed",self.on_entry_forecolor_changed,gevice)
        self.entry_csvseparator.connect ("changed",self.on_entry_csvseparator_changed,gevice)
        self.button_backcolor.connect ("clicked",self.on_button_background_clicked,self.entry_backcolor)
        self.button_forecolor.connect ("clicked",self.on_button_foreground_clicked,self.entry_forecolor)
        self.checkbutton_ip_diag.connect ("toggled",self.change_estatus_on_diagram,gevice)
        self.checkbutton_model_diag.connect ("toggled",self.change_estatus_on_diagram,gevice)
        self.checkbutton_link_diag.connect ("toggled",self.change_estatus_on_diagram,gevice)
        self.entry_host.connect ("changed",self.on_entry_host_changed,gevice)
        self.entry_dbase.connect ("changed",self.on_entry_dbase_changed,gevice)
        self.entry_user_dbase.connect ("changed",self.on_entry_user_dbase_changed,gevice)
        
        self.button_add_user.connect ("clicked",self.on_button_add_user_clicked,gevice)
        self.button_rem_user.connect ("clicked",self.on_button_rem_user_clicked,gevice)        
        
        # for not activate callback when loading preferences
        self.flag_load_preferences = True
        
        self.entry_host.set_text(self.host)
        self.entry_user_dbase.set_text(self.user_dbase)
        self.entry_dbase.set_text(self.dbase)
        
        self.checkbutton_ip.set_active(self.viewip)
        self.checkbutton_model.set_active(self.viewmodel)
        self.checkbutton_serial.set_active(self.viewserial)
        self.checkbutton_comments.set_active(self.viewcomments)
        self.entry_backcolor.set_text (self.backcolor)
        self.entry_forecolor.set_text (self.forecolor)
        self.entry_csvseparator.set_text (self.csvseparator)
        self.checkbutton_ip_diag.set_active(self.diagip)
        self.checkbutton_model_diag.set_active(self.diagmodel)
        self.checkbutton_link_diag.set_active(self.diaglink)
                   
        self.flag_load_preferences = False
        
        col = gtk.TreeViewColumn (_("Users"))
        self.treeview_users.append_column (col)
        cell =  gtk.CellRendererText()
        cell.connect('edited', self.on_name_user_edited,gevice)
        col.pack_start (cell,True)
        cell.set_property('editable',True)
        col.add_attribute (cell,"text",0)        
        
        self.treeview_users.set_model (None)               
        self.treeview_users.set_model (gevice.modelusers)
        gevice.modelusers.clear()
        
        for usr in self.listusers:
            iter = gevice.modelusers.append ()
            gevice.modelusers.set (
                    iter,
                    0,usr)


    def on_name_user_edited(self,cell,path,newname,gevice):
        newname = newname.strip()
        iter = gevice.modelusers.get_iter_from_string(path)
        oldname = gevice.modelusers.get(iter,0)[0]
        
        # check, newname exists
        if oldname == newname:
            return 
        
        self.is_in_list = False
        gevice.modelusers.foreach(self.is_newname_in_list, newname)
        
        if not self.is_in_list:
            gevice.modelusers.set(iter,0,newname)
            self.save_preferences(gevice)
        else:
        	result = gevice.show_message (_("Name exist: ") + newname,gtk.MESSAGE_INFO,gtk.BUTTONS_OK)


    def is_newname_in_list(self,model,path,iter,newname):
        oldname = model.get(iter,0)[0]

        self.is_in_list = False;
        if oldname == newname:
            self.is_in_list = True;
            return True
        return False;


    def show_interface (self):
        self.window_prefer.show_all()

    def close_window (self,window):
        window.destroy()

    def on_button_add_user_clicked (self,button,gevice):
        liststore = self.treeview_users.get_model()
        iter = liststore.append ()
        liststore.set (
            iter,
            0,"New")
            
        path = liststore.get_path(iter)
        self.treeview_users.set_cursor(path,None,False)
        
        self.save_preferences(gevice)


    def on_button_rem_user_clicked (self,button,gevice):
        selection = self.treeview_users.get_selection()
        model,iter = selection.get_selected()
        
        name = model.get(iter,0)[0]
                
        result = gevice.show_message (_("Do you want to remove: ") + name,gtk.MESSAGE_QUESTION,gtk.BUTTONS_YES_NO)
        
        if result == gtk.RESPONSE_YES:
                model.remove(iter)
                self.save_preferences(gevice)
            

    def on_button_background_clicked (self,button,entry):
        self.create_color_selection_dialog(_("Select background color"),entry)
        
    def on_button_foreground_clicked (self,button,entry):
        self.create_color_selection_dialog(_("Select text color"),entry)

    def create_color_selection_dialog (self,title,entry):
        colord = gtk.ColorSelectionDialog(title)
        colord.ok_button.connect ("clicked", self.get_color_preferences,colord,entry)
        colord.cancel_button.connect ("clicked", self.close_selection_dialog,colord)
        
        colorstr = entry.get_text()
        colorgdk = gtk.gdk.color_parse(colorstr)
        colord.colorsel.set_current_color(colorgdk)
        
        colord.show()

    def get_color_preferences (self,button,dialog,entry):
        gdkcolor = dialog.colorsel.get_current_color()
        color = gdkcolor.to_string()
        
        entry.set_text(color)
        self.close_selection_dialog(None,dialog)

    def close_selection_dialog(self,button,dialog):
        dialog.destroy()

    def on_button_close_prefer_clicked (self,button):
        self.close_window (self.window_prefer)

    def on_window_prefer_delete_event (self,window,event):
        self.close_window (window)

    def on_spinbutton_prefer_change_value (self,spinbutton,gevice):
        self.save_preferences(gevice)

    def on_entry_host_changed (self,editable,gevice):
        self.save_preferences(gevice)
        
    def on_entry_dbase_changed (self,editable,gevice):
        self.save_preferences(gevice)
        
    def on_entry_user_dbase_changed (self,editable,gevice):
        self.save_preferences(gevice)
        
    def on_entry_backcolor_changed (self,editable,gevice):
        self.save_preferences(gevice)

    def on_entry_csvseparator_changed (self,editable,gevice):
        self.save_preferences(gevice)
        
    def on_entry_forecolor_changed (self,editable,gevice):
        self.save_preferences(gevice)

    def load_preferences (self,gevice):
        client = gconf.client_get_default()

        host = client.get_string('/apps/gevice/host')
        dbase = client.get_string('/apps/gevice/dbase')
        user_dbase = client.get_string('/apps/gevice/user_dbase')
        backcolor = client.get_string('/apps/gevice/backcolor')
        forecolor = client.get_string('/apps/gevice/forecolor')
        csvseparator = client.get_string('/apps/gevice/csvseparator')
        listusers = client.get_list('/apps/gevice/listusers',gconf.VALUE_STRING)
        
        self.viewip = client.get_bool('/apps/gevice/viewip')
        self.viewmodel = client.get_bool('/apps/gevice/viewmodel')
        self.viewserial = client.get_bool('/apps/gevice/viewserial')
        self.viewcomments = client.get_bool('/apps/gevice/viewcomments')
        self.diagip = client.get_bool('/apps/gevice/diagip')
        self.diagmodel = client.get_bool('/apps/gevice/diagmodel')
        self.diaglink = client.get_bool('/apps/gevice/diaglink')
        
        if (listusers):
            self.listusers = listusers
        else:
            self.listusers = ['user']
                    
        if (host):
            self.host = host        

        if (user_dbase):
            self.user_dbase = user_dbase        

        if (dbase):
            self.dbase = dbase        
        
        if (backcolor):
            self.backcolor = backcolor            
        
        if (forecolor):
            self.forecolor = forecolor
            
        if (csvseparator):
            self.csvseparator = csvseparator
        
        gevice.update_statusbar ()

    
    def save_preferences(self,gevice):
        if (not self.flag_load_preferences):
        
            host = self.entry_host.get_text()
            host = host.strip()
            if len(host) >= 0:
                self.host = host
            
            dbase = self.entry_dbase.get_text()
            dbase = dbase.strip()
            if len(dbase) >= 0:
                self.dbase = dbase
            
            user_dbase = self.entry_user_dbase.get_text()
            user_dbase = user_dbase.strip()
            if len(user_dbase) >= 0:
                self.user_dbase = user_dbase
            
            self.viewip = self.checkbutton_ip.get_active()
            self.viewmodel = self.checkbutton_model.get_active()
            self.viewserial = self.checkbutton_serial.get_active()
            self.viewcomments = self.checkbutton_comments.get_active()
            self.backcolor = self.entry_backcolor.get_text ()
            self.forecolor = self.entry_forecolor.get_text ()
            self.csvseparator = self.entry_csvseparator.get_text ()
            self.diagip = self.checkbutton_ip_diag.get_active()
            self.diagmodel = self.checkbutton_model_diag.get_active()
            self.diaglink = self.checkbutton_link_diag.get_active()
        
            client = gconf.client_get_default()
            client.set_string('/apps/gevice/host', self.host)
            client.set_string('/apps/gevice/dbase', self.dbase)
            client.set_string('/apps/gevice/user_dbase', self.user_dbase)
            client.set_bool('/apps/gevice/viewip', self.viewip)
            client.set_bool('/apps/gevice/viewmodel', self.viewmodel)
            client.set_bool('/apps/gevice/viewserial', self.viewserial)
            client.set_bool('/apps/gevice/viewcomments', self.viewcomments)
            client.set_string('/apps/gevice/backcolor', self.backcolor)
            client.set_string('/apps/gevice/forecolor', self.forecolor)
            client.set_string('/apps/gevice/csvseparator', self.csvseparator)
            client.set_bool('/apps/gevice/diagip', self.diagip)
            client.set_bool('/apps/gevice/diagmodel', self.diagmodel)
            client.set_bool('/apps/gevice/diaglink', self.diaglink)
            
            # clear list
            self.listusers = []
            gevice.modelusers.foreach(self.update_list_users)
            client.set_list('/apps/gevice/listusers',gconf.VALUE_STRING,self.listusers)
            
            gevice.set_listusers_on_combobox()
            gevice.update_statusbar ()
    
    def update_list_users(self,model,path,iter):
        username = model.get(iter,0)[0]
        self.listusers.append(username)
        
        
    def show_column (self,checkbutton,column,gevice):
        st =  checkbutton.get_active()
        tcl = gevice.gmodel.treeview.get_column (column)
        
        if (st):
            tcl.set_visible (True)
        else:
            tcl.set_visible (False)
        
        self.save_preferences(gevice)
    
    def change_estatus_on_diagram (self,checkbutton,gevice):
        self.save_preferences(gevice)
