
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <giomm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "appinfo.h"
#include "asyncresult.h"
#include "cancellable.h"
#include "drive.h"
#include "file.h"
#include "fileattribute.h"
#include "fileenumerator.h"
#include "fileicon.h"
#include "fileinfo.h"
#include "fileinputstream.h"
#include "fileoutputstream.h"
#include "filemonitor.h"
#include "filterinputstream.h"
#include "icon.h"
#include "inputstream.h"
#include "loadableicon.h"
#include "mount.h"
#include "mountoperation.h"
#include "outputstream.h"
#include "seekable.h"
#include "simpleasyncresult.h"
#include "volume.h"
#include "volumemonitor.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType g_app_launch_context_get_type(void);
GType g_cancellable_get_type(void);
GType g_file_enumerator_get_type(void);
GType g_file_icon_get_type(void);
GType g_file_info_get_type(void);
GType g_file_input_stream_get_type(void);
GType g_file_monitor_get_type(void);
GType g_file_output_stream_get_type(void);
GType g_input_stream_get_type(void);
GType g_mount_operation_get_type(void);
GType g_output_stream_get_type(void);
GType g_simple_async_result_get_type(void);
GType g_volume_monitor_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gio {  class AppLaunchContext_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gio {  class Cancellable_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gio {  class FileEnumerator_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gio {  class FileIcon_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gio {  class FileInfo_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gio {  class FileInputStream_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gio {  class FileMonitor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gio {  class FileOutputStream_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gio {  class InputStream_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gio {  class MountOperation_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gio {  class OutputStream_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gio {  class SimpleAsyncResult_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gio {  class VolumeMonitor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

namespace Gio { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(g_app_launch_context_get_type(), &Gio::AppLaunchContext_Class::wrap_new);
  Glib::wrap_register(g_cancellable_get_type(), &Gio::Cancellable_Class::wrap_new);
  Glib::wrap_register(g_file_enumerator_get_type(), &Gio::FileEnumerator_Class::wrap_new);
  Glib::wrap_register(g_file_icon_get_type(), &Gio::FileIcon_Class::wrap_new);
  Glib::wrap_register(g_file_info_get_type(), &Gio::FileInfo_Class::wrap_new);
  Glib::wrap_register(g_file_input_stream_get_type(), &Gio::FileInputStream_Class::wrap_new);
  Glib::wrap_register(g_file_monitor_get_type(), &Gio::FileMonitor_Class::wrap_new);
  Glib::wrap_register(g_file_output_stream_get_type(), &Gio::FileOutputStream_Class::wrap_new);
  Glib::wrap_register(g_input_stream_get_type(), &Gio::InputStream_Class::wrap_new);
  Glib::wrap_register(g_mount_operation_get_type(), &Gio::MountOperation_Class::wrap_new);
  Glib::wrap_register(g_output_stream_get_type(), &Gio::OutputStream_Class::wrap_new);
  Glib::wrap_register(g_simple_async_result_get_type(), &Gio::SimpleAsyncResult_Class::wrap_new);
  Glib::wrap_register(g_volume_monitor_get_type(), &Gio::VolumeMonitor_Class::wrap_new);

  // Register the gtkmm gtypes:
  Gio::AppLaunchContext::get_type();
  Gio::Cancellable::get_type();
  Gio::FileEnumerator::get_type();
  Gio::FileIcon::get_type();
  Gio::FileInfo::get_type();
  Gio::FileInputStream::get_type();
  Gio::FileMonitor::get_type();
  Gio::FileOutputStream::get_type();
  Gio::InputStream::get_type();
  Gio::MountOperation::get_type();
  Gio::OutputStream::get_type();
  Gio::SimpleAsyncResult::get_type();
  Gio::VolumeMonitor::get_type();

} // wrap_init()

} //Gio


