/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2003 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_DIR_FUNCS_H__
#define __GNOME_CMD_DIR_FUNCS_H__

#include "gnome-cmd-dir-types.h"
#include "gnome-cmd-file-types.h"

typedef void (* GnomeCmdDirFileCreatedFunc) (GnomeCmdDir *dir,
											 GnomeCmdFile *finfo,
											 gpointer user_data);
typedef void (* GnomeCmdDirFileDeletedFunc) (GnomeCmdDir *dir,
											 GnomeCmdFile *finfo,
											 gpointer user_data);
typedef void (* GnomeCmdDirFileChangedFunc) (GnomeCmdDir *dir,
											 GnomeCmdFile *finfo,
											 gpointer user_data);


GtkType gnome_cmd_dir_get_type (void);
GnomeCmdDir *gnome_cmd_dir_new_with_values (GnomeVFSURI *baseuri,
											const gchar *path,
											gboolean add_to_pool);
GnomeCmdDir *gnome_cmd_dir_new_from_uri_str (const gchar *dir_uri_str,
											 gboolean add_to_pool);
GnomeCmdDir *gnome_cmd_dir_get_parent (GnomeCmdDir *dir);

void gnome_cmd_dir_ref (GnomeCmdDir *dir);
void gnome_cmd_dir_unref (GnomeCmdDir *dir);

GList *gnome_cmd_dir_list_files (GnomeCmdDir *dir, gboolean visprog);
GList *gnome_cmd_dir_relist_files (GnomeCmdDir *dir, gboolean visprog);

const gchar *gnome_cmd_dir_get_path (GnomeCmdDir *dir);
GnomeVFSURI *gnome_cmd_dir_get_uri (GnomeCmdDir *dir);
const gchar *gnome_cmd_dir_get_uri_str (GnomeCmdDir *dir);
GnomeVFSURI *gnome_cmd_dir_get_file_uri (GnomeCmdDir *dir, const gchar *filename);

void gnome_cmd_dir_content_changed (GnomeCmdDir *dir);

void gnome_cmd_dir_file_created (GnomeCmdDir *dir, const gchar *filename);
void gnome_cmd_dir_file_deleted (GnomeCmdDir *dir, const gchar *filename);
void gnome_cmd_dir_file_changed (GnomeCmdDir *dir, const gchar *filename);
void gnome_cmd_dir_file_renamed (GnomeCmdDir *dir, GnomeCmdFile *finfo);

gboolean gnome_cmd_dir_uses_fam (GnomeCmdDir *dir);

#endif // __GNOME_CMD_DIR_FUNCS_H__
