/* contacts-contact-pane.c generated by valac 0.13.0.32-acab5, the Vala compiler
 * generated from contacts-contact-pane.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <libnotify/notify.h>


#define CONTACTS_TYPE_DETAILS_LAYOUT (contacts_details_layout_get_type ())
#define CONTACTS_DETAILS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_DETAILS_LAYOUT, ContactsDetailsLayout))
#define CONTACTS_DETAILS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_DETAILS_LAYOUT, ContactsDetailsLayoutClass))
#define CONTACTS_IS_DETAILS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_DETAILS_LAYOUT))
#define CONTACTS_IS_DETAILS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_DETAILS_LAYOUT))
#define CONTACTS_DETAILS_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_DETAILS_LAYOUT, ContactsDetailsLayoutClass))

typedef struct _ContactsDetailsLayout ContactsDetailsLayout;
typedef struct _ContactsDetailsLayoutClass ContactsDetailsLayoutClass;
typedef struct _ContactsDetailsLayoutPrivate ContactsDetailsLayoutPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define CONTACTS_DETAILS_LAYOUT_TYPE_STATE (contacts_details_layout_state_get_type ())
typedef struct _ContactsDetailsLayoutState ContactsDetailsLayoutState;
#define _contacts_details_layout_state_free0(var) ((var == NULL) ? NULL : (var = (contacts_details_layout_state_free (var), NULL)))

#define CONTACTS_TYPE_CONTACT_FRAME (contacts_contact_frame_get_type ())
#define CONTACTS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrame))
#define CONTACTS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))
#define CONTACTS_IS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_IS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_CONTACT_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))

typedef struct _ContactsContactFrame ContactsContactFrame;
typedef struct _ContactsContactFrameClass ContactsContactFrameClass;
typedef struct _ContactsContactFramePrivate ContactsContactFramePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define CONTACTS_TYPE_CONTACT_PANE (contacts_contact_pane_get_type ())
#define CONTACTS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane))
#define CONTACTS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))
#define CONTACTS_IS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_IS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_CONTACT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))

typedef struct _ContactsContactPane ContactsContactPane;
typedef struct _ContactsContactPaneClass ContactsContactPaneClass;
typedef struct _ContactsContactPanePrivate ContactsContactPanePrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;

#define CONTACTS_CONTACT_PANE_TYPE_DISPLAY_MODE (contacts_contact_pane_display_mode_get_type ())
#define _contacts_store_unref0(var) ((var == NULL) ? NULL : (var = (contacts_store_unref (var), NULL)))

#define CONTACTS_TYPE_TYPECOMBO (contacts_typecombo_get_type ())
#define CONTACTS_TYPECOMBO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_TYPECOMBO, ContactsTypeCombo))
#define CONTACTS_TYPECOMBO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_TYPECOMBO, ContactsTypeComboClass))
#define CONTACTS_IS_TYPECOMBO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_TYPECOMBO))
#define CONTACTS_IS_TYPECOMBO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_TYPECOMBO))
#define CONTACTS_TYPECOMBO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_TYPECOMBO, ContactsTypeComboClass))

typedef struct _ContactsTypeCombo ContactsTypeCombo;
typedef struct _ContactsTypeComboClass ContactsTypeComboClass;

#define CONTACTS_TYPE_TYPESET (contacts_typeset_get_type ())
#define CONTACTS_TYPESET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_TYPESET, ContactsTypeSet))
#define CONTACTS_TYPESET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_TYPESET, ContactsTypeSetClass))
#define CONTACTS_IS_TYPESET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_TYPESET))
#define CONTACTS_IS_TYPESET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_TYPESET))
#define CONTACTS_TYPESET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_TYPESET, ContactsTypeSetClass))

typedef struct _ContactsTypeSet ContactsTypeSet;
typedef struct _ContactsTypeSetClass ContactsTypeSetClass;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define CONTACTS_TYPE_MENU_BUTTON (contacts_menu_button_get_type ())
#define CONTACTS_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_MENU_BUTTON, ContactsMenuButton))
#define CONTACTS_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_MENU_BUTTON, ContactsMenuButtonClass))
#define CONTACTS_IS_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_MENU_BUTTON))
#define CONTACTS_IS_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_MENU_BUTTON))
#define CONTACTS_MENU_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_MENU_BUTTON, ContactsMenuButtonClass))

typedef struct _ContactsMenuButton ContactsMenuButton;
typedef struct _ContactsMenuButtonClass ContactsMenuButtonClass;
typedef struct _ContactsContactPrivate ContactsContactPrivate;
typedef struct _Block7Data Block7Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
typedef struct _Block15Data Block15Data;
typedef struct _Block16Data Block16Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _ContactsDetailsLayout {
	GObject parent_instance;
	ContactsDetailsLayoutPrivate * priv;
	GtkGrid* current_row;
};

struct _ContactsDetailsLayoutClass {
	GObjectClass parent_class;
};

struct _ContactsDetailsLayoutPrivate {
	GtkGrid* fields_grid;
	GtkSizeGroup* label_size_group;
	gboolean expands;
	GtkWidget* last_label;
};

struct _ContactsDetailsLayoutState {
	gboolean expands;
	GtkGrid* current_row;
	GtkWidget* last_label;
};

struct _ContactsContactFrame {
	GtkFrame parent_instance;
	ContactsContactFramePrivate * priv;
};

struct _ContactsContactFrameClass {
	GtkFrameClass parent_class;
};

struct _ContactsContactFramePrivate {
	gint size;
	gchar* text;
	GdkPixbuf* pixbuf;
	PangoLayout* layout;
	gint text_height;
};

struct _ContactsContactPane {
	GtkEventBox parent_instance;
	ContactsContactPanePrivate * priv;
};

struct _ContactsContactPaneClass {
	GtkEventBoxClass parent_class;
};

typedef enum  {
	CONTACTS_CONTACT_PANE_DISPLAY_MODE_INITIAL,
	CONTACTS_CONTACT_PANE_DISPLAY_MODE_EMPTY,
	CONTACTS_CONTACT_PANE_DISPLAY_MODE_DETAILS,
	CONTACTS_CONTACT_PANE_DISPLAY_MODE_NOTES,
	CONTACTS_CONTACT_PANE_DISPLAY_MODE_EDIT
} ContactsContactPaneDisplayMode;

struct _ContactsContactPanePrivate {
	ContactsStore* contacts_store;
	ContactsContact* selected_contact;
	FolksPersona* editing_persona;
	ContactsContactPaneDisplayMode display_mode;
	GtkGrid* fields_grid;
	gboolean has_notes;
	GtkWidget* notes_dot;
	GtkButtonBox* normal_buttons;
	GtkButtonBox* editing_buttons;
	ContactsDetailsLayout* layout;
	GeeHashSet* editing_emails;
	GeeHashSet* editing_phones;
	GeeHashSet* editing_urls;
};

struct _Block3Data {
	int _ref_count_;
	ContactsContactPane * self;
	ContactsTypeCombo* combo;
	GeeSet* detail_set;
	gchar* property_name;
};

struct _Block4Data {
	int _ref_count_;
	ContactsContactPane * self;
	GtkEntry* entry;
	GeeSet* detail_set;
	gchar* property_name;
};

struct _Block5Data {
	int _ref_count_;
	ContactsContactPane * self;
	GtkGrid* row;
	GeeSet* detail_set;
	FolksFieldDetails* detail;
	gchar* property_name;
};

struct _Block6Data {
	int _ref_count_;
	ContactsContactPane * self;
	ContactsDetailsLayoutState* url_row;
	ContactsDetailsLayoutState* end_row;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	ContactsContactPane * self;
	GeeHashSet* notes;
};

struct _Block8Data {
	int _ref_count_;
	ContactsContactPane * self;
	GeeHashMultiMap* widgets;
	gulong id;
};

struct _Block9Data {
	int _ref_count_;
	ContactsContactPane * self;
	ContactsContactFrame* image_frame;
	GtkEntry* e;
	ContactsContact* contact;
};

struct _Block10Data {
	int _ref_count_;
	Block9Data * _data9_;
	FolksPersona* p;
};

struct _Block11Data {
	int _ref_count_;
	ContactsContactPane * self;
	ContactsContact* contact;
};

struct _Block12Data {
	int _ref_count_;
	Block11Data * _data11_;
	gchar* email_addr;
};

struct _Block13Data {
	int _ref_count_;
	Block11Data * _data11_;
	gchar* protocol;
};

struct _Block14Data {
	int _ref_count_;
	Block13Data * _data13_;
	gchar* id;
};

struct _Block15Data {
	int _ref_count_;
	Block11Data * _data11_;
	FolksPostalAddress* addr;
	GtkButton* button;
};

struct _Block16Data {
	int _ref_count_;
	Block15Data * _data15_;
	NotifyNotification* notification;
};


static gpointer contacts_details_layout_parent_class = NULL;
static gpointer contacts_contact_frame_parent_class = NULL;
static gpointer contacts_contact_pane_parent_class = NULL;

GType contacts_details_layout_get_type (void) G_GNUC_CONST;
#define CONTACTS_DETAILS_LAYOUT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_DETAILS_LAYOUT, ContactsDetailsLayoutPrivate))
enum  {
	CONTACTS_DETAILS_LAYOUT_DUMMY_PROPERTY
};
ContactsDetailsLayout* contacts_details_layout_new (GtkGrid* fields_grid);
ContactsDetailsLayout* contacts_details_layout_construct (GType object_type, GtkGrid* fields_grid);
void contacts_details_layout_reset (ContactsDetailsLayout* self, gboolean full);
void contacts_details_layout_mark_row_stable (ContactsDetailsLayout* self);
static void contacts_details_layout_new_row (ContactsDetailsLayout* self);
void contacts_utils_grid_insert_row_after (GtkGrid* grid, GtkWidget* widget, gboolean expand_intersecting);
void contacts_details_layout_add_widget_label (ContactsDetailsLayout* self, GtkWidget* w);
void contacts_details_layout_add_label (ContactsDetailsLayout* self, const gchar* label);
void contacts_details_layout_attach_detail (ContactsDetailsLayout* self, GtkWidget* widget);
void contacts_details_layout_add_detail (ContactsDetailsLayout* self, const gchar* val);
GtkEntry* contacts_details_layout_add_entry (ContactsDetailsLayout* self, const gchar* val);
void contacts_details_layout_add_label_detail (ContactsDetailsLayout* self, const gchar* label, const gchar* val);
void contacts_details_layout_add_link (ContactsDetailsLayout* self, const gchar* uri, const gchar* text);
GtkButton* contacts_details_layout_add_button (ContactsDetailsLayout* self, const gchar* icon, gboolean at_top);
GtkButton* contacts_details_layout_add_remove (ContactsDetailsLayout* self, gboolean at_top);
GType contacts_details_layout_state_get_type (void) G_GNUC_CONST;
ContactsDetailsLayoutState* contacts_details_layout_state_dup (const ContactsDetailsLayoutState* self);
void contacts_details_layout_state_free (ContactsDetailsLayoutState* self);
void contacts_details_layout_state_copy (const ContactsDetailsLayoutState* self, ContactsDetailsLayoutState* dest);
void contacts_details_layout_state_destroy (ContactsDetailsLayoutState* self);
ContactsDetailsLayoutState* contacts_details_layout_save_state (ContactsDetailsLayout* self);
void contacts_details_layout_load_state (ContactsDetailsLayout* self, ContactsDetailsLayoutState* state);
static void contacts_details_layout_finalize (GObject* obj);
GType contacts_contact_frame_get_type (void) G_GNUC_CONST;
#define CONTACTS_CONTACT_FRAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFramePrivate))
enum  {
	CONTACTS_CONTACT_FRAME_DUMMY_PROPERTY
};
ContactsContactFrame* contacts_contact_frame_new (gint size);
ContactsContactFrame* contacts_contact_frame_construct (GType object_type, gint size);
void contacts_contact_frame_set_image (ContactsContactFrame* self, FolksAvatarDetails* details);
GdkPixbuf* contacts_contact_draw_fallback_avatar (gint size);
void contacts_contact_frame_set_text (ContactsContactFrame* self, const gchar* text_, gint text_height_);
static gboolean contacts_contact_frame_real_draw (GtkWidget* base, cairo_t* cr);
static void contacts_contact_frame_finalize (GObject* obj);
GType contacts_contact_pane_get_type (void) G_GNUC_CONST;
gpointer contacts_store_ref (gpointer instance);
void contacts_store_unref (gpointer instance);
GParamSpec* contacts_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void contacts_value_set_store (GValue* value, gpointer v_object);
void contacts_value_take_store (GValue* value, gpointer v_object);
gpointer contacts_value_get_store (const GValue* value);
GType contacts_store_get_type (void) G_GNUC_CONST;
GType contacts_contact_get_type (void) G_GNUC_CONST;
static GType contacts_contact_pane_display_mode_get_type (void) G_GNUC_UNUSED;
#define CONTACTS_CONTACT_PANE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPanePrivate))
enum  {
	CONTACTS_CONTACT_PANE_DUMMY_PROPERTY
};
#define CONTACTS_CONTACT_PANE_PROFILE_SIZE 96
#define CONTACTS_CONTACT_PANE_LABEL_HEIGHT 20
static GtkWidget* contacts_contact_pane_create_image (ContactsContactPane* self, FolksAvatarDetails* details, gint size);
GType contacts_typecombo_get_type (void) G_GNUC_CONST;
static void contacts_contact_pane_update_edit_detail_type (ContactsContactPane* self, GeeSet* detail_set, ContactsTypeCombo* combo, const gchar* property_name);
FolksFieldDetails* contacts_typecombo_update_details (ContactsTypeCombo* self, FolksFieldDetails* old_details);
GType contacts_typeset_get_type (void) G_GNUC_CONST;
static void contacts_contact_pane_add_detail_combo (ContactsContactPane* self, ContactsTypeSet* type_set, GeeSet* detail_set, FolksFieldDetails* detail, const gchar* property_name);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
ContactsTypeCombo* contacts_typecombo_new (ContactsTypeSet* type_set);
ContactsTypeCombo* contacts_typecombo_construct (GType object_type, ContactsTypeSet* type_set);
void contacts_typecombo_set_active (ContactsTypeCombo* self, FolksFieldDetails* details);
static void _lambda13_ (Block3Data* _data3_);
static void __lambda13__contacts_typecombo_changed (ContactsTypeCombo* _sender, gpointer self);
static void contacts_contact_pane_update_edit_detail_value (ContactsContactPane* self, GeeSet* detail_set, GtkEntry* entry, const gchar* property_name);
static GtkEntry* contacts_contact_pane_add_detail_entry (ContactsContactPane* self, GeeSet* detail_set, FolksFieldDetails* detail, const gchar* property_name, const gchar* placeholder_text);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static gboolean _lambda14_ (GdkEventFocus* ev, Block4Data* _data4_);
static gboolean __lambda14__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void contacts_contact_pane_add_detail_remove (ContactsContactPane* self, GeeSet* detail_set, FolksFieldDetails* detail, const gchar* property_name, gboolean at_top);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void _lambda15_ (Block5Data* _data5_);
static void __lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void contacts_contact_pane_add_detail_editor (ContactsContactPane* self, ContactsTypeSet* type_set, GeeSet* detail_set, FolksFieldDetails* detail_in, const gchar* property_name, const gchar* placeholder_text);
static void contacts_contact_pane_add_detail_editor_no_type (ContactsContactPane* self, GeeSet* detail_set, FolksFieldDetails* detail_in, const gchar* property_name, const gchar* placeholder_text);
static void contacts_contact_pane_update_edit_details (ContactsContactPane* self, ContactsContactFrame* image_frame, FolksPersona* persona, gboolean new_contact);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
GList* contacts_contact_sort_fields (GeeSet* details);
ContactsTypeSet* contacts_typeset_get_general (void);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
ContactsTypeSet* contacts_typeset_get_phone (void);
gchar** contacts_contact_format_address (FolksPostalAddress* addr, int* result_length1);
ContactsMenuButton* contacts_menu_button_new (const gchar* label);
ContactsMenuButton* contacts_menu_button_construct (GType object_type, const gchar* label);
GType contacts_menu_button_get_type (void) G_GNUC_CONST;
GtkMenuItem* contacts_utils_add_menu_item (GtkMenu* menu, const gchar* label);
static void _lambda16_ (Block6Data* _data6_);
static void __lambda16__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda17_ (Block6Data* _data6_);
static void __lambda17__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda18_ (Block6Data* _data6_);
static void __lambda18__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void contacts_menu_button_set_menu (ContactsMenuButton* self, GtkMenu* menu);
static void contacts_contact_pane_display_card (ContactsContactPane* self, ContactsContact* contact);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
GtkWidget* contacts_contact_create_merged_presence_widget (ContactsContact* self);
static void contacts_contact_pane_save_notes (ContactsContactPane* self, GeeHashMultiMap* widgets);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
void contacts_contact_ensure_writable_persona (ContactsContact* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* contacts_contact_ensure_writable_persona_finish (ContactsContact* self, GAsyncResult* _res_, GError** error);
static void _lambda19_ (GObject* obj, GAsyncResult* _result_, Block7Data* _data7_);
static void __lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static GtkTextView* contacts_contact_pane_add_note (ContactsContactPane* self);
static void contacts_contact_pane_update_note (ContactsContactPane* self, GtkTextView* text, FolksNote* note);
static void contacts_contact_pane_display_notes (ContactsContactPane* self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static void contacts_contact_pane_set_display_mode (ContactsContactPane* self, ContactsContactPaneDisplayMode mode);
FolksPersona* contacts_contact_find_writable_persona (ContactsContact* self);
static void _lambda20_ (Block8Data* _data8_);
static void __lambda20__contacts_contact_pane_save_data (ContactsContactPane* _sender, gpointer self);
static void contacts_contact_pane_display_edit (ContactsContactPane* self, ContactsContact* contact, FolksPersona* persona, gboolean new_contact);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
static gboolean _lambda21_ (GdkEventFocus* ev, Block9Data* _data9_);
static gboolean __lambda21__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static void _lambda22_ (GtkToggleButton* a_button, Block10Data* _data10_);
static void __lambda22__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void contacts_contact_pane_display_contact (ContactsContactPane* self, ContactsContact* contact);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static void contacts_contact_pane_set_has_notes (ContactsContactPane* self, gboolean has_notes);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
gchar* contacts_typeset_format_type (ContactsTypeSet* self, FolksFieldDetails* detail);
static void _lambda23_ (Block12Data* _data12_);
void contacts_utils_compose_mail (const gchar* email);
static void __lambda23__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (Block14Data* _data14_);
gchar* contacts_contact_format_im_name (ContactsContact* self, const gchar* protocol, const gchar* id);
GtkWidget* contacts_contact_create_presence_widget (ContactsContact* self, const gchar* protocol, const gchar* im_address);
static void _lambda24_ (Block14Data* _data14_);
void contacts_utils_start_chat (ContactsContact* contact, const gchar* protocol, const gchar* id);
static void __lambda24__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (Block15Data* _data15_);
static void _lambda25_ (Block15Data* _data15_);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (Block16Data* _data16_);
static gboolean _lambda26_ (Block16Data* _data16_);
static gboolean __lambda26__gsource_func (gpointer self);
static void __lambda25__gtk_button_clicked (GtkButton* _sender, gpointer self);
gchar* contacts_contact_format_uri_link_text (FolksFieldDetails* detail);
static void contacts_contact_pane_selected_contact_changed (ContactsContactPane* self);
void contacts_contact_pane_new_contact (ContactsContactPane* self);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self);
static void _lambda27_ (GObject* obj, GAsyncResult* res, ContactsContactPane* self);
ContactsContact* contacts_store_find_contact_with_persona (ContactsStore* self, FolksPersona* persona);
void contacts_contact_pane_show_contact (ContactsContactPane* self, ContactsContact* new_contact, gboolean edit);
static void __lambda27__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _contacts_contact_pane_selected_contact_changed_contacts_contact_changed (ContactsContact* _sender, gpointer self);
ContactsContactPane* contacts_contact_pane_new (ContactsStore* contacts_store);
ContactsContactPane* contacts_contact_pane_construct (GType object_type, ContactsStore* contacts_store);
static gboolean _lambda28_ (GtkWidget* widget, cairo_t* cr, ContactsContactPane* self);
static gboolean __lambda28__gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static void _lambda29_ (GtkButton* button, ContactsContactPane* self);
static void __lambda29__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda30_ (GtkButton* button, ContactsContactPane* self);
static void __lambda30__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda31_ (GtkButton* button, ContactsContactPane* self);
static void __lambda31__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void contacts_contact_pane_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ContactsDetailsLayout* contacts_details_layout_construct (GType object_type, GtkGrid* fields_grid) {
	ContactsDetailsLayout * self = NULL;
	GtkGrid* _tmp0_;
	GtkSizeGroup* _tmp1_ = NULL;
	g_return_val_if_fail (fields_grid != NULL, NULL);
	self = (ContactsDetailsLayout*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (fields_grid);
	_g_object_unref0 (self->priv->fields_grid);
	self->priv->fields_grid = _tmp0_;
	_tmp1_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (self->priv->label_size_group);
	self->priv->label_size_group = _tmp1_;
	return self;
}


ContactsDetailsLayout* contacts_details_layout_new (GtkGrid* fields_grid) {
	return contacts_details_layout_construct (CONTACTS_TYPE_DETAILS_LAYOUT, fields_grid);
}


void contacts_details_layout_reset (ContactsDetailsLayout* self, gboolean full) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self->priv->fields_grid);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp0_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* w = NULL;
			w = (GtkWidget*) w_it->data;
			{
				gboolean _tmp1_ = FALSE;
				if (full) {
					_tmp1_ = TRUE;
				} else {
					gconstpointer _tmp2_ = NULL;
					_tmp2_ = g_object_get_data ((GObject*) w, "contacts-stable");
					_tmp1_ = !GPOINTER_TO_INT (_tmp2_);
				}
				if (_tmp1_) {
					gtk_widget_destroy (w);
				}
			}
		}
		_g_list_free0 (w_collection);
	}
	_g_object_unref0 (self->current_row);
	self->current_row = NULL;
	_g_object_unref0 (self->priv->last_label);
	self->priv->last_label = NULL;
}


void contacts_details_layout_mark_row_stable (ContactsDetailsLayout* self) {
	g_return_if_fail (self != NULL);
	g_object_set_data_full ((GObject*) self->current_row, "contacts-stable", GINT_TO_POINTER (TRUE), NULL);
}


static void contacts_details_layout_new_row (ContactsDetailsLayout* self) {
	GtkGrid* _tmp0_ = NULL;
	GtkGrid* grid;
	GtkGrid* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	grid = g_object_ref_sink (_tmp0_);
	self->priv->expands = FALSE;
	_g_object_unref0 (self->priv->last_label);
	self->priv->last_label = NULL;
	gtk_grid_set_row_spacing (grid, (guint) 8);
	gtk_orientable_set_orientation ((GtkOrientable*) grid, GTK_ORIENTATION_HORIZONTAL);
	if (self->current_row != NULL) {
		contacts_utils_grid_insert_row_after (self->priv->fields_grid, (GtkWidget*) self->current_row, TRUE);
		gtk_grid_attach_next_to (self->priv->fields_grid, (GtkWidget*) grid, (GtkWidget*) self->current_row, GTK_POS_BOTTOM, 1, 1);
	} else {
		gtk_container_add ((GtkContainer*) self->priv->fields_grid, (GtkWidget*) grid);
	}
	_tmp1_ = _g_object_ref0 (grid);
	_g_object_unref0 (self->current_row);
	self->current_row = _tmp1_;
	_g_object_unref0 (grid);
}


void contacts_details_layout_add_widget_label (ContactsDetailsLayout* self, GtkWidget* w) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	contacts_details_layout_new_row (self);
	gtk_size_group_add_widget (self->priv->label_size_group, w);
	gtk_container_add ((GtkContainer*) self->current_row, w);
}


void contacts_details_layout_add_label (ContactsDetailsLayout* self, const gchar* label) {
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* l;
	GtkStyleContext* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (label);
	l = g_object_ref_sink (_tmp0_);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) l);
	gtk_style_context_add_class (_tmp1_, "dim-label");
	gtk_misc_set_alignment ((GtkMisc*) l, (gfloat) 1, 0.5f);
	contacts_details_layout_add_widget_label (self, (GtkWidget*) l);
	_g_object_unref0 (l);
}


void contacts_details_layout_attach_detail (ContactsDetailsLayout* self, GtkWidget* widget) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (self->priv->last_label != NULL) {
		gtk_grid_attach_next_to (self->current_row, widget, self->priv->last_label, GTK_POS_BOTTOM, 1, 1);
	} else {
		gtk_container_add ((GtkContainer*) self->current_row, widget);
	}
	gtk_widget_show (widget);
	_tmp0_ = _g_object_ref0 (widget);
	_g_object_unref0 (self->priv->last_label);
	self->priv->last_label = _tmp0_;
}


void contacts_details_layout_add_detail (ContactsDetailsLayout* self, const gchar* val) {
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* label;
	g_return_if_fail (self != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (val);
	label = g_object_ref_sink (_tmp0_);
	gtk_label_set_selectable (label, TRUE);
	gtk_widget_set_valign ((GtkWidget*) label, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
	g_object_set ((GtkMisc*) label, "xalign", 0.0f, NULL);
	contacts_details_layout_attach_detail (self, (GtkWidget*) label);
	_g_object_unref0 (label);
}


GtkEntry* contacts_details_layout_add_entry (ContactsDetailsLayout* self, const gchar* val) {
	GtkEntry* result = NULL;
	GtkEntry* _tmp0_ = NULL;
	GtkEntry* entry;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (val != NULL, NULL);
	_tmp0_ = (GtkEntry*) gtk_entry_new ();
	entry = g_object_ref_sink (_tmp0_);
	gtk_entry_set_text (entry, val);
	gtk_widget_set_valign ((GtkWidget*) entry, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) entry, GTK_ALIGN_FILL);
	gtk_widget_set_hexpand ((GtkWidget*) entry, TRUE);
	self->priv->expands = TRUE;
	contacts_details_layout_attach_detail (self, (GtkWidget*) entry);
	result = entry;
	return result;
}


void contacts_details_layout_add_label_detail (ContactsDetailsLayout* self, const gchar* label, const gchar* val) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (val != NULL);
	contacts_details_layout_add_label (self, label);
	contacts_details_layout_add_detail (self, val);
}


void contacts_details_layout_add_link (ContactsDetailsLayout* self, const gchar* uri, const gchar* text) {
	GtkLinkButton* _tmp0_ = NULL;
	GtkLinkButton* v;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* l;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = (GtkLinkButton*) gtk_link_button_new_with_label (uri, text);
	v = g_object_ref_sink (_tmp0_);
	gtk_widget_set_valign ((GtkWidget*) v, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) v, GTK_ALIGN_START);
	_tmp1_ = gtk_bin_get_child ((GtkBin*) v);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (GTK_IS_LABEL (_tmp2_) ? ((GtkLabel*) _tmp2_) : NULL);
	l = _tmp3_;
	gtk_label_set_ellipsize (l, PANGO_ELLIPSIZE_END);
	g_object_set ((GtkMisc*) l, "xalign", 0.0f, NULL);
	contacts_details_layout_attach_detail (self, (GtkWidget*) v);
	_g_object_unref0 (l);
	_g_object_unref0 (v);
}


GtkButton* contacts_details_layout_add_button (ContactsDetailsLayout* self, const gchar* icon, gboolean at_top) {
	GtkButton* result = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkButton* button;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	button = g_object_ref_sink (_tmp0_);
	gtk_widget_set_valign ((GtkWidget*) button, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) button, GTK_ALIGN_END);
	if (!self->priv->expands) {
		gtk_widget_set_hexpand ((GtkWidget*) button, TRUE);
	}
	if (icon != NULL) {
		GtkImage* _tmp1_ = NULL;
		GtkImage* image;
		_tmp1_ = (GtkImage*) gtk_image_new ();
		image = g_object_ref_sink (_tmp1_);
		gtk_image_set_from_icon_name (image, icon, GTK_ICON_SIZE_MENU);
		gtk_container_add ((GtkContainer*) button, (GtkWidget*) image);
		gtk_widget_show ((GtkWidget*) image);
		_g_object_unref0 (image);
	}
	if (at_top) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->priv->last_label == NULL;
	}
	if (_tmp2_) {
		gtk_container_add ((GtkContainer*) self->current_row, (GtkWidget*) button);
	} else {
		gtk_grid_attach_next_to (self->current_row, (GtkWidget*) button, self->priv->last_label, GTK_POS_RIGHT, 1, 1);
	}
	result = button;
	return result;
}


GtkButton* contacts_details_layout_add_remove (ContactsDetailsLayout* self, gboolean at_top) {
	GtkButton* result = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkButton* button;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_details_layout_add_button (self, "edit-delete-symbolic", at_top);
	button = _tmp0_;
	gtk_button_set_relief (button, GTK_RELIEF_NONE);
	result = button;
	return result;
}


static gpointer _contacts_details_layout_state_dup0 (gpointer self) {
	return self ? contacts_details_layout_state_dup (self) : NULL;
}


ContactsDetailsLayoutState* contacts_details_layout_save_state (ContactsDetailsLayout* self) {
	ContactsDetailsLayoutState* result = NULL;
	ContactsDetailsLayoutState _tmp0_ = {0};
	ContactsDetailsLayoutState _tmp1_ = {0};
	ContactsDetailsLayoutState _tmp2_;
	ContactsDetailsLayoutState* _tmp3_;
	ContactsDetailsLayoutState* _tmp4_;
	ContactsDetailsLayoutState* state;
	GtkGrid* _tmp5_;
	GtkWidget* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	memset (&_tmp0_, 0, sizeof (ContactsDetailsLayoutState));
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _contacts_details_layout_state_dup0 (&_tmp2_);
	_tmp4_ = _tmp3_;
	contacts_details_layout_state_destroy (&_tmp2_);
	state = _tmp4_;
	(*state).expands = self->priv->expands;
	_tmp5_ = _g_object_ref0 (self->current_row);
	_g_object_unref0 ((*state).current_row);
	(*state).current_row = _tmp5_;
	_tmp6_ = _g_object_ref0 (self->priv->last_label);
	_g_object_unref0 ((*state).last_label);
	(*state).last_label = _tmp6_;
	result = state;
	return result;
}


void contacts_details_layout_load_state (ContactsDetailsLayout* self, ContactsDetailsLayoutState* state) {
	GtkGrid* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->expands = (*state).expands;
	_tmp0_ = _g_object_ref0 ((*state).current_row);
	_g_object_unref0 (self->current_row);
	self->current_row = _tmp0_;
	_tmp1_ = _g_object_ref0 ((*state).last_label);
	_g_object_unref0 (self->priv->last_label);
	self->priv->last_label = _tmp1_;
}


void contacts_details_layout_state_copy (const ContactsDetailsLayoutState* self, ContactsDetailsLayoutState* dest) {
	(*dest).expands = (*self).expands;
	_g_object_unref0 ((*dest).current_row);
	(*dest).current_row = _g_object_ref0 ((*self).current_row);
	_g_object_unref0 ((*dest).last_label);
	(*dest).last_label = _g_object_ref0 ((*self).last_label);
}


void contacts_details_layout_state_destroy (ContactsDetailsLayoutState* self) {
	_g_object_unref0 ((*self).current_row);
	_g_object_unref0 ((*self).last_label);
}


ContactsDetailsLayoutState* contacts_details_layout_state_dup (const ContactsDetailsLayoutState* self) {
	ContactsDetailsLayoutState* dup;
	dup = g_new0 (ContactsDetailsLayoutState, 1);
	contacts_details_layout_state_copy (self, dup);
	return dup;
}


void contacts_details_layout_state_free (ContactsDetailsLayoutState* self) {
	contacts_details_layout_state_destroy (self);
	g_free (self);
}


GType contacts_details_layout_state_get_type (void) {
	static volatile gsize contacts_details_layout_state_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_details_layout_state_type_id__volatile)) {
		GType contacts_details_layout_state_type_id;
		contacts_details_layout_state_type_id = g_boxed_type_register_static ("ContactsDetailsLayoutState", (GBoxedCopyFunc) contacts_details_layout_state_dup, (GBoxedFreeFunc) contacts_details_layout_state_free);
		g_once_init_leave (&contacts_details_layout_state_type_id__volatile, contacts_details_layout_state_type_id);
	}
	return contacts_details_layout_state_type_id__volatile;
}


static void contacts_details_layout_class_init (ContactsDetailsLayoutClass * klass) {
	contacts_details_layout_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsDetailsLayoutPrivate));
	G_OBJECT_CLASS (klass)->finalize = contacts_details_layout_finalize;
}


static void contacts_details_layout_instance_init (ContactsDetailsLayout * self) {
	self->priv = CONTACTS_DETAILS_LAYOUT_GET_PRIVATE (self);
}


static void contacts_details_layout_finalize (GObject* obj) {
	ContactsDetailsLayout * self;
	self = CONTACTS_DETAILS_LAYOUT (obj);
	_g_object_unref0 (self->priv->fields_grid);
	_g_object_unref0 (self->priv->label_size_group);
	_g_object_unref0 (self->current_row);
	_g_object_unref0 (self->priv->last_label);
	G_OBJECT_CLASS (contacts_details_layout_parent_class)->finalize (obj);
}


GType contacts_details_layout_get_type (void) {
	static volatile gsize contacts_details_layout_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_details_layout_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsDetailsLayoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_details_layout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsDetailsLayout), 0, (GInstanceInitFunc) contacts_details_layout_instance_init, NULL };
		GType contacts_details_layout_type_id;
		contacts_details_layout_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsDetailsLayout", &g_define_type_info, 0);
		g_once_init_leave (&contacts_details_layout_type_id__volatile, contacts_details_layout_type_id);
	}
	return contacts_details_layout_type_id__volatile;
}


ContactsContactFrame* contacts_contact_frame_construct (GType object_type, gint size) {
	ContactsContactFrame * self = NULL;
	GtkImage* _tmp0_ = NULL;
	GtkImage* image;
	GtkStyleContext* _tmp1_ = NULL;
	self = (ContactsContactFrame*) g_object_new (object_type, NULL);
	self->priv->size = size;
	_tmp0_ = (GtkImage*) gtk_image_new ();
	image = g_object_ref_sink (_tmp0_);
	gtk_widget_set_size_request ((GtkWidget*) image, size, size);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) image);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "contact-frame");
	gtk_frame_set_shadow_type ((GtkFrame*) self, GTK_SHADOW_OUT);
	_g_object_unref0 (image);
	return self;
}


ContactsContactFrame* contacts_contact_frame_new (gint size) {
	return contacts_contact_frame_construct (CONTACTS_TYPE_CONTACT_FRAME, size);
}


void contacts_contact_frame_set_image (ContactsContactFrame* self, FolksAvatarDetails* details) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->pixbuf);
	self->priv->pixbuf = NULL;
	if (details != NULL) {
		GFile* _tmp2_ = NULL;
		_tmp2_ = folks_avatar_details_get_avatar (details);
		_tmp1_ = _tmp2_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GFile* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp3_ = folks_avatar_details_get_avatar (details);
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ != NULL;
		_g_free0 (_tmp5_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			GFile* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			GdkPixbuf* _tmp9_ = NULL;
			GdkPixbuf* _tmp10_;
			GdkPixbuf* _tmp11_;
			_tmp6_ = folks_avatar_details_get_avatar (details);
			_tmp7_ = g_file_get_path (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = gdk_pixbuf_new_from_file_at_scale (_tmp8_, self->priv->size, self->priv->size, TRUE, &_inner_error_);
			_tmp10_ = _tmp9_;
			_g_free0 (_tmp8_);
			_tmp11_ = _tmp10_;
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
			_g_object_unref0 (self->priv->pixbuf);
			self->priv->pixbuf = _tmp11_;
		}
		goto __finally2;
		__catch2_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
		}
		__finally2:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (self->priv->pixbuf == NULL) {
		GdkPixbuf* _tmp12_ = NULL;
		_tmp12_ = contacts_contact_draw_fallback_avatar (self->priv->size);
		_g_object_unref0 (self->priv->pixbuf);
		self->priv->pixbuf = _tmp12_;
	}
}


void contacts_contact_frame_set_text (ContactsContactFrame* self, const gchar* text_, gint text_height_) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (text_);
	_g_free0 (self->priv->text);
	self->priv->text = _tmp0_;
	self->priv->text_height = text_height_;
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = NULL;
	if (self->priv->text != NULL) {
		PangoLayout* _tmp1_ = NULL;
		_tmp1_ = gtk_widget_create_pango_layout ((GtkWidget*) self, self->priv->text);
		_g_object_unref0 (self->priv->layout);
		self->priv->layout = _tmp1_;
		pango_layout_set_width (self->priv->layout, self->priv->size);
		pango_layout_set_height (self->priv->layout, self->priv->text_height);
		pango_layout_set_alignment (self->priv->layout, PANGO_ALIGN_CENTER);
	}
}


static gboolean contacts_contact_frame_real_draw (GtkWidget* base, cairo_t* cr) {
	ContactsContactFrame * self;
	gboolean result = FALSE;
	self = (ContactsContactFrame*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	cairo_save (cr);
	if (self->priv->pixbuf != NULL) {
		gdk_cairo_set_source_pixbuf (cr, self->priv->pixbuf, (gdouble) 2, (gdouble) 2);
		cairo_paint (cr);
	}
	if (self->priv->layout != NULL) {
		GtkStyleContext* _tmp0_ = NULL;
		cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.5);
		cairo_rectangle (cr, (gdouble) 2, (gdouble) ((2 + self->priv->size) - self->priv->text_height), (gdouble) self->priv->size, (gdouble) self->priv->text_height);
		cairo_fill (cr);
		cairo_set_source_rgb (cr, 1.0, 1.0, 1.0);
		_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_render_layout (_tmp0_, cr, (gdouble) (self->priv->size / 2), (gdouble) (self->priv->size - self->priv->text_height), self->priv->layout);
	}
	cairo_restore (cr);
	GTK_WIDGET_CLASS (contacts_contact_frame_parent_class)->draw ((GtkWidget*) GTK_FRAME (self), cr);
	result = TRUE;
	return result;
}


static void contacts_contact_frame_class_init (ContactsContactFrameClass * klass) {
	contacts_contact_frame_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsContactFramePrivate));
	GTK_WIDGET_CLASS (klass)->draw = contacts_contact_frame_real_draw;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_frame_finalize;
}


static void contacts_contact_frame_instance_init (ContactsContactFrame * self) {
	self->priv = CONTACTS_CONTACT_FRAME_GET_PRIVATE (self);
}


static void contacts_contact_frame_finalize (GObject* obj) {
	ContactsContactFrame * self;
	self = CONTACTS_CONTACT_FRAME (obj);
	_g_free0 (self->priv->text);
	_g_object_unref0 (self->priv->pixbuf);
	_g_object_unref0 (self->priv->layout);
	G_OBJECT_CLASS (contacts_contact_frame_parent_class)->finalize (obj);
}


GType contacts_contact_frame_get_type (void) {
	static volatile gsize contacts_contact_frame_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_frame_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsContactFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactFrame), 0, (GInstanceInitFunc) contacts_contact_frame_instance_init, NULL };
		GType contacts_contact_frame_type_id;
		contacts_contact_frame_type_id = g_type_register_static (GTK_TYPE_FRAME, "ContactsContactFrame", &g_define_type_info, 0);
		g_once_init_leave (&contacts_contact_frame_type_id__volatile, contacts_contact_frame_type_id);
	}
	return contacts_contact_frame_type_id__volatile;
}


static GType contacts_contact_pane_display_mode_get_type (void) {
	static volatile gsize contacts_contact_pane_display_mode_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_pane_display_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{CONTACTS_CONTACT_PANE_DISPLAY_MODE_INITIAL, "CONTACTS_CONTACT_PANE_DISPLAY_MODE_INITIAL", "initial"}, {CONTACTS_CONTACT_PANE_DISPLAY_MODE_EMPTY, "CONTACTS_CONTACT_PANE_DISPLAY_MODE_EMPTY", "empty"}, {CONTACTS_CONTACT_PANE_DISPLAY_MODE_DETAILS, "CONTACTS_CONTACT_PANE_DISPLAY_MODE_DETAILS", "details"}, {CONTACTS_CONTACT_PANE_DISPLAY_MODE_NOTES, "CONTACTS_CONTACT_PANE_DISPLAY_MODE_NOTES", "notes"}, {CONTACTS_CONTACT_PANE_DISPLAY_MODE_EDIT, "CONTACTS_CONTACT_PANE_DISPLAY_MODE_EDIT", "edit"}, {0, NULL, NULL}};
		GType contacts_contact_pane_display_mode_type_id;
		contacts_contact_pane_display_mode_type_id = g_enum_register_static ("ContactsContactPaneDisplayMode", values);
		g_once_init_leave (&contacts_contact_pane_display_mode_type_id__volatile, contacts_contact_pane_display_mode_type_id);
	}
	return contacts_contact_pane_display_mode_type_id__volatile;
}


static GtkWidget* contacts_contact_pane_create_image (ContactsContactPane* self, FolksAvatarDetails* details, gint size) {
	GtkWidget* result = NULL;
	GtkImage* _tmp0_ = NULL;
	GtkImage* image;
	GdkPixbuf* pixbuf;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkImage*) gtk_image_new ();
	image = g_object_ref_sink (_tmp0_);
	gtk_widget_set_size_request ((GtkWidget*) image, size, size);
	pixbuf = NULL;
	if (details != NULL) {
		GFile* _tmp3_ = NULL;
		_tmp3_ = folks_avatar_details_get_avatar (details);
		_tmp2_ = _tmp3_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp4_ = folks_avatar_details_get_avatar (details);
		_tmp5_ = g_file_get_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_ != NULL;
		_g_free0 (_tmp6_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			GFile* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			GdkPixbuf* _tmp10_ = NULL;
			GdkPixbuf* _tmp11_;
			GdkPixbuf* _tmp12_;
			_tmp7_ = folks_avatar_details_get_avatar (details);
			_tmp8_ = g_file_get_path (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = gdk_pixbuf_new_from_file_at_scale (_tmp9_, size, size, TRUE, &_inner_error_);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp9_);
			_tmp12_ = _tmp11_;
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp12_;
		}
		goto __finally3;
		__catch3_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (image);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (pixbuf == NULL) {
		GdkPixbuf* _tmp13_ = NULL;
		_tmp13_ = contacts_contact_draw_fallback_avatar (size);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp13_;
	}
	if (pixbuf != NULL) {
		gtk_image_set_from_pixbuf (image, pixbuf);
	}
	result = (GtkWidget*) image;
	_g_object_unref0 (pixbuf);
	return result;
}


static void contacts_contact_pane_update_edit_detail_type (ContactsContactPane* self, GeeSet* detail_set, ContactsTypeCombo* combo, const gchar* property_name) {
	FolksFieldDetails* old_detail;
	FolksFieldDetails* _tmp5_ = NULL;
	FolksFieldDetails* new_detail;
	gconstpointer _tmp6_ = NULL;
	GtkEntry* _tmp7_;
	gconstpointer _tmp8_ = NULL;
	ContactsTypeCombo* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (detail_set != NULL);
	g_return_if_fail (combo != NULL);
	g_return_if_fail (property_name != NULL);
	old_detail = NULL;
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _detail_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) detail_set);
		_detail_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksFieldDetails* detail;
			gconstpointer _tmp3_ = NULL;
			_tmp1_ = gee_iterator_next (_detail_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_detail_it);
			detail = (FolksFieldDetails*) _tmp2_;
			_tmp3_ = g_object_get_data ((GObject*) detail, "combo");
			if (((ContactsTypeCombo*) _tmp3_) == combo) {
				FolksFieldDetails* _tmp4_;
				_tmp4_ = _g_object_ref0 (detail);
				_g_object_unref0 (old_detail);
				old_detail = _tmp4_;
				_g_object_unref0 (detail);
				break;
			}
			_g_object_unref0 (detail);
		}
		_g_object_unref0 (_detail_it);
	}
	g_assert (old_detail != NULL);
	_tmp5_ = contacts_typecombo_update_details (combo, old_detail);
	new_detail = _tmp5_;
	_tmp6_ = g_object_get_data ((GObject*) old_detail, "entry");
	_tmp7_ = _g_object_ref0 ((GtkEntry*) _tmp6_);
	g_object_set_data_full ((GObject*) new_detail, "entry", _tmp7_, g_object_unref);
	_tmp8_ = g_object_get_data ((GObject*) old_detail, "combo");
	_tmp9_ = _g_object_ref0 ((ContactsTypeCombo*) _tmp8_);
	g_object_set_data_full ((GObject*) new_detail, "combo", _tmp9_, g_object_unref);
	gee_collection_remove ((GeeCollection*) detail_set, old_detail);
	gee_collection_add ((GeeCollection*) detail_set, new_detail);
	g_object_set ((GObject*) self->priv->editing_persona, property_name, detail_set, NULL);
	_g_object_unref0 (new_detail);
	_g_object_unref0 (old_detail);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->combo);
		_g_object_unref0 (_data3_->detail_set);
		_g_free0 (_data3_->property_name);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _lambda13_ (Block3Data* _data3_) {
	ContactsContactPane * self;
	self = _data3_->self;
	contacts_contact_pane_update_edit_detail_type (self, _data3_->detail_set, _data3_->combo, _data3_->property_name);
}


static void __lambda13__contacts_typecombo_changed (ContactsTypeCombo* _sender, gpointer self) {
	_lambda13_ (self);
}


static void contacts_contact_pane_add_detail_combo (ContactsContactPane* self, ContactsTypeSet* type_set, GeeSet* detail_set, FolksFieldDetails* detail, const gchar* property_name) {
	Block3Data* _data3_;
	ContactsTypeCombo* _tmp0_ = NULL;
	ContactsTypeCombo* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_set != NULL);
	g_return_if_fail (detail_set != NULL);
	g_return_if_fail (detail != NULL);
	g_return_if_fail (property_name != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->detail_set = _g_object_ref0 (detail_set);
	_data3_->property_name = g_strdup (property_name);
	_tmp0_ = contacts_typecombo_new (type_set);
	_data3_->combo = g_object_ref_sink (_tmp0_);
	gtk_widget_set_halign ((GtkWidget*) _data3_->combo, GTK_ALIGN_FILL);
	gtk_widget_set_hexpand ((GtkWidget*) _data3_->combo, FALSE);
	contacts_typecombo_set_active (_data3_->combo, detail);
	contacts_details_layout_add_widget_label (self->priv->layout, (GtkWidget*) _data3_->combo);
	_tmp1_ = _g_object_ref0 (_data3_->combo);
	g_object_set_data_full ((GObject*) detail, "combo", _tmp1_, g_object_unref);
	g_signal_connect_data (_data3_->combo, "changed", (GCallback) __lambda13__contacts_typecombo_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void contacts_contact_pane_update_edit_detail_value (ContactsContactPane* self, GeeSet* detail_set, GtkEntry* entry, const gchar* property_name) {
	FolksFieldDetails* old_detail;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (detail_set != NULL);
	g_return_if_fail (entry != NULL);
	g_return_if_fail (property_name != NULL);
	old_detail = NULL;
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _detail_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) detail_set);
		_detail_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksFieldDetails* detail;
			gconstpointer _tmp3_ = NULL;
			_tmp1_ = gee_iterator_next (_detail_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_detail_it);
			detail = (FolksFieldDetails*) _tmp2_;
			_tmp3_ = g_object_get_data ((GObject*) detail, "entry");
			if (((GtkEntry*) _tmp3_) == entry) {
				FolksFieldDetails* _tmp4_;
				_tmp4_ = _g_object_ref0 (detail);
				_g_object_unref0 (old_detail);
				old_detail = _tmp4_;
				_g_object_unref0 (detail);
				break;
			}
			_g_object_unref0 (detail);
		}
		_g_object_unref0 (_detail_it);
	}
	g_assert (old_detail != NULL);
	_tmp5_ = folks_field_details_get_value (old_detail);
	_tmp6_ = gtk_entry_get_text (entry);
	if (g_strcmp0 (_tmp5_, _tmp6_) != 0) {
		const gchar* _tmp7_ = NULL;
		FolksFieldDetails* _tmp8_ = NULL;
		FolksFieldDetails* new_detail;
		GeeMultiMap* _tmp9_ = NULL;
		gconstpointer _tmp10_ = NULL;
		GtkEntry* _tmp11_;
		gconstpointer _tmp12_ = NULL;
		ContactsTypeCombo* _tmp13_;
		_tmp7_ = gtk_entry_get_text (entry);
		_tmp8_ = folks_field_details_new (_tmp7_);
		new_detail = _tmp8_;
		_tmp9_ = folks_field_details_get_parameters (old_detail);
		folks_field_details_set_parameters (new_detail, _tmp9_);
		_tmp10_ = g_object_get_data ((GObject*) old_detail, "entry");
		_tmp11_ = _g_object_ref0 ((GtkEntry*) _tmp10_);
		g_object_set_data_full ((GObject*) new_detail, "entry", _tmp11_, g_object_unref);
		_tmp12_ = g_object_get_data ((GObject*) old_detail, "combo");
		_tmp13_ = _g_object_ref0 ((ContactsTypeCombo*) _tmp12_);
		g_object_set_data_full ((GObject*) new_detail, "combo", _tmp13_, g_object_unref);
		gee_collection_remove ((GeeCollection*) detail_set, old_detail);
		gee_collection_add ((GeeCollection*) detail_set, new_detail);
		g_object_set ((GObject*) self->priv->editing_persona, property_name, detail_set, NULL);
		_g_object_unref0 (new_detail);
	}
	_g_object_unref0 (old_detail);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->entry);
		_g_object_unref0 (_data4_->detail_set);
		_g_free0 (_data4_->property_name);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean _lambda14_ (GdkEventFocus* ev, Block4Data* _data4_) {
	ContactsContactPane * self;
	gboolean result = FALSE;
	self = _data4_->self;
	contacts_contact_pane_update_edit_detail_value (self, _data4_->detail_set, _data4_->entry, _data4_->property_name);
	result = FALSE;
	return result;
}


static gboolean __lambda14__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = _lambda14_ (event, self);
	return result;
}


static GtkEntry* contacts_contact_pane_add_detail_entry (ContactsContactPane* self, GeeSet* detail_set, FolksFieldDetails* detail, const gchar* property_name, const gchar* placeholder_text) {
	GtkEntry* result = NULL;
	Block4Data* _data4_;
	const gchar* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (detail_set != NULL, NULL);
	g_return_val_if_fail (detail != NULL, NULL);
	g_return_val_if_fail (property_name != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->detail_set = _g_object_ref0 (detail_set);
	_data4_->property_name = g_strdup (property_name);
	_tmp0_ = folks_field_details_get_value (detail);
	_tmp1_ = contacts_details_layout_add_entry (self->priv->layout, _tmp0_);
	_data4_->entry = _tmp1_;
	_tmp2_ = _g_object_ref0 (_data4_->entry);
	g_object_set_data_full ((GObject*) detail, "entry", _tmp2_, g_object_unref);
	if (placeholder_text != NULL) {
		g_object_set ((GObject*) _data4_->entry, "placeholder-text", placeholder_text, NULL);
	}
	g_signal_connect_data ((GtkWidget*) _data4_->entry, "focus-out-event", (GCallback) __lambda14__gtk_widget_focus_out_event, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp3_ = _g_object_ref0 (_data4_->entry);
	result = _tmp3_;
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		_g_object_unref0 (_data5_->row);
		_g_object_unref0 (_data5_->detail_set);
		_g_object_unref0 (_data5_->detail);
		_g_free0 (_data5_->property_name);
		g_slice_free (Block5Data, _data5_);
	}
}


static void _lambda15_ (Block5Data* _data5_) {
	ContactsContactPane * self;
	self = _data5_->self;
	gee_collection_remove ((GeeCollection*) _data5_->detail_set, _data5_->detail);
	g_object_set ((GObject*) self->priv->editing_persona, _data5_->property_name, _data5_->detail_set, NULL);
	gtk_widget_destroy ((GtkWidget*) _data5_->row);
}


static void __lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda15_ (self);
}


static void contacts_contact_pane_add_detail_remove (ContactsContactPane* self, GeeSet* detail_set, FolksFieldDetails* detail, const gchar* property_name, gboolean at_top) {
	Block5Data* _data5_;
	GtkButton* _tmp0_ = NULL;
	GtkButton* remove_button;
	GtkGrid* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (detail_set != NULL);
	g_return_if_fail (detail != NULL);
	g_return_if_fail (property_name != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->detail_set = _g_object_ref0 (detail_set);
	_data5_->detail = _g_object_ref0 (detail);
	_data5_->property_name = g_strdup (property_name);
	_tmp0_ = contacts_details_layout_add_remove (self->priv->layout, at_top);
	remove_button = _tmp0_;
	_tmp1_ = _g_object_ref0 (self->priv->layout->current_row);
	_data5_->row = _tmp1_;
	g_signal_connect_data (remove_button, "clicked", (GCallback) __lambda15__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_g_object_unref0 (remove_button);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static void contacts_contact_pane_add_detail_editor (ContactsContactPane* self, ContactsTypeSet* type_set, GeeSet* detail_set, FolksFieldDetails* detail_in, const gchar* property_name, const gchar* placeholder_text) {
	FolksFieldDetails* _tmp0_;
	FolksFieldDetails* _tmp1_;
	FolksFieldDetails* _tmp3_;
	FolksFieldDetails* detail;
	GtkEntry* _tmp4_ = NULL;
	GtkEntry* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_set != NULL);
	g_return_if_fail (detail_set != NULL);
	g_return_if_fail (property_name != NULL);
	_tmp0_ = _g_object_ref0 (detail_in);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		FolksFieldDetails* _tmp2_ = NULL;
		_tmp2_ = folks_field_details_new ("");
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp2_;
	}
	_tmp3_ = _g_object_ref0 (_tmp1_);
	detail = _tmp3_;
	gee_collection_add ((GeeCollection*) detail_set, detail);
	contacts_contact_pane_add_detail_combo (self, type_set, detail_set, detail, property_name);
	_tmp4_ = contacts_contact_pane_add_detail_entry (self, detail_set, detail, property_name, placeholder_text);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	contacts_contact_pane_add_detail_remove (self, detail_set, detail, property_name, TRUE);
	_g_object_unref0 (detail);
	_g_object_unref0 (_tmp1_);
}


static void contacts_contact_pane_add_detail_editor_no_type (ContactsContactPane* self, GeeSet* detail_set, FolksFieldDetails* detail_in, const gchar* property_name, const gchar* placeholder_text) {
	FolksFieldDetails* _tmp0_;
	FolksFieldDetails* _tmp1_;
	FolksFieldDetails* _tmp3_;
	FolksFieldDetails* detail;
	GtkEntry* _tmp4_ = NULL;
	GtkEntry* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (detail_set != NULL);
	g_return_if_fail (property_name != NULL);
	_tmp0_ = _g_object_ref0 (detail_in);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		FolksFieldDetails* _tmp2_ = NULL;
		_tmp2_ = folks_field_details_new ("");
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp2_;
	}
	_tmp3_ = _g_object_ref0 (_tmp1_);
	detail = _tmp3_;
	gee_collection_add ((GeeCollection*) detail_set, detail);
	_tmp4_ = contacts_contact_pane_add_detail_entry (self, detail_set, detail, property_name, placeholder_text);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	contacts_contact_pane_add_detail_remove (self, detail_set, detail, property_name, FALSE);
	_g_object_unref0 (detail);
	_g_object_unref0 (_tmp1_);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		_contacts_details_layout_state_free0 (_data6_->end_row);
		_contacts_details_layout_state_free0 (_data6_->url_row);
		g_slice_free (Block6Data, _data6_);
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _lambda16_ (Block6Data* _data6_) {
	ContactsContactPane * self;
	ContactsTypeSet* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ContactsDetailsLayoutState* _tmp2_ = NULL;
	self = _data6_->self;
	contacts_details_layout_load_state (self->priv->layout, _data6_->end_row);
	_tmp0_ = contacts_typeset_get_general ();
	_tmp1_ = _ ("Enter email address");
	contacts_contact_pane_add_detail_editor (self, _tmp0_, (GeeSet*) self->priv->editing_emails, NULL, "email_addresses", _tmp1_);
	gtk_widget_show_all ((GtkWidget*) self->priv->fields_grid);
	_tmp2_ = contacts_details_layout_save_state (self->priv->layout);
	_contacts_details_layout_state_free0 (_data6_->end_row);
	_data6_->end_row = _tmp2_;
}


static void __lambda16__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda16_ (self);
}


static void _lambda17_ (Block6Data* _data6_) {
	ContactsContactPane * self;
	ContactsTypeSet* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ContactsDetailsLayoutState* _tmp2_ = NULL;
	self = _data6_->self;
	contacts_details_layout_load_state (self->priv->layout, _data6_->end_row);
	_tmp0_ = contacts_typeset_get_phone ();
	_tmp1_ = _ ("Enter phone number");
	contacts_contact_pane_add_detail_editor (self, _tmp0_, (GeeSet*) self->priv->editing_phones, NULL, "phone_numbers", _tmp1_);
	gtk_widget_show_all ((GtkWidget*) self->priv->fields_grid);
	_tmp2_ = contacts_details_layout_save_state (self->priv->layout);
	_contacts_details_layout_state_free0 (_data6_->end_row);
	_data6_->end_row = _tmp2_;
}


static void __lambda17__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda17_ (self);
}


static void _lambda18_ (Block6Data* _data6_) {
	ContactsContactPane * self;
	const gchar* _tmp0_ = NULL;
	ContactsDetailsLayoutState* _tmp1_ = NULL;
	self = _data6_->self;
	if (_data6_->url_row != NULL) {
		contacts_details_layout_load_state (self->priv->layout, _data6_->url_row);
	} else {
		contacts_details_layout_add_label (self->priv->layout, "Links");
	}
	_tmp0_ = _ ("Enter link");
	contacts_contact_pane_add_detail_editor_no_type (self, (GeeSet*) self->priv->editing_urls, NULL, "urls", _tmp0_);
	_tmp1_ = contacts_details_layout_save_state (self->priv->layout);
	_contacts_details_layout_state_free0 (_data6_->url_row);
	_data6_->url_row = _tmp1_;
	gtk_widget_show_all ((GtkWidget*) self->priv->fields_grid);
}


static void __lambda18__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda18_ (self);
}


static void contacts_contact_pane_update_edit_details (ContactsContactPane* self, ContactsContactFrame* image_frame, FolksPersona* persona, gboolean new_contact) {
	Block6Data* _data6_;
	FolksPersona* _tmp0_;
	FolksPersonaStore* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GeeHashSet* _tmp3_ = NULL;
	GeeHashSet* _tmp4_ = NULL;
	GeeHashSet* _tmp5_ = NULL;
	FolksPersona* _tmp6_;
	FolksEmailDetails* _tmp7_;
	FolksEmailDetails* email_details;
	FolksPersona* _tmp17_;
	FolksImDetails* _tmp18_;
	FolksImDetails* im_details;
	FolksPersona* _tmp38_;
	FolksPhoneDetails* _tmp39_;
	FolksPhoneDetails* phone_details;
	FolksPersona* _tmp49_;
	FolksPostalAddressDetails* _tmp50_;
	FolksPostalAddressDetails* postal_details;
	FolksPersona* _tmp69_;
	FolksUrlDetails* _tmp70_;
	FolksUrlDetails* urls_details;
	ContactsDetailsLayoutState* _tmp79_ = NULL;
	FolksPersonaStore* _tmp80_ = NULL;
	gboolean _tmp81_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image_frame != NULL);
	g_return_if_fail (persona != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	contacts_details_layout_reset (self->priv->layout, FALSE);
	_tmp0_ = persona;
	contacts_contact_frame_set_image (image_frame, FOLKS_IS_AVATAR_DETAILS (_tmp0_) ? ((FolksAvatarDetails*) _tmp0_) : NULL);
	_tmp1_ = folks_persona_get_store (persona);
	_tmp2_ = folks_persona_store_get_display_name (_tmp1_);
	contacts_contact_frame_set_text (image_frame, _tmp2_, CONTACTS_CONTACT_PANE_LABEL_HEIGHT);
	_tmp3_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->editing_emails);
	self->priv->editing_emails = _tmp3_;
	_tmp4_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->editing_phones);
	self->priv->editing_phones = _tmp4_;
	_tmp5_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->editing_urls);
	self->priv->editing_urls = _tmp5_;
	_tmp6_ = persona;
	_tmp7_ = _g_object_ref0 (FOLKS_IS_EMAIL_DETAILS (_tmp6_) ? ((FolksEmailDetails*) _tmp6_) : NULL);
	email_details = _tmp7_;
	if (email_details != NULL) {
		GeeSet* _tmp8_ = NULL;
		GeeSet* _tmp9_;
		GeeSet* emails;
		gboolean _tmp10_;
		_tmp8_ = folks_email_details_get_email_addresses (email_details);
		_tmp9_ = _g_object_ref0 (_tmp8_);
		emails = _tmp9_;
		_tmp10_ = gee_collection_get_is_empty ((GeeCollection*) emails);
		if (!_tmp10_) {
			GList* _tmp11_ = NULL;
			_tmp11_ = contacts_contact_sort_fields (emails);
			{
				GList* email_collection = NULL;
				GList* email_it = NULL;
				email_collection = _tmp11_;
				for (email_it = email_collection; email_it != NULL; email_it = email_it->next) {
					FolksFieldDetails* _tmp12_;
					FolksFieldDetails* email = NULL;
					_tmp12_ = _g_object_ref0 ((FolksFieldDetails*) email_it->data);
					email = _tmp12_;
					{
						ContactsTypeSet* _tmp13_ = NULL;
						const gchar* _tmp14_ = NULL;
						_tmp13_ = contacts_typeset_get_general ();
						_tmp14_ = _ ("Enter email address");
						contacts_contact_pane_add_detail_editor (self, _tmp13_, (GeeSet*) self->priv->editing_emails, email, "email_addresses", _tmp14_);
						_g_object_unref0 (email);
					}
				}
				__g_list_free__g_object_unref0_0 (email_collection);
			}
		}
		_g_object_unref0 (emails);
	}
	if (new_contact) {
		ContactsTypeSet* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp15_ = contacts_typeset_get_general ();
		_tmp16_ = _ ("Enter email address");
		contacts_contact_pane_add_detail_editor (self, _tmp15_, (GeeSet*) self->priv->editing_emails, NULL, "email_addresses", _tmp16_);
	}
	_tmp17_ = persona;
	_tmp18_ = _g_object_ref0 (FOLKS_IS_IM_DETAILS (_tmp17_) ? ((FolksImDetails*) _tmp17_) : NULL);
	im_details = _tmp18_;
	if (im_details != NULL) {
		GeeMultiMap* _tmp19_ = NULL;
		GeeMultiMap* _tmp20_;
		GeeMultiMap* ims;
		GeeSet* _tmp21_ = NULL;
		GeeSet* im_keys;
		gboolean _tmp22_;
		_tmp19_ = folks_im_details_get_im_addresses (im_details);
		_tmp20_ = _g_object_ref0 (_tmp19_);
		ims = _tmp20_;
		_tmp21_ = gee_multi_map_get_keys (ims);
		im_keys = _tmp21_;
		_tmp22_ = gee_collection_get_is_empty ((GeeCollection*) im_keys);
		if (!_tmp22_) {
			{
				GeeIterator* _tmp23_ = NULL;
				GeeIterator* _protocol_it;
				_tmp23_ = gee_iterable_iterator ((GeeIterable*) im_keys);
				_protocol_it = _tmp23_;
				while (TRUE) {
					gboolean _tmp24_;
					gpointer _tmp25_ = NULL;
					gchar* protocol;
					_tmp24_ = gee_iterator_next (_protocol_it);
					if (!_tmp24_) {
						break;
					}
					_tmp25_ = gee_iterator_get (_protocol_it);
					protocol = (gchar*) _tmp25_;
					{
						GeeCollection* _tmp26_ = NULL;
						GeeCollection* _tmp27_;
						GeeIterator* _tmp28_ = NULL;
						GeeIterator* _tmp29_;
						GeeIterator* _id_it;
						_tmp26_ = gee_multi_map_get (ims, protocol);
						_tmp27_ = _tmp26_;
						_tmp28_ = gee_iterable_iterator ((GeeIterable*) _tmp27_);
						_tmp29_ = _tmp28_;
						_g_object_unref0 (_tmp27_);
						_id_it = _tmp29_;
						while (TRUE) {
							gboolean _tmp30_;
							gpointer _tmp31_ = NULL;
							gchar* id;
							const gchar* _tmp32_ = NULL;
							gchar* _tmp33_;
							gchar* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp36_;
							GtkButton* _tmp37_ = NULL;
							GtkButton* button;
							_tmp30_ = gee_iterator_next (_id_it);
							if (!_tmp30_) {
								break;
							}
							_tmp31_ = gee_iterator_get (_id_it);
							id = (gchar*) _tmp31_;
							_tmp32_ = _ ("Chat");
							_tmp33_ = g_strconcat (protocol, "/", NULL);
							_tmp34_ = _tmp33_;
							_tmp35_ = g_strconcat (_tmp34_, id, NULL);
							_tmp36_ = _tmp35_;
							contacts_details_layout_add_label_detail (self->priv->layout, _tmp32_, _tmp36_);
							_g_free0 (_tmp36_);
							_g_free0 (_tmp34_);
							_tmp37_ = contacts_details_layout_add_remove (self->priv->layout, TRUE);
							button = _tmp37_;
							gtk_widget_set_sensitive ((GtkWidget*) button, FALSE);
							_g_object_unref0 (button);
							_g_free0 (id);
						}
						_g_object_unref0 (_id_it);
					}
					_g_free0 (protocol);
				}
				_g_object_unref0 (_protocol_it);
			}
		}
		_g_object_unref0 (im_keys);
		_g_object_unref0 (ims);
	}
	_tmp38_ = persona;
	_tmp39_ = _g_object_ref0 (FOLKS_IS_PHONE_DETAILS (_tmp38_) ? ((FolksPhoneDetails*) _tmp38_) : NULL);
	phone_details = _tmp39_;
	if (phone_details != NULL) {
		GeeSet* _tmp40_ = NULL;
		GeeSet* _tmp41_;
		GeeSet* phone_numbers;
		gboolean _tmp42_;
		_tmp40_ = folks_phone_details_get_phone_numbers (phone_details);
		_tmp41_ = _g_object_ref0 (_tmp40_);
		phone_numbers = _tmp41_;
		_tmp42_ = gee_collection_get_is_empty ((GeeCollection*) phone_numbers);
		if (!_tmp42_) {
			GList* _tmp43_ = NULL;
			_tmp43_ = contacts_contact_sort_fields (phone_numbers);
			{
				GList* p_collection = NULL;
				GList* p_it = NULL;
				p_collection = _tmp43_;
				for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
					FolksFieldDetails* _tmp44_;
					FolksFieldDetails* p = NULL;
					_tmp44_ = _g_object_ref0 ((FolksFieldDetails*) p_it->data);
					p = _tmp44_;
					{
						ContactsTypeSet* _tmp45_ = NULL;
						const gchar* _tmp46_ = NULL;
						_tmp45_ = contacts_typeset_get_phone ();
						_tmp46_ = _ ("Enter phone number");
						contacts_contact_pane_add_detail_editor (self, _tmp45_, (GeeSet*) self->priv->editing_phones, p, "phone_numbers", _tmp46_);
						_g_object_unref0 (p);
					}
				}
				__g_list_free__g_object_unref0_0 (p_collection);
			}
		}
		_g_object_unref0 (phone_numbers);
	}
	if (new_contact) {
		ContactsTypeSet* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		_tmp47_ = contacts_typeset_get_phone ();
		_tmp48_ = _ ("Enter phone number");
		contacts_contact_pane_add_detail_editor (self, _tmp47_, (GeeSet*) self->priv->editing_phones, NULL, "phone_numbers", _tmp48_);
	}
	_tmp49_ = persona;
	_tmp50_ = _g_object_ref0 (FOLKS_IS_POSTAL_ADDRESS_DETAILS (_tmp49_) ? ((FolksPostalAddressDetails*) _tmp49_) : NULL);
	postal_details = _tmp50_;
	if (postal_details != NULL) {
		GeeSet* _tmp51_ = NULL;
		GeeSet* _tmp52_;
		GeeSet* postals;
		gboolean _tmp53_;
		_tmp51_ = folks_postal_address_details_get_postal_addresses (postal_details);
		_tmp52_ = _g_object_ref0 (_tmp51_);
		postals = _tmp52_;
		_tmp53_ = gee_collection_get_is_empty ((GeeCollection*) postals);
		if (!_tmp53_) {
			{
				GeeIterator* _tmp54_ = NULL;
				GeeIterator* _addr_it;
				_tmp54_ = gee_iterable_iterator ((GeeIterable*) postals);
				_addr_it = _tmp54_;
				while (TRUE) {
					gboolean _tmp55_;
					gpointer _tmp56_ = NULL;
					FolksPostalAddress* addr;
					gchar* _tmp57_;
					gchar* type;
					GeeSet* _tmp58_ = NULL;
					GeeSet* _tmp59_;
					GeeSet* types;
					gint _tmp65_;
					gchar** _tmp66_ = NULL;
					gchar** strs;
					gint strs_length1;
					gint _strs_size_;
					GtkButton* _tmp68_ = NULL;
					GtkButton* button;
					_tmp55_ = gee_iterator_next (_addr_it);
					if (!_tmp55_) {
						break;
					}
					_tmp56_ = gee_iterator_get (_addr_it);
					addr = (FolksPostalAddress*) _tmp56_;
					_tmp57_ = g_strdup ("");
					type = _tmp57_;
					_tmp58_ = folks_postal_address_get_types (addr);
					_tmp59_ = _g_object_ref0 (_tmp58_);
					types = _tmp59_;
					if (types != NULL) {
						GeeIterator* _tmp60_ = NULL;
						GeeIterator* i;
						gboolean _tmp61_;
						_tmp60_ = gee_iterable_iterator ((GeeIterable*) types);
						i = _tmp60_;
						_tmp61_ = gee_iterator_next (i);
						if (_tmp61_) {
							gpointer _tmp62_ = NULL;
							gchar* _tmp63_;
							gchar* _tmp64_;
							_tmp62_ = gee_iterator_get (i);
							_tmp63_ = (gchar*) _tmp62_;
							_tmp64_ = g_strconcat (type, _tmp63_, NULL);
							_g_free0 (type);
							type = _tmp64_;
							_g_free0 (_tmp63_);
						}
						_g_object_unref0 (i);
					}
					_tmp66_ = contacts_contact_format_address (addr, &_tmp65_);
					strs = _tmp66_;
					strs_length1 = _tmp65_;
					_strs_size_ = strs_length1;
					contacts_details_layout_add_label (self->priv->layout, type);
					{
						gchar** s_collection = NULL;
						gint s_collection_length1 = 0;
						gint _s_collection_size_ = 0;
						gint s_it;
						s_collection = strs;
						s_collection_length1 = strs_length1;
						for (s_it = 0; s_it < strs_length1; s_it = s_it + 1) {
							gchar* _tmp67_;
							gchar* s = NULL;
							_tmp67_ = g_strdup (s_collection[s_it]);
							s = _tmp67_;
							{
								contacts_details_layout_add_detail (self->priv->layout, s);
								_g_free0 (s);
							}
						}
					}
					_tmp68_ = contacts_details_layout_add_remove (self->priv->layout, TRUE);
					button = _tmp68_;
					gtk_widget_set_sensitive ((GtkWidget*) button, FALSE);
					_g_object_unref0 (button);
					strs = (_vala_array_free (strs, strs_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (types);
					_g_free0 (type);
					_g_object_unref0 (addr);
				}
				_g_object_unref0 (_addr_it);
			}
		}
		_g_object_unref0 (postals);
	}
	_data6_->url_row = NULL;
	_tmp69_ = persona;
	_tmp70_ = _g_object_ref0 (FOLKS_IS_URL_DETAILS (_tmp69_) ? ((FolksUrlDetails*) _tmp69_) : NULL);
	urls_details = _tmp70_;
	if (urls_details != NULL) {
		GeeSet* _tmp71_ = NULL;
		GeeSet* _tmp72_;
		GeeSet* urls;
		gboolean _tmp73_;
		_tmp71_ = folks_url_details_get_urls (urls_details);
		_tmp72_ = _g_object_ref0 (_tmp71_);
		urls = _tmp72_;
		_tmp73_ = gee_collection_get_is_empty ((GeeCollection*) urls);
		if (!_tmp73_) {
			ContactsDetailsLayoutState* _tmp78_ = NULL;
			contacts_details_layout_add_label (self->priv->layout, "Links");
			{
				GeeIterator* _tmp74_ = NULL;
				GeeIterator* _url_details_it;
				_tmp74_ = gee_iterable_iterator ((GeeIterable*) urls);
				_url_details_it = _tmp74_;
				while (TRUE) {
					gboolean _tmp75_;
					gpointer _tmp76_ = NULL;
					FolksFieldDetails* url_details;
					const gchar* _tmp77_ = NULL;
					_tmp75_ = gee_iterator_next (_url_details_it);
					if (!_tmp75_) {
						break;
					}
					_tmp76_ = gee_iterator_get (_url_details_it);
					url_details = (FolksFieldDetails*) _tmp76_;
					_tmp77_ = _ ("Enter phone number");
					contacts_contact_pane_add_detail_editor_no_type (self, (GeeSet*) self->priv->editing_urls, url_details, "urls", _tmp77_);
					_g_object_unref0 (url_details);
				}
				_g_object_unref0 (_url_details_it);
			}
			_tmp78_ = contacts_details_layout_save_state (self->priv->layout);
			_contacts_details_layout_state_free0 (_data6_->url_row);
			_data6_->url_row = _tmp78_;
		}
		_g_object_unref0 (urls);
	}
	_tmp79_ = contacts_details_layout_save_state (self->priv->layout);
	_data6_->end_row = _tmp79_;
	_tmp80_ = folks_persona_get_store (persona);
	_tmp81_ = folks_persona_store_get_is_writeable (_tmp80_);
	if (_tmp81_) {
		const gchar* _tmp82_ = NULL;
		ContactsMenuButton* _tmp83_ = NULL;
		ContactsMenuButton* menu_button;
		GtkMenu* _tmp84_ = NULL;
		GtkMenu* menu;
		const gchar* _tmp85_ = NULL;
		GtkMenuItem* _tmp86_ = NULL;
		GtkMenuItem* _tmp87_;
		const gchar* _tmp88_ = NULL;
		GtkMenuItem* _tmp89_ = NULL;
		GtkMenuItem* _tmp90_;
		const gchar* _tmp91_ = NULL;
		GtkMenuItem* _tmp92_ = NULL;
		GtkMenuItem* _tmp93_;
		contacts_details_layout_add_label (self->priv->layout, "");
		_tmp82_ = _ ("Add detail");
		_tmp83_ = contacts_menu_button_new (_tmp82_);
		menu_button = g_object_ref_sink (_tmp83_);
		gtk_widget_set_hexpand ((GtkWidget*) menu_button, FALSE);
		gtk_widget_set_margin_top ((GtkWidget*) menu_button, 12);
		_tmp84_ = (GtkMenu*) gtk_menu_new ();
		menu = g_object_ref_sink (_tmp84_);
		_tmp85_ = _ ("Email");
		_tmp86_ = contacts_utils_add_menu_item (menu, _tmp85_);
		_tmp87_ = _tmp86_;
		g_signal_connect_data (_tmp87_, "activate", (GCallback) __lambda16__gtk_menu_item_activate, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
		_g_object_unref0 (_tmp87_);
		_tmp88_ = _ ("Phone number");
		_tmp89_ = contacts_utils_add_menu_item (menu, _tmp88_);
		_tmp90_ = _tmp89_;
		g_signal_connect_data (_tmp90_, "activate", (GCallback) __lambda17__gtk_menu_item_activate, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
		_g_object_unref0 (_tmp90_);
		_tmp91_ = _ ("Link");
		_tmp92_ = contacts_utils_add_menu_item (menu, _tmp91_);
		_tmp93_ = _tmp92_;
		g_signal_connect_data (_tmp93_, "activate", (GCallback) __lambda18__gtk_menu_item_activate, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
		_g_object_unref0 (_tmp93_);
		contacts_menu_button_set_menu (menu_button, menu);
		contacts_details_layout_attach_detail (self->priv->layout, (GtkWidget*) menu_button);
		_g_object_unref0 (menu);
		_g_object_unref0 (menu_button);
	}
	gtk_widget_show_all ((GtkWidget*) self->priv->fields_grid);
	_g_object_unref0 (urls_details);
	_g_object_unref0 (postal_details);
	_g_object_unref0 (phone_details);
	_g_object_unref0 (im_details);
	_g_object_unref0 (email_details);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}


static void contacts_contact_pane_display_card (ContactsContactPane* self, ContactsContact* contact) {
	ContactsContactFrame* _tmp0_ = NULL;
	ContactsContactFrame* image_frame;
	GtkGrid* _tmp1_ = NULL;
	GtkGrid* ig;
	GtkGrid* _tmp2_ = NULL;
	GtkGrid* g;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* l;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* nick;
	gboolean _tmp11_ = FALSE;
	GtkWidget* _tmp18_ = NULL;
	GtkWidget* merged_presence;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_tmp0_ = contacts_contact_frame_new (CONTACTS_CONTACT_PANE_PROFILE_SIZE);
	image_frame = g_object_ref_sink (_tmp0_);
	contacts_contact_frame_set_image (image_frame, (FolksAvatarDetails*) contact->individual);
	_tmp1_ = (GtkGrid*) gtk_grid_new ();
	ig = g_object_ref_sink (_tmp1_);
	gtk_container_add ((GtkContainer*) ig, (GtkWidget*) image_frame);
	contacts_details_layout_add_widget_label (self->priv->layout, (GtkWidget*) ig);
	gtk_widget_set_vexpand ((GtkWidget*) self->priv->layout->current_row, FALSE);
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	g = g_object_ref_sink (_tmp2_);
	gtk_container_add ((GtkContainer*) self->priv->layout->current_row, (GtkWidget*) g);
	_tmp3_ = (GtkLabel*) gtk_label_new (NULL);
	l = g_object_ref_sink (_tmp3_);
	_tmp4_ = contacts_contact_get_display_name (contact);
	_tmp5_ = g_strconcat ("<span font='22'><b>", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, "</b></span>", NULL);
	_tmp8_ = _tmp7_;
	gtk_label_set_markup (l, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	gtk_widget_set_hexpand ((GtkWidget*) l, TRUE);
	gtk_widget_set_halign ((GtkWidget*) l, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) l, GTK_ALIGN_START);
	gtk_label_set_ellipsize (l, PANGO_ELLIPSIZE_END);
	g_object_set ((GtkMisc*) l, "xalign", 0.0f, NULL);
	gtk_grid_attach (g, (GtkWidget*) l, 0, 0, 1, 1);
	_tmp9_ = folks_name_details_get_nickname ((FolksNameDetails*) contact->individual);
	_tmp10_ = g_strdup (_tmp9_);
	nick = _tmp10_;
	if (nick != NULL) {
		gint _tmp12_;
		_tmp12_ = strlen (nick);
		_tmp11_ = _tmp12_ > 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GtkLabel* _tmp17_ = NULL;
		_tmp13_ = g_strconcat ("\xE2\x80\x9C", nick, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, "\xE2\x80\x9D", NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = (GtkLabel*) gtk_label_new (_tmp16_);
		_g_object_unref0 (l);
		l = g_object_ref_sink (_tmp17_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		gtk_widget_set_halign ((GtkWidget*) l, GTK_ALIGN_START);
		gtk_widget_set_valign ((GtkWidget*) l, GTK_ALIGN_START);
		gtk_label_set_ellipsize (l, PANGO_ELLIPSIZE_END);
		g_object_set ((GtkMisc*) l, "xalign", 0.0f, NULL);
		gtk_grid_attach (g, (GtkWidget*) l, 0, 1, 1, 1);
	}
	_tmp18_ = contacts_contact_create_merged_presence_widget (contact);
	merged_presence = _tmp18_;
	gtk_widget_set_halign (merged_presence, GTK_ALIGN_START);
	gtk_widget_set_valign (merged_presence, GTK_ALIGN_END);
	gtk_widget_set_vexpand (merged_presence, TRUE);
	gtk_grid_attach (g, merged_presence, 0, 3, 1, 1);
	_g_object_unref0 (merged_presence);
	_g_free0 (nick);
	_g_object_unref0 (l);
	_g_object_unref0 (g);
	_g_object_unref0 (ig);
	_g_object_unref0 (image_frame);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->notes);
		g_slice_free (Block7Data, _data7_);
	}
}


static void _lambda19_ (GObject* obj, GAsyncResult* _result_, Block7Data* _data7_) {
	ContactsContactPane * self;
	GError * _inner_error_ = NULL;
	self = _data7_->self;
	g_return_if_fail (_result_ != NULL);
	{
		FolksPersona* _tmp0_ = NULL;
		FolksPersona* p;
		_tmp0_ = contacts_contact_ensure_writable_persona_finish (self->priv->selected_contact, _result_, &_inner_error_);
		p = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		if (FOLKS_IS_NOTE_DETAILS (p)) {
			FolksPersona* _tmp1_;
			_tmp1_ = p;
			folks_note_details_set_notes (FOLKS_IS_NOTE_DETAILS (_tmp1_) ? ((FolksNoteDetails*) _tmp1_) : NULL, (GeeSet*) _data7_->notes);
		} else {
			g_warning ("contacts-contact-pane.vala:648: Writable store doesn't support notes");
		}
		_g_object_unref0 (p);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("contacts-contact-pane.vala:650: Unable to create writable persona: %s", e->message);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda19_ (source_object, res, self);
	block7_data_unref (self);
}


static void contacts_contact_pane_save_notes (ContactsContactPane* self, GeeHashMultiMap* widgets) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widgets != NULL);
	{
		GeeSet* _tmp0_ = NULL;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_;
		GeeIterator* _persona_it;
		_tmp0_ = gee_multi_map_get_keys ((GeeMultiMap*) widgets);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_persona_it = _tmp3_;
		while (TRUE) {
			Block7Data* _data7_;
			gboolean _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksPersona* persona;
			gboolean modified;
			GeeHashSet* _tmp6_ = NULL;
			_data7_ = g_slice_new0 (Block7Data);
			_data7_->_ref_count_ = 1;
			_data7_->self = g_object_ref (self);
			_tmp4_ = gee_iterator_next (_persona_it);
			if (!_tmp4_) {
				block7_data_unref (_data7_);
				_data7_ = NULL;
				break;
			}
			_tmp5_ = gee_iterator_get (_persona_it);
			persona = (FolksPersona*) _tmp5_;
			modified = FALSE;
			_tmp6_ = gee_hash_set_new (FOLKS_TYPE_NOTE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
			_data7_->notes = _tmp6_;
			{
				GeeCollection* _tmp7_ = NULL;
				GeeCollection* _tmp8_;
				GeeIterator* _tmp9_ = NULL;
				GeeIterator* _tmp10_;
				GeeIterator* _view_it;
				_tmp7_ = gee_multi_map_get ((GeeMultiMap*) widgets, persona);
				_tmp8_ = _tmp7_;
				_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp8_);
				_view_it = _tmp10_;
				while (TRUE) {
					gboolean _tmp11_;
					gpointer _tmp12_ = NULL;
					GtkTextView* view;
					GtkTextBuffer* _tmp13_ = NULL;
					gboolean _tmp14_;
					gconstpointer _tmp15_ = NULL;
					gchar* _tmp16_;
					gchar* uid;
					GtkTextIter start = {0};
					GtkTextIter end = {0};
					GtkTextBuffer* _tmp17_ = NULL;
					GtkTextIter _tmp18_ = {0};
					GtkTextBuffer* _tmp19_ = NULL;
					GtkTextIter _tmp20_ = {0};
					GtkTextBuffer* _tmp21_ = NULL;
					gchar* _tmp22_ = NULL;
					gchar* text;
					gint _tmp23_;
					_tmp11_ = gee_iterator_next (_view_it);
					if (!_tmp11_) {
						break;
					}
					_tmp12_ = gee_iterator_get (_view_it);
					view = (GtkTextView*) _tmp12_;
					_tmp13_ = gtk_text_view_get_buffer (view);
					_tmp14_ = gtk_text_buffer_get_modified (_tmp13_);
					if (_tmp14_) {
						modified = TRUE;
					}
					_tmp15_ = g_object_get_data ((GObject*) view, "uid");
					_tmp16_ = g_strdup ((const gchar*) _tmp15_);
					uid = _tmp16_;
					_tmp17_ = gtk_text_view_get_buffer (view);
					gtk_text_buffer_get_start_iter (_tmp17_, &_tmp18_);
					start = _tmp18_;
					_tmp19_ = gtk_text_view_get_buffer (view);
					gtk_text_buffer_get_end_iter (_tmp19_, &_tmp20_);
					end = _tmp20_;
					_tmp21_ = gtk_text_view_get_buffer (view);
					_tmp22_ = gtk_text_buffer_get_text (_tmp21_, &start, &end, TRUE);
					text = _tmp22_;
					_tmp23_ = strlen (text);
					if (_tmp23_ > 0) {
						FolksNote* _tmp24_ = NULL;
						FolksNote* note;
						_tmp24_ = folks_note_new (text, uid);
						note = _tmp24_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _data7_->notes, note);
						_g_object_unref0 (note);
					}
					_g_free0 (text);
					_g_free0 (uid);
					_g_object_unref0 (view);
				}
				_g_object_unref0 (_view_it);
			}
			if (modified) {
				if (persona == NULL) {
					contacts_contact_ensure_writable_persona (self->priv->selected_contact, __lambda19__gasync_ready_callback, block7_data_ref (_data7_));
				} else {
					FolksPersona* _tmp25_;
					_tmp25_ = persona;
					folks_note_details_set_notes (FOLKS_IS_NOTE_DETAILS (_tmp25_) ? ((FolksNoteDetails*) _tmp25_) : NULL, (GeeSet*) _data7_->notes);
				}
			}
			_g_object_unref0 (persona);
			block7_data_unref (_data7_);
			_data7_ = NULL;
		}
		_g_object_unref0 (_persona_it);
	}
}


static GtkTextView* contacts_contact_pane_add_note (ContactsContactPane* self) {
	GtkTextView* result = NULL;
	GtkTextView* _tmp0_ = NULL;
	GtkTextView* text;
	GtkScrolledWindow* _tmp1_ = NULL;
	GtkScrolledWindow* scrolled;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkTextView*) gtk_text_view_new ();
	text = g_object_ref_sink (_tmp0_);
	gtk_widget_set_hexpand ((GtkWidget*) text, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) text, TRUE);
	_tmp1_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	scrolled = g_object_ref_sink (_tmp1_);
	gtk_scrolled_window_set_shadow_type (scrolled, GTK_SHADOW_OUT);
	gtk_scrolled_window_add_with_viewport (scrolled, (GtkWidget*) text);
	gtk_container_add ((GtkContainer*) self->priv->fields_grid, (GtkWidget*) scrolled);
	result = text;
	_g_object_unref0 (scrolled);
	return result;
}


static void contacts_contact_pane_update_note (ContactsContactPane* self, GtkTextView* text, FolksNote* note) {
	GtkTextBuffer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (note != NULL);
	_tmp0_ = gtk_text_view_get_buffer (text);
	_tmp1_ = folks_note_get_content (note);
	gtk_text_buffer_set_text (_tmp0_, _tmp1_, -1);
	_tmp2_ = gtk_text_view_get_buffer (text);
	gtk_text_buffer_set_modified (_tmp2_, FALSE);
	_tmp3_ = folks_note_get_uid (note);
	_tmp4_ = g_strdup (_tmp3_);
	g_object_set_data_full ((GObject*) text, "uid", _tmp4_, g_free);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->self);
		_g_object_unref0 (_data8_->widgets);
		g_slice_free (Block8Data, _data8_);
	}
}


static void _lambda20_ (Block8Data* _data8_) {
	ContactsContactPane * self;
	self = _data8_->self;
	contacts_contact_pane_save_notes (self, _data8_->widgets);
	g_signal_handler_disconnect ((GObject*) self, _data8_->id);
}


static void __lambda20__contacts_contact_pane_save_data (ContactsContactPane* _sender, gpointer self) {
	_lambda20_ (self);
}


static void contacts_contact_pane_display_notes (ContactsContactPane* self) {
	Block8Data* _data8_;
	GeeHashMultiMap* _tmp0_ = NULL;
	GtkTextView* _tmp1_ = NULL;
	GtkTextView* main_text;
	FolksPersona* _tmp2_ = NULL;
	FolksPersona* writable_persona;
	gboolean _tmp3_ = FALSE;
	gboolean primary_note_seen;
	gulong _tmp20_;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	contacts_contact_pane_set_display_mode (self, CONTACTS_CONTACT_PANE_DISPLAY_MODE_NOTES);
	contacts_contact_pane_display_card (self, self->priv->selected_contact);
	_tmp0_ = gee_hash_multi_map_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, GTK_TYPE_TEXT_VIEW, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL);
	_data8_->widgets = _tmp0_;
	_tmp1_ = contacts_contact_pane_add_note (self);
	main_text = _tmp1_;
	_tmp2_ = contacts_contact_find_writable_persona (self->priv->selected_contact);
	writable_persona = _tmp2_;
	if (writable_persona == NULL) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = FOLKS_IS_NOTE_DETAILS (writable_persona);
	}
	if (_tmp3_) {
		gee_multi_map_set ((GeeMultiMap*) _data8_->widgets, writable_persona, main_text);
	} else {
		g_warning ("contacts-contact-pane.vala:688: Writable store doesn't support notes");
	}
	primary_note_seen = FALSE;
	{
		GeeSet* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _persona_it;
		_tmp4_ = folks_individual_get_personas (self->priv->selected_contact->individual);
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_persona_it = _tmp5_;
		while (TRUE) {
			gboolean _tmp6_;
			gpointer _tmp7_ = NULL;
			FolksPersona* persona;
			FolksPersona* _tmp8_;
			FolksNoteDetails* _tmp9_;
			FolksNoteDetails* notes;
			_tmp6_ = gee_iterator_next (_persona_it);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = gee_iterator_get (_persona_it);
			persona = (FolksPersona*) _tmp7_;
			_tmp8_ = persona;
			_tmp9_ = _g_object_ref0 (FOLKS_IS_NOTE_DETAILS (_tmp8_) ? ((FolksNoteDetails*) _tmp8_) : NULL);
			notes = _tmp9_;
			if (notes == NULL) {
				_g_object_unref0 (notes);
				_g_object_unref0 (persona);
				continue;
			}
			{
				GeeSet* _tmp10_ = NULL;
				GeeIterator* _tmp11_ = NULL;
				GeeIterator* _note_it;
				_tmp10_ = folks_note_details_get_notes (notes);
				_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
				_note_it = _tmp11_;
				while (TRUE) {
					gboolean _tmp12_;
					gpointer _tmp13_ = NULL;
					FolksNote* note;
					gboolean _tmp14_ = FALSE;
					_tmp12_ = gee_iterator_next (_note_it);
					if (!_tmp12_) {
						break;
					}
					_tmp13_ = gee_iterator_get (_note_it);
					note = (FolksNote*) _tmp13_;
					if (persona == writable_persona) {
						_tmp14_ = !primary_note_seen;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						primary_note_seen = TRUE;
						contacts_contact_pane_update_note (self, main_text, note);
					} else {
						FolksPersonaStore* _tmp15_ = NULL;
						gboolean _tmp16_;
						_tmp15_ = folks_persona_get_store (persona);
						_tmp16_ = folks_persona_store_get_is_writeable (_tmp15_);
						if (_tmp16_) {
							GtkTextView* _tmp17_ = NULL;
							GtkTextView* text;
							_tmp17_ = contacts_contact_pane_add_note (self);
							text = _tmp17_;
							contacts_contact_pane_update_note (self, text, note);
							gee_multi_map_set ((GeeMultiMap*) _data8_->widgets, persona, text);
							_g_object_unref0 (text);
						} else {
							const gchar* _tmp18_ = NULL;
							GtkLabel* _tmp19_ = NULL;
							GtkLabel* label;
							_tmp18_ = folks_note_get_content (note);
							_tmp19_ = (GtkLabel*) gtk_label_new (_tmp18_);
							label = g_object_ref_sink (_tmp19_);
							gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
							gtk_container_add ((GtkContainer*) self->priv->fields_grid, (GtkWidget*) label);
							_g_object_unref0 (label);
						}
					}
					_g_object_unref0 (note);
				}
				_g_object_unref0 (_note_it);
			}
			_g_object_unref0 (notes);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	gtk_widget_show_all ((GtkWidget*) self->priv->fields_grid);
	_data8_->id = (gulong) 0;
	_tmp20_ = g_signal_connect_data (self, "save-data", (GCallback) __lambda20__contacts_contact_pane_save_data, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	_data8_->id = _tmp20_;
	_g_object_unref0 (writable_persona);
	_g_object_unref0 (main_text);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_g_object_unref0 (_data9_->self);
		_g_object_unref0 (_data9_->e);
		_g_object_unref0 (_data9_->image_frame);
		_g_object_unref0 (_data9_->contact);
		g_slice_free (Block9Data, _data9_);
	}
}


static gboolean _lambda21_ (GdkEventFocus* ev, Block9Data* _data9_) {
	ContactsContactPane * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean name_set;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	self = _data9_->self;
	_tmp0_ = gtk_entry_get_text (_data9_->e);
	gtk_widget_set_name ((GtkWidget*) self, _tmp0_);
	name_set = FALSE;
	_tmp1_ = gtk_widget_get_name ((GtkWidget*) self);
	_tmp2_ = g_object_get_data ((GObject*) _data9_->e, "original-text");
	if (g_strcmp0 (_tmp1_, (const gchar*) _tmp2_) != 0) {
		{
			GeeSet* _tmp3_ = NULL;
			GeeIterator* _tmp4_ = NULL;
			GeeIterator* _p_it;
			_tmp3_ = folks_individual_get_personas (_data9_->contact->individual);
			_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
			_p_it = _tmp4_;
			while (TRUE) {
				gboolean _tmp5_;
				gpointer _tmp6_ = NULL;
				FolksPersona* p;
				gboolean _tmp7_ = FALSE;
				_tmp5_ = gee_iterator_next (_p_it);
				if (!_tmp5_) {
					break;
				}
				_tmp6_ = gee_iterator_get (_p_it);
				p = (FolksPersona*) _tmp6_;
				if (FOLKS_IS_NAME_DETAILS (p)) {
					FolksPersonaStore* _tmp8_ = NULL;
					gboolean _tmp9_;
					_tmp8_ = folks_persona_get_store (p);
					_tmp9_ = folks_persona_store_get_is_writeable (_tmp8_);
					_tmp7_ = _tmp9_;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					FolksPersona* _tmp10_;
					const gchar* _tmp11_ = NULL;
					_tmp10_ = p;
					_tmp11_ = gtk_widget_get_name ((GtkWidget*) self);
					folks_name_details_set_full_name (FOLKS_IS_NAME_DETAILS (_tmp10_) ? ((FolksNameDetails*) _tmp10_) : NULL, _tmp11_);
					name_set = TRUE;
				}
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_it);
		}
		if (!name_set) {
			g_warning ("contacts-contact-pane.vala:761: Didn't find a writable persona to stor" \
"e the name");
		}
	}
	result = FALSE;
	return result;
}


static gboolean __lambda21__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = _lambda21_ (event, self);
	return result;
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		block9_data_unref (_data10_->_data9_);
		_data10_->_data9_ = NULL;
		_g_object_unref0 (_data10_->p);
		g_slice_free (Block10Data, _data10_);
	}
}


static void _lambda22_ (GtkToggleButton* a_button, Block10Data* _data10_) {
	Block9Data* _data9_;
	ContactsContactPane * self;
	gboolean _tmp0_;
	_data9_ = _data10_->_data9_;
	self = _data9_->self;
	g_return_if_fail (a_button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (a_button);
	if (_tmp0_) {
		contacts_contact_pane_update_edit_details (self, _data9_->image_frame, _data10_->p, FALSE);
	}
}


static void __lambda22__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda22_ (_sender, self);
}


static void contacts_contact_pane_display_edit (ContactsContactPane* self, ContactsContact* contact, FolksPersona* persona, gboolean new_contact) {
	Block9Data* _data9_;
	FolksPersona* _tmp0_;
	ContactsContactFrame* _tmp1_ = NULL;
	GtkGrid* _tmp2_ = NULL;
	GtkGrid* ig;
	GtkGrid* _tmp3_ = NULL;
	GtkGrid* g;
	GtkEntry* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	GtkGrid* _tmp9_ = NULL;
	GtkGrid* personas;
	GtkRadioButton* button;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	g_return_if_fail (persona != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_data9_->contact = _g_object_ref0 (contact);
	_tmp0_ = _g_object_ref0 (persona);
	_g_object_unref0 (self->priv->editing_persona);
	self->priv->editing_persona = _tmp0_;
	contacts_contact_pane_set_display_mode (self, CONTACTS_CONTACT_PANE_DISPLAY_MODE_EDIT);
	_tmp1_ = contacts_contact_frame_new (CONTACTS_CONTACT_PANE_PROFILE_SIZE);
	_data9_->image_frame = g_object_ref_sink (_tmp1_);
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	ig = g_object_ref_sink (_tmp2_);
	gtk_container_add ((GtkContainer*) ig, (GtkWidget*) _data9_->image_frame);
	contacts_details_layout_add_widget_label (self->priv->layout, (GtkWidget*) ig);
	contacts_details_layout_mark_row_stable (self->priv->layout);
	gtk_widget_set_vexpand ((GtkWidget*) self->priv->layout->current_row, FALSE);
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	g = g_object_ref_sink (_tmp3_);
	gtk_container_add ((GtkContainer*) self->priv->layout->current_row, (GtkWidget*) g);
	_tmp4_ = (GtkEntry*) gtk_entry_new ();
	_data9_->e = g_object_ref_sink (_tmp4_);
	_tmp5_ = _ ("Enter name");
	g_object_set ((GObject*) _data9_->e, "placeholder-text", _tmp5_, NULL);
	_tmp6_ = contacts_contact_get_display_name (_data9_->contact);
	_tmp7_ = g_strdup (_tmp6_);
	g_object_set_data_full ((GObject*) _data9_->e, "original-text", _tmp7_, g_free);
	_tmp8_ = contacts_contact_get_display_name (_data9_->contact);
	gtk_entry_set_text (_data9_->e, _tmp8_);
	gtk_widget_set_hexpand ((GtkWidget*) _data9_->e, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _data9_->e, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _data9_->e, GTK_ALIGN_START);
	gtk_grid_attach (g, (GtkWidget*) _data9_->e, 0, 0, 1, 1);
	if (new_contact) {
		gtk_widget_grab_focus ((GtkWidget*) _data9_->e);
	}
	g_signal_connect_data ((GtkWidget*) _data9_->e, "focus-out-event", (GCallback) __lambda21__gtk_widget_focus_out_event, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp9_ = (GtkGrid*) gtk_grid_new ();
	personas = g_object_ref_sink (_tmp9_);
	gtk_grid_set_row_spacing (personas, (guint) 4);
	gtk_widget_set_halign ((GtkWidget*) personas, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) personas, GTK_ALIGN_END);
	gtk_widget_set_vexpand ((GtkWidget*) personas, TRUE);
	button = NULL;
	{
		GeeSet* _tmp10_ = NULL;
		GeeIterator* _tmp11_ = NULL;
		GeeIterator* _p_it;
		_tmp10_ = folks_individual_get_personas (_data9_->contact->individual);
		_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
		_p_it = _tmp11_;
		while (TRUE) {
			Block10Data* _data10_;
			gboolean _tmp12_;
			gpointer _tmp13_ = NULL;
			GtkRadioButton* _tmp14_ = NULL;
			GtkStyleContext* _tmp15_ = NULL;
			FolksPersona* _tmp16_;
			GtkWidget* _tmp17_ = NULL;
			GtkWidget* image;
			_data10_ = g_slice_new0 (Block10Data);
			_data10_->_ref_count_ = 1;
			_data10_->_data9_ = block9_data_ref (_data9_);
			_tmp12_ = gee_iterator_next (_p_it);
			if (!_tmp12_) {
				block10_data_unref (_data10_);
				_data10_ = NULL;
				break;
			}
			_tmp13_ = gee_iterator_get (_p_it);
			_data10_->p = (FolksPersona*) _tmp13_;
			_tmp14_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (button);
			_g_object_unref0 (button);
			button = g_object_ref_sink (_tmp14_);
			_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) button);
			gtk_style_context_add_class (_tmp15_, "contact-button");
			gtk_widget_set_can_default ((GtkWidget*) button, FALSE);
			_tmp16_ = _data10_->p;
			_tmp17_ = contacts_contact_pane_create_image (self, FOLKS_IS_AVATAR_DETAILS (_tmp16_) ? ((FolksAvatarDetails*) _tmp16_) : NULL, 48);
			image = _tmp17_;
			gtk_container_add ((GtkContainer*) button, image);
			gtk_toggle_button_set_mode ((GtkToggleButton*) button, FALSE);
			gtk_container_add ((GtkContainer*) personas, (GtkWidget*) button);
			if (_data10_->p == persona) {
				gtk_toggle_button_set_active ((GtkToggleButton*) button, TRUE);
			}
			g_signal_connect_data ((GtkToggleButton*) button, "toggled", (GCallback) __lambda22__gtk_toggle_button_toggled, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
			_g_object_unref0 (image);
			block10_data_unref (_data10_);
			_data10_ = NULL;
		}
		_g_object_unref0 (_p_it);
	}
	contacts_contact_pane_update_edit_details (self, _data9_->image_frame, persona, new_contact);
	gtk_grid_attach (g, (GtkWidget*) personas, 0, 3, 1, 1);
	gtk_widget_show_all ((GtkWidget*) self->priv->fields_grid);
	_g_object_unref0 (button);
	_g_object_unref0 (personas);
	_g_object_unref0 (g);
	_g_object_unref0 (ig);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->self);
		_g_object_unref0 (_data11_->contact);
		g_slice_free (Block11Data, _data11_);
	}
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		block11_data_unref (_data12_->_data11_);
		_data12_->_data11_ = NULL;
		_g_free0 (_data12_->email_addr);
		g_slice_free (Block12Data, _data12_);
	}
}


static void _lambda23_ (Block12Data* _data12_) {
	Block11Data* _data11_;
	ContactsContactPane * self;
	_data11_ = _data12_->_data11_;
	self = _data11_->self;
	contacts_utils_compose_mail (_data12_->email_addr);
}


static void __lambda23__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda23_ (self);
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		block11_data_unref (_data13_->_data11_);
		_data13_->_data11_ = NULL;
		_g_free0 (_data13_->protocol);
		g_slice_free (Block13Data, _data13_);
	}
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (Block14Data* _data14_) {
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		block13_data_unref (_data14_->_data13_);
		_data14_->_data13_ = NULL;
		_g_free0 (_data14_->id);
		g_slice_free (Block14Data, _data14_);
	}
}


static void _lambda24_ (Block14Data* _data14_) {
	Block13Data* _data13_;
	Block11Data* _data11_;
	ContactsContactPane * self;
	_data13_ = _data14_->_data13_;
	_data11_ = _data13_->_data11_;
	self = _data11_->self;
	contacts_utils_start_chat (_data11_->contact, _data13_->protocol, _data14_->id);
}


static void __lambda24__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda24_ (self);
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (Block15Data* _data15_) {
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		block11_data_unref (_data15_->_data11_);
		_data15_->_data11_ = NULL;
		_g_object_unref0 (_data15_->button);
		_g_object_unref0 (_data15_->addr);
		g_slice_free (Block15Data, _data15_);
	}
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (Block16Data* _data16_) {
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		block15_data_unref (_data16_->_data15_);
		_data16_->_data15_ = NULL;
		_g_object_unref0 (_data16_->notification);
		g_slice_free (Block16Data, _data16_);
	}
}


static gboolean _lambda26_ (Block16Data* _data16_) {
	Block15Data* _data15_;
	Block11Data* _data11_;
	ContactsContactPane * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	_data15_ = _data16_->_data15_;
	_data11_ = _data15_->_data11_;
	self = _data11_->self;
	{
		notify_notification_close (_data16_->notification, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gboolean __lambda26__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda26_ (self);
	return result;
}


static void _lambda25_ (Block15Data* _data15_) {
	Block11Data* _data11_;
	ContactsContactPane * self;
	Block16Data* _data16_;
	gchar* _tmp0_;
	gchar* addr_s;
	gint _tmp1_;
	gchar** _tmp2_ = NULL;
	GdkScreen* _tmp7_ = NULL;
	GdkDisplay* _tmp8_ = NULL;
	GtkClipboard* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	NotifyNotification* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	_data11_ = _data15_->_data11_;
	self = _data11_->self;
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->_data15_ = block15_data_ref (_data15_);
	_tmp0_ = g_strdup ("");
	addr_s = _tmp0_;
	_tmp2_ = contacts_contact_format_address (_data15_->addr, &_tmp1_);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it;
		s_collection = _tmp2_;
		s_collection_length1 = _tmp1_;
		for (s_it = 0; s_it < _tmp1_; s_it = s_it + 1) {
			gchar* _tmp3_;
			gchar* s = NULL;
			_tmp3_ = g_strdup (s_collection[s_it]);
			s = _tmp3_;
			{
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp4_ = g_strconcat (s, "\n", NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (addr_s, _tmp5_, NULL);
				_g_free0 (addr_s);
				addr_s = _tmp6_;
				_g_free0 (_tmp5_);
				_g_free0 (s);
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp7_ = gtk_widget_get_screen ((GtkWidget*) _data15_->button);
	_tmp8_ = gdk_screen_get_display (_tmp7_);
	_tmp9_ = gtk_clipboard_get_for_display (_tmp8_, GDK_SELECTION_CLIPBOARD);
	gtk_clipboard_set_text (_tmp9_, addr_s, -1);
	_tmp10_ = _ ("Address copied to clipboard");
	_tmp11_ = notify_notification_new (_tmp10_, NULL, "edit-copy");
	_data16_->notification = _tmp11_;
	notify_notification_set_timeout (_data16_->notification, 3000);
	notify_notification_set_urgency (_data16_->notification, NOTIFY_URGENCY_CRITICAL);
	{
		notify_notification_show (_data16_->notification, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 3000, __lambda26__gsource_func, block16_data_ref (_data16_), block16_data_unref);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (addr_s);
		block16_data_unref (_data16_);
		_data16_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (addr_s);
	block16_data_unref (_data16_);
	_data16_ = NULL;
}


static void __lambda25__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda25_ (self);
}


static void contacts_contact_pane_display_contact (ContactsContactPane* self, ContactsContact* contact) {
	Block11Data* _data11_;
	GeeSet* _tmp0_ = NULL;
	gboolean _tmp1_;
	GeeSet* _tmp2_ = NULL;
	GeeSet* _tmp3_;
	GeeSet* emails;
	gboolean _tmp4_;
	GeeMultiMap* _tmp13_ = NULL;
	GeeMultiMap* _tmp14_;
	GeeMultiMap* ims;
	GeeSet* _tmp15_ = NULL;
	GeeSet* im_keys;
	gboolean _tmp16_;
	GeeSet* _tmp31_ = NULL;
	GeeSet* _tmp32_;
	GeeSet* phone_numbers;
	gboolean _tmp33_;
	GeeSet* _tmp39_ = NULL;
	GeeSet* _tmp40_;
	GeeSet* postals;
	gboolean _tmp41_;
	GeeSet* _tmp57_ = NULL;
	GeeSet* _tmp58_;
	GeeSet* urls;
	gboolean _tmp59_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_data11_->contact = _g_object_ref0 (contact);
	contacts_contact_pane_set_display_mode (self, CONTACTS_CONTACT_PANE_DISPLAY_MODE_DETAILS);
	_tmp0_ = folks_note_details_get_notes ((FolksNoteDetails*) _data11_->contact->individual);
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	contacts_contact_pane_set_has_notes (self, !_tmp1_);
	contacts_contact_pane_display_card (self, _data11_->contact);
	_tmp2_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _data11_->contact->individual);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	emails = _tmp3_;
	_tmp4_ = gee_collection_get_is_empty ((GeeCollection*) emails);
	if (!_tmp4_) {
		GList* _tmp5_ = NULL;
		_tmp5_ = contacts_contact_sort_fields (emails);
		{
			GList* email_collection = NULL;
			GList* email_it = NULL;
			email_collection = _tmp5_;
			for (email_it = email_collection; email_it != NULL; email_it = email_it->next) {
				FolksFieldDetails* _tmp6_;
				FolksFieldDetails* email = NULL;
				_tmp6_ = _g_object_ref0 ((FolksFieldDetails*) email_it->data);
				email = _tmp6_;
				{
					Block12Data* _data12_;
					ContactsTypeSet* _tmp7_ = NULL;
					gchar* _tmp8_ = NULL;
					gchar* type;
					const gchar* _tmp9_ = NULL;
					GtkButton* _tmp10_ = NULL;
					GtkButton* button;
					const gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					_data12_ = g_slice_new0 (Block12Data);
					_data12_->_ref_count_ = 1;
					_data12_->_data11_ = block11_data_ref (_data11_);
					_tmp7_ = contacts_typeset_get_general ();
					_tmp8_ = contacts_typeset_format_type (_tmp7_, email);
					type = _tmp8_;
					_tmp9_ = folks_field_details_get_value (email);
					contacts_details_layout_add_label_detail (self->priv->layout, type, _tmp9_);
					_tmp10_ = contacts_details_layout_add_button (self->priv->layout, "mail-unread-symbolic", TRUE);
					button = _tmp10_;
					_tmp11_ = folks_field_details_get_value (email);
					_tmp12_ = g_strdup (_tmp11_);
					_data12_->email_addr = _tmp12_;
					g_signal_connect_data (button, "clicked", (GCallback) __lambda23__gtk_button_clicked, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
					_g_object_unref0 (button);
					_g_free0 (type);
					_g_object_unref0 (email);
					block12_data_unref (_data12_);
					_data12_ = NULL;
				}
			}
			__g_list_free__g_object_unref0_0 (email_collection);
		}
	}
	_tmp13_ = folks_im_details_get_im_addresses ((FolksImDetails*) _data11_->contact->individual);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	ims = _tmp14_;
	_tmp15_ = gee_multi_map_get_keys (ims);
	im_keys = _tmp15_;
	_tmp16_ = gee_collection_get_is_empty ((GeeCollection*) im_keys);
	if (!_tmp16_) {
		{
			GeeIterator* _tmp17_ = NULL;
			GeeIterator* _protocol_it;
			_tmp17_ = gee_iterable_iterator ((GeeIterable*) im_keys);
			_protocol_it = _tmp17_;
			while (TRUE) {
				Block13Data* _data13_;
				gboolean _tmp18_;
				gpointer _tmp19_ = NULL;
				_data13_ = g_slice_new0 (Block13Data);
				_data13_->_ref_count_ = 1;
				_data13_->_data11_ = block11_data_ref (_data11_);
				_tmp18_ = gee_iterator_next (_protocol_it);
				if (!_tmp18_) {
					block13_data_unref (_data13_);
					_data13_ = NULL;
					break;
				}
				_tmp19_ = gee_iterator_get (_protocol_it);
				_data13_->protocol = (gchar*) _tmp19_;
				{
					GeeCollection* _tmp20_ = NULL;
					GeeCollection* _tmp21_;
					GeeIterator* _tmp22_ = NULL;
					GeeIterator* _tmp23_;
					GeeIterator* _id_it;
					_tmp20_ = gee_multi_map_get (ims, _data13_->protocol);
					_tmp21_ = _tmp20_;
					_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
					_tmp23_ = _tmp22_;
					_g_object_unref0 (_tmp21_);
					_id_it = _tmp23_;
					while (TRUE) {
						Block14Data* _data14_;
						gboolean _tmp24_;
						gpointer _tmp25_ = NULL;
						const gchar* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						gchar* _tmp28_;
						GtkButton* button;
						GtkWidget* _tmp29_ = NULL;
						GtkWidget* presence;
						_data14_ = g_slice_new0 (Block14Data);
						_data14_->_ref_count_ = 1;
						_data14_->_data13_ = block13_data_ref (_data13_);
						_tmp24_ = gee_iterator_next (_id_it);
						if (!_tmp24_) {
							block14_data_unref (_data14_);
							_data14_ = NULL;
							break;
						}
						_tmp25_ = gee_iterator_get (_id_it);
						_data14_->id = (gchar*) _tmp25_;
						_tmp26_ = _ ("Chat");
						_tmp27_ = contacts_contact_format_im_name (_data11_->contact, _data13_->protocol, _data14_->id);
						_tmp28_ = _tmp27_;
						contacts_details_layout_add_label_detail (self->priv->layout, _tmp26_, _tmp28_);
						_g_free0 (_tmp28_);
						button = NULL;
						_tmp29_ = contacts_contact_create_presence_widget (_data11_->contact, _data13_->protocol, _data14_->id);
						presence = _tmp29_;
						if (presence != NULL) {
							GtkButton* _tmp30_ = NULL;
							_tmp30_ = contacts_details_layout_add_button (self->priv->layout, NULL, TRUE);
							_g_object_unref0 (button);
							button = _tmp30_;
							gtk_container_add ((GtkContainer*) button, presence);
						}
						if (button != NULL) {
							g_signal_connect_data (button, "clicked", (GCallback) __lambda24__gtk_button_clicked, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
						}
						_g_object_unref0 (presence);
						_g_object_unref0 (button);
						block14_data_unref (_data14_);
						_data14_ = NULL;
					}
					_g_object_unref0 (_id_it);
				}
				block13_data_unref (_data13_);
				_data13_ = NULL;
			}
			_g_object_unref0 (_protocol_it);
		}
	}
	_tmp31_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) _data11_->contact->individual);
	_tmp32_ = _g_object_ref0 (_tmp31_);
	phone_numbers = _tmp32_;
	_tmp33_ = gee_collection_get_is_empty ((GeeCollection*) phone_numbers);
	if (!_tmp33_) {
		GList* _tmp34_ = NULL;
		_tmp34_ = contacts_contact_sort_fields (phone_numbers);
		{
			GList* p_collection = NULL;
			GList* p_it = NULL;
			p_collection = _tmp34_;
			for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
				FolksFieldDetails* _tmp35_;
				FolksFieldDetails* p = NULL;
				_tmp35_ = _g_object_ref0 ((FolksFieldDetails*) p_it->data);
				p = _tmp35_;
				{
					ContactsTypeSet* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					gchar* type;
					const gchar* _tmp38_ = NULL;
					_tmp36_ = contacts_typeset_get_phone ();
					_tmp37_ = contacts_typeset_format_type (_tmp36_, p);
					type = _tmp37_;
					_tmp38_ = folks_field_details_get_value (p);
					contacts_details_layout_add_label_detail (self->priv->layout, type, _tmp38_);
					_g_free0 (type);
					_g_object_unref0 (p);
				}
			}
			__g_list_free__g_object_unref0_0 (p_collection);
		}
	}
	_tmp39_ = folks_postal_address_details_get_postal_addresses ((FolksPostalAddressDetails*) _data11_->contact->individual);
	_tmp40_ = _g_object_ref0 (_tmp39_);
	postals = _tmp40_;
	_tmp41_ = gee_collection_get_is_empty ((GeeCollection*) postals);
	if (!_tmp41_) {
		{
			GeeIterator* _tmp42_ = NULL;
			GeeIterator* _addr_it;
			_tmp42_ = gee_iterable_iterator ((GeeIterable*) postals);
			_addr_it = _tmp42_;
			while (TRUE) {
				Block15Data* _data15_;
				gboolean _tmp43_;
				gpointer _tmp44_ = NULL;
				gchar* _tmp45_;
				gchar* type;
				GeeSet* _tmp46_ = NULL;
				GeeSet* _tmp47_;
				GeeSet* types;
				gint _tmp53_;
				gchar** _tmp54_ = NULL;
				gchar** strs;
				gint strs_length1;
				gint _strs_size_;
				GtkButton* _tmp56_ = NULL;
				_data15_ = g_slice_new0 (Block15Data);
				_data15_->_ref_count_ = 1;
				_data15_->_data11_ = block11_data_ref (_data11_);
				_tmp43_ = gee_iterator_next (_addr_it);
				if (!_tmp43_) {
					block15_data_unref (_data15_);
					_data15_ = NULL;
					break;
				}
				_tmp44_ = gee_iterator_get (_addr_it);
				_data15_->addr = (FolksPostalAddress*) _tmp44_;
				_tmp45_ = g_strdup ("");
				type = _tmp45_;
				_tmp46_ = folks_postal_address_get_types (_data15_->addr);
				_tmp47_ = _g_object_ref0 (_tmp46_);
				types = _tmp47_;
				if (types != NULL) {
					GeeIterator* _tmp48_ = NULL;
					GeeIterator* i;
					gboolean _tmp49_;
					_tmp48_ = gee_iterable_iterator ((GeeIterable*) types);
					i = _tmp48_;
					_tmp49_ = gee_iterator_next (i);
					if (_tmp49_) {
						gpointer _tmp50_ = NULL;
						gchar* _tmp51_;
						gchar* _tmp52_;
						_tmp50_ = gee_iterator_get (i);
						_tmp51_ = (gchar*) _tmp50_;
						_tmp52_ = g_strconcat (type, _tmp51_, NULL);
						_g_free0 (type);
						type = _tmp52_;
						_g_free0 (_tmp51_);
					}
					_g_object_unref0 (i);
				}
				_tmp54_ = contacts_contact_format_address (_data15_->addr, &_tmp53_);
				strs = _tmp54_;
				strs_length1 = _tmp53_;
				_strs_size_ = strs_length1;
				contacts_details_layout_add_label (self->priv->layout, type);
				if (strs_length1 > 0) {
					{
						gchar** s_collection = NULL;
						gint s_collection_length1 = 0;
						gint _s_collection_size_ = 0;
						gint s_it;
						s_collection = strs;
						s_collection_length1 = strs_length1;
						for (s_it = 0; s_it < strs_length1; s_it = s_it + 1) {
							gchar* _tmp55_;
							gchar* s = NULL;
							_tmp55_ = g_strdup (s_collection[s_it]);
							s = _tmp55_;
							{
								contacts_details_layout_add_detail (self->priv->layout, s);
								_g_free0 (s);
							}
						}
					}
				}
				_tmp56_ = contacts_details_layout_add_button (self->priv->layout, "edit-copy-symbolic", TRUE);
				_data15_->button = _tmp56_;
				g_signal_connect_data (_data15_->button, "clicked", (GCallback) __lambda25__gtk_button_clicked, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
				strs = (_vala_array_free (strs, strs_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (types);
				_g_free0 (type);
				block15_data_unref (_data15_);
				_data15_ = NULL;
			}
			_g_object_unref0 (_addr_it);
		}
	}
	_tmp57_ = folks_url_details_get_urls ((FolksUrlDetails*) _data11_->contact->individual);
	_tmp58_ = _g_object_ref0 (_tmp57_);
	urls = _tmp58_;
	_tmp59_ = gee_collection_get_is_empty ((GeeCollection*) urls);
	if (!_tmp59_) {
		contacts_details_layout_add_label (self->priv->layout, "Links");
		{
			GeeIterator* _tmp60_ = NULL;
			GeeIterator* _url_details_it;
			_tmp60_ = gee_iterable_iterator ((GeeIterable*) urls);
			_url_details_it = _tmp60_;
			while (TRUE) {
				gboolean _tmp61_;
				gpointer _tmp62_ = NULL;
				FolksFieldDetails* url_details;
				const gchar* _tmp63_ = NULL;
				gchar* _tmp64_ = NULL;
				gchar* _tmp65_;
				_tmp61_ = gee_iterator_next (_url_details_it);
				if (!_tmp61_) {
					break;
				}
				_tmp62_ = gee_iterator_get (_url_details_it);
				url_details = (FolksFieldDetails*) _tmp62_;
				_tmp63_ = folks_field_details_get_value (url_details);
				_tmp64_ = contacts_contact_format_uri_link_text (url_details);
				_tmp65_ = _tmp64_;
				contacts_details_layout_add_link (self->priv->layout, _tmp63_, _tmp65_);
				_g_free0 (_tmp65_);
				_g_object_unref0 (url_details);
			}
			_g_object_unref0 (_url_details_it);
		}
	}
	gtk_widget_show_all ((GtkWidget*) self->priv->fields_grid);
	_g_object_unref0 (urls);
	_g_object_unref0 (postals);
	_g_object_unref0 (phone_numbers);
	_g_object_unref0 (im_keys);
	_g_object_unref0 (ims);
	_g_object_unref0 (emails);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}


static void contacts_contact_pane_set_has_notes (ContactsContactPane* self, gboolean has_notes) {
	g_return_if_fail (self != NULL);
	self->priv->has_notes = has_notes;
	gtk_widget_queue_draw (self->priv->notes_dot);
}


static void contacts_contact_pane_selected_contact_changed (ContactsContactPane* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->display_mode == CONTACTS_CONTACT_PANE_DISPLAY_MODE_DETAILS) {
		contacts_contact_pane_display_contact (self, self->priv->selected_contact);
	}
}


static void contacts_contact_pane_set_display_mode (ContactsContactPane* self, ContactsContactPaneDisplayMode mode) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	contacts_details_layout_reset (self->priv->layout, TRUE);
	if (self->priv->display_mode == mode) {
		return;
	}
	self->priv->display_mode = mode;
	if (mode == CONTACTS_CONTACT_PANE_DISPLAY_MODE_EMPTY) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = mode == CONTACTS_CONTACT_PANE_DISPLAY_MODE_DETAILS;
	}
	if (_tmp0_) {
		gtk_widget_show ((GtkWidget*) self->priv->normal_buttons);
		gtk_widget_hide ((GtkWidget*) self->priv->editing_buttons);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->normal_buttons, mode != CONTACTS_CONTACT_PANE_DISPLAY_MODE_EMPTY);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->normal_buttons);
		gtk_widget_show ((GtkWidget*) self->priv->editing_buttons);
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static void _lambda27_ (GObject* obj, GAsyncResult* res, ContactsContactPane* self) {
	GObject* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* store;
	FolksPersona* persona;
	ContactsContact* _tmp8_ = NULL;
	ContactsContact* contact;
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (FOLKS_IS_PERSONA_STORE (_tmp0_) ? ((FolksPersonaStore*) _tmp0_) : NULL);
	store = _tmp1_;
	persona = NULL;
	{
		FolksPersona* _tmp2_ = NULL;
		FolksPersona* _tmp3_;
		_tmp2_ = folks_persona_store_add_persona_from_details_finish (store, res, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_g_object_unref0 (persona);
		persona = _tmp3_;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GtkWidget* _tmp4_ = NULL;
		GtkWidget* _tmp5_;
		const gchar* _tmp6_ = NULL;
		GtkMessageDialog* _tmp7_ = NULL;
		GtkMessageDialog* dialog;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _ ("Unable to create new contacts: %s\n");
		_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new (GTK_IS_WINDOW (_tmp5_) ? ((GtkWindow*) _tmp5_) : NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp6_, e->message);
		dialog = g_object_ref_sink (_tmp7_);
		gtk_widget_show ((GtkWidget*) dialog);
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
		_g_object_unref0 (persona);
		_g_object_unref0 (store);
		return;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (persona);
		_g_object_unref0 (store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = contacts_store_find_contact_with_persona (self->priv->contacts_store, persona);
	contact = _tmp8_;
	if (contact == NULL) {
		GtkWidget* _tmp9_ = NULL;
		GtkWidget* _tmp10_;
		const gchar* _tmp11_ = NULL;
		GtkMessageDialog* _tmp12_ = NULL;
		GtkMessageDialog* dialog;
		_tmp9_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = _ ("Unable to find newly created contact\n");
		_tmp12_ = (GtkMessageDialog*) gtk_message_dialog_new (GTK_IS_WINDOW (_tmp10_) ? ((GtkWindow*) _tmp10_) : NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp11_);
		dialog = g_object_ref_sink (_tmp12_);
		gtk_widget_show ((GtkWidget*) dialog);
		_g_object_unref0 (dialog);
		_g_object_unref0 (contact);
		_g_object_unref0 (persona);
		_g_object_unref0 (store);
		return;
	}
	contacts_contact_pane_show_contact (self, contact, FALSE);
	contacts_contact_pane_display_edit (self, contact, persona, TRUE);
	_g_object_unref0 (contact);
	_g_object_unref0 (persona);
	_g_object_unref0 (store);
}


static void __lambda27__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda27_ (source_object, res, self);
	g_object_unref (self);
}


void contacts_contact_pane_new_contact (ContactsContactPane* self) {
	GHashTable* _tmp0_ = NULL;
	GHashTable* details;
	FolksIndividualAggregator* _tmp1_ = NULL;
	FolksPersonaStore* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	details = _tmp0_;
	_tmp1_ = contacts_store_get_aggregator (self->priv->contacts_store);
	_tmp2_ = folks_individual_aggregator_get_primary_store (_tmp1_);
	folks_persona_store_add_persona_from_details (_tmp2_, details, __lambda27__gasync_ready_callback, g_object_ref (self));
	_g_hash_table_unref0 (details);
}


static void _contacts_contact_pane_selected_contact_changed_contacts_contact_changed (ContactsContact* _sender, gpointer self) {
	contacts_contact_pane_selected_contact_changed (self);
}


void contacts_contact_pane_show_contact (ContactsContactPane* self, ContactsContact* new_contact, gboolean edit) {
	ContactsContact* _tmp1_;
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "save-data");
	if (self->priv->selected_contact != NULL) {
		guint _tmp0_;
		g_signal_parse_name ("changed", CONTACTS_TYPE_CONTACT, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self->priv->selected_contact, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _contacts_contact_pane_selected_contact_changed_contacts_contact_changed, self);
	}
	_tmp1_ = _g_object_ref0 (new_contact);
	_g_object_unref0 (self->priv->selected_contact);
	self->priv->selected_contact = _tmp1_;
	_g_object_unref0 (self->priv->editing_persona);
	self->priv->editing_persona = NULL;
	contacts_contact_pane_set_display_mode (self, CONTACTS_CONTACT_PANE_DISPLAY_MODE_EMPTY);
	contacts_contact_pane_set_has_notes (self, FALSE);
	if (self->priv->selected_contact != NULL) {
		contacts_contact_pane_display_contact (self, self->priv->selected_contact);
		g_signal_connect_object (self->priv->selected_contact, "changed", (GCallback) _contacts_contact_pane_selected_contact_changed_contacts_contact_changed, self, 0);
	}
}


static gpointer _contacts_store_ref0 (gpointer self) {
	return self ? contacts_store_ref (self) : NULL;
}


static gboolean _lambda28_ (GtkWidget* widget, cairo_t* cr, ContactsContactPane* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	if (self->priv->has_notes) {
		GdkRGBA color = {0};
		GtkStyleContext* _tmp0_ = NULL;
		GdkRGBA _tmp1_ = {0};
		GdkRGBA _tmp2_ = {0};
		cairo_arc (cr, (gdouble) 3, (gdouble) (3 + 2), (gdouble) 3, (gdouble) 0, 2 * G_PI);
		_tmp0_ = gtk_widget_get_style_context (widget);
		gtk_style_context_get_color (_tmp0_, 0, &_tmp1_);
		_tmp2_ = _tmp1_;
		color = _tmp2_;
		gdk_cairo_set_source_rgba (cr, &color);
		cairo_fill (cr);
	}
	result = TRUE;
	return result;
}


static gboolean __lambda28__gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = _lambda28_ (_sender, cr, self);
	return result;
}


static void _lambda29_ (GtkButton* button, ContactsContactPane* self) {
	g_return_if_fail (button != NULL);
	contacts_contact_pane_display_notes (self);
}


static void __lambda29__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda29_ (_sender, self);
}


static void _lambda30_ (GtkButton* button, ContactsContactPane* self) {
	FolksPersona* persona;
	GeeSet* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
	GeeIterator* i;
	gboolean _tmp2_;
	g_return_if_fail (button != NULL);
	persona = NULL;
	_tmp0_ = folks_individual_get_personas (self->priv->selected_contact->individual);
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	i = _tmp1_;
	_tmp2_ = gee_iterator_next (i);
	if (_tmp2_) {
		gpointer _tmp3_ = NULL;
		_tmp3_ = gee_iterator_get (i);
		_g_object_unref0 (persona);
		persona = (FolksPersona*) _tmp3_;
	}
	contacts_contact_pane_display_edit (self, self->priv->selected_contact, persona, FALSE);
	_g_object_unref0 (i);
	_g_object_unref0 (persona);
}


static void __lambda30__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda30_ (_sender, self);
}


static void _lambda31_ (GtkButton* button, ContactsContactPane* self) {
	g_return_if_fail (button != NULL);
	g_signal_emit_by_name (self, "save-data");
	contacts_contact_pane_display_contact (self, self->priv->selected_contact);
}


static void __lambda31__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda31_ (_sender, self);
}


ContactsContactPane* contacts_contact_pane_construct (GType object_type, ContactsStore* contacts_store) {
	ContactsContactPane * self = NULL;
	ContactsStore* _tmp0_;
	GtkStyleContext* _tmp1_ = NULL;
	GtkGrid* _tmp2_ = NULL;
	GtkGrid* grid;
	GtkScrolledWindow* _tmp3_ = NULL;
	GtkScrolledWindow* fields_scrolled;
	GtkGrid* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	ContactsDetailsLayout* _tmp7_ = NULL;
	GtkButtonBox* _tmp8_ = NULL;
	GtkButtonBox* bbox;
	GtkButtonBox* _tmp9_;
	GtkButton* _tmp10_ = NULL;
	GtkButton* notes_button;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* notes_grid;
	const gchar* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* label;
	GtkDrawingArea* _tmp14_ = NULL;
	GtkDrawingArea* a;
	GtkDrawingArea* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
	GtkButton* button;
	const gchar* _tmp18_ = NULL;
	ContactsMenuButton* _tmp19_ = NULL;
	ContactsMenuButton* menu_button;
	GtkButtonBox* _tmp20_ = NULL;
	GtkButtonBox* _tmp21_;
	GtkButton* _tmp22_ = NULL;
	GtkMenu* _tmp23_ = NULL;
	GtkMenu* menu;
	const gchar* _tmp24_ = NULL;
	GtkMenuItem* _tmp25_ = NULL;
	GtkMenuItem* _tmp26_;
	const gchar* _tmp27_ = NULL;
	GtkMenuItem* _tmp28_ = NULL;
	GtkMenuItem* _tmp29_;
	const gchar* _tmp30_ = NULL;
	GtkMenuItem* _tmp31_ = NULL;
	GtkMenuItem* _tmp32_;
	g_return_val_if_fail (contacts_store != NULL, NULL);
	self = (ContactsContactPane*) g_object_new (object_type, NULL);
	_tmp0_ = _contacts_store_ref0 (contacts_store);
	_contacts_store_unref0 (self->priv->contacts_store);
	self->priv->contacts_store = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "contact-pane");
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	grid = g_object_ref_sink (_tmp2_);
	gtk_container_set_border_width ((GtkContainer*) grid, (guint) 10);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	_tmp3_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	fields_scrolled = g_object_ref_sink (_tmp3_);
	gtk_widget_set_hexpand ((GtkWidget*) fields_scrolled, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) fields_scrolled, TRUE);
	gtk_scrolled_window_set_policy (fields_scrolled, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp4_ = (GtkGrid*) gtk_grid_new ();
	_g_object_unref0 (self->priv->fields_grid);
	self->priv->fields_grid = g_object_ref_sink (_tmp4_);
	gtk_grid_set_column_spacing (self->priv->fields_grid, (guint) 3);
	gtk_orientable_set_orientation ((GtkOrientable*) self->priv->fields_grid, GTK_ORIENTATION_VERTICAL);
	gtk_scrolled_window_add_with_viewport (fields_scrolled, (GtkWidget*) self->priv->fields_grid);
	_tmp5_ = gtk_bin_get_child ((GtkBin*) fields_scrolled);
	_tmp6_ = gtk_widget_get_style_context (_tmp5_);
	gtk_style_context_add_class (_tmp6_, "contact-pane");
	_tmp7_ = contacts_details_layout_new (self->priv->fields_grid);
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp7_;
	gtk_grid_attach (grid, (GtkWidget*) fields_scrolled, 0, 1, 1, 1);
	_tmp8_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	bbox = g_object_ref_sink (_tmp8_);
	_tmp9_ = _g_object_ref0 (bbox);
	_g_object_unref0 (self->priv->normal_buttons);
	self->priv->normal_buttons = _tmp9_;
	gtk_box_set_spacing ((GtkBox*) bbox, 5);
	gtk_widget_set_margin_top ((GtkWidget*) bbox, 8);
	gtk_button_box_set_layout (bbox, GTK_BUTTONBOX_START);
	gtk_grid_attach (grid, (GtkWidget*) bbox, 0, 2, 1, 1);
	_tmp10_ = (GtkButton*) gtk_button_new ();
	notes_button = g_object_ref_sink (_tmp10_);
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
	notes_grid = g_object_ref_sink (_tmp11_);
	_tmp12_ = _ ("Notes");
	_tmp13_ = (GtkLabel*) gtk_label_new (_tmp12_);
	label = g_object_ref_sink (_tmp13_);
	gtk_widget_set_hexpand ((GtkWidget*) label, TRUE);
	_tmp14_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	a = g_object_ref_sink (_tmp14_);
	gtk_widget_set_size_request ((GtkWidget*) a, 6, -1);
	gtk_widget_set_has_window ((GtkWidget*) a, FALSE);
	gtk_container_add ((GtkContainer*) notes_grid, (GtkWidget*) a);
	gtk_container_add ((GtkContainer*) notes_grid, (GtkWidget*) label);
	_tmp15_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	_g_object_unref0 (self->priv->notes_dot);
	self->priv->notes_dot = (GtkWidget*) g_object_ref_sink (_tmp15_);
	gtk_widget_set_has_window (self->priv->notes_dot, FALSE);
	gtk_widget_set_size_request (self->priv->notes_dot, 6, -1);
	g_signal_connect_object (self->priv->notes_dot, "draw", (GCallback) __lambda28__gtk_widget_draw, self, 0);
	gtk_container_add ((GtkContainer*) notes_grid, self->priv->notes_dot);
	gtk_container_add ((GtkContainer*) notes_button, (GtkWidget*) notes_grid);
	g_signal_connect_object (notes_button, "clicked", (GCallback) __lambda29__gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) notes_button, FALSE, FALSE, (guint) 0);
	_tmp16_ = _ ("Edit");
	_tmp17_ = (GtkButton*) gtk_button_new_with_label (_tmp16_);
	button = g_object_ref_sink (_tmp17_);
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
	g_signal_connect_object (button, "clicked", (GCallback) __lambda30__gtk_button_clicked, self, 0);
	_tmp18_ = _ ("More");
	_tmp19_ = contacts_menu_button_new (_tmp18_);
	menu_button = g_object_ref_sink (_tmp19_);
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) menu_button, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) bbox);
	gtk_widget_set_no_show_all ((GtkWidget*) bbox, TRUE);
	_tmp20_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	_g_object_unref0 (bbox);
	bbox = g_object_ref_sink (_tmp20_);
	_tmp21_ = _g_object_ref0 (bbox);
	_g_object_unref0 (self->priv->editing_buttons);
	self->priv->editing_buttons = _tmp21_;
	gtk_box_set_spacing ((GtkBox*) bbox, 5);
	gtk_widget_set_margin_top ((GtkWidget*) bbox, 8);
	gtk_button_box_set_layout (bbox, GTK_BUTTONBOX_END);
	gtk_grid_attach (grid, (GtkWidget*) bbox, 0, 3, 1, 1);
	_tmp22_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_CLOSE);
	_g_object_unref0 (button);
	button = g_object_ref_sink (_tmp22_);
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
	g_signal_connect_object (button, "clicked", (GCallback) __lambda31__gtk_button_clicked, self, 0);
	_tmp23_ = (GtkMenu*) gtk_menu_new ();
	menu = g_object_ref_sink (_tmp23_);
	_tmp24_ = _ ("Add/Remove Linked Contacts...");
	_tmp25_ = contacts_utils_add_menu_item (menu, _tmp24_);
	_tmp26_ = _tmp25_;
	_g_object_unref0 (_tmp26_);
	_tmp27_ = _ ("Send...");
	_tmp28_ = contacts_utils_add_menu_item (menu, _tmp27_);
	_tmp29_ = _tmp28_;
	_g_object_unref0 (_tmp29_);
	_tmp30_ = _ ("Delete");
	_tmp31_ = contacts_utils_add_menu_item (menu, _tmp30_);
	_tmp32_ = _tmp31_;
	_g_object_unref0 (_tmp32_);
	contacts_menu_button_set_menu (menu_button, menu);
	gtk_widget_show_all ((GtkWidget*) bbox);
	gtk_widget_set_no_show_all ((GtkWidget*) bbox, TRUE);
	gtk_widget_show_all ((GtkWidget*) grid);
	contacts_contact_pane_set_display_mode (self, CONTACTS_CONTACT_PANE_DISPLAY_MODE_EMPTY);
	contacts_contact_pane_set_has_notes (self, FALSE);
	_g_object_unref0 (menu);
	_g_object_unref0 (menu_button);
	_g_object_unref0 (button);
	_g_object_unref0 (a);
	_g_object_unref0 (label);
	_g_object_unref0 (notes_grid);
	_g_object_unref0 (notes_button);
	_g_object_unref0 (bbox);
	_g_object_unref0 (fields_scrolled);
	_g_object_unref0 (grid);
	return self;
}


ContactsContactPane* contacts_contact_pane_new (ContactsStore* contacts_store) {
	return contacts_contact_pane_construct (CONTACTS_TYPE_CONTACT_PANE, contacts_store);
}


static void contacts_contact_pane_class_init (ContactsContactPaneClass * klass) {
	contacts_contact_pane_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsContactPanePrivate));
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_pane_finalize;
	g_signal_new ("save_data", CONTACTS_TYPE_CONTACT_PANE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void contacts_contact_pane_instance_init (ContactsContactPane * self) {
	self->priv = CONTACTS_CONTACT_PANE_GET_PRIVATE (self);
}


static void contacts_contact_pane_finalize (GObject* obj) {
	ContactsContactPane * self;
	self = CONTACTS_CONTACT_PANE (obj);
	_contacts_store_unref0 (self->priv->contacts_store);
	_g_object_unref0 (self->priv->selected_contact);
	_g_object_unref0 (self->priv->editing_persona);
	_g_object_unref0 (self->priv->fields_grid);
	_g_object_unref0 (self->priv->notes_dot);
	_g_object_unref0 (self->priv->normal_buttons);
	_g_object_unref0 (self->priv->editing_buttons);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->editing_emails);
	_g_object_unref0 (self->priv->editing_phones);
	_g_object_unref0 (self->priv->editing_urls);
	G_OBJECT_CLASS (contacts_contact_pane_parent_class)->finalize (obj);
}


GType contacts_contact_pane_get_type (void) {
	static volatile gsize contacts_contact_pane_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_pane_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsContactPaneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_pane_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactPane), 0, (GInstanceInitFunc) contacts_contact_pane_instance_init, NULL };
		GType contacts_contact_pane_type_id;
		contacts_contact_pane_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "ContactsContactPane", &g_define_type_info, 0);
		g_once_init_leave (&contacts_contact_pane_type_id__volatile, contacts_contact_pane_type_id);
	}
	return contacts_contact_pane_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



