/*****************************************************************
 * Parallel port probing (currently linux only)                  *
 * (c) 1999 by Bernhard Rosenkraenzer <bero@redhat.com>          *
 * Parts taken from Tim Waugh <twaugh@redhat.com>'s deviceid     *
 * $Id: parport.c,v 1.1.1.1 2002/11/05 20:43:59 dave Exp $        *
 ****************************************************************/

#include "parport.h"
#include <ctype.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#ifdef linux
/* The following includes are needed for parport probing... */
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <unistd.h>
#include "ppdev.h"
#endif

/*----------------------------------------------------------------
  Trim white space from front and back.
----------------------------------------------------------------*/
char *trim (char *str1) {

  char *str2 = NULL;
  char *p = NULL;
  int len, i;

  if (str1 == NULL) return NULL;

  str2 = (char *) malloc (strlen(str1)+1);
  
  p = str1;
  while (p && (p[0] == ' '))
    p++;

  if (p) {
    strcpy (str2, p);

    len = strlen (str2);
    for (i=len-1; (i >= 0) && (str2[i] == ' '); i--) 
      str2[i] = 0;
  }

  return str2;
}



/* parse_probe_output: Parse output in IEEE-1284 format.
 * Not useful anywhere outside parport.c, therefore not included
 * in the header or docs.
 * input: output of probe_parport and two strings to look for
 * (Linux 2.2 used different identifiers than >= 2.3)           */
char *parse_probe_output(char *output, char *txt1, char *txt2)
{
  char *result=NULL, *result_t, *tmp;
  if(output==NULL) return NULL;
  tmp=(char *) malloc(strlen(txt1)+3);
  sprintf(tmp, "%s:", txt1);
  if(!strncmp(output, tmp, strlen(tmp))) {
    result=strdup(output+strlen(tmp));
  } else {
    sprintf(tmp, ";%s:", txt1);
    if(strstr(output, tmp))
      result=strdup(strstr(output, tmp)+strlen(tmp));
    else {
      sprintf(tmp, "\n%s:", txt1);
      if(strstr(output, tmp))
	result=strdup(strstr(output, tmp)+strlen(tmp));
    }
  }
  if(!result) {
    free(tmp); tmp=(char *) malloc(strlen(txt2)+3);
    sprintf(tmp, "%s:", txt2);
    if(!strncmp(output, tmp, strlen(tmp))) {
      result=strdup(output+strlen(tmp));
    } else {
      sprintf(tmp, ";%s:", txt2);
      if(strstr(output, tmp))
	result=strdup(strstr(output, tmp)+strlen(tmp));
      else {
	sprintf(tmp, "\n%s:", txt2);
	if(strstr(output, tmp))
	  result=strdup(strstr(output, tmp)+strlen(tmp));
      }
    }
  }
  if(result) {
    if(strchr(result, ';'))
      *strchr(result, ';')=0;
    if(strchr(result, '\n'))
      *strchr(result, '\n')=0;
  }
  free(tmp);
  if(!result)
    return NULL;

  /* Modified by pruett (uses local trim() function 
     instead of rhcl_trim() ) */
  result_t = trim(result);
  free(result);
  return result_t;
}

char *parport_probe_manufacturer(int port)
{
  return parse_probe_output(probe_parport(port), "MFG", "MANUFACTURER");
}

char *parport_probe_model(int port)
{
  return parse_probe_output(probe_parport(port), "MDL", "MODEL");
}

char *parport_probe_cmdset(int port)
{
  return parse_probe_output(probe_parport(port), "CMD", "COMMAND SET");
}

char *parport_probe_description(int port)
{
  return parse_probe_output(probe_parport(port), "DES", "DESCRIPTION");
}

char *parport_probe_class(int port)
{
  return parse_probe_output(probe_parport(port), "CLS", "CLASS");
}

#ifdef linux
char *probe_parport(int port)
{
  FILE *f;
  char *ret;
  char *cur;
  char portname[60];
  
  sprintf(portname, "/proc/parport/%u/autoprobe", port);
  f=fopen(portname, "r"); /* ITS4: ignore */
  if(f==NULL) { /* Ok, this is Linux >2.2.x... */
    sprintf(portname, "/proc/sys/dev/parport/parport%u/autoprobe", port);
    f=fopen(portname, "r"); /* ITS4: ignore */
    if(f==NULL)/* IEEE-1284 autoprobing not supported by OS */
      return NULL;
  }

  /* Unfortunately, we can't stat() /proc files */
  ret=(char *) malloc(10240);
  memset(ret, 0, 10240);
  cur=ret;
  while(!feof(f))
    *cur++=fgetc(f);
  fclose(f);
  return ret;
}
#else
char *probe_parport(int port)
{
  /* This is currently supported on Linux only. Feel free to 
     reimplement it for your favorite OS and let us have the 
     patch. */
  return NULL;
}
#endif
