/***************************************************************************
 * parport.h - autoprobing of parallel port devices (currently linux only) *
 *                           Red Hat Config Library                        *
 * (c) 1999 by Bernhard Rosenkrnzer <bero@redhat.com>                     *
 * $Id: parport.h,v 1.1.1.1 2002/11/05 20:43:59 dave Exp $                    *
 ***************************************************************************/

#ifndef RHCL_PARPORT_H
#define RHCL_PARPORT_H

#include <string.h>
#include <stdio.h>
#include <unistd.h>

#ifdef __cplusplus
extern "C" {
#endif

/** parport_probe_manufacturer
 * Tries to determine the manufacturer of a parallel port device
 * 
 * @param port Number of parallel port
 * @return manufacturer or NULL if device is not IEEE-1284 compatible.
 */
char *parport_probe_manufacturer(int port);

/** parport_probe_model
 * Tries to determine the model of a parallel port device
 * 
 * @param port Number of parallel port
 * @return model or NULL if device is not IEEE-1284 compatible.
 */
char *parport_probe_model(int port);

/** parport_probe_cmdset
 * Tries to determine the command set of a parallel port device
 * 
 * @param port Number of parallel port
 * @return command set or NULL if device is not IEEE-1284 compatible.
 */
char *parport_probe_cmdset(int port);

/** parport_probe_description
 * Tries to determine the description of a parallel port device
 * 
 * @param port Number of parallel port
 * @return description or NULL if device is not IEEE-1284 compatible.
 */
char *parport_probe_description(int port);

/** parport_probe_class
 * Tries to determine the class of a parallel port device
 * (i.e. PRINTER, SCANNER, ...)
 * 
 * @param port Number of parallel port
 * @return class or NULL if device is not IEEE-1284 compatible.
 */
char *parport_probe_class(int port);

/** probe_parport
 * Return IEEE-1284 information on a parallel port device
 * For internal use (parport_probe_*)
 * 
 * @param port Number of parallel port
 * @return IEEE-1284 information or NULL if device (or OS) is not IEEE-1284
 *         compatible.
 */
char *probe_parport(int port);

#ifdef __cplusplus
}
#endif

#endif
