
#include <src/Channel.h>
#include "src/Schedule.h"




struct _DVBChannelPrivate {
	char* _Name;
	guint _TransportStreamId;
	char* _Network;
	guint* _LogicalChannelNumber;
	guint _VideoPID;
	guint _AudioPID;
	guint _Frequency;
	DVBSchedule* schedule;
	guint sid;
};

#define DVB_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL, DVBChannelPrivate))
enum  {
	DVB_CHANNEL_DUMMY_PROPERTY,
	DVB_CHANNEL_SID,
	DVB_CHANNEL_NAME,
	DVB_CHANNEL_TRANSPORT_STREAM_ID,
	DVB_CHANNEL_NETWORK,
	DVB_CHANNEL_LOGICAL_CHANNEL_NUMBER,
	DVB_CHANNEL_VIDEO_PID,
	DVB_CHANNEL_AUDIO_PID,
	DVB_CHANNEL_FREQUENCY,
	DVB_CHANNEL_SCHEDULE
};
static gboolean dvb_channel_real_is_valid (DVBChannel* self);
static void dvb_channel_real_setup_dvb_source (DVBChannel* self, GstElement* source);
static char* dvb_channel_real_to_string (DVBChannel* self);
static guint* _uint_dup (guint* self);
static gpointer dvb_channel_parent_class = NULL;
static void dvb_channel_finalize (GObject* obj);



static gboolean dvb_channel_real_is_valid (DVBChannel* self) {
	g_return_val_if_fail (DVB_IS_CHANNEL (self), FALSE);
	return (self->priv->_Name != NULL && self->priv->_Frequency != 0 && dvb_channel_get_Sid (self) != 0);
}


gboolean dvb_channel_is_valid (DVBChannel* self) {
	return DVB_CHANNEL_GET_CLASS (self)->is_valid (self);
}


static void dvb_channel_real_setup_dvb_source (DVBChannel* self, GstElement* source) {
	g_return_if_fail (DVB_IS_CHANNEL (self));
	g_critical ("Type `%s' does not implement abstract method `dvb_channel_setup_dvb_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


/**
         * @source: Either dvbbasebin or dvbsrc
         *
         * Set properties of source so that the channel can be watched
         */
void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source) {
	DVB_CHANNEL_GET_CLASS (self)->setup_dvb_source (self, source);
}


static char* dvb_channel_real_to_string (DVBChannel* self) {
	g_return_val_if_fail (DVB_IS_CHANNEL (self), NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_channel_to_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char* dvb_channel_to_string (DVBChannel* self) {
	return DVB_CHANNEL_GET_CLASS (self)->to_string (self);
}


guint dvb_channel_get_Sid (DVBChannel* self) {
	g_return_val_if_fail (DVB_IS_CHANNEL (self), 0U);
	return self->priv->sid;
}


void dvb_channel_set_Sid (DVBChannel* self, guint value) {
	DVBSchedule* _tmp1;
	g_return_if_fail (DVB_IS_CHANNEL (self));
	self->priv->sid = value;
	_tmp1 = NULL;
	self->priv->schedule = (_tmp1 = dvb_schedule_new (self), (self->priv->schedule == NULL ? NULL : (self->priv->schedule = (g_object_unref (self->priv->schedule), NULL))), _tmp1);
	g_object_notify (((GObject *) (self)), "Sid");
}


const char* dvb_channel_get_Name (DVBChannel* self) {
	g_return_val_if_fail (DVB_IS_CHANNEL (self), NULL);
	return self->priv->_Name;
}


void dvb_channel_set_Name (DVBChannel* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (DVB_IS_CHANNEL (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_Name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_Name = (g_free (self->priv->_Name), NULL)), _tmp2);
	g_object_notify (((GObject *) (self)), "Name");
}


guint dvb_channel_get_TransportStreamId (DVBChannel* self) {
	g_return_val_if_fail (DVB_IS_CHANNEL (self), 0U);
	return self->priv->_TransportStreamId;
}


void dvb_channel_set_TransportStreamId (DVBChannel* self, guint value) {
	g_return_if_fail (DVB_IS_CHANNEL (self));
	self->priv->_TransportStreamId = value;
	g_object_notify (((GObject *) (self)), "TransportStreamId");
}


const char* dvb_channel_get_Network (DVBChannel* self) {
	g_return_val_if_fail (DVB_IS_CHANNEL (self), NULL);
	return self->priv->_Network;
}


void dvb_channel_set_Network (DVBChannel* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (DVB_IS_CHANNEL (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_Network = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_Network = (g_free (self->priv->_Network), NULL)), _tmp2);
	g_object_notify (((GObject *) (self)), "Network");
}


guint* dvb_channel_get_LogicalChannelNumber (DVBChannel* self) {
	g_return_val_if_fail (DVB_IS_CHANNEL (self), 0U);
	return self->priv->_LogicalChannelNumber;
}


static guint* _uint_dup (guint* self) {
	return g_memdup (self, sizeof (guint));
}


void dvb_channel_set_LogicalChannelNumber (DVBChannel* self, guint* value) {
	guint* _tmp2;
	guint* _tmp1;
	g_return_if_fail (DVB_IS_CHANNEL (self));
	self->priv->_LogicalChannelNumber = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : _uint_dup (_tmp1))), (self->priv->_LogicalChannelNumber == NULL ? NULL : (self->priv->_LogicalChannelNumber = (g_free (self->priv->_LogicalChannelNumber), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "LogicalChannelNumber");
}


guint dvb_channel_get_VideoPID (DVBChannel* self) {
	g_return_val_if_fail (DVB_IS_CHANNEL (self), 0U);
	return self->priv->_VideoPID;
}


void dvb_channel_set_VideoPID (DVBChannel* self, guint value) {
	g_return_if_fail (DVB_IS_CHANNEL (self));
	self->priv->_VideoPID = value;
	g_object_notify (((GObject *) (self)), "VideoPID");
}


guint dvb_channel_get_AudioPID (DVBChannel* self) {
	g_return_val_if_fail (DVB_IS_CHANNEL (self), 0U);
	return self->priv->_AudioPID;
}


void dvb_channel_set_AudioPID (DVBChannel* self, guint value) {
	g_return_if_fail (DVB_IS_CHANNEL (self));
	self->priv->_AudioPID = value;
	g_object_notify (((GObject *) (self)), "AudioPID");
}


guint dvb_channel_get_Frequency (DVBChannel* self) {
	g_return_val_if_fail (DVB_IS_CHANNEL (self), 0U);
	return self->priv->_Frequency;
}


void dvb_channel_set_Frequency (DVBChannel* self, guint value) {
	g_return_if_fail (DVB_IS_CHANNEL (self));
	self->priv->_Frequency = value;
	g_object_notify (((GObject *) (self)), "Frequency");
}


DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self) {
	g_return_val_if_fail (DVB_IS_CHANNEL (self), NULL);
	return self->priv->schedule;
}


static void dvb_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannel * self;
	self = DVB_CHANNEL (object);
	switch (property_id) {
		case DVB_CHANNEL_SID:
		g_value_set_uint (value, dvb_channel_get_Sid (self));
		break;
		case DVB_CHANNEL_NAME:
		g_value_set_string (value, dvb_channel_get_Name (self));
		break;
		case DVB_CHANNEL_TRANSPORT_STREAM_ID:
		g_value_set_uint (value, dvb_channel_get_TransportStreamId (self));
		break;
		case DVB_CHANNEL_NETWORK:
		g_value_set_string (value, dvb_channel_get_Network (self));
		break;
		case DVB_CHANNEL_LOGICAL_CHANNEL_NUMBER:
		g_value_set_uint (value, dvb_channel_get_LogicalChannelNumber (self));
		break;
		case DVB_CHANNEL_VIDEO_PID:
		g_value_set_uint (value, dvb_channel_get_VideoPID (self));
		break;
		case DVB_CHANNEL_AUDIO_PID:
		g_value_set_uint (value, dvb_channel_get_AudioPID (self));
		break;
		case DVB_CHANNEL_FREQUENCY:
		g_value_set_uint (value, dvb_channel_get_Frequency (self));
		break;
		case DVB_CHANNEL_SCHEDULE:
		g_value_set_object (value, dvb_channel_get_Schedule (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannel * self;
	self = DVB_CHANNEL (object);
	switch (property_id) {
		case DVB_CHANNEL_SID:
		dvb_channel_set_Sid (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_NAME:
		dvb_channel_set_Name (self, g_value_get_string (value));
		break;
		case DVB_CHANNEL_TRANSPORT_STREAM_ID:
		dvb_channel_set_TransportStreamId (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_NETWORK:
		dvb_channel_set_Network (self, g_value_get_string (value));
		break;
		case DVB_CHANNEL_LOGICAL_CHANNEL_NUMBER:
		dvb_channel_set_LogicalChannelNumber (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_VIDEO_PID:
		dvb_channel_set_VideoPID (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_AUDIO_PID:
		dvb_channel_set_AudioPID (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_FREQUENCY:
		dvb_channel_set_Frequency (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_channel_class_init (DVBChannelClass * klass) {
	dvb_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_channel_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_finalize;
	DVB_CHANNEL_CLASS (klass)->is_valid = dvb_channel_real_is_valid;
	DVB_CHANNEL_CLASS (klass)->setup_dvb_source = dvb_channel_real_setup_dvb_source;
	DVB_CHANNEL_CLASS (klass)->to_string = dvb_channel_real_to_string;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_SID, g_param_spec_uint ("Sid", "Sid", "Sid", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_TRANSPORT_STREAM_ID, g_param_spec_uint ("TransportStreamId", "TransportStreamId", "TransportStreamId", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_NETWORK, g_param_spec_string ("Network", "Network", "Network", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LOGICAL_CHANNEL_NUMBER, g_param_spec_uint ("LogicalChannelNumber", "LogicalChannelNumber", "LogicalChannelNumber", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_VIDEO_PID, g_param_spec_uint ("VideoPID", "VideoPID", "VideoPID", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_AUDIO_PID, g_param_spec_uint ("AudioPID", "AudioPID", "AudioPID", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_FREQUENCY, g_param_spec_uint ("Frequency", "Frequency", "Frequency", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_SCHEDULE, g_param_spec_object ("Schedule", "Schedule", "Schedule", DVB_TYPE_SCHEDULE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void dvb_channel_instance_init (DVBChannel * self) {
	self->priv = DVB_CHANNEL_GET_PRIVATE (self);
}


static void dvb_channel_finalize (GObject* obj) {
	DVBChannel * self;
	self = DVB_CHANNEL (obj);
	self->priv->_Name = (g_free (self->priv->_Name), NULL);
	self->priv->_Network = (g_free (self->priv->_Network), NULL);
	(self->priv->_LogicalChannelNumber == NULL ? NULL : (self->priv->_LogicalChannelNumber = (g_free (self->priv->_LogicalChannelNumber), NULL)));
	(self->priv->schedule == NULL ? NULL : (self->priv->schedule = (g_object_unref (self->priv->schedule), NULL)));
	G_OBJECT_CLASS (dvb_channel_parent_class)->finalize (obj);
}


GType dvb_channel_get_type (void) {
	static GType dvb_channel_type_id = 0;
	if (dvb_channel_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannel), 0, (GInstanceInitFunc) dvb_channel_instance_init, NULL };
		dvb_channel_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannel", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return dvb_channel_type_id;
}




