
#include <src/GConfStore.h>
#include <gconf/gconf-client.h>
#include <stdlib.h>
#include <string.h>
#include <gee/collection.h>
#include <gio/gio.h>
#include <gconf/gconf.h>
#include "src/ChannelList.h"




struct _DVBGConfStorePrivate {
	GConfClient* client;
};

#define DVB_GCONF_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_GCONF_STORE, DVBGConfStorePrivate))
enum  {
	DVB_GCONF_STORE_DUMMY_PROPERTY
};
static DVBGConfStore* dvb_gconf_store_instance;
#define DVB_GCONF_STORE_DEVICE_GROUPS_DIR_KEY "/device_groups"
#define DVB_GCONF_STORE_DEVICE_GROUP_DIR_NAME "/group_%d"
#define DVB_GCONF_STORE_DEVICE_GROUP_CHANNELS_FILE_KEY "/channels_file"
#define DVB_GCONF_STORE_DEVICE_GROUP_ADAPTER_TYPE_KEY "/adapter_type"
#define DVB_GCONF_STORE_DEVICE_GROUP_RECORDINGS_DIR_KEY "/recordings_dir"
#define DVB_GCONF_STORE_DEVICES_DIR_KEY "/devices"
#define DVB_GCONF_STORE_DEVICE_DIR_NAME "/device_%d_%d"
#define DVB_GCONF_STORE_DEVICE_ADAPTER_KEY "/adapter"
#define DVB_GCONF_STORE_DEVICE_FRONTEND_KEY "/frontend"
#define DVB_GCONF_STORE_TIMERS_DIR_KEY "/timers"
#define DVB_GCONF_STORE_TIMER_DIR_NAME "/timer_%d"
#define DVB_GCONF_STORE_TIMER_ID_KEY "/id"
#define DVB_GCONF_STORE_TIMER_CHANNEL_SID_KEY "/channel_sid"
#define DVB_GCONF_STORE_TIMER_YEAR_KEY "/year"
#define DVB_GCONF_STORE_TIMER_MONTH_KEY "/month"
#define DVB_GCONF_STORE_TIMER_DAY_KEY "/day"
#define DVB_GCONF_STORE_TIMER_HOUR_KEY "/hour"
#define DVB_GCONF_STORE_TIMER_MINUTE_KEY "/minute"
#define DVB_GCONF_STORE_TIMER_DURATION_KEY "/duration"
static GeeArrayList* dvb_gconf_store_get_all_devices (DVBGConfStore* self, const char* root_dir);
static char* dvb_gconf_store_get_device_path (DVBDevice* dev);
static char* dvb_gconf_store_get_device_group_path (DVBDeviceGroup* dev);
static GObject * dvb_gconf_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer dvb_gconf_store_parent_class = NULL;
static void dvb_gconf_store_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



DVBGConfStore* dvb_gconf_store_get_instance (void) {
	DVBGConfStore* _tmp1;
	/* TODO make thread-safe*/
	if (dvb_gconf_store_instance == NULL) {
		DVBGConfStore* _tmp0;
		_tmp0 = NULL;
		dvb_gconf_store_instance = (_tmp0 = dvb_gconf_store_new (), (dvb_gconf_store_instance == NULL ? NULL : (dvb_gconf_store_instance = (g_object_unref (dvb_gconf_store_instance), NULL))), _tmp0);
	}
	_tmp1 = NULL;
	return (_tmp1 = dvb_gconf_store_instance, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
}


static GeeArrayList* dvb_gconf_store_get_all_devices (DVBGConfStore* self, const char* root_dir) {
	GError * inner_error;
	char* devices_path;
	GeeArrayList* devs;
	GeeArrayList* _tmp6;
	g_return_val_if_fail (DVB_IS_GCONF_STORE (self), NULL);
	g_return_val_if_fail (root_dir != NULL, NULL);
	inner_error = NULL;
	devices_path = g_strconcat (root_dir, DVB_GCONF_STORE_DEVICES_DIR_KEY, NULL);
	devs = gee_array_list_new (DVB_TYPE_DEVICE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	{
		GSList* dirs;
		dirs = gconf_client_all_dirs (self->priv->client, devices_path, &inner_error);
		if (inner_error != NULL) {
			goto __catch7_g_error;
		}
		{
			GSList* base_path_collection;
			GSList* base_path_it;
			base_path_collection = dirs;
			for (base_path_it = base_path_collection; base_path_it != NULL; base_path_it = base_path_it->next) {
				const char* _tmp5;
				char* base_path;
				_tmp5 = NULL;
				base_path = (_tmp5 = ((char*) (base_path_it->data)), (_tmp5 == NULL ? NULL : g_strdup (_tmp5)));
				{
					char* _tmp0;
					gint _tmp1;
					gint gconf_adapter;
					char* _tmp2;
					gint _tmp3;
					gint gconf_frontend;
					DVBDevice* _tmp4;
					_tmp0 = NULL;
					gconf_adapter = (_tmp1 = gconf_client_get_int (self->priv->client, (_tmp0 = g_strconcat (base_path, DVB_GCONF_STORE_DEVICE_ADAPTER_KEY, NULL)), &inner_error), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
					if (inner_error != NULL) {
						goto __catch7_g_error;
					}
					if (gconf_adapter < 0) {
						base_path = (g_free (base_path), NULL);
						continue;
					}
					_tmp2 = NULL;
					gconf_frontend = (_tmp3 = gconf_client_get_int (self->priv->client, (_tmp2 = g_strconcat (base_path, DVB_GCONF_STORE_DEVICE_FRONTEND_KEY, NULL)), &inner_error), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
					if (inner_error != NULL) {
						goto __catch7_g_error;
					}
					if (gconf_frontend < 0) {
						base_path = (g_free (base_path), NULL);
						continue;
					}
					_tmp4 = NULL;
					gee_collection_add (GEE_COLLECTION (devs), (_tmp4 = dvb_device_new (((guint) (gconf_adapter)), ((guint) (gconf_frontend)), TRUE)));
					(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
					base_path = (g_free (base_path), NULL);
				}
			}
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
		}
	}
	__finally7:
	;
	_tmp6 = NULL;
	return (_tmp6 = devs, (devices_path = (g_free (devices_path), NULL)), _tmp6);
}


GeeArrayList* dvb_gconf_store_get_all_device_groups (DVBGConfStore* self) {
	GError * inner_error;
	char* groups_path;
	GeeArrayList* groups;
	GeeArrayList* _tmp12;
	g_return_val_if_fail (DVB_IS_GCONF_STORE (self), NULL);
	inner_error = NULL;
	groups_path = g_strdup (DVB_GCONF_STORE_BASE_DIR DVB_GCONF_STORE_DEVICE_GROUPS_DIR_KEY);
	groups = gee_array_list_new (DVB_TYPE_DEVICE_GROUP, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	{
		GSList* dirs;
		dirs = gconf_client_all_dirs (self->priv->client, groups_path, &inner_error);
		if (inner_error != NULL) {
			goto __catch8_g_error;
		}
		{
			GSList* base_path_collection;
			GSList* base_path_it;
			base_path_collection = dirs;
			for (base_path_it = base_path_collection; base_path_it != NULL; base_path_it = base_path_it->next) {
				const char* _tmp11;
				char* base_path;
				_tmp11 = NULL;
				base_path = (_tmp11 = ((char*) (base_path_it->data)), (_tmp11 == NULL ? NULL : g_strdup (_tmp11)));
				{
					GFile* groupfile;
					char* group_dir;
					gint _tmp0_length1;
					char** _tmp0;
					guint _tmp1;
					guint group_id;
					char* _tmp2;
					GFile* _tmp3;
					GFile* recordings_dir;
					char* _tmp4;
					gint _tmp5;
					gint gconf_type;
					DVBAdapterType type;
					gint _tmp6;
					char* _tmp7;
					GFile* _tmp8;
					GFile* channels_file;
					DVBChannelList* channels;
					DVBDeviceGroup* new_group;
					GeeArrayList* devs;
					/* base_path looks like
					 /apps/dvb-daemon/device_groups/group_1*/
					groupfile = g_file_new_for_path (base_path);
					group_dir = g_file_get_basename (groupfile);
					_tmp0 = NULL;
					group_id = (_tmp1 = ((guint) (atoi ((((_tmp0 = g_strsplit (group_dir, "_", 0)), _tmp0_length1 = -1, _tmp0)[1])))), (_tmp0 = (_vala_array_free (_tmp0, _tmp0_length1, ((GDestroyNotify) (g_free))), NULL)), _tmp1);
					_tmp2 = NULL;
					_tmp3 = NULL;
					recordings_dir = (_tmp3 = g_file_new_for_path (gconf_client_get_string (self->priv->client, (_tmp2 = g_strconcat (base_path, DVB_GCONF_STORE_DEVICE_GROUP_RECORDINGS_DIR_KEY, NULL)), &inner_error)), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
					_tmp4 = NULL;
					gconf_type = (_tmp5 = gconf_client_get_int (self->priv->client, (_tmp4 = g_strconcat (base_path, DVB_GCONF_STORE_DEVICE_GROUP_ADAPTER_TYPE_KEY, NULL)), &inner_error), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
					if (inner_error != NULL) {
						goto __catch8_g_error;
					}
					type = 0;
					_tmp6 = gconf_type;
					if (_tmp6 == 0)
					do {
						type = DVB_ADAPTER_TYPE_DVB_T;
						break;
					} while (0); else if (_tmp6 == 1)
					do {
						type = DVB_ADAPTER_TYPE_DVB_S;
						break;
					} while (0); else if (_tmp6 == 2)
					do {
						type = DVB_ADAPTER_TYPE_DVB_C;
						break;
					} while (0); else
					do {
						continue;
					} while (0);
					_tmp7 = NULL;
					_tmp8 = NULL;
					channels_file = (_tmp8 = g_file_new_for_path (gconf_client_get_string (self->priv->client, (_tmp7 = g_strconcat (base_path, DVB_GCONF_STORE_DEVICE_GROUP_CHANNELS_FILE_KEY, NULL)), &inner_error)), (_tmp7 = (g_free (_tmp7), NULL)), _tmp8);
					channels = NULL;
					{
						DVBChannelList* _tmp9;
						_tmp9 = NULL;
						channels = (_tmp9 = dvb_channel_list_restore_from_file (channels_file, type, &inner_error), (channels == NULL ? NULL : (channels = (g_object_unref (channels), NULL))), _tmp9);
						if (inner_error != NULL) {
							goto __catch9_g_error;
						}
					}
					goto __finally9;
					__catch9_g_error:
					{
						GError * e;
						e = inner_error;
						inner_error = NULL;
						{
							g_warning (e->message);
							(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
							base_path = (g_free (base_path), NULL);
							(groupfile == NULL ? NULL : (groupfile = (g_object_unref (groupfile), NULL)));
							group_dir = (g_free (group_dir), NULL);
							(recordings_dir == NULL ? NULL : (recordings_dir = (g_object_unref (recordings_dir), NULL)));
							(channels_file == NULL ? NULL : (channels_file = (g_object_unref (channels_file), NULL)));
							(channels == NULL ? NULL : (channels = (g_object_unref (channels), NULL)));
							continue;
						}
					}
					__finally9:
					;
					new_group = NULL;
					devs = dvb_gconf_store_get_all_devices (self, base_path);
					g_assert (gee_collection_get_size (GEE_COLLECTION (devs)) > 0);
					{
						GeeArrayList* dev_collection;
						int dev_it;
						dev_collection = devs;
						for (dev_it = 0; dev_it < gee_collection_get_size (GEE_COLLECTION (dev_collection)); dev_it = dev_it + 1) {
							DVBDevice* dev;
							dev = ((DVBDevice*) (gee_list_get (GEE_LIST (dev_collection), dev_it)));
							{
								if (new_group == NULL) {
									DVBDeviceGroup* _tmp10;
									dvb_device_set_Channels (dev, channels);
									dvb_device_set_RecordingsDirectory (dev, recordings_dir);
									_tmp10 = NULL;
									new_group = (_tmp10 = dvb_device_group_new (group_id, dev), (new_group == NULL ? NULL : (new_group = (g_object_unref (new_group), NULL))), _tmp10);
								} else {
									dvb_device_group_add (new_group, dev);
								}
								(dev == NULL ? NULL : (dev = (g_object_unref (dev), NULL)));
							}
						}
					}
					g_assert (new_group != NULL);
					g_assert (dvb_device_group_get_size (new_group) > 0);
					gee_collection_add (GEE_COLLECTION (groups), new_group);
					base_path = (g_free (base_path), NULL);
					(groupfile == NULL ? NULL : (groupfile = (g_object_unref (groupfile), NULL)));
					group_dir = (g_free (group_dir), NULL);
					(recordings_dir == NULL ? NULL : (recordings_dir = (g_object_unref (recordings_dir), NULL)));
					(channels_file == NULL ? NULL : (channels_file = (g_object_unref (channels_file), NULL)));
					(channels == NULL ? NULL : (channels = (g_object_unref (channels), NULL)));
					(new_group == NULL ? NULL : (new_group = (g_object_unref (new_group), NULL)));
					(devs == NULL ? NULL : (devs = (g_object_unref (devs), NULL)));
				}
			}
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
		}
	}
	__finally8:
	;
	_tmp12 = NULL;
	return (_tmp12 = groups, (groups_path = (g_free (groups_path), NULL)), _tmp12);
}


void dvb_gconf_store_add_device_group (DVBGConfStore* self, DVBDeviceGroup* dev_group) {
	GError * inner_error;
	char* base_path;
	g_return_if_fail (DVB_IS_GCONF_STORE (self));
	g_return_if_fail (DVB_IS_DEVICE_GROUP (dev_group));
	inner_error = NULL;
	base_path = dvb_gconf_store_get_device_group_path (dev_group);
	{
		if (!gconf_client_dir_exists (self->priv->client, base_path, &inner_error)) {
			char* _tmp0;
			char* _tmp2;
			char* _tmp1;
			char* _tmp4;
			char* _tmp3;
			_tmp0 = NULL;
			gconf_client_set_int (self->priv->client, (_tmp0 = g_strconcat (base_path, DVB_GCONF_STORE_DEVICE_GROUP_ADAPTER_TYPE_KEY, NULL)), ((gint) (dvb_device_group_get_Type (dev_group))), &inner_error);
			if (inner_error != NULL) {
				goto __catch10_g_error;
			}
			_tmp0 = (g_free (_tmp0), NULL);
			_tmp2 = NULL;
			_tmp1 = NULL;
			gconf_client_set_string (self->priv->client, (_tmp1 = g_strconcat (base_path, DVB_GCONF_STORE_DEVICE_GROUP_CHANNELS_FILE_KEY, NULL)), (_tmp2 = g_file_get_path (dvb_channel_list_get_channels_file (dvb_device_group_get_Channels (dev_group)))), &inner_error);
			if (inner_error != NULL) {
				goto __catch10_g_error;
			}
			_tmp2 = (g_free (_tmp2), NULL);
			_tmp1 = (g_free (_tmp1), NULL);
			_tmp4 = NULL;
			_tmp3 = NULL;
			gconf_client_set_string (self->priv->client, (_tmp3 = g_strconcat (base_path, DVB_GCONF_STORE_DEVICE_GROUP_RECORDINGS_DIR_KEY, NULL)), (_tmp4 = g_file_get_path (dvb_device_group_get_RecordingsDirectory (dev_group))), &inner_error);
			if (inner_error != NULL) {
				goto __catch10_g_error;
			}
			_tmp4 = (g_free (_tmp4), NULL);
			_tmp3 = (g_free (_tmp3), NULL);
			{
				DVBDeviceGroup* dev_collection;
				GeeIterator* dev_it;
				dev_collection = dev_group;
				dev_it = gee_iterable_iterator (GEE_ITERABLE (dev_collection));
				while (gee_iterator_next (dev_it)) {
					DVBDevice* dev;
					dev = ((DVBDevice*) (gee_iterator_get (dev_it)));
					{
						dvb_gconf_store_add_device_to_group (self, dev, dev_group);
						(dev == NULL ? NULL : (dev = (g_object_unref (dev), NULL)));
					}
				}
				(dev_it == NULL ? NULL : (dev_it = (g_object_unref (dev_it), NULL)));
			}
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
		}
	}
	__finally10:
	;
	base_path = (g_free (base_path), NULL);
}


void dvb_gconf_store_remove_device_group (DVBGConfStore* self, DVBDeviceGroup* devgroup) {
	GError * inner_error;
	char* base_path;
	g_return_if_fail (DVB_IS_GCONF_STORE (self));
	g_return_if_fail (DVB_IS_DEVICE_GROUP (devgroup));
	inner_error = NULL;
	base_path = dvb_gconf_store_get_device_group_path (devgroup);
	{
		if (gconf_client_dir_exists (self->priv->client, base_path, &inner_error)) {
			gconf_client_recursive_unset (self->priv->client, base_path, GCONF_UNSET_INCLUDING_SCHEMA_NAMES, &inner_error);
			if (inner_error != NULL) {
				goto __catch11_g_error;
			}
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
		}
	}
	__finally11:
	;
	base_path = (g_free (base_path), NULL);
}


void dvb_gconf_store_add_device_to_group (DVBGConfStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup) {
	GError * inner_error;
	char* _tmp1;
	char* _tmp0;
	char* _tmp2;
	char* base_path;
	g_return_if_fail (DVB_IS_GCONF_STORE (self));
	g_return_if_fail (DVB_IS_DEVICE (dev));
	g_return_if_fail (DVB_IS_DEVICE_GROUP (devgroup));
	inner_error = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	base_path = (_tmp2 = g_strconcat ((_tmp0 = dvb_gconf_store_get_device_group_path (devgroup)), (_tmp1 = dvb_gconf_store_get_device_path (dev)), NULL), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	{
		char* _tmp3;
		char* _tmp4;
		_tmp3 = NULL;
		gconf_client_set_int (self->priv->client, (_tmp3 = g_strconcat (base_path, DVB_GCONF_STORE_DEVICE_ADAPTER_KEY, NULL)), ((gint) (dvb_device_get_Adapter (dev))), &inner_error);
		if (inner_error != NULL) {
			goto __catch12_g_error;
		}
		_tmp3 = (g_free (_tmp3), NULL);
		_tmp4 = NULL;
		gconf_client_set_int (self->priv->client, (_tmp4 = g_strconcat (base_path, DVB_GCONF_STORE_DEVICE_FRONTEND_KEY, NULL)), ((gint) (dvb_device_get_Frontend (dev))), &inner_error);
		if (inner_error != NULL) {
			goto __catch12_g_error;
		}
		_tmp4 = (g_free (_tmp4), NULL);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
		}
	}
	__finally12:
	;
	base_path = (g_free (base_path), NULL);
}


void dvb_gconf_store_remove_device_from_group (DVBGConfStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup) {
	GError * inner_error;
	char* _tmp1;
	char* _tmp0;
	char* _tmp2;
	char* base_path;
	g_return_if_fail (DVB_IS_GCONF_STORE (self));
	g_return_if_fail (DVB_IS_DEVICE (dev));
	g_return_if_fail (DVB_IS_DEVICE_GROUP (devgroup));
	inner_error = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	base_path = (_tmp2 = g_strconcat ((_tmp0 = dvb_gconf_store_get_device_group_path (devgroup)), (_tmp1 = dvb_gconf_store_get_device_path (dev)), NULL), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	{
		if (gconf_client_dir_exists (self->priv->client, base_path, &inner_error)) {
			gconf_client_recursive_unset (self->priv->client, base_path, GCONF_UNSET_INCLUDING_SCHEMA_NAMES, &inner_error);
			if (inner_error != NULL) {
				goto __catch13_g_error;
			}
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
		}
	}
	__finally13:
	;
	base_path = (g_free (base_path), NULL);
}


GeeArrayList* dvb_gconf_store_get_all_timers_of_device_group (DVBGConfStore* self, DVBDeviceGroup* dev) {
	GError * inner_error;
	char* _tmp0;
	char* _tmp1;
	char* timers_path;
	GeeArrayList* timers;
	GeeArrayList* _tmp20;
	g_return_val_if_fail (DVB_IS_GCONF_STORE (self), NULL);
	g_return_val_if_fail (DVB_IS_DEVICE_GROUP (dev), NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	_tmp1 = NULL;
	timers_path = (_tmp1 = g_strconcat ((_tmp0 = dvb_gconf_store_get_device_group_path (dev)), DVB_GCONF_STORE_TIMERS_DIR_KEY, NULL), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	timers = gee_array_list_new (DVB_TYPE_TIMER, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
	{
		GSList* dirs;
		dirs = gconf_client_all_dirs (self->priv->client, timers_path, &inner_error);
		if (inner_error != NULL) {
			goto __catch14_g_error;
		}
		{
			GSList* base_path_collection;
			GSList* base_path_it;
			base_path_collection = dirs;
			for (base_path_it = base_path_collection; base_path_it != NULL; base_path_it = base_path_it->next) {
				const char* _tmp19;
				char* base_path;
				_tmp19 = NULL;
				base_path = (_tmp19 = ((char*) (base_path_it->data)), (_tmp19 == NULL ? NULL : g_strdup (_tmp19)));
				{
					char* _tmp2;
					gint _tmp3;
					gint gconf_id;
					char* _tmp4;
					gint _tmp5;
					gint gconf_sid;
					char* _tmp6;
					gint _tmp7;
					gint gconf_year;
					char* _tmp8;
					gint _tmp9;
					gint gconf_month;
					char* _tmp10;
					gint _tmp11;
					gint gconf_day;
					char* _tmp12;
					gint _tmp13;
					gint gconf_hour;
					char* _tmp14;
					gint _tmp15;
					gint gconf_minute;
					char* _tmp16;
					gint _tmp17;
					gint gconf_duration;
					DVBTimer* _tmp18;
					_tmp2 = NULL;
					gconf_id = (_tmp3 = gconf_client_get_int (self->priv->client, (_tmp2 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_ID_KEY, NULL)), &inner_error), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
					if (inner_error != NULL) {
						goto __catch14_g_error;
					}
					if (gconf_id <= 0) {
						base_path = (g_free (base_path), NULL);
						continue;
					}
					_tmp4 = NULL;
					gconf_sid = (_tmp5 = gconf_client_get_int (self->priv->client, (_tmp4 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_CHANNEL_SID_KEY, NULL)), &inner_error), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
					if (inner_error != NULL) {
						goto __catch14_g_error;
					}
					if (gconf_sid <= 0) {
						base_path = (g_free (base_path), NULL);
						continue;
					}
					_tmp6 = NULL;
					gconf_year = (_tmp7 = gconf_client_get_int (self->priv->client, (_tmp6 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_YEAR_KEY, NULL)), &inner_error), (_tmp6 = (g_free (_tmp6), NULL)), _tmp7);
					if (inner_error != NULL) {
						goto __catch14_g_error;
					}
					if (gconf_year <= 0) {
						base_path = (g_free (base_path), NULL);
						continue;
					}
					_tmp8 = NULL;
					gconf_month = (_tmp9 = gconf_client_get_int (self->priv->client, (_tmp8 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_MONTH_KEY, NULL)), &inner_error), (_tmp8 = (g_free (_tmp8), NULL)), _tmp9);
					if (inner_error != NULL) {
						goto __catch14_g_error;
					}
					if (gconf_month < 0) {
						base_path = (g_free (base_path), NULL);
						continue;
					}
					_tmp10 = NULL;
					gconf_day = (_tmp11 = gconf_client_get_int (self->priv->client, (_tmp10 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_DAY_KEY, NULL)), &inner_error), (_tmp10 = (g_free (_tmp10), NULL)), _tmp11);
					if (inner_error != NULL) {
						goto __catch14_g_error;
					}
					if (gconf_day < 0) {
						base_path = (g_free (base_path), NULL);
						continue;
					}
					_tmp12 = NULL;
					gconf_hour = (_tmp13 = gconf_client_get_int (self->priv->client, (_tmp12 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_HOUR_KEY, NULL)), &inner_error), (_tmp12 = (g_free (_tmp12), NULL)), _tmp13);
					if (inner_error != NULL) {
						goto __catch14_g_error;
					}
					if (gconf_hour < 0) {
						base_path = (g_free (base_path), NULL);
						continue;
					}
					_tmp14 = NULL;
					gconf_minute = (_tmp15 = gconf_client_get_int (self->priv->client, (_tmp14 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_MINUTE_KEY, NULL)), &inner_error), (_tmp14 = (g_free (_tmp14), NULL)), _tmp15);
					if (inner_error != NULL) {
						goto __catch14_g_error;
					}
					if (gconf_minute < 0) {
						base_path = (g_free (base_path), NULL);
						continue;
					}
					_tmp16 = NULL;
					gconf_duration = (_tmp17 = gconf_client_get_int (self->priv->client, (_tmp16 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_DURATION_KEY, NULL)), &inner_error), (_tmp16 = (g_free (_tmp16), NULL)), _tmp17);
					if (inner_error != NULL) {
						goto __catch14_g_error;
					}
					if (gconf_duration <= 0) {
						base_path = (g_free (base_path), NULL);
						continue;
					}
					_tmp18 = NULL;
					gee_collection_add (GEE_COLLECTION (timers), (_tmp18 = dvb_timer_new (((guint32) (gconf_id)), ((guint) (gconf_sid)), gconf_year, gconf_month, gconf_day, gconf_hour, gconf_minute, ((guint) (gconf_duration)), NULL)));
					(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
					base_path = (g_free (base_path), NULL);
				}
			}
		}
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
		}
	}
	__finally14:
	;
	_tmp20 = NULL;
	return (_tmp20 = timers, (timers_path = (g_free (timers_path), NULL)), _tmp20);
}


void dvb_gconf_store_add_timer_to_device_group (DVBGConfStore* self, DVBTimer* timer, DVBDeviceGroup* dev) {
	GError * inner_error;
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	char* _tmp3;
	char* base_path;
	g_return_if_fail (DVB_IS_GCONF_STORE (self));
	g_return_if_fail (DVB_IS_TIMER (timer));
	g_return_if_fail (DVB_IS_DEVICE_GROUP (dev));
	inner_error = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp3 = NULL;
	base_path = (_tmp3 = g_strconcat ((_tmp1 = g_strconcat ((_tmp0 = dvb_gconf_store_get_device_group_path (dev)), DVB_GCONF_STORE_TIMERS_DIR_KEY, NULL)), (_tmp2 = g_strdup_printf (DVB_GCONF_STORE_TIMER_DIR_NAME, dvb_timer_get_Id (timer))), NULL), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp3);
	{
		if (!gconf_client_dir_exists (self->priv->client, base_path, &inner_error)) {
			char* _tmp4;
			char* _tmp5;
			char* _tmp6;
			char* _tmp7;
			char* _tmp8;
			char* _tmp9;
			char* _tmp10;
			char* _tmp11;
			_tmp4 = NULL;
			gconf_client_set_int (self->priv->client, (_tmp4 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_ID_KEY, NULL)), ((gint) (dvb_timer_get_Id (timer))), &inner_error);
			if (inner_error != NULL) {
				goto __catch15_g_error;
			}
			_tmp4 = (g_free (_tmp4), NULL);
			_tmp5 = NULL;
			gconf_client_set_int (self->priv->client, (_tmp5 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_CHANNEL_SID_KEY, NULL)), ((gint) (dvb_timer_get_ChannelSid (timer))), &inner_error);
			if (inner_error != NULL) {
				goto __catch15_g_error;
			}
			_tmp5 = (g_free (_tmp5), NULL);
			_tmp6 = NULL;
			gconf_client_set_int (self->priv->client, (_tmp6 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_YEAR_KEY, NULL)), ((gint) (dvb_timer_get_Year (timer))), &inner_error);
			if (inner_error != NULL) {
				goto __catch15_g_error;
			}
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp7 = NULL;
			gconf_client_set_int (self->priv->client, (_tmp7 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_MONTH_KEY, NULL)), ((gint) (dvb_timer_get_Month (timer))), &inner_error);
			if (inner_error != NULL) {
				goto __catch15_g_error;
			}
			_tmp7 = (g_free (_tmp7), NULL);
			_tmp8 = NULL;
			gconf_client_set_int (self->priv->client, (_tmp8 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_DAY_KEY, NULL)), ((gint) (dvb_timer_get_Day (timer))), &inner_error);
			if (inner_error != NULL) {
				goto __catch15_g_error;
			}
			_tmp8 = (g_free (_tmp8), NULL);
			_tmp9 = NULL;
			gconf_client_set_int (self->priv->client, (_tmp9 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_HOUR_KEY, NULL)), ((gint) (dvb_timer_get_Hour (timer))), &inner_error);
			if (inner_error != NULL) {
				goto __catch15_g_error;
			}
			_tmp9 = (g_free (_tmp9), NULL);
			_tmp10 = NULL;
			gconf_client_set_int (self->priv->client, (_tmp10 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_MINUTE_KEY, NULL)), ((gint) (dvb_timer_get_Minute (timer))), &inner_error);
			if (inner_error != NULL) {
				goto __catch15_g_error;
			}
			_tmp10 = (g_free (_tmp10), NULL);
			_tmp11 = NULL;
			gconf_client_set_int (self->priv->client, (_tmp11 = g_strconcat (base_path, DVB_GCONF_STORE_TIMER_DURATION_KEY, NULL)), ((gint) (dvb_timer_get_Duration (timer))), &inner_error);
			if (inner_error != NULL) {
				goto __catch15_g_error;
			}
			_tmp11 = (g_free (_tmp11), NULL);
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
		}
	}
	__finally15:
	;
	base_path = (g_free (base_path), NULL);
}


void dvb_gconf_store_remove_timer_from_device_group (DVBGConfStore* self, guint timer_id, DVBDeviceGroup* dev) {
	GError * inner_error;
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	char* _tmp3;
	char* base_path;
	g_return_if_fail (DVB_IS_GCONF_STORE (self));
	g_return_if_fail (DVB_IS_DEVICE_GROUP (dev));
	inner_error = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp3 = NULL;
	base_path = (_tmp3 = g_strconcat ((_tmp1 = g_strconcat ((_tmp0 = dvb_gconf_store_get_device_group_path (dev)), DVB_GCONF_STORE_TIMERS_DIR_KEY, NULL)), (_tmp2 = g_strdup_printf (DVB_GCONF_STORE_TIMER_DIR_NAME, timer_id)), NULL), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp3);
	{
		if (gconf_client_dir_exists (self->priv->client, base_path, &inner_error)) {
			gconf_client_recursive_unset (self->priv->client, base_path, GCONF_UNSET_INCLUDING_SCHEMA_NAMES, &inner_error);
			if (inner_error != NULL) {
				goto __catch16_g_error;
			}
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
		}
	}
	__finally16:
	;
	base_path = (g_free (base_path), NULL);
}


static char* dvb_gconf_store_get_device_path (DVBDevice* dev) {
	char* _tmp0;
	char* _tmp1;
	g_return_val_if_fail (DVB_IS_DEVICE (dev), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strconcat (DVB_GCONF_STORE_DEVICES_DIR_KEY, (_tmp0 = g_strdup_printf (DVB_GCONF_STORE_DEVICE_DIR_NAME, dvb_device_get_Adapter (dev), dvb_device_get_Frontend (dev))), NULL), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
}


static char* dvb_gconf_store_get_device_group_path (DVBDeviceGroup* dev) {
	char* _tmp0;
	char* _tmp1;
	g_return_val_if_fail (DVB_IS_DEVICE_GROUP (dev), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strconcat (DVB_GCONF_STORE_BASE_DIR DVB_GCONF_STORE_DEVICE_GROUPS_DIR_KEY, (_tmp0 = g_strdup_printf (DVB_GCONF_STORE_DEVICE_GROUP_DIR_NAME, dvb_device_group_get_Id (dev))), NULL), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
}


/**
     * Example tree:
     * /app/dvb-daemon
     *     /device_groups
     *         /group_0
     *             /devices
     *                 /device_0_0
     *                      adapter
     *                      frontend
     *                  /device_1_0
     *                      adapter
     *                     frontend
     *             /timers
     *                 /timer_0
     *                     id
     *                     channel_sid
     *                     year
     *                 /timer_1
     *                     id
     *                     channel_sid
     *                     year
     *             channels_file
     *             adapter_type
     *             recordings_dir
     *         /group_1
     *             /devices
     *                  /device_2_0
     *                      adapter
     *                      frontend
     *                  /device_3_0
     *                      adapter
     *                      frontend
     *             channels_file
     *             adapter_type
     *             recordings_dir
     */
DVBGConfStore* dvb_gconf_store_construct (GType object_type) {
	DVBGConfStore * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBGConfStore* dvb_gconf_store_new (void) {
	return dvb_gconf_store_construct (DVB_TYPE_GCONF_STORE);
}


static GObject * dvb_gconf_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DVBGConfStoreClass * klass;
	GObjectClass * parent_class;
	DVBGConfStore * self;
	klass = DVB_GCONF_STORE_CLASS (g_type_class_peek (DVB_TYPE_GCONF_STORE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_GCONF_STORE (obj);
	{
		GConfClient* _tmp1;
		GConfClient* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		self->priv->client = (_tmp1 = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->client == NULL ? NULL : (self->priv->client = (g_object_unref (self->priv->client), NULL))), _tmp1);
	}
	return obj;
}


static void dvb_gconf_store_class_init (DVBGConfStoreClass * klass) {
	dvb_gconf_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBGConfStorePrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_gconf_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_gconf_store_finalize;
}


static void dvb_gconf_store_instance_init (DVBGConfStore * self) {
	self->priv = DVB_GCONF_STORE_GET_PRIVATE (self);
}


static void dvb_gconf_store_finalize (GObject* obj) {
	DVBGConfStore * self;
	self = DVB_GCONF_STORE (obj);
	(self->priv->client == NULL ? NULL : (self->priv->client = (g_object_unref (self->priv->client), NULL)));
	G_OBJECT_CLASS (dvb_gconf_store_parent_class)->finalize (obj);
}


GType dvb_gconf_store_get_type (void) {
	static GType dvb_gconf_store_type_id = 0;
	if (dvb_gconf_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBGConfStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_gconf_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBGConfStore), 0, (GInstanceInitFunc) dvb_gconf_store_instance_init, NULL };
		dvb_gconf_store_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBGConfStore", &g_define_type_info, 0);
	}
	return dvb_gconf_store_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if (array != NULL && destroy_func != NULL) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) (array))[i] != NULL)
			destroy_func (((gpointer*) (array))[i]);
		}
		else
		for (i = 0; ((gpointer*) (array))[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) (array))[i]);
		}
	}
	g_free (array);
}




