
#include <src/IDBusRecordingsStore.h>
#include <dbus/dbus-glib.h>




static gboolean _dbus_dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, GArray** dbus_result, GError** error);
static gboolean _dbus_dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id, char** result, GError** error);
static gboolean _dbus_dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id, char** result, GError** error);
static gboolean _dbus_dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id, char** result, GError** error);
static gboolean _dbus_dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, GArray** dbus_result, GError** error);
static gboolean _dbus_dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* result, GError** error);
static gboolean _dbus_dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* result, GError** error);
static gboolean _dbus_dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id, gboolean* result, GError** error);


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

/**
         * @returns: A list of ids for all recordings
         */
guint32* dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, int* result_length1) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetRecordings (self, result_length1);
}


/**
         * @rec_id: The id of the recording
         * @returns: The location of the recording on the filesystem
         */
char* dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetLocation (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: The name of the recording (e.g. the name of
         * a TV show)
         */
char* dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetName (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: A short text describing the recorded item
         * (e.g. the description from EPG)
         */
char* dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetDescription (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: The starting time of the recording
         */
guint* dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, int* result_length1) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetStartTime (self, rec_id, result_length1);
}


/**
         * @rec_id: The id of the recording
         * @returns: Start time as UNIX timestamp
         */
gint64 dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetStartTimestamp (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: The length of the recording in seconds
         * or -1 if no recording with the given id exists
         */
gint64 dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetLength (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: TRUE on success, FALSE otherwises
         *
         * Delete the recording. This deletes all files in the directory
         * created by the Recorder
         */
gboolean dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->Delete (self, rec_id);
}


static gboolean _dbus_dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, GArray** dbus_result, GError** error) {
	guint32* result;
	int result_length1;
	result = dvb_id_bus_recordings_store_GetRecordings (self, &result_length1);
	(*dbus_result) = g_array_new (TRUE, TRUE, sizeof (guint32));
	g_array_append_vals ((*dbus_result), result, result_length1);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id, char** result, GError** error) {
	*result = dvb_id_bus_recordings_store_GetLocation (self, rec_id);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id, char** result, GError** error) {
	*result = dvb_id_bus_recordings_store_GetName (self, rec_id);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id, char** result, GError** error) {
	*result = dvb_id_bus_recordings_store_GetDescription (self, rec_id);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, GArray** dbus_result, GError** error) {
	guint* result;
	int result_length1;
	result = dvb_id_bus_recordings_store_GetStartTime (self, rec_id, &result_length1);
	(*dbus_result) = g_array_new (TRUE, TRUE, sizeof (guint));
	g_array_append_vals ((*dbus_result), result, result_length1);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* result, GError** error) {
	*result = dvb_id_bus_recordings_store_GetStartTimestamp (self, rec_id);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* result, GError** error) {
	*result = dvb_id_bus_recordings_store_GetLength (self, rec_id);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id, gboolean* result, GError** error) {
	*result = dvb_id_bus_recordings_store_Delete (self, rec_id);
	return !error || !*error;
}


static void dvb_id_bus_recordings_store_base_init (DVBIDBusRecordingsStoreIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("changed", DVB_TYPE_ID_BUS_RECORDINGS_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		static const DBusGMethodInfo dvb_id_bus_recordings_store_dbus_methods[] = {
{ (GCallback) _dbus_dvb_id_bus_recordings_store_GetRecordings, g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER, 0 },
{ (GCallback) _dbus_dvb_id_bus_recordings_store_GetLocation, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 63 },
{ (GCallback) _dbus_dvb_id_bus_recordings_store_GetName, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 134 },
{ (GCallback) _dbus_dvb_id_bus_recordings_store_GetDescription, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 201 },
{ (GCallback) _dbus_dvb_id_bus_recordings_store_GetStartTime, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 275 },
{ (GCallback) _dbus_dvb_id_bus_recordings_store_GetStartTimestamp, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 348 },
{ (GCallback) _dbus_dvb_id_bus_recordings_store_GetLength, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 425 },
{ (GCallback) _dbus_dvb_id_bus_recordings_store_Delete, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 494 },
}
;
		static const DBusGObjectInfo dvb_id_bus_recordings_store_dbus_object_info = { 0, dvb_id_bus_recordings_store_dbus_methods, 8, "org.gnome.DVB.RecordingsStore\0GetRecordings\0S\0result\0O\0F\0N\0au\0\0org.gnome.DVB.RecordingsStore\0GetLocation\0S\0rec_id\0I\0u\0result\0O\0F\0N\0s\0\0org.gnome.DVB.RecordingsStore\0GetName\0S\0rec_id\0I\0u\0result\0O\0F\0N\0s\0\0org.gnome.DVB.RecordingsStore\0GetDescription\0S\0rec_id\0I\0u\0result\0O\0F\0N\0s\0\0org.gnome.DVB.RecordingsStore\0GetStartTime\0S\0rec_id\0I\0u\0result\0O\0F\0N\0au\0\0org.gnome.DVB.RecordingsStore\0GetStartTimestamp\0S\0rec_id\0I\0u\0result\0O\0F\0N\0x\0\0org.gnome.DVB.RecordingsStore\0GetLength\0S\0rec_id\0I\0u\0result\0O\0F\0N\0x\0\0org.gnome.DVB.RecordingsStore\0Delete\0S\0rec_id\0I\0u\0result\0O\0F\0N\0b\0\0", "org.gnome.DVB.RecordingsStore\0Changed\0", "" };
		dbus_g_object_type_install_info (DVB_TYPE_ID_BUS_RECORDINGS_STORE, &dvb_id_bus_recordings_store_dbus_object_info);
	}
}


GType dvb_id_bus_recordings_store_get_type (void) {
	static GType dvb_id_bus_recordings_store_type_id = 0;
	if (dvb_id_bus_recordings_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusRecordingsStoreIface), (GBaseInitFunc) dvb_id_bus_recordings_store_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_recordings_store_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusRecordingsStore", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_recordings_store_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_recordings_store_type_id;
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint32 arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_VOID__UINT_UINT) ((marshal_data ? marshal_data : cc->callback)));
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__POINTER_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__UINT_POINTER_POINTER) (gpointer data1, guint32 arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_BOOLEAN__UINT_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__UINT_POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_uint (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_pointer (param_values + 3), data2);
	g_value_set_boolean (return_value, v_return);
}



