
#include <src/MpegTsEnums.h>




static int _vala_strcmp0 (const char * str1, const char * str2);




GType dvb_dvb_src_code_rate_get_type (void) {
	static GType dvb_dvb_src_code_rate_type_id = 0;
	if (G_UNLIKELY (dvb_dvb_src_code_rate_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_CODE_RATE_FEC_NONE, "DVB_DVB_SRC_CODE_RATE_FEC_NONE", "fec-none"}, {DVB_DVB_SRC_CODE_RATE_FEC_1_2, "DVB_DVB_SRC_CODE_RATE_FEC_1_2", "fec-1-2"}, {DVB_DVB_SRC_CODE_RATE_FEC_2_3, "DVB_DVB_SRC_CODE_RATE_FEC_2_3", "fec-2-3"}, {DVB_DVB_SRC_CODE_RATE_FEC_3_4, "DVB_DVB_SRC_CODE_RATE_FEC_3_4", "fec-3-4"}, {DVB_DVB_SRC_CODE_RATE_FEC_4_5, "DVB_DVB_SRC_CODE_RATE_FEC_4_5", "fec-4-5"}, {DVB_DVB_SRC_CODE_RATE_FEC_5_6, "DVB_DVB_SRC_CODE_RATE_FEC_5_6", "fec-5-6"}, {DVB_DVB_SRC_CODE_RATE_FEC_6_7, "DVB_DVB_SRC_CODE_RATE_FEC_6_7", "fec-6-7"}, {DVB_DVB_SRC_CODE_RATE_FEC_7_8, "DVB_DVB_SRC_CODE_RATE_FEC_7_8", "fec-7-8"}, {DVB_DVB_SRC_CODE_RATE_FEC_8_9, "DVB_DVB_SRC_CODE_RATE_FEC_8_9", "fec-8-9"}, {DVB_DVB_SRC_CODE_RATE_FEC_AUTO, "DVB_DVB_SRC_CODE_RATE_FEC_AUTO", "fec-auto"}, {0, NULL, NULL}};
		dvb_dvb_src_code_rate_type_id = g_enum_register_static ("DVBDvbSrcCodeRate", values);
	}
	return dvb_dvb_src_code_rate_type_id;
}



GType dvb_dvb_src_modulation_get_type (void) {
	static GType dvb_dvb_src_modulation_type_id = 0;
	if (G_UNLIKELY (dvb_dvb_src_modulation_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_MODULATION_QPSK, "DVB_DVB_SRC_MODULATION_QPSK", "qpsk"}, {DVB_DVB_SRC_MODULATION_QAM_16, "DVB_DVB_SRC_MODULATION_QAM_16", "qam-16"}, {DVB_DVB_SRC_MODULATION_QAM_32, "DVB_DVB_SRC_MODULATION_QAM_32", "qam-32"}, {DVB_DVB_SRC_MODULATION_QAM_64, "DVB_DVB_SRC_MODULATION_QAM_64", "qam-64"}, {DVB_DVB_SRC_MODULATION_QAM_128, "DVB_DVB_SRC_MODULATION_QAM_128", "qam-128"}, {DVB_DVB_SRC_MODULATION_QAM_256, "DVB_DVB_SRC_MODULATION_QAM_256", "qam-256"}, {DVB_DVB_SRC_MODULATION_QAM_AUTO, "DVB_DVB_SRC_MODULATION_QAM_AUTO", "qam-auto"}, {0, NULL, NULL}};
		dvb_dvb_src_modulation_type_id = g_enum_register_static ("DVBDvbSrcModulation", values);
	}
	return dvb_dvb_src_modulation_type_id;
}



GType dvb_dvb_src_transmission_mode_get_type (void) {
	static GType dvb_dvb_src_transmission_mode_type_id = 0;
	if (G_UNLIKELY (dvb_dvb_src_transmission_mode_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K, "DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K", "transmission-mode-2k"}, {DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K, "DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K", "transmission-mode-8k"}, {DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO, "DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO", "transmission-mode-auto"}, {0, NULL, NULL}};
		dvb_dvb_src_transmission_mode_type_id = g_enum_register_static ("DVBDvbSrcTransmissionMode", values);
	}
	return dvb_dvb_src_transmission_mode_type_id;
}



GType dvb_dvb_src_bandwidth_get_type (void) {
	static GType dvb_dvb_src_bandwidth_type_id = 0;
	if (G_UNLIKELY (dvb_dvb_src_bandwidth_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ, "DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ", "bandwidth-8-mhz"}, {DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ, "DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ", "bandwidth-7-mhz"}, {DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ, "DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ", "bandwidth-6-mhz"}, {DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO, "DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO", "bandwidth-auto"}, {0, NULL, NULL}};
		dvb_dvb_src_bandwidth_type_id = g_enum_register_static ("DVBDvbSrcBandwidth", values);
	}
	return dvb_dvb_src_bandwidth_type_id;
}



GType dvb_dvb_src_guard_get_type (void) {
	static GType dvb_dvb_src_guard_type_id = 0;
	if (G_UNLIKELY (dvb_dvb_src_guard_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32", "guard-interval-1-32"}, {DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16", "guard-interval-1-16"}, {DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8", "guard-interval-1-8"}, {DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4", "guard-interval-1-4"}, {DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO", "guard-interval-auto"}, {0, NULL, NULL}};
		dvb_dvb_src_guard_type_id = g_enum_register_static ("DVBDvbSrcGuard", values);
	}
	return dvb_dvb_src_guard_type_id;
}



GType dvb_dvb_src_hierarchy_get_type (void) {
	static GType dvb_dvb_src_hierarchy_type_id = 0;
	if (G_UNLIKELY (dvb_dvb_src_hierarchy_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE", "hierarchy-none"}, {DVB_DVB_SRC_HIERARCHY_HIERARCHY_1, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_1", "hierarchy-1"}, {DVB_DVB_SRC_HIERARCHY_HIERARCHY_2, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_2", "hierarchy-2"}, {DVB_DVB_SRC_HIERARCHY_HIERARCHY_4, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_4", "hierarchy-4"}, {DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO", "hierarchy-auto"}, {0, NULL, NULL}};
		dvb_dvb_src_hierarchy_type_id = g_enum_register_static ("DVBDvbSrcHierarchy", values);
	}
	return dvb_dvb_src_hierarchy_type_id;
}



GType dvb_dvb_src_inversion_get_type (void) {
	static GType dvb_dvb_src_inversion_type_id = 0;
	if (G_UNLIKELY (dvb_dvb_src_inversion_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_INVERSION_INVERSION_OFF, "DVB_DVB_SRC_INVERSION_INVERSION_OFF", "inversion-off"}, {DVB_DVB_SRC_INVERSION_INVERSION_ON, "DVB_DVB_SRC_INVERSION_INVERSION_ON", "inversion-on"}, {DVB_DVB_SRC_INVERSION_INVERSION_AUTO, "DVB_DVB_SRC_INVERSION_INVERSION_AUTO", "inversion-auto"}, {0, NULL, NULL}};
		dvb_dvb_src_inversion_type_id = g_enum_register_static ("DVBDvbSrcInversion", values);
	}
	return dvb_dvb_src_inversion_type_id;
}


/**
     * @bandwith: 0, 6, 7 or 8
     */
DVBDvbSrcBandwidth dvb_get_bandwidth_val (guint bandwidth) {
	DVBDvbSrcBandwidth val;
	guint _tmp0;
	val = 0;
	_tmp0 = bandwidth;
	if (_tmp0 == 0)
	do {
		val = DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO;
		break;
	} while (0); else if (_tmp0 == 6)
	do {
		val = DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ;
		break;
	} while (0); else if (_tmp0 == 7)
	do {
		val = DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ;
		break;
	} while (0); else if (_tmp0 == 8)
	do {
		val = DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ;
		break;
	} while (0);
	return val;
}


/**
     * @hierarchy: 0, 1, 2 or 4.
     * If value doesn't match one of above HIERARCHY_AUTO is returned.
     */
DVBDvbSrcHierarchy dvb_get_hierarchy_val (guint hierarchy) {
	DVBDvbSrcHierarchy val;
	guint _tmp0;
	val = 0;
	_tmp0 = hierarchy;
	if (_tmp0 == 0)
	do {
		val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE;
		break;
	} while (0); else if (_tmp0 == 1)
	do {
		val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_1;
		break;
	} while (0); else if (_tmp0 == 2)
	do {
		val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_2;
		break;
	} while (0); else if (_tmp0 == 4)
	do {
		val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_4;
		break;
	} while (0); else
	do {
		val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO;
		break;
	} while (0);
	return val;
}


/**
     * @modulation: QPSK, QAM16, QAM32, QAM64, QAM128 or QAM256.
     * If value doesn't match one of above QAM_AUTO is returned.
     */
DVBDvbSrcModulation dvb_get_modulation_val (const char* constellation) {
	DVBDvbSrcModulation val;
	g_return_val_if_fail (constellation != NULL, 0);
	val = 0;
	if (_vala_strcmp0 (constellation, "QPSK") == 0) {
		val = DVB_DVB_SRC_MODULATION_QPSK;
	} else {
		if (_vala_strcmp0 (constellation, "QAM16") == 0) {
			val = DVB_DVB_SRC_MODULATION_QAM_16;
		} else {
			if (_vala_strcmp0 (constellation, "QAM32") == 0) {
				val = DVB_DVB_SRC_MODULATION_QAM_32;
			} else {
				if (_vala_strcmp0 (constellation, "QAM64") == 0) {
					val = DVB_DVB_SRC_MODULATION_QAM_64;
				} else {
					if (_vala_strcmp0 (constellation, "QAM128") == 0) {
						val = DVB_DVB_SRC_MODULATION_QAM_128;
					} else {
						if (_vala_strcmp0 (constellation, "QAM256") == 0) {
							val = DVB_DVB_SRC_MODULATION_QAM_256;
						} else {
							val = DVB_DVB_SRC_MODULATION_QAM_AUTO;
						}
					}
				}
			}
		}
	}
	return val;
}


/**
     * @code_rate_string: "NONE", 1/2", "2/3", "3/4", "4/5", "5/6", "6/7",
     * "7/8" or "8/9".
     * If value doesn't match one of above FEC_AUTO is returned.
     */
DVBDvbSrcCodeRate dvb_get_code_rate_val (const char* code_rate_string) {
	DVBDvbSrcCodeRate val;
	g_return_val_if_fail (code_rate_string != NULL, 0);
	val = 0;
	if (_vala_strcmp0 (code_rate_string, "NONE") == 0) {
		val = DVB_DVB_SRC_CODE_RATE_FEC_NONE;
	} else {
		if (_vala_strcmp0 (code_rate_string, "1/2") == 0) {
			val = DVB_DVB_SRC_CODE_RATE_FEC_1_2;
		} else {
			if (_vala_strcmp0 (code_rate_string, "2/3") == 0) {
				val = DVB_DVB_SRC_CODE_RATE_FEC_2_3;
			} else {
				if (_vala_strcmp0 (code_rate_string, "3/4") == 0) {
					val = DVB_DVB_SRC_CODE_RATE_FEC_3_4;
				} else {
					if (_vala_strcmp0 (code_rate_string, "4/5") == 0) {
						val = DVB_DVB_SRC_CODE_RATE_FEC_4_5;
					} else {
						if (_vala_strcmp0 (code_rate_string, "5/6") == 0) {
							val = DVB_DVB_SRC_CODE_RATE_FEC_5_6;
						} else {
							if (_vala_strcmp0 (code_rate_string, "6/7") == 0) {
								val = DVB_DVB_SRC_CODE_RATE_FEC_5_6;
							} else {
								if (_vala_strcmp0 (code_rate_string, "7/8") == 0) {
									val = DVB_DVB_SRC_CODE_RATE_FEC_7_8;
								} else {
									if (_vala_strcmp0 (code_rate_string, "8/9") == 0) {
										val = DVB_DVB_SRC_CODE_RATE_FEC_8_9;
									} else {
										val = DVB_DVB_SRC_CODE_RATE_FEC_AUTO;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	return val;
}


/**
     * @guard: 4, 8, 16 or 32.
     * If value doesn't match one of above GUARD_INTERVAL_AUTO is returned.
     */
DVBDvbSrcGuard dvb_get_guard_interval_val (guint guard) {
	DVBDvbSrcGuard val;
	guint _tmp0;
	val = 0;
	_tmp0 = guard;
	if (_tmp0 == 4)
	do {
		val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4;
		break;
	} while (0); else if (_tmp0 == 8)
	do {
		val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8;
		break;
	} while (0); else if (_tmp0 == 16)
	do {
		val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16;
		break;
	} while (0); else if (_tmp0 == 32)
	do {
		val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32;
		break;
	} while (0); else
	do {
		val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO;
		break;
	} while (0);
	return val;
}


/**
     * @transmode: "2k" or "8k"
     * If value doesn't match one of above TRANSMISSION_MODE_AUTO is returned.
     */
DVBDvbSrcTransmissionMode dvb_get_transmission_mode_val (const char* transmode) {
	DVBDvbSrcTransmissionMode val;
	g_return_val_if_fail (transmode != NULL, 0);
	val = 0;
	if (_vala_strcmp0 (transmode, "2k") == 0) {
		val = DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K;
	} else {
		if (_vala_strcmp0 (transmode, "8k") == 0) {
			val = DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K;
		} else {
			val = DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO;
		}
	}
	return val;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




