
#ifndef __SRC_CHANNEL_H__
#define __SRC_CHANNEL_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>

G_BEGIN_DECLS

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
typedef struct _DVBEventElement DVBEventElement;
typedef struct _DVBEventElementClass DVBEventElementClass;
typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannelPrivate DVBChannelPrivate;

struct _DVBChannel {
	GObject parent_instance;
	DVBChannelPrivate * priv;
};

struct _DVBChannelClass {
	GObjectClass parent_class;
	gboolean (*is_valid) (DVBChannel* self);
	gboolean (*on_same_transport_stream) (DVBChannel* self, DVBChannel* channel);
	void (*setup_dvb_source) (DVBChannel* self, GstElement* source);
	char* (*to_string) (DVBChannel* self);
};


gboolean dvb_channel_is_valid (DVBChannel* self);
gboolean dvb_channel_on_same_transport_stream (DVBChannel* self, DVBChannel* channel);
void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source);
char* dvb_channel_to_string (DVBChannel* self);
guint dvb_channel_get_Sid (DVBChannel* self);
void dvb_channel_set_Sid (DVBChannel* self, guint value);
const char* dvb_channel_get_Name (DVBChannel* self);
void dvb_channel_set_Name (DVBChannel* self, const char* value);
guint dvb_channel_get_TransportStreamId (DVBChannel* self);
void dvb_channel_set_TransportStreamId (DVBChannel* self, guint value);
const char* dvb_channel_get_Network (DVBChannel* self);
void dvb_channel_set_Network (DVBChannel* self, const char* value);
guint* dvb_channel_get_LogicalChannelNumber (DVBChannel* self);
void dvb_channel_set_LogicalChannelNumber (DVBChannel* self, guint* value);
guint dvb_channel_get_VideoPID (DVBChannel* self);
void dvb_channel_set_VideoPID (DVBChannel* self, guint value);
guint dvb_channel_get_AudioPID (DVBChannel* self);
void dvb_channel_set_AudioPID (DVBChannel* self, guint value);
guint dvb_channel_get_Frequency (DVBChannel* self);
void dvb_channel_set_Frequency (DVBChannel* self, guint value);
DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self);
GType dvb_channel_get_type (void);


G_END_DECLS

#endif
