
#ifndef __SRC_LIVETV_SERVER_H__
#define __SRC_LIVETV_SERVER_H__

#include <glib.h>
#include <glib-object.h>
#include <gst/rtsp-server/rtsp-server.h>
#include <gst/gst.h>
#include <gst/rtsp-server/rtsp-media.h>

G_BEGIN_DECLS


#define DVB_TYPE_SERVER (dvb_server_get_type ())
#define DVB_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SERVER, DVBServer))
#define DVB_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SERVER, DVBServerClass))
#define DVB_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SERVER))
#define DVB_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SERVER))
#define DVB_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SERVER, DVBServerClass))

typedef struct _DVBServer DVBServer;
typedef struct _DVBServerClass DVBServerClass;
typedef struct _DVBServerPrivate DVBServerPrivate;

/**
     * RTSP Server
     *
     * It listens on port 1554.
     * E.g. http://localhost:1554/3/514
     * will open the channel with sid 514 of device group 3
     */
struct _DVBServer {
	GstRTSPServer parent_instance;
	DVBServerPrivate * priv;
};

struct _DVBServerClass {
	GstRTSPServerClass parent_class;
};


DVBServer* dvb_server_construct (GType object_type);
DVBServer* dvb_server_new (void);
GType dvb_server_get_type (void);


G_END_DECLS

#endif
