
#include <src/ChannelListReader.h>
#include <stdlib.h>
#include <string.h>
#include <gee/collection.h>
#include "src/Utils.h"
#include "src/Channel.h"
#include "src/Terrestrial/TerrestrialChannel.h"
#include "src/MpegTsEnums.h"
#include "src/Satellite/SatelliteChannel.h"
#include "src/Cable/CableChannel.h"




struct _DVBChannelListReaderPrivate {
	GFile* _ChannelFile;
	DVBAdapterType _Type;
};

#define DVB_CHANNEL_LIST_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL_LIST_READER, DVBChannelListReaderPrivate))
enum  {
	DVB_CHANNEL_LIST_READER_DUMMY_PROPERTY,
	DVB_CHANNEL_LIST_READER_CHANNEL_FILE,
	DVB_CHANNEL_LIST_READER_TYPE
};
static DVBChannel* dvb_channel_list_reader_parse_line (DVBChannelListReader* self, const char* line);
static DVBTerrestrialChannel* dvb_channel_list_reader_parse_terrestrial_channel (const char* line);
static DVBSatelliteChannel* dvb_channel_list_reader_parse_satellite_channel (const char* line);
static DVBCableChannel* dvb_channel_list_reader_parse_cable_channel (const char* line);
static gint dvb_channel_list_reader_get_value_with_prefix (GType enumtype, const char* name, const char* prefix);
static void dvb_channel_list_reader_set_ChannelFile (DVBChannelListReader* self, GFile* value);
static void dvb_channel_list_reader_set_Type (DVBChannelListReader* self, DVBAdapterType value);
static gpointer dvb_channel_list_reader_parent_class = NULL;
static void dvb_channel_list_reader_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



DVBChannelListReader* dvb_channel_list_reader_construct (GType object_type, GFile* file, DVBAdapterType type) {
	GParameter * __params;
	GParameter * __params_it;
	DVBChannelListReader * self;
	g_return_val_if_fail (file != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "ChannelFile";
	g_value_init (&__params_it->value, G_TYPE_FILE);
	g_value_set_object (&__params_it->value, file);
	__params_it++;
	__params_it->name = "Type";
	g_value_init (&__params_it->value, DVB_TYPE_ADAPTER_TYPE);
	g_value_set_enum (&__params_it->value, type);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBChannelListReader* dvb_channel_list_reader_new (GFile* file, DVBAdapterType type) {
	return dvb_channel_list_reader_construct (DVB_TYPE_CHANNEL_LIST_READER, file, type);
}


DVBChannelList* dvb_channel_list_reader_read (DVBChannelListReader* self, GError** error) {
	GError * inner_error;
	char* contents;
	DVBChannelList* channels;
	DVBChannelList* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	inner_error = NULL;
	contents = dvb_utils_read_file_contents (self->priv->_ChannelFile, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (contents == NULL) {
		DVBChannelList* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = NULL, contents = (g_free (contents), NULL), _tmp0);
	}
	channels = dvb_channel_list_new (self->priv->_ChannelFile);
	{
		char** _tmp1;
		char** line_collection;
		int line_collection_length1;
		int line_it;
		_tmp1 = NULL;
		line_collection = _tmp1 = g_strsplit (contents, "\n", 0);
		line_collection_length1 = _vala_array_length (_tmp1);
		for (line_it = 0; line_it < _vala_array_length (_tmp1); line_it = line_it + 1) {
			const char* _tmp2;
			char* line;
			_tmp2 = NULL;
			line = (_tmp2 = line_collection[line_it], (_tmp2 == NULL) ? NULL : g_strdup (_tmp2));
			{
				if (strlen (line) > 0) {
					DVBChannel* c;
					c = dvb_channel_list_reader_parse_line (self, line);
					if (c != NULL) {
						dvb_channel_list_add (channels, c);
					} else {
						g_warning ("ChannelListReader.vala:27: Could not parse channel");
					}
					(c == NULL) ? NULL : (c = (g_object_unref (c), NULL));
				}
				line = (g_free (line), NULL);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp3 = NULL;
	return (_tmp3 = channels, contents = (g_free (contents), NULL), _tmp3);
}


static DVBChannel* dvb_channel_list_reader_parse_line (DVBChannelListReader* self, const char* line) {
	DVBChannel* c;
	DVBChannel* _tmp3;
	DVBChannel* _tmp4;
	DVBChannel* _tmp5;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	c = NULL;
	switch (self->priv->_Type) {
		case DVB_ADAPTER_TYPE_DVB_T:
		{
			DVBChannel* _tmp0;
			_tmp0 = NULL;
			c = (_tmp0 = (DVBChannel*) dvb_channel_list_reader_parse_terrestrial_channel (line), (c == NULL) ? NULL : (c = (g_object_unref (c), NULL)), _tmp0);
			break;
		}
		case DVB_ADAPTER_TYPE_DVB_S:
		{
			DVBChannel* _tmp1;
			_tmp1 = NULL;
			c = (_tmp1 = (DVBChannel*) dvb_channel_list_reader_parse_satellite_channel (line), (c == NULL) ? NULL : (c = (g_object_unref (c), NULL)), _tmp1);
			break;
		}
		case DVB_ADAPTER_TYPE_DVB_C:
		{
			DVBChannel* _tmp2;
			_tmp2 = NULL;
			c = (_tmp2 = (DVBChannel*) dvb_channel_list_reader_parse_cable_channel (line), (c == NULL) ? NULL : (c = (g_object_unref (c), NULL)), _tmp2);
			break;
		}
		default:
		{
			g_critical ("ChannelListReader.vala:50: Unknown adapter type");
			break;
		}
	}
	_tmp3 = NULL;
	if ((dvb_channel_is_valid (c))) {
		_tmp3 = c;
	} else {
		_tmp3 = NULL;
	}
	_tmp4 = NULL;
	_tmp5 = NULL;
	return (_tmp5 = (_tmp4 = _tmp3, (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4)), (c == NULL) ? NULL : (c = (g_object_unref (c), NULL)), _tmp5);
}


/**
         * @line: The line to parse
         * @returns: #TerrestrialChannel representing that line
         * 
         * A line looks like
         * Das Erste:212500000:INVERSION_AUTO:BANDWIDTH_7_MHZ:FEC_3_4:FEC_1_2:QAM_16:TRANSMISSION_MODE_8K:GUARD_INTERVAL_1_4:HIERARCHY_NONE:513:514:32
         */
static DVBTerrestrialChannel* dvb_channel_list_reader_parse_terrestrial_channel (const char* line) {
	DVBTerrestrialChannel* channel;
	char** _tmp1;
	gint fields_size;
	gint fields_length1;
	char** _tmp0;
	char** fields;
	gint i;
	char* val;
	char* _tmp3;
	const char* _tmp2;
	DVBTerrestrialChannel* _tmp4;
	g_return_val_if_fail (line != NULL, NULL);
	channel = dvb_terrestrial_channel_new ();
	_tmp1 = NULL;
	_tmp0 = NULL;
	fields = (_tmp1 = _tmp0 = g_strsplit (line, ":", 0), fields_length1 = _vala_array_length (_tmp0), fields_size = fields_length1, _tmp1);
	i = 0;
	val = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	while ((val = (_tmp3 = (_tmp2 = fields[i], (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), val = (g_free (val), NULL), _tmp3)) != NULL) {
		if (i == 0) {
			if (g_utf8_validate (val, -1, NULL)) {
				dvb_channel_set_Name ((DVBChannel*) channel, val);
			} else {
				g_warning ("ChannelListReader.vala:76: Bad UTF-8 encoded channel name");
				dvb_channel_set_Name ((DVBChannel*) channel, "Bad encoding");
			}
		} else {
			if (i == 1) {
				dvb_channel_set_Frequency ((DVBChannel*) channel, (guint) atoi (val));
			} else {
				if (i == 2) {
					dvb_terrestrial_channel_set_Inversion (channel, (DVBDvbSrcInversion) dvb_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_INVERSION, val, "DVB_DVB_SRC_INVERSION_"));
				} else {
					if (i == 3) {
						dvb_terrestrial_channel_set_Bandwidth (channel, (DVBDvbSrcBandwidth) dvb_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_BANDWIDTH, val, "DVB_DVB_SRC_BANDWIDTH_"));
					} else {
						if (i == 4) {
							dvb_terrestrial_channel_set_CodeRateHP (channel, (DVBDvbSrcCodeRate) dvb_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, val, "DVB_DVB_SRC_CODE_RATE_"));
						} else {
							if (i == 5) {
								dvb_terrestrial_channel_set_CodeRateLP (channel, (DVBDvbSrcCodeRate) dvb_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, val, "DVB_DVB_SRC_CODE_RATE_"));
							} else {
								if (i == 6) {
									dvb_terrestrial_channel_set_Constellation (channel, (DVBDvbSrcModulation) dvb_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_MODULATION, val, "DVB_DVB_SRC_MODULATION_"));
								} else {
									if (i == 7) {
										dvb_terrestrial_channel_set_TransmissionMode (channel, (DVBDvbSrcTransmissionMode) dvb_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_TRANSMISSION_MODE, val, "DVB_DVB_SRC_TRANSMISSION_MODE_"));
									} else {
										if (i == 8) {
											dvb_terrestrial_channel_set_GuardInterval (channel, (DVBDvbSrcGuard) dvb_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_GUARD, val, "DVB_DVB_SRC_GUARD_"));
										} else {
											if (i == 9) {
												dvb_terrestrial_channel_set_Hierarchy (channel, (DVBDvbSrcHierarchy) dvb_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_HIERARCHY, val, "DVB_DVB_SRC_HIERARCHY_"));
											} else {
												if (i == 10) {
													dvb_channel_set_VideoPID ((DVBChannel*) channel, (guint) atoi (val));
												} else {
													if (i == 11) {
														gee_collection_add ((GeeCollection*) dvb_channel_get_AudioPIDs ((DVBChannel*) channel), GUINT_TO_POINTER ((guint) atoi (val)));
													} else {
														if (i == 12) {
															dvb_channel_set_Sid ((DVBChannel*) channel, (guint) atoi (val));
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		i++;
	}
	_tmp4 = NULL;
	return (_tmp4 = channel, fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL), val = (g_free (val), NULL), _tmp4);
}


/**
         *
         * A line looks like
         * Das Erste:11836:h:0:27500:101:102:28106
         */
static DVBSatelliteChannel* dvb_channel_list_reader_parse_satellite_channel (const char* line) {
	DVBSatelliteChannel* channel;
	char** _tmp1;
	gint fields_size;
	gint fields_length1;
	char** _tmp0;
	char** fields;
	gint i;
	char* val;
	char* _tmp3;
	const char* _tmp2;
	DVBSatelliteChannel* _tmp4;
	g_return_val_if_fail (line != NULL, NULL);
	channel = dvb_satellite_channel_new ();
	_tmp1 = NULL;
	_tmp0 = NULL;
	fields = (_tmp1 = _tmp0 = g_strsplit (line, ":", 0), fields_length1 = _vala_array_length (_tmp0), fields_size = fields_length1, _tmp1);
	i = 0;
	val = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	while ((val = (_tmp3 = (_tmp2 = fields[i], (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), val = (g_free (val), NULL), _tmp3)) != NULL) {
		if (i == 0) {
			if (g_utf8_validate (val, -1, NULL)) {
				dvb_channel_set_Name ((DVBChannel*) channel, val);
			} else {
				g_warning ("ChannelListReader.vala:137: Bad UTF-8 encoded channel name");
				dvb_channel_set_Name ((DVBChannel*) channel, "Bad encoding");
			}
		} else {
			if (i == 1) {
				/* frequency is stored in MHz*/
				dvb_channel_set_Frequency ((DVBChannel*) channel, (guint) (atoi (val) * 1000));
			} else {
				if (i == 2) {
					dvb_satellite_channel_set_Polarization (channel, val);
				} else {
					if (i == 3) {
						/* Sat number*/
						dvb_satellite_channel_set_DiseqcSource (channel, atoi (val));
					} else {
						if (i == 4) {
							/* symbol rate is stored in kBaud*/
							dvb_satellite_channel_set_SymbolRate (channel, (guint) atoi (val));
						} else {
							if (i == 5) {
								dvb_channel_set_VideoPID ((DVBChannel*) channel, (guint) atoi (val));
							} else {
								if (i == 6) {
									gee_collection_add ((GeeCollection*) dvb_channel_get_AudioPIDs ((DVBChannel*) channel), GUINT_TO_POINTER ((guint) atoi (val)));
								} else {
									if (i == 7) {
										dvb_channel_set_Sid ((DVBChannel*) channel, (guint) atoi (val));
									}
								}
							}
						}
					}
				}
			}
		}
		i++;
	}
	_tmp4 = NULL;
	return (_tmp4 = channel, fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL), val = (g_free (val), NULL), _tmp4);
}


/**
         *
         * line looks like
         * ProSieben:330000000:INVERSION_AUTO:6900000:FEC_NONE:QAM_64:255:256:898
         */
static DVBCableChannel* dvb_channel_list_reader_parse_cable_channel (const char* line) {
	DVBCableChannel* channel;
	char** _tmp1;
	gint fields_size;
	gint fields_length1;
	char** _tmp0;
	char** fields;
	gint i;
	char* val;
	char* _tmp3;
	const char* _tmp2;
	DVBCableChannel* _tmp4;
	g_return_val_if_fail (line != NULL, NULL);
	channel = dvb_cable_channel_new ();
	_tmp1 = NULL;
	_tmp0 = NULL;
	fields = (_tmp1 = _tmp0 = g_strsplit (line, ":", 0), fields_length1 = _vala_array_length (_tmp0), fields_size = fields_length1, _tmp1);
	i = 0;
	val = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	while ((val = (_tmp3 = (_tmp2 = fields[i], (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), val = (g_free (val), NULL), _tmp3)) != NULL) {
		if (i == 0) {
			if (g_utf8_validate (val, -1, NULL)) {
				dvb_channel_set_Name ((DVBChannel*) channel, val);
			} else {
				g_warning ("ChannelListReader.vala:182: Bad UTF-8 encoded channel name");
				dvb_channel_set_Name ((DVBChannel*) channel, "Bad encoding");
			}
		} else {
			if (i == 1) {
				dvb_channel_set_Frequency ((DVBChannel*) channel, (guint) atoi (val));
			} else {
				if (i == 2) {
					dvb_cable_channel_set_Inversion (channel, (DVBDvbSrcInversion) dvb_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_INVERSION, val, "DVB_DVB_SRC_INVERSION_"));
				} else {
					if (i == 3) {
						dvb_cable_channel_set_SymbolRate (channel, (guint) atoi (val));
					} else {
						if (i == 4) {
							dvb_cable_channel_set_CodeRate (channel, (DVBDvbSrcCodeRate) dvb_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, val, "DVB_DVB_SRC_CODE_RATE_"));
						} else {
							if (i == 5) {
								dvb_cable_channel_set_Modulation (channel, (DVBDvbSrcModulation) dvb_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_MODULATION, val, "DVB_DVB_SRC_MODULATION_"));
							} else {
								if (i == 6) {
									dvb_channel_set_VideoPID ((DVBChannel*) channel, (guint) atoi (val));
								} else {
									if (i == 7) {
										gee_collection_add ((GeeCollection*) dvb_channel_get_AudioPIDs ((DVBChannel*) channel), GUINT_TO_POINTER ((guint) atoi (val)));
									} else {
										if (i == 8) {
											dvb_channel_set_Sid ((DVBChannel*) channel, (guint) atoi (val));
										}
									}
								}
							}
						}
					}
				}
			}
		}
		i++;
	}
	_tmp4 = NULL;
	return (_tmp4 = channel, fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL), val = (g_free (val), NULL), _tmp4);
}


static gint dvb_channel_list_reader_get_value_with_prefix (GType enumtype, const char* name, const char* prefix) {
	char* _tmp0;
	gint _tmp1;
	g_return_val_if_fail (name != NULL, 0);
	g_return_val_if_fail (prefix != NULL, 0);
	_tmp0 = NULL;
	return (_tmp1 = dvb_utils_get_value_by_name_from_enum (enumtype, _tmp0 = g_strconcat (prefix, name, NULL)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
}


GFile* dvb_channel_list_reader_get_ChannelFile (DVBChannelListReader* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_ChannelFile;
}


static void dvb_channel_list_reader_set_ChannelFile (DVBChannelListReader* self, GFile* value) {
	GFile* _tmp2;
	GFile* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_ChannelFile = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_ChannelFile == NULL) ? NULL : (self->priv->_ChannelFile = (g_object_unref (self->priv->_ChannelFile), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "ChannelFile");
}


DVBAdapterType dvb_channel_list_reader_get_Type (DVBChannelListReader* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_Type;
}


static void dvb_channel_list_reader_set_Type (DVBChannelListReader* self, DVBAdapterType value) {
	g_return_if_fail (self != NULL);
	self->priv->_Type = value;
	g_object_notify ((GObject *) self, "Type");
}


static void dvb_channel_list_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannelListReader * self;
	gpointer boxed;
	self = DVB_CHANNEL_LIST_READER (object);
	switch (property_id) {
		case DVB_CHANNEL_LIST_READER_CHANNEL_FILE:
		g_value_set_object (value, dvb_channel_list_reader_get_ChannelFile (self));
		break;
		case DVB_CHANNEL_LIST_READER_TYPE:
		g_value_set_enum (value, dvb_channel_list_reader_get_Type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_channel_list_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannelListReader * self;
	self = DVB_CHANNEL_LIST_READER (object);
	switch (property_id) {
		case DVB_CHANNEL_LIST_READER_CHANNEL_FILE:
		dvb_channel_list_reader_set_ChannelFile (self, g_value_get_object (value));
		break;
		case DVB_CHANNEL_LIST_READER_TYPE:
		dvb_channel_list_reader_set_Type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_channel_list_reader_class_init (DVBChannelListReaderClass * klass) {
	dvb_channel_list_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelListReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_channel_list_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_channel_list_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_list_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_READER_CHANNEL_FILE, g_param_spec_object ("ChannelFile", "ChannelFile", "ChannelFile", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_READER_TYPE, g_param_spec_enum ("Type", "Type", "Type", DVB_TYPE_ADAPTER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_channel_list_reader_instance_init (DVBChannelListReader * self) {
	self->priv = DVB_CHANNEL_LIST_READER_GET_PRIVATE (self);
}


static void dvb_channel_list_reader_finalize (GObject* obj) {
	DVBChannelListReader * self;
	self = DVB_CHANNEL_LIST_READER (obj);
	(self->priv->_ChannelFile == NULL) ? NULL : (self->priv->_ChannelFile = (g_object_unref (self->priv->_ChannelFile), NULL));
	G_OBJECT_CLASS (dvb_channel_list_reader_parent_class)->finalize (obj);
}


GType dvb_channel_list_reader_get_type (void) {
	static GType dvb_channel_list_reader_type_id = 0;
	if (dvb_channel_list_reader_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelListReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_list_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannelListReader), 0, (GInstanceInitFunc) dvb_channel_list_reader_instance_init, NULL };
		dvb_channel_list_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannelListReader", &g_define_type_info, 0);
	}
	return dvb_channel_list_reader_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




