
#ifndef __SRC_TERRESTRIAL_TERRESTRIALSCANNER_H__
#define __SRC_TERRESTRIAL_TERRESTRIALSCANNER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include "src/Scanner.h"
#include "src/Device.h"
#include "src/ScannedItem.h"
#include "src/Channel.h"
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS


#define DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER (dvb_id_bus_terrestrial_scanner_get_type ())
#define DVB_ID_BUS_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, DVBIDBusTerrestrialScanner))
#define DVB_IS_ID_BUS_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER))
#define DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, DVBIDBusTerrestrialScannerIface))

typedef struct _DVBIDBusTerrestrialScanner DVBIDBusTerrestrialScanner;
typedef struct _DVBIDBusTerrestrialScannerIface DVBIDBusTerrestrialScannerIface;

#define DVB_TYPE_TERRESTRIAL_SCANNER (dvb_terrestrial_scanner_get_type ())
#define DVB_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScanner))
#define DVB_TERRESTRIAL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScannerClass))
#define DVB_IS_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_SCANNER))
#define DVB_IS_TERRESTRIAL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_SCANNER))
#define DVB_TERRESTRIAL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScannerClass))

typedef struct _DVBTerrestrialScanner DVBTerrestrialScanner;
typedef struct _DVBTerrestrialScannerClass DVBTerrestrialScannerClass;
typedef struct _DVBTerrestrialScannerPrivate DVBTerrestrialScannerPrivate;

struct _DVBIDBusTerrestrialScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusTerrestrialScanner* self);
	void (*Destroy) (DVBIDBusTerrestrialScanner* self);
	gboolean (*WriteChannelsToFile) (DVBIDBusTerrestrialScanner* self, const char* path);
	void (*AddScanningData) (DVBIDBusTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard);
	gboolean (*AddScanningDataFromFile) (DVBIDBusTerrestrialScanner* self, const char* path);
};

struct _DVBTerrestrialScanner {
	DVBScanner parent_instance;
	DVBTerrestrialScannerPrivate * priv;
};

struct _DVBTerrestrialScannerClass {
	DVBScannerClass parent_class;
};


void dvb_id_bus_terrestrial_scanner_Run (DVBIDBusTerrestrialScanner* self);
void dvb_id_bus_terrestrial_scanner_Destroy (DVBIDBusTerrestrialScanner* self);
gboolean dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, const char* path);
void dvb_id_bus_terrestrial_scanner_AddScanningData (DVBIDBusTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard);
gboolean dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, const char* path);
void dvb_id_bus_terrestrial_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_id_bus_terrestrial_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_id_bus_terrestrial_scanner_get_type (void);
DVBIDBusTerrestrialScanner* dvb_id_bus_terrestrial_scanner_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DVBTerrestrialScanner* dvb_terrestrial_scanner_construct (GType object_type, DVBDevice* device);
DVBTerrestrialScanner* dvb_terrestrial_scanner_new (DVBDevice* device);
void dvb_terrestrial_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_terrestrial_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_terrestrial_scanner_get_type (void);


G_END_DECLS

#endif
