
#include <src/rtsp/MediaFactory.h>
#include <stdlib.h>
#include <string.h>
#include "src/EPGScanner.h"
#include "src/Manager.h"
#include "src/DeviceGroup.h"
#include "src/Device.h"
#include "src/ChannelList.h"
#include "src/Channel.h"




struct _DVBMediaFactoryPrivate {
	char* sid;
	GstBin* dvbrtpbin;
	DVBEPGScanner* epgscanner;
};

#define DVB_MEDIA_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactoryPrivate))
enum  {
	DVB_MEDIA_FACTORY_DUMMY_PROPERTY
};
static void _dvb_media_factory_on_dvbbasebin_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
static GstElement* dvb_media_factory_real_get_element (GstRTSPMediaFactory* base, GstRTSPUrl* url);
static void dvb_media_factory_on_dvbbasebin_pad_added (DVBMediaFactory* self, GstElement* elem, GstPad* pad);
static void dvb_media_factory_bus_watch_func (DVBMediaFactory* self, GstBus* bus, GstMessage* message);
static gpointer dvb_media_factory_parent_class = NULL;
static void dvb_media_factory_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _dvb_media_factory_on_dvbbasebin_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
	dvb_media_factory_on_dvbbasebin_pad_added (self, _sender, pad);
}


static GstElement* dvb_media_factory_real_get_element (GstRTSPMediaFactory* base, GstRTSPUrl* url) {
	DVBMediaFactory * self;
	guint sidnr;
	guint grpnr;
	char** _tmp1;
	gint path_elements_size;
	gint path_elements_length1;
	char** _tmp0;
	char** path_elements;
	gint i;
	char* elem;
	char* _tmp3;
	const char* _tmp2;
	DVBManager* _tmp4;
	DVBManager* manager;
	DVBDeviceGroup* devgrp;
	DVBEPGScanner* _tmp7;
	DVBEPGScanner* _tmp6;
	DVBDevice* free_dev;
	DVBChannel* channel;
	char* _tmp10;
	GstElement* dvbbasebin;
	GstElement* payload;
	GstBin* _tmp13;
	GstElement* _tmp14;
	GstElement* _tmp15;
	GstElement* _tmp16;
	GstElement* _tmp17;
	self = (DVBMediaFactory*) base;
	g_return_val_if_fail (url != NULL, NULL);
	sidnr = (guint) 0;
	grpnr = (guint) 0;
	_tmp1 = NULL;
	_tmp0 = NULL;
	path_elements = (_tmp1 = _tmp0 = g_strsplit (url->abspath, "/", 0), path_elements_length1 = _vala_array_length (_tmp0), path_elements_size = path_elements_length1, _tmp1);
	i = 0;
	elem = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	while ((elem = (_tmp3 = (_tmp2 = path_elements[i], (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), elem = (g_free (elem), NULL), _tmp3)) != NULL) {
		if (i == 1) {
			grpnr = (guint) atoi (elem);
		} else {
			if (i == 2) {
				sidnr = (guint) atoi (elem);
			}
		}
		i++;
	}
	_tmp4 = NULL;
	manager = (_tmp4 = dvb_manager_get_instance (), (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4));
	devgrp = dvb_manager_get_device_group_if_exists (manager, grpnr);
	if (devgrp == NULL) {
		GstElement* _tmp5;
		g_warning ("MediaFactory.vala:32: Unknown group %u", grpnr);
		_tmp5 = NULL;
		return (_tmp5 = NULL, path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL), elem = (g_free (elem), NULL), (manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL)), (devgrp == NULL) ? NULL : (devgrp = (g_object_unref (devgrp), NULL)), _tmp5);
	}
	/* Stop EPG scanner*/
	_tmp7 = NULL;
	_tmp6 = NULL;
	self->priv->epgscanner = (_tmp7 = (_tmp6 = dvb_device_group_get_epgscanner (devgrp), (_tmp6 == NULL) ? NULL : g_object_ref (_tmp6)), (self->priv->epgscanner == NULL) ? NULL : (self->priv->epgscanner = (g_object_unref (self->priv->epgscanner), NULL)), _tmp7);
	if (self->priv->epgscanner != NULL) {
		dvb_epg_scanner_stop (self->priv->epgscanner);
	}
	free_dev = dvb_device_group_get_next_free_device (devgrp);
	if (free_dev == NULL) {
		GstElement* _tmp8;
		g_warning ("MediaFactory.vala:42: All devices of group %u are currently busy", grpnr);
		_tmp8 = NULL;
		return (_tmp8 = NULL, path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL), elem = (g_free (elem), NULL), (manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL)), (devgrp == NULL) ? NULL : (devgrp = (g_object_unref (devgrp), NULL)), (free_dev == NULL) ? NULL : (free_dev = (g_object_unref (free_dev), NULL)), _tmp8);
	}
	channel = dvb_channel_list_get_channel (dvb_device_get_Channels (free_dev), sidnr);
	if (channel == NULL) {
		GstElement* _tmp9;
		g_warning ("MediaFactory.vala:48: No channel %u in group %u", sidnr, grpnr);
		_tmp9 = NULL;
		return (_tmp9 = NULL, path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL), elem = (g_free (elem), NULL), (manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL)), (devgrp == NULL) ? NULL : (devgrp = (g_object_unref (devgrp), NULL)), (free_dev == NULL) ? NULL : (free_dev = (g_object_unref (free_dev), NULL)), (channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL)), _tmp9);
	}
	_tmp10 = NULL;
	self->priv->sid = (_tmp10 = g_strdup_printf ("%u", sidnr), self->priv->sid = (g_free (self->priv->sid), NULL), _tmp10);
	/*
	          FIXME: We need a way to get to the pipeline
	            Gst.Bus bus = pipeline.get_bus();
	            bus.add_signal_watch();
	            bus.message += this.bus_watch_func;
	          */
	dvbbasebin = gst_element_factory_make ("dvbbasebin", "dvbbasebin");
	if (dvbbasebin == NULL) {
		GstElement* _tmp11;
		g_critical ("MediaFactory.vala:62: Could not create dvbbasebin element");
		_tmp11 = NULL;
		return (_tmp11 = NULL, path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL), elem = (g_free (elem), NULL), (manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL)), (devgrp == NULL) ? NULL : (devgrp = (g_object_unref (devgrp), NULL)), (free_dev == NULL) ? NULL : (free_dev = (g_object_unref (free_dev), NULL)), (channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL)), (dvbbasebin == NULL) ? NULL : (dvbbasebin = (gst_object_unref (dvbbasebin), NULL)), _tmp11);
	}
	g_signal_connect_object (dvbbasebin, "pad-added", (GCallback) _dvb_media_factory_on_dvbbasebin_pad_added_gst_element_pad_added, self, 0);
	dvb_channel_setup_dvb_source (channel, dvbbasebin);
	payload = gst_element_factory_make ("rtpmp2tpay", "pay0");
	if (payload == NULL) {
		GstElement* _tmp12;
		g_critical ("MediaFactory.vala:71: Could not create rtpmp2tpay element");
		_tmp12 = NULL;
		return (_tmp12 = NULL, path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL), elem = (g_free (elem), NULL), (manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL)), (devgrp == NULL) ? NULL : (devgrp = (g_object_unref (devgrp), NULL)), (free_dev == NULL) ? NULL : (free_dev = (g_object_unref (free_dev), NULL)), (channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL)), (dvbbasebin == NULL) ? NULL : (dvbbasebin = (gst_object_unref (dvbbasebin), NULL)), (payload == NULL) ? NULL : (payload = (gst_object_unref (payload), NULL)), _tmp12);
	}
	_tmp13 = NULL;
	self->priv->dvbrtpbin = (_tmp13 = (GstBin*) gst_bin_new ("dvbrtpbin"), (self->priv->dvbrtpbin == NULL) ? NULL : (self->priv->dvbrtpbin = (gst_object_unref (self->priv->dvbrtpbin), NULL)), _tmp13);
	_tmp14 = NULL;
	gst_bin_add (self->priv->dvbrtpbin, (_tmp14 = dvbbasebin, (_tmp14 == NULL) ? NULL : gst_object_ref (_tmp14)));
	_tmp15 = NULL;
	gst_bin_add (self->priv->dvbrtpbin, (_tmp15 = payload, (_tmp15 == NULL) ? NULL : gst_object_ref (_tmp15)));
	g_object_set ((GObject*) dvbbasebin, "program-numbers", self->priv->sid, NULL);
	g_object_set ((GObject*) dvbbasebin, "adapter", dvb_device_get_Adapter (free_dev), NULL);
	g_object_set ((GObject*) dvbbasebin, "frontend", dvb_device_get_Frontend (free_dev), NULL);
	_tmp16 = NULL;
	_tmp17 = NULL;
	return (_tmp17 = (_tmp16 = (GstElement*) self->priv->dvbrtpbin, (_tmp16 == NULL) ? NULL : gst_object_ref (_tmp16)), path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL), elem = (g_free (elem), NULL), (manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL)), (devgrp == NULL) ? NULL : (devgrp = (g_object_unref (devgrp), NULL)), (free_dev == NULL) ? NULL : (free_dev = (g_object_unref (free_dev), NULL)), (channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL)), (dvbbasebin == NULL) ? NULL : (dvbbasebin = (gst_object_unref (dvbbasebin), NULL)), (payload == NULL) ? NULL : (payload = (gst_object_unref (payload), NULL)), _tmp17);
}


static void dvb_media_factory_on_dvbbasebin_pad_added (DVBMediaFactory* self, GstElement* elem, GstPad* pad) {
	char* _tmp0;
	char* program;
	char* _tmp1;
	gboolean _tmp2;
	g_return_if_fail (self != NULL);
	g_return_if_fail (elem != NULL);
	g_return_if_fail (pad != NULL);
	_tmp0 = NULL;
	g_debug ("MediaFactory.vala:87: Pad %s added", _tmp0 = gst_object_get_name ((GstObject*) pad));
	_tmp0 = (g_free (_tmp0), NULL);
	program = g_strdup_printf ("program_%s", self->priv->sid);
	_tmp1 = NULL;
	if ((_tmp2 = _vala_strcmp0 (_tmp1 = gst_object_get_name ((GstObject*) pad), program) == 0, _tmp1 = (g_free (_tmp1), NULL), _tmp2)) {
		char* sink_name;
		GstElement* sink;
		char* _tmp4;
		sink_name = g_strdup ("pay0");
		sink = gst_bin_get_by_name ((GST_BIN (self->priv->dvbrtpbin)), sink_name);
		if (sink == NULL) {
			g_critical ("MediaFactory.vala:95: No element with name %s", sink_name);
		} else {
			GstPad* _tmp3;
			GstPad* sinkpad;
			GstPadLinkReturn rc;
			/* Link dvbbasebin and rtpmp2tpay*/
			_tmp3 = NULL;
			sinkpad = (_tmp3 = gst_element_get_pad (sink, "sink"), (_tmp3 == NULL) ? NULL : gst_object_ref (_tmp3));
			rc = gst_pad_link (pad, sinkpad);
			if (rc != GST_PAD_LINK_OK) {
				g_critical ("MediaFactory.vala:102: Could not link pads");
			}
			g_debug ("MediaFactory.vala:104: Src pad %s linked with sink pad %s", program, sink_name);
			(sinkpad == NULL) ? NULL : (sinkpad = (gst_object_unref (sinkpad), NULL));
		}
		_tmp4 = NULL;
		self->priv->sid = (_tmp4 = NULL, self->priv->sid = (g_free (self->priv->sid), NULL), _tmp4);
		sink_name = (g_free (sink_name), NULL);
		(sink == NULL) ? NULL : (sink = (gst_object_unref (sink), NULL));
	}
	program = (g_free (program), NULL);
}


static void dvb_media_factory_bus_watch_func (DVBMediaFactory* self, GstBus* bus, GstMessage* message) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus != NULL);
	g_return_if_fail (message != NULL);
	switch (message->type) {
		case GST_MESSAGE_ELEMENT:
		{
			const char* _tmp0;
			char* structure_name;
			_tmp0 = NULL;
			structure_name = (_tmp0 = gst_structure_get_name (message->structure), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
			if (_vala_strcmp0 (structure_name, "eit") == 0) {
				if (self->priv->epgscanner != NULL) {
					dvb_epg_scanner_on_eit_structure (self->priv->epgscanner, message->structure);
				}
			}
			structure_name = (g_free (structure_name), NULL);
			break;
		}
		case GST_MESSAGE_STATE_CHANGED:
		{
			gint enumval;
			enumval = 0;
			gst_structure_get_enum (message->structure, "new-state", GST_TYPE_STATE, &enumval);
			if (enumval == GST_STATE_NULL) {
				char* _tmp1;
				DVBEPGScanner* _tmp2;
				g_debug ("MediaFactory.vala:126: Pipeline stopped");
				_tmp1 = NULL;
				self->priv->sid = (_tmp1 = NULL, self->priv->sid = (g_free (self->priv->sid), NULL), _tmp1);
				/* Start EPG scanner again*/
				if (self->priv->epgscanner != NULL) {
					dvb_epg_scanner_start (self->priv->epgscanner);
				}
				_tmp2 = NULL;
				self->priv->epgscanner = (_tmp2 = NULL, (self->priv->epgscanner == NULL) ? NULL : (self->priv->epgscanner = (g_object_unref (self->priv->epgscanner), NULL)), _tmp2);
			}
			break;
		}
	}
}


DVBMediaFactory* dvb_media_factory_construct (GType object_type) {
	DVBMediaFactory * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBMediaFactory* dvb_media_factory_new (void) {
	return dvb_media_factory_construct (DVB_TYPE_MEDIA_FACTORY);
}


static void dvb_media_factory_class_init (DVBMediaFactoryClass * klass) {
	dvb_media_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBMediaFactoryPrivate));
	G_OBJECT_CLASS (klass)->finalize = dvb_media_factory_finalize;
	GST_RTSP_MEDIA_FACTORY_CLASS (klass)->get_element = dvb_media_factory_real_get_element;
}


static void dvb_media_factory_instance_init (DVBMediaFactory * self) {
	self->priv = DVB_MEDIA_FACTORY_GET_PRIVATE (self);
}


static void dvb_media_factory_finalize (GObject* obj) {
	DVBMediaFactory * self;
	self = DVB_MEDIA_FACTORY (obj);
	self->priv->sid = (g_free (self->priv->sid), NULL);
	(self->priv->dvbrtpbin == NULL) ? NULL : (self->priv->dvbrtpbin = (gst_object_unref (self->priv->dvbrtpbin), NULL));
	(self->priv->epgscanner == NULL) ? NULL : (self->priv->epgscanner = (g_object_unref (self->priv->epgscanner), NULL));
	G_OBJECT_CLASS (dvb_media_factory_parent_class)->finalize (obj);
}


GType dvb_media_factory_get_type (void) {
	static GType dvb_media_factory_type_id = 0;
	if (dvb_media_factory_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaFactory), 0, (GInstanceInitFunc) dvb_media_factory_instance_init, NULL };
		dvb_media_factory_type_id = g_type_register_static (GST_TYPE_RTSP_MEDIA_FACTORY, "DVBMediaFactory", &g_define_type_info, 0);
	}
	return dvb_media_factory_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




