
#include <src/ScannedItem.h>




struct _DVBScannedItemPrivate {
	guint _Frequency;
};

#define DVB_SCANNED_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCANNED_ITEM, DVBScannedItemPrivate))
enum  {
	DVB_SCANNED_ITEM_DUMMY_PROPERTY,
	DVB_SCANNED_ITEM_FREQUENCY
};
#define DVB_SCANNED_ITEM_PRIME 31
static void dvb_scanned_item_set_Frequency (DVBScannedItem* self, guint value);
static gpointer dvb_scanned_item_parent_class = NULL;
static void dvb_scanned_item_finalize (GObject* obj);
struct _DVBScannedSatteliteItemPrivate {
	char* _Polarization;
};

#define DVB_SCANNED_SATTELITE_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemPrivate))
enum  {
	DVB_SCANNED_SATTELITE_ITEM_DUMMY_PROPERTY,
	DVB_SCANNED_SATTELITE_ITEM_POLARIZATION
};
static void dvb_scanned_sattelite_item_set_Polarization (DVBScannedSatteliteItem* self, const char* value);
static gpointer dvb_scanned_sattelite_item_parent_class = NULL;
static void dvb_scanned_sattelite_item_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



DVBScannedItem* dvb_scanned_item_construct (GType object_type, guint frequency) {
	GParameter * __params;
	GParameter * __params_it;
	DVBScannedItem * self;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "Frequency";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, frequency);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBScannedItem* dvb_scanned_item_new (guint frequency) {
	return dvb_scanned_item_construct (DVB_TYPE_SCANNED_ITEM, frequency);
}


guint dvb_scanned_item_hash (DVBScannedItem* o) {
	guint hashval;
	hashval = 0U;
	/* Most specific class first*/
	if (DVB_IS_SCANNED_SATTELITE_ITEM (o)) {
		hashval = ((2 * DVB_SCANNED_ITEM_PRIME) + (DVB_SCANNED_ITEM_PRIME * o->priv->_Frequency)) + g_str_hash (dvb_scanned_sattelite_item_get_Polarization (DVB_SCANNED_SATTELITE_ITEM (o)));
	} else {
		if (DVB_IS_SCANNED_ITEM (o)) {
			hashval = o->priv->_Frequency;
		} else {
			hashval = (guint) 0;
		}
	}
	return hashval;
}


gboolean dvb_scanned_item_equal (DVBScannedItem* o1, DVBScannedItem* o2) {
	gboolean _tmp0;
	_tmp0 = FALSE;
	if (o1 == NULL) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = o2 == NULL;
	}
	if (_tmp0) {
		return FALSE;
	}
	if (_vala_strcmp0 (g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) o1)), g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) o2))) != 0) {
		return FALSE;
	}
	if (DVB_IS_SCANNED_SATTELITE_ITEM (o1)) {
		DVBScannedSatteliteItem* _tmp3;
		DVBScannedSatteliteItem* item1;
		DVBScannedSatteliteItem* _tmp4;
		DVBScannedSatteliteItem* item2;
		gboolean _tmp5;
		gboolean _tmp6;
		_tmp3 = NULL;
		item1 = (_tmp3 = DVB_SCANNED_SATTELITE_ITEM (o1), (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3));
		_tmp4 = NULL;
		item2 = (_tmp4 = DVB_SCANNED_SATTELITE_ITEM (o2), (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4));
		_tmp5 = FALSE;
		if (DVB_SCANNED_ITEM (item1)->priv->_Frequency == DVB_SCANNED_ITEM (item2)->priv->_Frequency) {
			_tmp5 = _vala_strcmp0 (dvb_scanned_sattelite_item_get_Polarization (item1), dvb_scanned_sattelite_item_get_Polarization (item2)) == 0;
		} else {
			_tmp5 = FALSE;
		}
		return (_tmp6 = _tmp5, (item1 == NULL) ? NULL : (item1 = (g_object_unref (item1), NULL)), (item2 == NULL) ? NULL : (item2 = (g_object_unref (item2), NULL)), _tmp6);
	} else {
		if (DVB_IS_SCANNED_ITEM (o1)) {
			DVBScannedItem* _tmp7;
			DVBScannedItem* item1;
			DVBScannedItem* _tmp8;
			DVBScannedItem* item2;
			gboolean _tmp9;
			_tmp7 = NULL;
			item1 = (_tmp7 = DVB_SCANNED_ITEM (o1), (_tmp7 == NULL) ? NULL : g_object_ref (_tmp7));
			_tmp8 = NULL;
			item2 = (_tmp8 = DVB_SCANNED_ITEM (o2), (_tmp8 == NULL) ? NULL : g_object_ref (_tmp8));
			return (_tmp9 = item1->priv->_Frequency == item2->priv->_Frequency, (item1 == NULL) ? NULL : (item1 = (g_object_unref (item1), NULL)), (item2 == NULL) ? NULL : (item2 = (g_object_unref (item2), NULL)), _tmp9);
		} else {
			g_critical ("ScannedItem.vala:49: Don't comparing ScannedItem instances");
			return FALSE;
		}
	}
}


guint dvb_scanned_item_get_Frequency (DVBScannedItem* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_Frequency;
}


static void dvb_scanned_item_set_Frequency (DVBScannedItem* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Frequency = value;
	g_object_notify ((GObject *) self, "Frequency");
}


static void dvb_scanned_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBScannedItem * self;
	gpointer boxed;
	self = DVB_SCANNED_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_ITEM_FREQUENCY:
		g_value_set_uint (value, dvb_scanned_item_get_Frequency (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_scanned_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBScannedItem * self;
	self = DVB_SCANNED_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_ITEM_FREQUENCY:
		dvb_scanned_item_set_Frequency (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_scanned_item_class_init (DVBScannedItemClass * klass) {
	dvb_scanned_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBScannedItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_scanned_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_scanned_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_scanned_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNED_ITEM_FREQUENCY, g_param_spec_uint ("Frequency", "Frequency", "Frequency", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_scanned_item_instance_init (DVBScannedItem * self) {
	self->priv = DVB_SCANNED_ITEM_GET_PRIVATE (self);
}


static void dvb_scanned_item_finalize (GObject* obj) {
	DVBScannedItem * self;
	self = DVB_SCANNED_ITEM (obj);
	G_OBJECT_CLASS (dvb_scanned_item_parent_class)->finalize (obj);
}


GType dvb_scanned_item_get_type (void) {
	static GType dvb_scanned_item_type_id = 0;
	if (dvb_scanned_item_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScannedItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_scanned_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBScannedItem), 0, (GInstanceInitFunc) dvb_scanned_item_instance_init, NULL };
		dvb_scanned_item_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBScannedItem", &g_define_type_info, 0);
	}
	return dvb_scanned_item_type_id;
}


DVBScannedSatteliteItem* dvb_scanned_sattelite_item_construct (GType object_type, guint frequency, const char* polarization) {
	GParameter * __params;
	GParameter * __params_it;
	DVBScannedSatteliteItem * self;
	g_return_val_if_fail (polarization != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "Frequency";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, frequency);
	__params_it++;
	__params_it->name = "Polarization";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, polarization);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBScannedSatteliteItem* dvb_scanned_sattelite_item_new (guint frequency, const char* polarization) {
	return dvb_scanned_sattelite_item_construct (DVB_TYPE_SCANNED_SATTELITE_ITEM, frequency, polarization);
}


const char* dvb_scanned_sattelite_item_get_Polarization (DVBScannedSatteliteItem* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_Polarization;
}


static void dvb_scanned_sattelite_item_set_Polarization (DVBScannedSatteliteItem* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_Polarization = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_Polarization = (g_free (self->priv->_Polarization), NULL), _tmp2);
	g_object_notify ((GObject *) self, "Polarization");
}


static void dvb_scanned_sattelite_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBScannedSatteliteItem * self;
	gpointer boxed;
	self = DVB_SCANNED_SATTELITE_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_SATTELITE_ITEM_POLARIZATION:
		g_value_set_string (value, dvb_scanned_sattelite_item_get_Polarization (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_scanned_sattelite_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBScannedSatteliteItem * self;
	self = DVB_SCANNED_SATTELITE_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_SATTELITE_ITEM_POLARIZATION:
		dvb_scanned_sattelite_item_set_Polarization (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_scanned_sattelite_item_class_init (DVBScannedSatteliteItemClass * klass) {
	dvb_scanned_sattelite_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBScannedSatteliteItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_scanned_sattelite_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_scanned_sattelite_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_scanned_sattelite_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNED_SATTELITE_ITEM_POLARIZATION, g_param_spec_string ("Polarization", "Polarization", "Polarization", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_scanned_sattelite_item_instance_init (DVBScannedSatteliteItem * self) {
	self->priv = DVB_SCANNED_SATTELITE_ITEM_GET_PRIVATE (self);
}


static void dvb_scanned_sattelite_item_finalize (GObject* obj) {
	DVBScannedSatteliteItem * self;
	self = DVB_SCANNED_SATTELITE_ITEM (obj);
	self->priv->_Polarization = (g_free (self->priv->_Polarization), NULL);
	G_OBJECT_CLASS (dvb_scanned_sattelite_item_parent_class)->finalize (obj);
}


GType dvb_scanned_sattelite_item_get_type (void) {
	static GType dvb_scanned_sattelite_item_type_id = 0;
	if (dvb_scanned_sattelite_item_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScannedSatteliteItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_scanned_sattelite_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBScannedSatteliteItem), 0, (GInstanceInitFunc) dvb_scanned_sattelite_item_instance_init, NULL };
		dvb_scanned_sattelite_item_type_id = g_type_register_static (DVB_TYPE_SCANNED_ITEM, "DVBScannedSatteliteItem", &g_define_type_info, 0);
	}
	return dvb_scanned_sattelite_item_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




