/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_IDBUSMANAGER_H__
#define __SRC_IDBUSMANAGER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

G_BEGIN_DECLS


#define DVB_TYPE_ID_BUS_MANAGER (dvb_id_bus_manager_get_type ())
#define DVB_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManager))
#define DVB_IS_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_MANAGER))
#define DVB_ID_BUS_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManagerIface))

typedef struct _DVBIDBusManager DVBIDBusManager;
typedef struct _DVBIDBusManagerIface DVBIDBusManagerIface;

struct _DVBIDBusManagerIface {
	GTypeInterface parent_iface;
	char** (*GetScannerForDevice) (DVBIDBusManager* self, guint adapter, guint frontend, int* result_length1);
	guint* (*GetRegisteredDeviceGroups) (DVBIDBusManager* self, int* result_length1);
	char* (*GetTypeOfDeviceGroup) (DVBIDBusManager* self, guint group_id);
	char* (*GetRecorder) (DVBIDBusManager* self, guint group_id);
	gboolean (*AddDeviceToNewGroup) (DVBIDBusManager* self, guint adapter, guint frontend, const char* channels_conf, const char* recordings_dir, const char* name);
	gboolean (*AddDeviceToExistingGroup) (DVBIDBusManager* self, guint adapter, guint frontend, guint group_id);
	gboolean (*RemoveDeviceFromGroup) (DVBIDBusManager* self, guint adapter, guint frontend, guint group_id);
	char* (*GetDeviceGroupName) (DVBIDBusManager* self, guint group_id);
	char* (*GetChannelList) (DVBIDBusManager* self, guint group_id);
	char** (*GetDeviceGroupMembers) (DVBIDBusManager* self, guint group_id, int* result_length1);
	char* (*GetNameOfRegisteredDevice) (DVBIDBusManager* self, guint adapter, guint frontend);
	char* (*GetSchedule) (DVBIDBusManager* self, guint group_id, guint channel_sid);
};


char** dvb_id_bus_manager_GetScannerForDevice (DVBIDBusManager* self, guint adapter, guint frontend, int* result_length1);
guint* dvb_id_bus_manager_GetRegisteredDeviceGroups (DVBIDBusManager* self, int* result_length1);
char* dvb_id_bus_manager_GetTypeOfDeviceGroup (DVBIDBusManager* self, guint group_id);
char* dvb_id_bus_manager_GetRecorder (DVBIDBusManager* self, guint group_id);
gboolean dvb_id_bus_manager_AddDeviceToNewGroup (DVBIDBusManager* self, guint adapter, guint frontend, const char* channels_conf, const char* recordings_dir, const char* name);
gboolean dvb_id_bus_manager_AddDeviceToExistingGroup (DVBIDBusManager* self, guint adapter, guint frontend, guint group_id);
gboolean dvb_id_bus_manager_RemoveDeviceFromGroup (DVBIDBusManager* self, guint adapter, guint frontend, guint group_id);
char* dvb_id_bus_manager_GetDeviceGroupName (DVBIDBusManager* self, guint group_id);
char* dvb_id_bus_manager_GetChannelList (DVBIDBusManager* self, guint group_id);
char** dvb_id_bus_manager_GetDeviceGroupMembers (DVBIDBusManager* self, guint group_id, int* result_length1);
char* dvb_id_bus_manager_GetNameOfRegisteredDevice (DVBIDBusManager* self, guint adapter, guint frontend);
char* dvb_id_bus_manager_GetSchedule (DVBIDBusManager* self, guint group_id, guint channel_sid);
void dvb_id_bus_manager_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_id_bus_manager_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_id_bus_manager_get_type (void);
DVBIDBusManager* dvb_id_bus_manager_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);


G_END_DECLS

#endif
