/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <src/Recording.h>
#include <stdio.h>
#include "src/Utils.h"




struct _DVBRecordingPrivate {
	guint32 _Id;
	guint _ChannelSid;
	char* _ChannelName;
	GFile* _Location;
	char* _Name;
	char* _Description;
	struct tm _StartTime;
	gint64 _Length;
};

#define DVB_RECORDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_RECORDING, DVBRecordingPrivate))
enum  {
	DVB_RECORDING_DUMMY_PROPERTY,
	DVB_RECORDING_ID,
	DVB_RECORDING_CHANNEL_SID,
	DVB_RECORDING_CHANNEL_NAME,
	DVB_RECORDING_LOCATION,
	DVB_RECORDING_NAME,
	DVB_RECORDING_DESCRIPTION,
	DVB_RECORDING_LENGTH
};
static gpointer dvb_recording_parent_class = NULL;
static void dvb_recording_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



guint* dvb_recording_get_start (DVBRecording* self, int* result_length1) {
	guint* _tmp0;
	guint* _tmp1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = (_tmp0 = g_new0 (guint, 5), _tmp0[0] = (guint) (self->priv->_StartTime.tm_year + 1900), _tmp0[1] = (guint) (self->priv->_StartTime.tm_mon + 1), _tmp0[2] = (guint) self->priv->_StartTime.tm_mday, _tmp0[3] = (guint) self->priv->_StartTime.tm_hour, _tmp0[4] = (guint) self->priv->_StartTime.tm_min, _tmp0), *result_length1 = 5, _tmp1);
}


/**
         * Stores all information of the timer in info.rec
         * in the directory of this.Location
         */
void dvb_recording_save_to_disk (DVBRecording* self, GError** error) {
	GError * inner_error;
	GFile* parentdir;
	GFile* recfile;
	char* _tmp0;
	GFileOutputStream* stream;
	char* text;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	parentdir = g_file_get_parent (self->priv->_Location);
	recfile = g_file_get_child (parentdir, "info.rec");
	_tmp0 = NULL;
	g_debug ("Recording.vala:57: Saving recording to %s", _tmp0 = g_file_get_path (recfile));
	_tmp0 = (g_free (_tmp0), NULL);
	if (g_file_query_exists (recfile, NULL)) {
		g_debug ("Recording.vala:60: Deleting old info.rec");
		g_file_delete (recfile, NULL, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(parentdir == NULL) ? NULL : (parentdir = (g_object_unref (parentdir), NULL));
			(recfile == NULL) ? NULL : (recfile = (g_object_unref (recfile), NULL));
			return;
		}
	}
	stream = g_file_create (recfile, 0, NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(parentdir == NULL) ? NULL : (parentdir = (g_object_unref (parentdir), NULL));
		(recfile == NULL) ? NULL : (recfile = (g_object_unref (recfile), NULL));
		return;
	}
	text = dvb_recording_serialize (self);
	g_output_stream_write ((GOutputStream*) stream, text, (gsize) strlen (text), NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(parentdir == NULL) ? NULL : (parentdir = (g_object_unref (parentdir), NULL));
		(recfile == NULL) ? NULL : (recfile = (g_object_unref (recfile), NULL));
		(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
		text = (g_free (text), NULL);
		return;
	}
	g_output_stream_close ((GOutputStream*) stream, NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(parentdir == NULL) ? NULL : (parentdir = (g_object_unref (parentdir), NULL));
		(recfile == NULL) ? NULL : (recfile = (g_object_unref (recfile), NULL));
		(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
		text = (g_free (text), NULL);
		return;
	}
	(parentdir == NULL) ? NULL : (parentdir = (g_object_unref (parentdir), NULL));
	(recfile == NULL) ? NULL : (recfile = (g_object_unref (recfile), NULL));
	(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
	text = (g_free (text), NULL);
}


char* dvb_recording_serialize (DVBRecording* self) {
	guint* _tmp1;
	gint started_size;
	gint started_length1;
	gint _tmp0;
	guint* started;
	const char* _tmp2;
	const char* _tmp3;
	char* _tmp4;
	char* _tmp5;
	char* _tmp6;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1 = NULL;
	started = (_tmp1 = dvb_recording_get_start (self, &_tmp0), started_length1 = _tmp0, started_size = started_length1, _tmp1);
	_tmp2 = NULL;
	if (self->priv->_Name == NULL) {
		_tmp2 = "";
	} else {
		_tmp2 = self->priv->_Name;
	}
	_tmp3 = NULL;
	if (self->priv->_Description == NULL) {
		_tmp3 = "";
	} else {
		_tmp3 = self->priv->_Description;
	}
	_tmp4 = NULL;
	_tmp5 = NULL;
	_tmp6 = NULL;
	return (_tmp6 = (_tmp5 = g_strdup_printf ("%u\n%s\n%s\n%u-%u-%u %u:%u\n%" G_GINT64_FORMAT "\n%s\n%s", self->priv->_Id, self->priv->_ChannelName, _tmp4 = g_file_get_path (self->priv->_Location), started[0], started[1], started[2], started[3], started[4], self->priv->_Length, _tmp2, _tmp3), _tmp4 = (g_free (_tmp4), NULL), _tmp5), started = (g_free (started), NULL), _tmp6);
}


/* TODO throw error*/
DVBRecording* dvb_recording_deserialize (GFile* file, GError** error) {
	GError * inner_error;
	char* contents;
	char** _tmp2;
	gint fields_size;
	gint fields_length1;
	char** _tmp1;
	char** fields;
	DVBRecording* rec;
	char* field;
	gint i;
	char* _tmp4;
	const char* _tmp3;
	DVBRecording* _tmp12;
	g_return_val_if_fail (file != NULL, NULL);
	inner_error = NULL;
	contents = dvb_utils_read_file_contents (file, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (contents == NULL) {
		DVBRecording* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = NULL, contents = (g_free (contents), NULL), _tmp0);
	}
	_tmp2 = NULL;
	_tmp1 = NULL;
	fields = (_tmp2 = _tmp1 = g_strsplit (contents, "\n", 7), fields_length1 = _vala_array_length (_tmp1), fields_size = fields_length1, _tmp2);
	rec = dvb_recording_new ();
	field = NULL;
	i = 0;
	_tmp4 = NULL;
	_tmp3 = NULL;
	while ((field = (_tmp4 = (_tmp3 = fields[i], (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)), field = (g_free (field), NULL), _tmp4)) != NULL) {
		switch (i) {
			case 0:
			{
				dvb_recording_set_Id (rec, (guint32) atoi (field));
				break;
			}
			case 1:
			{
				dvb_recording_set_ChannelName (rec, field);
				break;
			}
			case 2:
			{
				if (_vala_strcmp0 (field, "") == 0) {
					dvb_recording_set_Location (rec, NULL);
				} else {
					GFile* _tmp5;
					_tmp5 = NULL;
					dvb_recording_set_Location (rec, _tmp5 = g_file_new_for_path (field));
					(_tmp5 == NULL) ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL));
				}
				break;
			}
			case 3:
			{
				{
					gint year;
					gint month;
					gint day;
					gint hour;
					gint minute;
					gboolean _tmp6;
					gboolean _tmp7;
					gboolean _tmp8;
					gboolean _tmp9;
					year = 0;
					month = 0;
					day = 0;
					hour = 0;
					minute = 0;
					sscanf (field, "%d-%d-%d %d:%d", &year, &month, &day, &hour, &minute, NULL);
					_tmp6 = FALSE;
					_tmp7 = FALSE;
					_tmp8 = FALSE;
					_tmp9 = FALSE;
					if (year >= 1900) {
						_tmp9 = month >= 1;
					} else {
						_tmp9 = FALSE;
					}
					if (_tmp9) {
						_tmp8 = day >= 1;
					} else {
						_tmp8 = FALSE;
					}
					if (_tmp8) {
						_tmp7 = hour >= 0;
					} else {
						_tmp7 = FALSE;
					}
					if (_tmp7) {
						_tmp6 = minute >= 0;
					} else {
						_tmp6 = FALSE;
					}
					if (_tmp6) {
						struct tm _tmp10 = {0};
						dvb_recording_set_StartTime (rec, (_tmp10 = dvb_utils_create_time (year, month, day, hour, minute, 0), &_tmp10));
					}
					break;
				}
			}
			case 4:
			{
				dvb_recording_set_Length (rec, (gint64) atoi (field));
				break;
			}
			case 5:
			{
				const char* _tmp11;
				_tmp11 = NULL;
				if (_vala_strcmp0 (field, "") == 0) {
					_tmp11 = NULL;
				} else {
					_tmp11 = field;
				}
				dvb_recording_set_Name (rec, _tmp11);
				break;
			}
			default:
			{
				dvb_recording_set_Description (rec, field);
				break;
			}
		}
		i++;
	}
	_tmp12 = NULL;
	return (_tmp12 = rec, contents = (g_free (contents), NULL), fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL), field = (g_free (field), NULL), _tmp12);
}


/**
     * This class represents a finished recording
     */
DVBRecording* dvb_recording_construct (GType object_type) {
	DVBRecording * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBRecording* dvb_recording_new (void) {
	return dvb_recording_construct (DVB_TYPE_RECORDING);
}


guint32 dvb_recording_get_Id (DVBRecording* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_Id;
}


void dvb_recording_set_Id (DVBRecording* self, guint32 value) {
	g_return_if_fail (self != NULL);
	self->priv->_Id = value;
	g_object_notify ((GObject *) self, "Id");
}


guint dvb_recording_get_ChannelSid (DVBRecording* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_ChannelSid;
}


void dvb_recording_set_ChannelSid (DVBRecording* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_ChannelSid = value;
	g_object_notify ((GObject *) self, "ChannelSid");
}


const char* dvb_recording_get_ChannelName (DVBRecording* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_ChannelName;
}


void dvb_recording_set_ChannelName (DVBRecording* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_ChannelName = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_ChannelName = (g_free (self->priv->_ChannelName), NULL), _tmp2);
	g_object_notify ((GObject *) self, "ChannelName");
}


GFile* dvb_recording_get_Location (DVBRecording* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_Location;
}


void dvb_recording_set_Location (DVBRecording* self, GFile* value) {
	GFile* _tmp2;
	GFile* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_Location = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_Location == NULL) ? NULL : (self->priv->_Location = (g_object_unref (self->priv->_Location), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "Location");
}


const char* dvb_recording_get_Name (DVBRecording* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_Name;
}


void dvb_recording_set_Name (DVBRecording* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_Name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_Name = (g_free (self->priv->_Name), NULL), _tmp2);
	g_object_notify ((GObject *) self, "Name");
}


const char* dvb_recording_get_Description (DVBRecording* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_Description;
}


void dvb_recording_set_Description (DVBRecording* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_Description = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_Description = (g_free (self->priv->_Description), NULL), _tmp2);
	g_object_notify ((GObject *) self, "Description");
}


void dvb_recording_get_StartTime (DVBRecording* self, struct tm* value) {
	g_return_if_fail (self != NULL);
	*value = self->priv->_StartTime;
	return;
}


void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value) {
	g_return_if_fail (self != NULL);
	self->priv->_StartTime = (*value);
}


gint64 dvb_recording_get_Length (DVBRecording* self) {
	g_return_val_if_fail (self != NULL, 0LL);
	return self->priv->_Length;
}


void dvb_recording_set_Length (DVBRecording* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_Length = value;
	g_object_notify ((GObject *) self, "Length");
}


static void dvb_recording_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBRecording * self;
	gpointer boxed;
	self = DVB_RECORDING (object);
	switch (property_id) {
		case DVB_RECORDING_ID:
		g_value_set_uint (value, dvb_recording_get_Id (self));
		break;
		case DVB_RECORDING_CHANNEL_SID:
		g_value_set_uint (value, dvb_recording_get_ChannelSid (self));
		break;
		case DVB_RECORDING_CHANNEL_NAME:
		g_value_set_string (value, dvb_recording_get_ChannelName (self));
		break;
		case DVB_RECORDING_LOCATION:
		g_value_set_object (value, dvb_recording_get_Location (self));
		break;
		case DVB_RECORDING_NAME:
		g_value_set_string (value, dvb_recording_get_Name (self));
		break;
		case DVB_RECORDING_DESCRIPTION:
		g_value_set_string (value, dvb_recording_get_Description (self));
		break;
		case DVB_RECORDING_LENGTH:
		g_value_set_int64 (value, dvb_recording_get_Length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_recording_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBRecording * self;
	self = DVB_RECORDING (object);
	switch (property_id) {
		case DVB_RECORDING_ID:
		dvb_recording_set_Id (self, g_value_get_uint (value));
		break;
		case DVB_RECORDING_CHANNEL_SID:
		dvb_recording_set_ChannelSid (self, g_value_get_uint (value));
		break;
		case DVB_RECORDING_CHANNEL_NAME:
		dvb_recording_set_ChannelName (self, g_value_get_string (value));
		break;
		case DVB_RECORDING_LOCATION:
		dvb_recording_set_Location (self, g_value_get_object (value));
		break;
		case DVB_RECORDING_NAME:
		dvb_recording_set_Name (self, g_value_get_string (value));
		break;
		case DVB_RECORDING_DESCRIPTION:
		dvb_recording_set_Description (self, g_value_get_string (value));
		break;
		case DVB_RECORDING_LENGTH:
		dvb_recording_set_Length (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_recording_class_init (DVBRecordingClass * klass) {
	dvb_recording_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBRecordingPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_recording_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_recording_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_recording_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_ID, g_param_spec_uint ("Id", "Id", "Id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_CHANNEL_SID, g_param_spec_uint ("ChannelSid", "ChannelSid", "ChannelSid", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_CHANNEL_NAME, g_param_spec_string ("ChannelName", "ChannelName", "ChannelName", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_LOCATION, g_param_spec_object ("Location", "Location", "Location", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_DESCRIPTION, g_param_spec_string ("Description", "Description", "Description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_LENGTH, g_param_spec_int64 ("Length", "Length", "Length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_recording_instance_init (DVBRecording * self) {
	self->priv = DVB_RECORDING_GET_PRIVATE (self);
}


static void dvb_recording_finalize (GObject* obj) {
	DVBRecording * self;
	self = DVB_RECORDING (obj);
	self->priv->_ChannelName = (g_free (self->priv->_ChannelName), NULL);
	(self->priv->_Location == NULL) ? NULL : (self->priv->_Location = (g_object_unref (self->priv->_Location), NULL));
	self->priv->_Name = (g_free (self->priv->_Name), NULL);
	self->priv->_Description = (g_free (self->priv->_Description), NULL);
	G_OBJECT_CLASS (dvb_recording_parent_class)->finalize (obj);
}


GType dvb_recording_get_type (void) {
	static GType dvb_recording_type_id = 0;
	if (dvb_recording_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBRecordingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_recording_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRecording), 0, (GInstanceInitFunc) dvb_recording_instance_init, NULL };
		dvb_recording_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBRecording", &g_define_type_info, 0);
	}
	return dvb_recording_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




