/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_SQLITEEPGSTORE_H__
#define __SRC_SQLITEEPGSTORE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include "src/EPGStore.h"
#include "src/Event.h"

G_BEGIN_DECLS


#define DVB_TYPE_SQLITE_EPG_STORE (dvb_sqlite_epg_store_get_type ())
#define DVB_SQLITE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SQLITE_EPG_STORE, DVBSqliteEPGStore))
#define DVB_SQLITE_EPG_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SQLITE_EPG_STORE, DVBSqliteEPGStoreClass))
#define DVB_IS_SQLITE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SQLITE_EPG_STORE))
#define DVB_IS_SQLITE_EPG_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SQLITE_EPG_STORE))
#define DVB_SQLITE_EPG_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SQLITE_EPG_STORE, DVBSqliteEPGStoreClass))

typedef struct _DVBSqliteEPGStore DVBSqliteEPGStore;
typedef struct _DVBSqliteEPGStoreClass DVBSqliteEPGStoreClass;
typedef struct _DVBSqliteEPGStorePrivate DVBSqliteEPGStorePrivate;

struct _DVBSqliteEPGStore {
	GObject parent_instance;
	DVBSqliteEPGStorePrivate * priv;
};

struct _DVBSqliteEPGStoreClass {
	GObjectClass parent_class;
};


DVBSqliteEPGStore* dvb_sqlite_epg_store_construct (GType object_type);
DVBSqliteEPGStore* dvb_sqlite_epg_store_new (void);
GType dvb_sqlite_epg_store_get_type (void);


G_END_DECLS

#endif
