/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_TIMER_H__
#define __SRC_TIMER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "src/OverlapType.h"
#include "src/Channel.h"

G_BEGIN_DECLS


#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;
typedef struct _DVBTimerPrivate DVBTimerPrivate;

/**
     * This class represents an event that should be recorded
     */
struct _DVBTimer {
	GObject parent_instance;
	DVBTimerPrivate * priv;
};

struct _DVBTimerClass {
	GObjectClass parent_class;
};


DVBTimer* dvb_timer_construct (GType object_type, guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration, const char* name);
DVBTimer* dvb_timer_new (guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration, const char* name);
gboolean dvb_timer_conflicts_with (DVBTimer* self, DVBTimer* t2);
DVBOverlapType dvb_timer_get_overlap_local (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
DVBOverlapType dvb_timer_get_overlap_utc (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
void dvb_timer_add_to_start_time (DVBTimer* self, gint minutes);
guint* dvb_timer_get_start_time (DVBTimer* self, int* result_length1);
struct tm dvb_timer_get_start_time_time (DVBTimer* self);
guint* dvb_timer_get_end_time (DVBTimer* self, int* result_length1);
gboolean dvb_timer_is_start_due (DVBTimer* self);
gboolean dvb_timer_is_end_due (DVBTimer* self);
gboolean dvb_timer_has_expired (DVBTimer* self);
char* dvb_timer_to_string (DVBTimer* self);
guint32 dvb_timer_get_Id (DVBTimer* self);
DVBChannel* dvb_timer_get_Channel (DVBTimer* self);
const char* dvb_timer_get_Name (DVBTimer* self);
void dvb_timer_set_Name (DVBTimer* self, const char* value);
guint dvb_timer_get_Year (DVBTimer* self);
void dvb_timer_set_Year (DVBTimer* self, guint value);
guint dvb_timer_get_Month (DVBTimer* self);
void dvb_timer_set_Month (DVBTimer* self, guint value);
guint dvb_timer_get_Day (DVBTimer* self);
void dvb_timer_set_Day (DVBTimer* self, guint value);
guint dvb_timer_get_Hour (DVBTimer* self);
void dvb_timer_set_Hour (DVBTimer* self, guint value);
guint dvb_timer_get_Minute (DVBTimer* self);
void dvb_timer_set_Minute (DVBTimer* self, guint value);
guint dvb_timer_get_Duration (DVBTimer* self);
void dvb_timer_set_Duration (DVBTimer* self, guint value);
GType dvb_timer_get_type (void);


G_END_DECLS

#endif
