/* -*- Mode: C; c-basic-offset: 4 -*- */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/* include this first, before NO_IMPORT_PYGOBJECT is defined */
#include <pygobject.h>
#include <libgnome/gnome-init.h>

void pygnome_register_classes (PyObject *d);
void pygnome_add_constants (PyObject *module, const gchar *strip_prefix);
extern PyMethodDef pygnome_functions[];

void
pygnome_add_defined_constants (PyObject *dict)
{
	PyDict_SetItemString (dict, "PARAM_NONE", Py_None);
	Py_INCREF (Py_None);

	PyDict_SetItemString (dict, "PARAM_POPT_TABLE", PyString_FromString (GNOME_PARAM_POPT_TABLE));
	PyDict_SetItemString (dict, "PARAM_POPT_FLAGS", PyString_FromString (GNOME_PARAM_POPT_FLAGS));
	PyDict_SetItemString (dict, "PARAM_POPT_CONTEXT", PyString_FromString (GNOME_PARAM_POPT_CONTEXT));
	PyDict_SetItemString (dict, "PARAM_CREATE_DIRECTORIES", PyString_FromString (GNOME_PARAM_CREATE_DIRECTORIES));
	PyDict_SetItemString (dict, "PARAM_ENABLE_SOUND", PyString_FromString (GNOME_PARAM_ENABLE_SOUND));
	PyDict_SetItemString (dict, "PARAM_ESPEAKER", PyString_FromString (GNOME_PARAM_ESPEAKER));
	PyDict_SetItemString (dict, "PARAM_APP_ID", PyString_FromString (GNOME_PARAM_APP_ID));
	PyDict_SetItemString (dict, "PARAM_APP_VERSION", PyString_FromString (GNOME_PARAM_APP_VERSION));
	PyDict_SetItemString (dict, "PARAM_GNOME_PREFIX", PyString_FromString (GNOME_PARAM_GNOME_PREFIX));
	PyDict_SetItemString (dict, "PARAM_GNOME_SYSCONFDIR", PyString_FromString (GNOME_PARAM_GNOME_SYSCONFDIR));
	PyDict_SetItemString (dict, "PARAM_GNOME_DATADIR", PyString_FromString (GNOME_PARAM_GNOME_DATADIR));
	PyDict_SetItemString (dict, "PARAM_GNOME_LIBDIR", PyString_FromString (GNOME_PARAM_GNOME_LIBDIR));
	PyDict_SetItemString (dict, "PARAM_APP_PREFIX", PyString_FromString (GNOME_PARAM_APP_PREFIX));
	PyDict_SetItemString (dict, "PARAM_APP_SYSCONFDIR", PyString_FromString (GNOME_PARAM_APP_SYSCONFDIR));
	PyDict_SetItemString (dict, "PARAM_APP_DATADIR", PyString_FromString (GNOME_PARAM_APP_DATADIR));
	PyDict_SetItemString (dict, "PARAM_APP_LIBDIR", PyString_FromString (GNOME_PARAM_APP_LIBDIR));
	PyDict_SetItemString (dict, "PARAM_HUMAN_READABLE_NAME", PyString_FromString (GNOME_PARAM_HUMAN_READABLE_NAME));
	PyDict_SetItemString (dict, "PARAM_GNOME_PATH", PyString_FromString (GNOME_PARAM_GNOME_PATH));		
}

DL_EXPORT(void)
init_gnome (void)
{
    PyObject *m, *d;
	
    init_pygobject ();
    
    m = Py_InitModule ("_gnome", pygnome_functions);
    d = PyModule_GetDict (m);
	
    pygnome_register_classes (d);
    pygnome_add_constants (m, "GNOME_");
    pygnome_add_defined_constants (d);
	
    if (!gnome_program_module_registered (LIBGNOME_MODULE))
	gnome_program_module_register (LIBGNOME_MODULE);
}
