/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescanoptionwidget.h
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:gnomescanoptionwidget
 * @short_description: A parent widget for configuration widget
 *
 * #GnomeScanOptionWidget simply show a label and a widget to
 * configure a context.
 */

#ifndef GNOME_SCAN_OPTION_WIDGET_H
#define GNOME_SCAN_OPTION_WIDGET_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "gnomescan.h"

G_BEGIN_DECLS

#define	GNOME_TYPE_SCAN_OPTION_WIDGET			(gnome_scan_option_widget_get_type ())
#define GNOME_SCAN_OPTION_WIDGET(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_OPTION_WIDGET, GnomeScanOptionWidget))
#define GNOME_SCAN_OPTION_WIDGET_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_OPTION_WIDGET, GnomeScanOptionWidgetClass))
#define GNOME_IS_SCAN_OPTION_WIDGET(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_OPTION_WIDGET))
#define GNOME_IS_SCAN_OPTION_WIDGET_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_OPTION_WIDGET))
#define GNOME_SCAN_OPTION_WIDGET_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_OPTION_WIDGET, GnomeScanOptionWidgetClass))

typedef struct _GnomeScanOptionWidget			GnomeScanOptionWidget;
typedef struct _GnomeScanOptionWidgetClass		GnomeScanOptionWidgetClass;

struct _GnomeScanOptionWidget {
  GtkHBox	       	parent;

  /*< public >*/
  GnomeScanContext	*context;
  GtkWidget		*label;
  GtkWidget		*child;
};

struct _GnomeScanOptionWidgetClass {
  GtkHBoxClass		parent;

  /* SIGNALS */
};

enum {
  GNOME_SCAN_OPTION_WIDGET_ERROR_FAILED
};

/* GObject functions */
GType			gnome_scan_option_widget_get_type		(void)	G_GNUC_CONST;

/* Methods */

GnomeScanContext*	gnome_scan_option_widget_get_context		(GnomeScanOptionWidget *widget);

void			gnome_scan_option_widget_show_label		(GnomeScanOptionWidget *widget);

void			gnome_scan_option_widget_hide_label		(GnomeScanOptionWidget *widget);

void			gnome_scan_option_widget_set_label		(GnomeScanOptionWidget *widget,
									 const gchar *text);

void			gnome_scan_option_widget_pack_child		(GnomeScanOptionWidget *widget,
									 GtkWidget *child,
									 gboolean expand,
									 gboolean fill);
G_END_DECLS

#endif
