/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescanpreview.h
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:gnomescanpreview
 * @title: GnomeScanPreview
 * @short_description: Simple previsualisation widget.
 *
 * The #GnomeScanPreview widget allow user to basically select a scan
 * area and a rotation of the picture. This widget is not intended for
 * precise area selection.
 */

#ifndef GNOME_SCAN_PREVIEW_H
#define GNOME_SCAN_PREVIEW_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gnomescan.h>

#define	GNOME_TYPE_SCAN_PREVIEW			(gnome_scan_preview_get_type ())
#define GNOME_SCAN_PREVIEW(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_PREVIEW, GnomeScanPreview))
#define GNOME_SCAN_PREVIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_PREVIEW, GnomeScanPreviewClass))
#define GNOME_IS_SCAN_PREVIEW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_PREVIEW))
#define GNOME_IS_SCAN_PREVIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_PREVIEW))
#define GNOME_SCAN_PREVIEW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_PREVIEW, GnomeScanPreviewClass))

typedef struct _GnomeScanPreview		GnomeScanPreview;
typedef struct _GnomeScanPreviewClass		GnomeScanPreviewClass;

struct _GnomeScanPreview {
  GtkVBox			parent;

  /*< public >*/
  GnomeScanContext	*context;
};

struct _GnomeScanPreviewClass {
  GtkVBoxClass			parent;

  /* SIGNALS */
};

enum {
  GNOME_SCAN_PREVIEW_ERROR_FAILED
};

/* GObject functions */
GType			gnome_scan_preview_get_type			(void);

/* Methods */

GtkWidget*		gnome_scan_preview_new 				(GnomeScanContext *context);

#endif
