/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <glib/gi18n.h>
#include "gnome-scan-param-specs.h"
#include "gnome-scan-utils.h"
#include "gnome-scan-processor-common.h"
#include "gnome-scan-preview-plugin-rotation.h"

typedef struct _GnomeScanProcessorCommonPrivate GnomeScanProcessorCommonPrivate;
struct _GnomeScanProcessorCommonPrivate
{
	gdouble		degrees;
	gboolean	enhance;
};

#define GET_PRIVATE(o)  (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_TYPE_SCAN_PROCESSOR_COMMON, GnomeScanProcessorCommonPrivate))

G_DEFINE_TYPE (GnomeScanProcessorCommon, gnome_scan_processor_common, GNOME_TYPE_SCAN_PLUGIN);

GS_DEFINE_QUARK(gs_param_group_processing_common, N_("Common Processing"));
#define	GS_PARAM_GROUP_PROCESSING_COMMON	(gs_param_group_processing_common_quark ())

static void
gnome_scan_processor_common_init (GnomeScanProcessorCommon *object)
{
	GParamSpec *pspec;
	GValue *min, *max, *step, *val;
#define gs_g_value_new_double(var, val)	\
  var = g_new0(GValue,1);			\
  g_value_init (var, G_TYPE_DOUBLE);		\
  g_value_set_double (var, val); 
	
  gs_g_value_new_double(min, 0.);
  gs_g_value_new_double(step, 1.);
  gs_g_value_new_double(max, 359.);
  gs_g_value_new_double(val, 0.);
#undef gs_g_value_new_int

	pspec = gs_param_spec_range("rotation", N_("Rotation"), N_("Rotation"),
								GS_PARAM_GROUP_PREVIEW,
								min, max, step, val,
								G_PARAM_WRITABLE);
	gs_param_spec_set_widget_type(pspec, GNOME_TYPE_SCAN_PREVIEW_PLUGIN_ROTATION);
	gnome_scan_plugin_params_add (GNOME_SCAN_PLUGIN (object), pspec);
	
	pspec = gs_param_spec_boolean ("enhance", N_("Automatic color enhancement"),
								   N_("Color enhancement produce better photos, "
								   "but take more time to process and can be "
								   "useless for text."),
								   GS_PARAM_GROUP_PROCESSING_COMMON,
								   TRUE,
								   G_PARAM_WRITABLE);
	gnome_scan_plugin_params_add (GNOME_SCAN_PLUGIN (object), pspec);
}

static void
gnome_scan_processor_common_finalize (GObject *object)
{
	/* TODO: Add deinitalization code here */

	G_OBJECT_CLASS (gnome_scan_processor_common_parent_class)->finalize (object);
}

GnomeScanPlugin*
gnome_scan_processor_common_new(void)
{
	return g_object_new (GNOME_TYPE_SCAN_PROCESSOR_COMMON, NULL);
}

void
gnome_scan_processor_common_configure (GnomeScanPlugin *plugin, GnomeScanSettings *settings)
{
	GnomeScanProcessorCommonPrivate *priv = GET_PRIVATE (plugin);
	priv->degrees = gnome_scan_settings_get_double (settings, "rotation");
	priv->enhance = gnome_scan_settings_get_boolean (settings, "enhance");
}

GList*
gnome_scan_processor_common_get_child_nodes (GnomeScanPlugin *plugin, GeglNode *root)
{
	GnomeScanProcessorCommonPrivate *priv = GET_PRIVATE (plugin);
	GList* node = NULL;
	GeglNode *op;
	
	op = gegl_node_new_child(root,
							 "operation", "rotate",
							 "degrees", priv->degrees,
							 NULL);
	node = g_list_append (node, op);
	
	if (priv->enhance) {
		op = gegl_node_new_child(root,
								 "operation", "stress",
								 /* those value are arbitraty, might
									be nice to expose this through
									profile : photo, text, quick,
									manual, … */
								 "iterations", 10,
								 "gamma", 2.,
								 "samples", 30,
								 NULL);
		node = g_list_append (node, op);
	}
	
	return node;
}

static void
gnome_scan_processor_common_class_init (GnomeScanProcessorCommonClass *klass)
{
	GObjectClass* object_class = G_OBJECT_CLASS (klass);
	GnomeScanPluginClass* parent_class = GNOME_SCAN_PLUGIN_CLASS (klass);

	g_type_class_add_private (klass, sizeof (GnomeScanProcessorCommonPrivate));

	parent_class->configure			= gnome_scan_processor_common_configure;
	parent_class->get_child_nodes	= gnome_scan_processor_common_get_child_nodes;
	
	object_class->finalize = gnome_scan_processor_common_finalize;
}

