/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef _GNOME_SCAN_BACKEND_H_
#define _GNOME_SCAN_BACKEND_H_

#include <glib-object.h>
#include "gnome-scanner.h"

G_BEGIN_DECLS

#define GNOME_TYPE_SCAN_BACKEND             (gnome_scan_backend_get_type ())
#define GNOME_SCAN_BACKEND(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_BACKEND, GnomeScanBackend))
#define GNOME_SCAN_BACKEND_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_BACKEND, GnomeScanBackendClass))
#define GNOME_IS_SCAN_BACKEND(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_BACKEND))
#define GNOME_IS_SCAN_BACKEND_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_BACKEND))
#define GNOME_SCAN_BACKEND_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_BACKEND, GnomeScanBackendClass))

typedef struct _GnomeScanBackendClass GnomeScanBackendClass;
typedef struct _GnomeScanBackend GnomeScanBackend;

struct _GnomeScanBackendClass
{
	GObjectClass parent_class;
	
	/* API */
	void	(* probe_scanners)	(GnomeScanBackend *backend);
	
	/* Signals */
	void	(* scanner_added)	(GnomeScanBackend *backend, GnomeScanner *scanner, gpointer data);
	void	(* scanner_removed)	(GnomeScanBackend *backend, GnomeScanner *scanner, gpointer data);
	void	(* probe_done)		(GnomeScanBackend *backend, gpointer data);
};

/**
 * GnomeScanBackend:
 *
 * The #GnomeScanBackend is only responsible to probe scanners,
 * emitting signal on scanner plug or unplug. Ideally, most of the
 * acquisition work is done through #GnomeScanner.
 **/
struct _GnomeScanBackend
{
	/*< private >*/
	GObject parent_instance;
};

GType gnome_scan_backend_get_type (void) G_GNUC_CONST;
GnomeScanBackend* gnome_scan_backend_new (GType backend_type);
void gnome_scan_backend_probe_scanners (GnomeScanBackend *backend);
void gnome_scan_backend_add_scanner (GnomeScanBackend *backend,
									 GnomeScanner *scanner);
void gnome_scan_backend_remove_scanner (GnomeScanBackend *backend,
										GnomeScanner *scanner);
void gnome_scan_backend_probe_done (GnomeScanBackend *backend);

G_END_DECLS

#endif /* _GNOME_SCAN_BACKEND_H_ */
