/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-module-manager.h>
#include <gmodule.h>
#include <gnome-scan-module.h>




struct _GnomeScanModuleManagerPrivate {
	char* _path;
	GSList* modules;
};

#define GNOME_SCAN_MODULE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_MODULE_MANAGER, GnomeScanModuleManagerPrivate))
enum  {
	GNOME_SCAN_MODULE_MANAGER_DUMMY_PROPERTY,
	GNOME_SCAN_MODULE_MANAGER_PATH
};
static void _g_slist_free_g_object_unref (GSList* self);
static gboolean gnome_scan_module_manager_is_valid_module_name (const char* name);
static gpointer gnome_scan_module_manager_parent_class = NULL;
static void gnome_scan_module_manager_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


/**
 * gnome_scan_module_manager_new:
 * @path: Search path.
 * 
 * Create a new #GnomeScanModuleManager which will handle @path.
 * 
 * Returns: a new #GnomeScanModuleManager
 **/
GnomeScanModuleManager* gnome_scan_module_manager_construct (GType object_type, const char* path) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanModuleManager * self;
	g_return_val_if_fail (path != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "path";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, path);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanModuleManager* gnome_scan_module_manager_new (const char* path) {
	return gnome_scan_module_manager_construct (GNOME_SCAN_TYPE_MODULE_MANAGER, path);
}


/**
 * gnome_scan_module_manager_query_modules:
 * @self: a #GnomeScanModuleManager
 * 
 * Search for shared objects in path, instanciate and initialize a
 * #GnomeScanModule for each shared object. Note that it won't search
 * in subdirectories.
 **/
void gnome_scan_module_manager_query_modules (GnomeScanModuleManager* self) {
	GError * inner_error;
	GnomeScanModule* module;
	GDir* dir;
	char** _tmp1;
	gint paths_size;
	gint paths_length1;
	char** _tmp0;
	char** paths;
	char* name;
	char* filename;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	module = NULL;
	dir = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	paths = (_tmp1 = _tmp0 = g_strsplit (self->priv->_path, G_SEARCHPATH_SEPARATOR_S, 0), paths_length1 = _vala_array_length (_tmp0), paths_size = paths_length1, _tmp1);
	name = NULL;
	filename = NULL;
	{
		char** path_collection;
		int path_collection_length1;
		int path_it;
		path_collection = paths;
		path_collection_length1 = paths_length1;
		for (path_it = 0; path_it < paths_length1; path_it = path_it + 1) {
			const char* _tmp9;
			char* path;
			_tmp9 = NULL;
			path = (_tmp9 = path_collection[path_it], (_tmp9 == NULL) ? NULL : g_strdup (_tmp9));
			{
				char* _tmp5;
				const char* _tmp4;
				{
					GDir* _tmp2;
					GDir* _tmp3;
					_tmp2 = g_dir_open (path, (guint) 0, &inner_error);
					if (inner_error != NULL) {
						goto __catch0_g_error;
						goto __finally0;
					}
					_tmp3 = NULL;
					dir = (_tmp3 = _tmp2, (dir == NULL) ? NULL : (dir = (g_dir_close (dir), NULL)), _tmp3);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError * error;
					error = inner_error;
					inner_error = NULL;
					{
						/* Show warning only for absolute path, else should be devel path… */
						if (g_utf8_get_char (g_utf8_offset_to_pointer (path, 0)) == '/') {
							g_warning ("gnome-scan-module-manager.vala:84: %s", error->message);
						}
						(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
					}
				}
				__finally0:
				if (inner_error != NULL) {
					path = (g_free (path), NULL);
					(module == NULL) ? NULL : (module = (g_object_unref (module), NULL));
					(dir == NULL) ? NULL : (dir = (g_dir_close (dir), NULL));
					paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
					name = (g_free (name), NULL);
					filename = (g_free (filename), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
					return;
				}
				if (dir == NULL) {
					path = (g_free (path), NULL);
					continue;
				}
				_tmp5 = NULL;
				_tmp4 = NULL;
				while ((name = (_tmp5 = (_tmp4 = g_dir_read_name (dir), (_tmp4 == NULL) ? NULL : g_strdup (_tmp4)), name = (g_free (name), NULL), _tmp5)) != NULL) {
					if (gnome_scan_module_manager_is_valid_module_name (name)) {
						char* _tmp6;
						GnomeScanModule* _tmp7;
						GTypeModule* _tmp8;
						_tmp6 = NULL;
						filename = (_tmp6 = g_build_filename (path, name, NULL), filename = (g_free (filename), NULL), _tmp6);
						_tmp7 = NULL;
						module = (_tmp7 = gnome_scan_module_new (filename), (module == NULL) ? NULL : (module = (g_object_unref (module), NULL)), _tmp7);
						if (!g_type_module_use ((GTypeModule*) module)) {
							g_warning ("gnome-scan-module-manager.vala:97: %s", g_module_error ());
						}
						/* throw exception ?*/
						_tmp8 = NULL;
						self->priv->modules = g_slist_append (self->priv->modules, (_tmp8 = (GTypeModule*) module, (_tmp8 == NULL) ? NULL : g_object_ref (_tmp8)));
					}
				}
				path = (g_free (path), NULL);
			}
		}
	}
	(module == NULL) ? NULL : (module = (g_object_unref (module), NULL));
	(dir == NULL) ? NULL : (dir = (g_dir_close (dir), NULL));
	paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
	name = (g_free (name), NULL);
	filename = (g_free (filename), NULL);
}


/**
 * gnome_scan_module_manager_unload_modules:
 * @self: a #GnomeScanModuleManager
 * 
 * Search for shared objects in path, instanciate and initialize a
 * #GnomeScanModule for each shared object. Note that it won't search
 * in subdirectories.
 **/
void gnome_scan_module_manager_unload_modules (GnomeScanModuleManager* self) {
	g_return_if_fail (self != NULL);
	{
		GSList* module_collection;
		GSList* module_it;
		module_collection = self->priv->modules;
		for (module_it = module_collection; module_it != NULL; module_it = module_it->next) {
			GTypeModule* _tmp0;
			GTypeModule* module;
			_tmp0 = NULL;
			module = (_tmp0 = (GTypeModule*) module_it->data, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
			{
				g_type_module_unuse (module);
				(module == NULL) ? NULL : (module = (g_object_unref (module), NULL));
			}
		}
	}
}


static gboolean gnome_scan_module_manager_is_valid_module_name (const char* name) {
	gboolean _tmp0;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0 = FALSE;
	if (g_str_has_prefix (name, "lib")) {
		gboolean _tmp1;
		_tmp1 = FALSE;
		if (g_str_has_suffix (name, G_MODULE_SUFFIX)) {
			_tmp1 = TRUE;
		} else {
			_tmp1 = g_str_has_suffix (name, ".la");
		}
		_tmp0 = (_tmp1);
	} else {
		_tmp0 = FALSE;
	}
	return _tmp0;
}


const char* gnome_scan_module_manager_get_path (GnomeScanModuleManager* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_path;
}


void gnome_scan_module_manager_set_path (GnomeScanModuleManager* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_path = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_path = (g_free (self->priv->_path), NULL), _tmp2);
	g_object_notify ((GObject *) self, "path");
}


static void gnome_scan_module_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanModuleManager * self;
	gpointer boxed;
	self = GNOME_SCAN_MODULE_MANAGER (object);
	switch (property_id) {
		case GNOME_SCAN_MODULE_MANAGER_PATH:
		g_value_set_string (value, gnome_scan_module_manager_get_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_module_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanModuleManager * self;
	self = GNOME_SCAN_MODULE_MANAGER (object);
	switch (property_id) {
		case GNOME_SCAN_MODULE_MANAGER_PATH:
		gnome_scan_module_manager_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_module_manager_class_init (GnomeScanModuleManagerClass * klass) {
	gnome_scan_module_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanModuleManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_module_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_module_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_module_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_MODULE_MANAGER_PATH, g_param_spec_string ("path", "Path", "Module path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void gnome_scan_module_manager_instance_init (GnomeScanModuleManager * self) {
	self->priv = GNOME_SCAN_MODULE_MANAGER_GET_PRIVATE (self);
}


static void gnome_scan_module_manager_finalize (GObject* obj) {
	GnomeScanModuleManager * self;
	self = GNOME_SCAN_MODULE_MANAGER (obj);
	self->priv->_path = (g_free (self->priv->_path), NULL);
	(self->priv->modules == NULL) ? NULL : (self->priv->modules = (_g_slist_free_g_object_unref (self->priv->modules), NULL));
	G_OBJECT_CLASS (gnome_scan_module_manager_parent_class)->finalize (obj);
}


GType gnome_scan_module_manager_get_type (void) {
	static GType gnome_scan_module_manager_type_id = 0;
	if (gnome_scan_module_manager_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanModuleManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_module_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanModuleManager), 0, (GInstanceInitFunc) gnome_scan_module_manager_instance_init, NULL };
		gnome_scan_module_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomeScanModuleManager", &g_define_type_info, 0);
	}
	return gnome_scan_module_manager_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




